/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.SymlinksNotSupportedException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FS_POSIX;
import org.eclipse.jgit.util.FS_Win32;
import org.eclipse.jgit.util.FS_Win32_Cygwin;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.ProcessResult;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FS {
    private static final Logger LOG = LoggerFactory.getLogger(FS.class);
    public static final FS DETECTED = FS.detect();
    private static FSFactory factory;
    private volatile Holder<File> userHome;
    private volatile Holder<File> gitSystemConfig;

    public static FS detect() {
        return FS.detect(null);
    }

    public static FS detect(Boolean cygwinUsed) {
        if (factory == null) {
            factory = new FSFactory();
        }
        return factory.detect(cygwinUsed);
    }

    protected FS() {
    }

    protected FS(FS src) {
        this.userHome = src.userHome;
        this.gitSystemConfig = src.gitSystemConfig;
    }

    public abstract FS newInstance();

    public abstract boolean supportsExecute();

    public boolean supportsSymlinks() {
        return false;
    }

    public abstract boolean isCaseSensitive();

    public abstract boolean canExecute(File var1);

    public abstract boolean setExecute(File var1, boolean var2);

    public long lastModified(File f) throws IOException {
        return f.lastModified();
    }

    public void setLastModified(File f, long time) throws IOException {
        f.setLastModified(time);
    }

    public long length(File path) throws IOException {
        return path.length();
    }

    public void delete(File f) throws IOException {
        if (!f.delete()) {
            throw new IOException(MessageFormat.format(JGitText.get().deleteFileFailed, f.getAbsolutePath()));
        }
    }

    public File resolve(File dir, String name) {
        File abspn = new File(name);
        if (abspn.isAbsolute()) {
            return abspn;
        }
        return new File(dir, name);
    }

    public File userHome() {
        Holder<File> p = this.userHome;
        if (p == null) {
            this.userHome = p = new Holder<File>(this.userHomeImpl());
        }
        return (File)p.value;
    }

    public FS setUserHome(File path) {
        this.userHome = new Holder<File>(path);
        return this;
    }

    public abstract boolean retryFailedLockFileCommit();

    protected File userHomeImpl() {
        String home = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("user.home");
            }
        });
        if (home == null || home.length() == 0) {
            return null;
        }
        return new File(home).getAbsoluteFile();
    }

    protected static File searchPath(String path, String ... lookFor) {
        if (path == null) {
            return null;
        }
        for (String p : path.split(File.pathSeparator)) {
            for (String command : lookFor) {
                File e = new File(p, command);
                if (!e.isFile()) continue;
                return e.getAbsoluteFile();
            }
        }
        return null;
    }

    protected static String readPipe(File dir, String[] command, String encoding) {
        return FS.readPipe(dir, command, encoding, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String readPipe(File dir, String[] command, String encoding, Map<String, String> env) {
        boolean debug = LOG.isDebugEnabled();
        try {
            if (debug) {
                LOG.debug("readpipe " + Arrays.asList(command) + "," + dir);
            }
            ProcessBuilder pb = new ProcessBuilder(command);
            pb.directory(dir);
            if (env != null) {
                pb.environment().putAll(env);
            }
            Process p = pb.start();
            BufferedReader lineRead = new BufferedReader(new InputStreamReader(p.getInputStream(), encoding));
            p.getOutputStream().close();
            GobblerThread gobbler = new GobblerThread(p, command, dir);
            gobbler.start();
            String r = null;
            try {
                String l;
                r = lineRead.readLine();
                if (debug) {
                    LOG.debug("readpipe may return '" + r + "'");
                    LOG.debug("(ignoring remaing output:");
                }
                while ((l = lineRead.readLine()) != null) {
                    if (!debug) continue;
                    LOG.debug(l);
                }
            }
            finally {
                p.getErrorStream().close();
                lineRead.close();
            }
            while (true) {
                try {
                    int rc = p.waitFor();
                    gobbler.join();
                    if (rc == 0 && r != null && r.length() > 0 && !gobbler.fail.get()) {
                        return r;
                    }
                    if (debug) {
                        LOG.debug("readpipe rc=" + rc);
                    }
                }
                catch (InterruptedException ie) {
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            LOG.debug("Caught exception in FS.readPipe()", (Throwable)e);
        }
        if (debug) {
            LOG.debug("readpipe returns null");
        }
        return null;
    }

    protected abstract File discoverGitExe();

    protected File discoverGitSystemConfig() {
        File gitExe = this.discoverGitExe();
        if (gitExe == null) {
            return null;
        }
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("GIT_EDITOR", "echo");
        String w = FS.readPipe(gitExe.getParentFile(), new String[]{"git", "config", "--system", "--edit"}, Charset.defaultCharset().name(), env);
        if (StringUtils.isEmptyOrNull(w)) {
            return null;
        }
        return new File(w);
    }

    public File getGitSystemConfig() {
        if (this.gitSystemConfig == null) {
            this.gitSystemConfig = new Holder<File>(this.discoverGitSystemConfig());
        }
        return (File)this.gitSystemConfig.value;
    }

    public FS setGitSystemConfig(File configFile) {
        this.gitSystemConfig = new Holder<File>(configFile);
        return this;
    }

    protected static File resolveGrandparentFile(File grandchild) {
        File parent;
        if (grandchild != null && (parent = grandchild.getParentFile()) != null) {
            return parent.getParentFile();
        }
        return null;
    }

    public String readSymLink(File path) throws IOException {
        throw new SymlinksNotSupportedException(JGitText.get().errorSymlinksNotSupported);
    }

    public boolean isSymLink(File path) throws IOException {
        return false;
    }

    public boolean exists(File path) {
        return path.exists();
    }

    public boolean isDirectory(File path) {
        return path.isDirectory();
    }

    public boolean isFile(File path) {
        return path.isFile();
    }

    public boolean isHidden(File path) throws IOException {
        return path.isHidden();
    }

    public void setHidden(File path, boolean hidden) throws IOException {
        if (!path.getName().startsWith(".")) {
            throw new IllegalArgumentException(JGitText.get().hiddenFilesStartWithDot);
        }
    }

    public void createSymLink(File path, String target) throws IOException {
        throw new SymlinksNotSupportedException(JGitText.get().errorSymlinksNotSupported);
    }

    public String relativize(String base, String other) {
        return FileUtils.relativize(base, other);
    }

    public ProcessResult runHookIfPresent(Repository repository, String hookName, String[] args) throws JGitInternalException {
        return this.runHookIfPresent(repository, hookName, args, System.out, System.err, null);
    }

    public ProcessResult runHookIfPresent(Repository repository, String hookName, String[] args, PrintStream outRedirect, PrintStream errRedirect, String stdinArgs) throws JGitInternalException {
        return new ProcessResult(ProcessResult.Status.NOT_SUPPORTED);
    }

    protected ProcessResult internalRunHookIfPresent(Repository repository, String hookName, String[] args, PrintStream outRedirect, PrintStream errRedirect, String stdinArgs) throws JGitInternalException {
        File hookFile = this.findHook(repository, hookName);
        if (hookFile == null) {
            return new ProcessResult(ProcessResult.Status.NOT_PRESENT);
        }
        String hookPath = hookFile.getAbsolutePath();
        File runDirectory = repository.isBare() ? repository.getDirectory() : repository.getWorkTree();
        String cmd = this.relativize(runDirectory.getAbsolutePath(), hookPath);
        ProcessBuilder hookProcess = this.runInShell(cmd, args);
        hookProcess.directory(runDirectory);
        try {
            return new ProcessResult(this.runProcess(hookProcess, outRedirect, errRedirect, stdinArgs), ProcessResult.Status.OK);
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionCaughtDuringExecutionOfHook, hookName), e);
        }
        catch (InterruptedException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionHookExecutionInterrupted, hookName), e);
        }
    }

    public File findHook(Repository repository, String hookName) {
        File hookFile = new File(new File(repository.getDirectory(), "hooks"), hookName);
        return hookFile.isFile() ? hookFile : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int runProcess(ProcessBuilder hookProcessBuilder, OutputStream outRedirect, OutputStream errRedirect, String stdinArgs) throws IOException, InterruptedException {
        IOException ioException;
        block31: {
            int n;
            ExecutorService executor = Executors.newFixedThreadPool(2);
            Process process = null;
            ioException = null;
            try {
                process = hookProcessBuilder.start();
                StreamGobbler errorGobbler = new StreamGobbler(process.getErrorStream(), errRedirect);
                StreamGobbler outputGobbler = new StreamGobbler(process.getInputStream(), outRedirect);
                executor.submit(errorGobbler);
                executor.submit(outputGobbler);
                if (stdinArgs != null) {
                    PrintWriter stdinWriter = new PrintWriter(process.getOutputStream());
                    stdinWriter.print(stdinArgs);
                    stdinWriter.flush();
                    stdinWriter.close();
                }
                n = process.waitFor();
            }
            catch (IOException e) {
                try {
                    ioException = e;
                }
                catch (Throwable throwable) {
                    FS.shutdownAndAwaitTermination(executor);
                    if (process != null) {
                        try {
                            process.waitFor();
                        }
                        catch (InterruptedException e2) {
                            Thread.interrupted();
                        }
                        try {
                            process.getErrorStream().close();
                        }
                        catch (IOException e3) {
                            ioException = ioException != null ? ioException : e3;
                        }
                        try {
                            process.getInputStream().close();
                        }
                        catch (IOException e4) {
                            ioException = ioException != null ? ioException : e4;
                        }
                        try {
                            process.getOutputStream().close();
                        }
                        catch (IOException e5) {
                            ioException = ioException != null ? ioException : e5;
                        }
                        process.destroy();
                    }
                    throw throwable;
                }
                FS.shutdownAndAwaitTermination(executor);
                if (process == null) break block31;
                try {
                    process.waitFor();
                }
                catch (InterruptedException e6) {
                    Thread.interrupted();
                }
                try {
                    process.getErrorStream().close();
                }
                catch (IOException e7) {
                    ioException = ioException != null ? ioException : e7;
                }
                try {
                    process.getInputStream().close();
                }
                catch (IOException e8) {
                    ioException = ioException != null ? ioException : e8;
                }
                try {
                    process.getOutputStream().close();
                }
                catch (IOException e9) {
                    ioException = ioException != null ? ioException : e9;
                }
                process.destroy();
            }
            FS.shutdownAndAwaitTermination(executor);
            if (process != null) {
                try {
                    process.waitFor();
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
                try {
                    process.getErrorStream().close();
                }
                catch (IOException e) {
                    ioException = ioException != null ? ioException : e;
                }
                try {
                    process.getInputStream().close();
                }
                catch (IOException e) {
                    ioException = ioException != null ? ioException : e;
                }
                try {
                    process.getOutputStream().close();
                }
                catch (IOException e) {
                    ioException = ioException != null ? ioException : e;
                }
                process.destroy();
            }
            return n;
        }
        throw ioException;
    }

    private static boolean shutdownAndAwaitTermination(ExecutorService pool) {
        boolean hasShutdown = true;
        pool.shutdown();
        try {
            if (!pool.awaitTermination(5L, TimeUnit.SECONDS)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(5L, TimeUnit.SECONDS)) {
                    hasShutdown = false;
                }
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
            hasShutdown = false;
        }
        return hasShutdown;
    }

    public abstract ProcessBuilder runInShell(String var1, String[] var2);

    public Attributes getAttributes(File path) {
        boolean isFile;
        boolean isDirectory = this.isDirectory(path);
        boolean bl = isFile = !isDirectory && path.isFile();
        assert (path.exists() == isDirectory || isFile);
        boolean exists = isDirectory || isFile;
        boolean canExecute = exists && !isDirectory && this.canExecute(path);
        boolean isSymlink = false;
        long lastModified = exists ? path.lastModified() : 0L;
        long createTime = 0L;
        return new Attributes(this, path, exists, isDirectory, canExecute, isSymlink, isFile, createTime, lastModified, -1L);
    }

    public File normalize(File file) {
        return file;
    }

    public String normalize(String name) {
        return name;
    }

    private static class StreamGobbler
    implements Callable<Void> {
        private final BufferedReader reader;
        private final BufferedWriter writer;

        public StreamGobbler(InputStream stream, OutputStream output) {
            this.reader = new BufferedReader(new InputStreamReader(stream));
            this.writer = output == null ? null : new BufferedWriter(new OutputStreamWriter(output));
        }

        @Override
        public Void call() throws IOException {
            boolean writeFailure = false;
            String line = null;
            while ((line = this.reader.readLine()) != null) {
                if (writeFailure || this.writer == null) continue;
                try {
                    this.writer.write(line);
                    this.writer.newLine();
                    this.writer.flush();
                }
                catch (IOException e) {
                    writeFailure = true;
                }
            }
            return null;
        }
    }

    public static class Attributes {
        private boolean isDirectory;
        private boolean isSymbolicLink;
        private boolean isRegularFile;
        private long creationTime;
        private long lastModifiedTime;
        private boolean isExecutable;
        private File file;
        private boolean exists;
        protected long length = -1L;
        FS fs;

        public boolean isDirectory() {
            return this.isDirectory;
        }

        public boolean isExecutable() {
            return this.isExecutable;
        }

        public boolean isSymbolicLink() {
            return this.isSymbolicLink;
        }

        public boolean isRegularFile() {
            return this.isRegularFile;
        }

        public long getCreationTime() {
            return this.creationTime;
        }

        public long getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        Attributes(FS fs, File file, boolean exists, boolean isDirectory, boolean isExecutable, boolean isSymbolicLink, boolean isRegularFile, long creationTime, long lastModifiedTime, long length) {
            this.fs = fs;
            this.file = file;
            this.exists = exists;
            this.isDirectory = isDirectory;
            this.isExecutable = isExecutable;
            this.isSymbolicLink = isSymbolicLink;
            this.isRegularFile = isRegularFile;
            this.creationTime = creationTime;
            this.lastModifiedTime = lastModifiedTime;
            this.length = length;
        }

        public Attributes(File path, FS fs) {
            this.file = path;
            this.fs = fs;
        }

        public long getLength() {
            if (this.length == -1L) {
                this.length = this.file.length();
                return this.length;
            }
            return this.length;
        }

        public String getName() {
            return this.file.getName();
        }

        public File getFile() {
            return this.file;
        }

        boolean exists() {
            return this.exists;
        }
    }

    private static class Holder<V> {
        final V value;

        Holder(V value) {
            this.value = value;
        }
    }

    private static class GobblerThread
    extends Thread {
        private final Process p;
        private final String desc;
        private final String dir;
        private final boolean debug = FS.access$200().isDebugEnabled();
        private final AtomicBoolean fail = new AtomicBoolean();

        private GobblerThread(Process p, String[] command, File dir) {
            this.p = p;
            if (this.debug) {
                this.desc = Arrays.asList(command).toString();
                this.dir = dir.toString();
            } else {
                this.desc = null;
                this.dir = null;
            }
        }

        @Override
        public void run() {
            InputStream is = this.p.getErrorStream();
            try {
                if (this.debug) {
                    int ch;
                    while ((ch = is.read()) != -1) {
                        System.err.print((char)ch);
                    }
                } else {
                    while (is.read() != -1) {
                    }
                }
            }
            catch (IOException e) {
                this.logError(e);
                this.fail.set(true);
            }
            try {
                is.close();
            }
            catch (IOException e) {
                this.logError(e);
                this.fail.set(true);
            }
        }

        private void logError(Throwable t) {
            if (!this.debug) {
                return;
            }
            String msg = MessageFormat.format(JGitText.get().exceptionCaughtDuringExcecutionOfCommand, this.desc, this.dir);
            LOG.debug(msg, t);
        }
    }

    public static class FSFactory {
        protected FSFactory() {
        }

        public FS detect(Boolean cygwinUsed) {
            if (SystemReader.getInstance().isWindows()) {
                if (cygwinUsed == null) {
                    cygwinUsed = FS_Win32_Cygwin.isCygwin();
                }
                if (cygwinUsed.booleanValue()) {
                    return new FS_Win32_Cygwin();
                }
                return new FS_Win32();
            }
            return new FS_POSIX();
        }
    }
}

