/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs.revprop;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.io.fs.FSFile;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNWCProperties;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNFSFSPackedRevProps {
    public static final int INT64_BUFFER_SIZE = 21;
    private final long firstRevision;
    private final List<Entry> entries;
    private byte[] cachedUncompressedByteArray;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SVNFSFSPackedRevProps fromPackFile(File file) throws SVNException {
        byte[] buffer = new byte[(int)file.length()];
        InputStream inputStream = null;
        try {
            Object errorMessage;
            inputStream = SVNFileUtil.openFileForReading(file);
            int read = SVNFileUtil.readIntoBuffer(inputStream, buffer, 0, buffer.length);
            if (read != buffer.length) {
                errorMessage = SVNErrorMessage.create(SVNErrorCode.STREAM_UNEXPECTED_EOF);
                SVNErrorManager.error((SVNErrorMessage)errorMessage, SVNLogType.FSFS);
            }
            errorMessage = SVNFSFSPackedRevProps.fromCompressedByteArray(buffer);
            return errorMessage;
        }
        catch (IOException e) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR);
            SVNErrorManager.error(errorMessage, e, SVNLogType.FSFS);
        }
        finally {
            SVNFileUtil.closeFile(inputStream);
        }
        return null;
    }

    public static SVNFSFSPackedRevProps fromCompressedByteArray(byte[] compressedData) throws SVNException {
        byte[] uncompressedData = SVNFSFSPackedRevProps.decompress(compressedData);
        return SVNFSFSPackedRevProps.fromUncompressedByteArray(uncompressedData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SVNFSFSPackedRevProps fromUncompressedByteArray(byte[] uncompressedData) throws SVNException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(uncompressedData);
        try {
            long firstRevision = SVNFSFSPackedRevProps.readNumber(inputStream);
            long revisionsCount = SVNFSFSPackedRevProps.readNumber(inputStream);
            int offset = 0;
            ArrayList<Entry> entries = new ArrayList<Entry>((int)revisionsCount);
            int i = 0;
            while ((long)i < revisionsCount) {
                Entry entry = new Entry(uncompressedData, offset, (int)SVNFSFSPackedRevProps.readNumber(inputStream));
                entries.add(entry);
                offset += entry.length;
                ++i;
            }
            if (inputStream.read() != 10) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Header end not found");
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
            int headerLength = uncompressedData.length - inputStream.available();
            for (Entry entry : entries) {
                entry.offset += headerLength;
            }
            SVNFSFSPackedRevProps sVNFSFSPackedRevProps = new SVNFSFSPackedRevProps(firstRevision, entries, uncompressedData);
            return sVNFSFSPackedRevProps;
        }
        finally {
            SVNFileUtil.closeFile(inputStream);
        }
    }

    private SVNFSFSPackedRevProps(long firstRevision, List<Entry> entries, byte[] cachedUncompressedByteArray) {
        this.firstRevision = firstRevision;
        this.entries = entries;
        this.cachedUncompressedByteArray = cachedUncompressedByteArray;
    }

    public long getFirstRevision() {
        return this.firstRevision;
    }

    public long getRevisionsCount() {
        return this.entries.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] asCompressedLevelNoneByteArray() throws SVNException {
        ByteArrayOutputStream byteArrayOutputStream;
        OutputStream outputStream = byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            outputStream = this.writeCompressedLevelNone(byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        finally {
            SVNFileUtil.closeFile(outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile(File packFile, boolean compress) throws SVNException {
        OutputStream outputStream = SVNFileUtil.openFileForWriting(packFile);
        try {
            outputStream = compress ? this.writeCompressedLevelDefault(outputStream) : this.writeCompressedLevelNone(outputStream);
        }
        finally {
            SVNFileUtil.closeFile(outputStream);
        }
    }

    private OutputStream writeCompressedLevelDefault(OutputStream outputStream) throws SVNException {
        return this.compressLevelDefault(this.asUncompressedByteArray(), outputStream);
    }

    private OutputStream writeCompressedLevelNone(OutputStream outputStream) throws SVNException {
        return SVNFSFSPackedRevProps.compressLevelNone(this.asUncompressedByteArray(), outputStream);
    }

    public SVNProperties parseProperties(long revision) throws SVNException {
        int revisionIndex = (int)(revision - this.getFirstRevision());
        if ((long)revisionIndex >= this.getRevisionsCount()) {
            return null;
        }
        Entry entry = this.entries.get(revisionIndex);
        return this.parseProperties(entry.data, entry.offset, entry.length);
    }

    private long getTotalSize() {
        long totalSize = 0L;
        for (Entry entry : this.entries) {
            totalSize += entry.getSize();
        }
        return totalSize;
    }

    private long getSerializedSize() throws SVNException {
        return this.asUncompressedByteArray().length;
    }

    public List<SVNFSFSPackedRevProps> setProperties(long revision, SVNProperties properties, long revPropPackSize) throws SVNException {
        byte[] propertiesByteArray = SVNFSFSPackedRevProps.composePropertiesByteArray(properties);
        long revisionIndex = revision - this.getFirstRevision();
        long newTotalSize = this.getTotalSize() - this.getSerializedSize() + (long)propertiesByteArray.length + (this.getRevisionsCount() + 2L) * 21L;
        this.setEntry(revision, propertiesByteArray);
        if (newTotalSize < revPropPackSize || this.entries.size() == 1) {
            return Collections.singletonList(this);
        }
        ArrayList<SVNFSFSPackedRevProps> packs = new ArrayList<SVNFSFSPackedRevProps>();
        int leftCount = 0;
        int rightCount = 0;
        int left = 0;
        int right = (int)this.getRevisionsCount() - 1;
        long leftSize = 42L;
        long rightSize = 42L;
        while (left <= right) {
            Entry leftEntry = this.entries.get(left);
            Entry rightEntry = this.entries.get(right);
            if (leftSize + leftEntry.getSize() < rightSize + rightEntry.getSize()) {
                leftSize += leftEntry.getSize();
                ++left;
                continue;
            }
            rightSize += rightEntry.getSize();
            --right;
        }
        leftCount = left;
        rightCount = (int)(this.getRevisionsCount() - (long)left);
        if (leftSize > revPropPackSize || rightSize > revPropPackSize) {
            leftCount = (int)revisionIndex;
            rightCount = (int)(this.getRevisionsCount() - (long)leftCount - 1L);
        }
        if (leftCount != 0) {
            long leftFirstRevision = this.getFirstRevision();
            packs.add(new SVNFSFSPackedRevProps(leftFirstRevision, this.entries.subList(0, leftCount), null));
        }
        if ((long)(leftCount + rightCount) < this.getRevisionsCount()) {
            long middleFirstRevision = revision;
            packs.add(new SVNFSFSPackedRevProps(middleFirstRevision, Collections.singletonList(this.entries.get((int)revisionIndex)), null));
        }
        if (rightCount != 0) {
            long rightFirstRevision = this.getRevisionsCount() - (long)rightCount + this.getFirstRevision();
            packs.add(new SVNFSFSPackedRevProps(rightFirstRevision, this.entries.subList((int)(this.getRevisionsCount() - (long)rightCount), (int)this.getRevisionsCount()), null));
        }
        return packs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] decompress(byte[] compressedData) throws SVNException {
        byte[] byArray;
        InputStream inputStream;
        ByteArrayOutputStream outputStream;
        block10: {
            byte[] byArray2;
            block9: {
                outputStream = null;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(compressedData);
                inputStream = byteArrayInputStream;
                try {
                    long uncompressedSize = SVNFSFSPackedRevProps.readEncodedUncompressedSize(byteArrayInputStream, 10);
                    if (uncompressedSize == (long)byteArrayInputStream.available()) {
                        byArray2 = SVNFSFSPackedRevProps.arrayCopyOfRange(compressedData, (int)((long)compressedData.length - uncompressedSize), (int)uncompressedSize);
                        SVNFileUtil.closeFile(inputStream);
                        break block9;
                    }
                    outputStream = new ByteArrayOutputStream();
                    inputStream = new InflaterInputStream(inputStream);
                    byte[] buffer = new byte[2048];
                    while (true) {
                        int read;
                        if ((read = inputStream.read(buffer)) < 0) {
                            byArray = outputStream.toByteArray();
                            SVNFileUtil.closeFile(inputStream);
                            break block10;
                        }
                        outputStream.write(buffer, 0, read);
                    }
                }
                catch (IOException e) {
                    SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR);
                    SVNErrorManager.error(errorMessage, e, SVNLogType.FSFS);
                    return null;
                }
            }
            SVNFileUtil.closeFile(outputStream);
            return byArray2;
        }
        SVNFileUtil.closeFile(outputStream);
        return byArray;
        finally {
            SVNFileUtil.closeFile(inputStream);
            SVNFileUtil.closeFile(outputStream);
        }
    }

    private static byte[] arrayCopyOfRange(byte[] bytes, int offset, int length) {
        byte[] copiedBytes = new byte[length];
        System.arraycopy(bytes, offset, copiedBytes, 0, length);
        return copiedBytes;
    }

    protected static OutputStream compressLevelNone(byte[] uncompressedData, OutputStream outputStream) throws SVNException {
        SVNFSFSPackedRevProps.writeEncodedUnCompressedSize(uncompressedData.length, outputStream);
        SVNFSFSPackedRevProps.writeBody(uncompressedData, outputStream);
        return outputStream;
    }

    private OutputStream compressLevelDefault(byte[] uncompressedData, OutputStream outputStream) throws SVNException {
        SVNFSFSPackedRevProps.writeEncodedUnCompressedSize(uncompressedData.length, outputStream);
        outputStream = new DeflaterOutputStream(outputStream);
        SVNFSFSPackedRevProps.writeBody(uncompressedData, outputStream);
        return outputStream;
    }

    private static void writeBody(byte[] bytes, OutputStream outputStream) throws SVNException {
        try {
            outputStream.write(bytes);
        }
        catch (IOException e) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR);
            SVNErrorManager.error(errorMessage, e, SVNLogType.FSFS);
        }
    }

    private static void writeEncodedUnCompressedSize(int compressedSize, OutputStream outputStream) throws SVNException {
        long v = compressedSize >> 7;
        int n = 1;
        while (v > 0L) {
            v >>= 7;
            ++n;
        }
        while (--n >= 0) {
            byte cont = (byte)((n > 0 ? 1 : 0) << 7);
            byte b = (byte)(compressedSize >> n * 7 & 0x7F | cont);
            try {
                outputStream.write(b);
            }
            catch (IOException e) {
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR);
                SVNErrorManager.error(errorMessage, e, SVNLogType.FSFS);
            }
        }
    }

    private static long readEncodedUncompressedSize(InputStream inputStream, int lengthRecordSize) throws SVNException {
        int c;
        int temp = 0;
        int bytesRead = 0;
        do {
            if (lengthRecordSize == bytesRead) {
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.SVNDIFF_INVALID_HEADER, "Decompression of svndiff data failed: size too large");
                SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
            }
            c = 0;
            try {
                c = inputStream.read();
            }
            catch (IOException e) {
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR);
                SVNErrorManager.error(errorMessage, e, SVNLogType.FSFS);
            }
            if (c < 0) {
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.SVNDIFF_UNEXPECTED_END, "Decompression of svndiff data failed: no size");
                SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
            }
            ++bytesRead;
            temp = temp << 7 | c & 0x7F;
        } while (c >= 128);
        return temp;
    }

    private byte[] asUncompressedByteArray() throws SVNException {
        if (this.cachedUncompressedByteArray == null) {
            this.cachedUncompressedByteArray = this.toUncompressedByteArray();
        }
        return this.cachedUncompressedByteArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SVNProperties parseProperties(byte[] data, int offset, int length) throws SVNException {
        try (FSFile fsFile = new FSFile(data, offset, length);){
            SVNProperties sVNProperties = fsFile.readProperties(false, true);
            return sVNProperties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] composePropertiesByteArray(SVNProperties properties) throws SVNException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            SVNWCProperties.setProperties(properties, byteArrayOutputStream, "END");
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        finally {
            SVNFileUtil.closeFile(byteArrayOutputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] toUncompressedByteArray() throws SVNException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.writeNumber(byteArrayOutputStream, this.getFirstRevision());
            this.writeNumber(byteArrayOutputStream, this.getRevisionsCount());
            for (Entry entry : this.entries) {
                this.writeNumber(byteArrayOutputStream, entry.getSize());
            }
            byteArrayOutputStream.write(10);
            for (Entry entry : this.entries) {
                byteArrayOutputStream.write(entry.data, entry.offset, entry.length);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        finally {
            SVNFileUtil.closeFile(byteArrayOutputStream);
        }
    }

    private void writeNumber(OutputStream outputStream, long number) throws SVNException {
        try {
            outputStream.write(String.valueOf(number).getBytes());
            outputStream.write(10);
        }
        catch (IOException e) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR);
            SVNErrorManager.error(errorMessage, e, SVNLogType.FSFS);
        }
    }

    private static long readNumber(InputStream inputStream) throws SVNException {
        char[] digits = new char[20];
        int digitsCount = 0;
        while (true) {
            SVNErrorMessage errorMessage;
            int c = 0;
            try {
                c = inputStream.read();
            }
            catch (IOException e) {
                SVNErrorMessage errorMessage2 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR);
                SVNErrorManager.error(errorMessage2, e, SVNLogType.FSFS);
            }
            if (c < 0) {
                errorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT);
                SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
            }
            if (c != 10 && (c < 48 || c > 57)) {
                errorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT);
                SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
            }
            if (c == 10) {
                return Long.parseLong(new String(digits, 0, digitsCount));
            }
            digits[digitsCount] = (char)c;
            ++digitsCount;
        }
    }

    private void setEntry(long revision, byte[] data) {
        this.invalidateCaches();
        this.entries.set((int)(revision - this.getFirstRevision()), new Entry(data, 0, data.length));
    }

    private void invalidateCaches() {
        this.cachedUncompressedByteArray = null;
    }

    private static class Entry {
        private byte[] data;
        private int offset;
        private int length;

        private Entry(byte[] data, int offset, int length) {
            this.data = data;
            this.offset = offset;
            this.length = length;
        }

        public long getSize() {
            return this.length;
        }
    }

    public static class Builder {
        private long firstRevision = -1L;
        private final List<Entry> entries = new ArrayList<Entry>();

        public SVNFSFSPackedRevProps build() throws SVNException {
            if (!SVNRevision.isValidRevisionNumber(this.firstRevision)) {
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS, "First revision is not set");
                SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
            }
            return new SVNFSFSPackedRevProps(this.firstRevision, this.entries, null);
        }

        public void setFirstRevision(long firstRevision) {
            this.firstRevision = firstRevision;
        }

        public void addByteArrayEntry(byte[] data) {
            this.addByteArrayEntry(data, 0, data.length);
        }

        public void addByteArrayEntry(byte[] data, int offset, int length) {
            this.entries.add(new Entry(data, offset, length));
        }

        public void addPropertiesEntry(SVNProperties properties) throws SVNException {
            this.addByteArrayEntry(SVNFSFSPackedRevProps.composePropertiesByteArray(properties));
        }
    }
}

