/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.mssql.tab;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.BasePreparedStatementTab;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class TriggerDetailsTab
extends BasePreparedStatementTab {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(TriggerDetailsTab.class);
    private static String SQL = "SELECT     tr.name AS [trigger],            tb.name AS [table],            sc.name AS [schema],            tr.create_date AS [create date],            tr.type_desc AS [type],            CASE (select type_desc from sys.trigger_events WHERE sys.trigger_events.object_id = tr.object_id AND type = 1)                WHEN 'INSERT' THEN 'Yes' ELSE 'No'            END [insert event],            CASE (select type_desc from sys.trigger_events WHERE sys.trigger_events.object_id = tr.object_id AND type = 2)                WHEN 'UPDATE' THEN 'Yes' ELSE 'No'            END [update event],            CASE (select type_desc from sys.trigger_events WHERE sys.trigger_events.object_id = tr.object_id AND type = 3)                WHEN 'DELETE' THEN 'Yes' ELSE 'No'            END [delete event] FROM       sys.schemas sc JOIN            sys.tables tb ON sc.schema_id = tb.schema_id JOIN            sys.triggers tr ON tb.object_id = tr.parent_id WHERE tr.name = ? AND sc.name = ?";
    private static final ILogger s_log = LoggerController.createLogger(TriggerDetailsTab.class);

    public TriggerDetailsTab() {
        super(i18n.TITLE, i18n.HINT, true);
    }

    protected PreparedStatement createStatement() throws SQLException {
        ISession session = this.getSession();
        IDatabaseObjectInfo doi = this.getDatabaseObjectInfo();
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Trigger details SQL: " + SQL));
            s_log.debug((Object)("Trigger name: " + doi.getSimpleName()));
            s_log.debug((Object)("Trigger schema: " + doi.getSchemaName()));
        }
        PreparedStatement pstmt = session.getSQLConnection().prepareStatement(SQL);
        pstmt.setString(1, doi.getSimpleName());
        pstmt.setString(2, doi.getSchemaName());
        return pstmt;
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    private static interface i18n {
        public static final String TITLE = TriggerDetailsTab.access$000().getString("TriggerDetailsTab.title");
        public static final String HINT = TriggerDetailsTab.access$000().getString("TriggerDetailsTab.hint");
    }
}

