/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class DockFrame
extends JPanel {
    private static final String PREFS_KEY_DOCK_AUTO_HIDE_ON = "squirrelSql_dock_auto_hide.";
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DockFrame.class);
    private Container _comp;
    private String _title;
    private JLabel _lblTitle;
    private JButton _btnAutoHide;
    private JButton _btnMinimize;
    private ImageIcon _iconAutohideOff;
    private ImageIcon _iconAutohideOn;

    public DockFrame(IApplication app, Container comp, String title) {
        this._comp = comp;
        this._title = title;
        this.setLayout(new BorderLayout());
        this.add((Component)this.createTitlePanel(app), "North");
        this.add((Component)this._comp, "Center");
    }

    private JPanel createTitlePanel(IApplication app) {
        JPanel ret = new JPanel();
        ret.setBorder(BorderFactory.createEtchedBorder());
        Color bg = new Color(102, 153, 255);
        ret.setBackground(bg);
        ret.setLayout(new GridBagLayout());
        this._lblTitle = new JLabel(this._title);
        this._lblTitle.setBackground(bg);
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
        ret.add((Component)this._lblTitle, gbc);
        this._iconAutohideOff = app.getResources().getIcon("autohideOff");
        this._iconAutohideOn = app.getResources().getIcon("autohideOn");
        this._btnAutoHide = Props.getBoolean(PREFS_KEY_DOCK_AUTO_HIDE_ON + this._title, true) ? new JButton(this._iconAutohideOn) : new JButton(this._iconAutohideOff);
        this._btnAutoHide.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DockFrame.this.onAutoHide();
            }
        });
        this._btnAutoHide.setToolTipText(s_stringMgr.getString("DockFrame.autoHideToolTip"));
        this._btnAutoHide.setBorder(BorderFactory.createEmptyBorder());
        this._btnAutoHide.setBackground(bg);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        ret.add((Component)this._btnAutoHide, gbc);
        this._btnMinimize = new JButton(app.getResources().getIcon("minimize"));
        this._btnMinimize.setToolTipText(s_stringMgr.getString("DockFrame.minimizeToolTip"));
        this._btnMinimize.setBorder(BorderFactory.createEmptyBorder());
        this._btnMinimize.setBackground(bg);
        gbc = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        ret.add((Component)this._btnMinimize, gbc);
        return ret;
    }

    private void onAutoHide() {
        if (this._btnAutoHide.getIcon() == this._iconAutohideOn) {
            this._btnAutoHide.setIcon(this._iconAutohideOff);
            Props.putBoolean(PREFS_KEY_DOCK_AUTO_HIDE_ON + this._title, false);
        } else if (this._btnAutoHide.getIcon() == this._iconAutohideOff) {
            this._btnAutoHide.setIcon(this._iconAutohideOn);
            Props.putBoolean(PREFS_KEY_DOCK_AUTO_HIDE_ON + this._title, true);
        } else {
            throw new IllegalStateException("undefined autohide state");
        }
    }

    public Container getComp() {
        return this._comp;
    }

    public JButton getMinimizeButton() {
        return this._btnMinimize;
    }

    public boolean isAutoHide() {
        return this._btnAutoHide.getIcon() == this._iconAutohideOn;
    }
}

