/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class DropedFileExtractor {
    private static final ILogger s_log = LoggerController.createLogger(DropedFileExtractor.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DropedFileExtractor.class);

    public static File getFile(DropTargetDropEvent dtde, IApplication app) {
        List<File> files = DropedFileExtractor._getFiles(dtde, app, true);
        if (0 == files.size()) {
            return null;
        }
        return files.get(0);
    }

    public static List<File> getFiles(DropTargetDropEvent dtde, IApplication app) {
        return DropedFileExtractor._getFiles(dtde, app, true);
    }

    private static List<File> _getFiles(DropTargetDropEvent dtde, IApplication app, boolean allowMoreThanOneFile) {
        try {
            DropTargetContext context = dtde.getDropTargetContext();
            dtde.acceptDrop(3);
            Transferable t = dtde.getTransferable();
            List<Object> filesToOpen = new ArrayList();
            filesToOpen = t.isDataFlavorSupported(DataFlavor.javaFileListFlavor) ? DropedFileExtractor.handleJavaFileListFlavor(t, app, allowMoreThanOneFile) : (t.isDataFlavorSupported(DataFlavor.stringFlavor) ? DropedFileExtractor.handleStringFlavor(t, app, allowMoreThanOneFile) : DropedFileExtractor.handleUriListFlavor(t));
            context.dropComplete(true);
            if (null != filesToOpen) {
                return filesToOpen;
            }
            return new ArrayList<File>();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static List<File> handleUriListFlavor(Transferable transferable) throws ClassNotFoundException {
        DataFlavor uriListFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
        File result = null;
        try {
            if (transferable.isDataFlavorSupported(uriListFlavor)) {
                String data = (String)transferable.getTransferData(uriListFlavor);
                List<File> fileList = DropedFileExtractor.textURIListToFileList(data);
                result = fileList.get(0);
            } else {
                s_log.error("handleUriListFlavor: no support for text/uri-list data flavor");
            }
        }
        catch (Exception e) {
            s_log.error("handleUriListFlavor: unexpected excption - " + e.getMessage(), e);
        }
        ArrayList<File> ret = new ArrayList<File>();
        ret.add(result);
        return ret;
    }

    private static List<File> handleStringFlavor(Transferable t, IApplication app, boolean allowMoreThanOneFile) throws UnsupportedFlavorException, IOException {
        ArrayList<File> result = new ArrayList<File>();
        String transferData = (String)t.getTransferData(DataFlavor.stringFlavor);
        if (transferData != null) {
            if (transferData.startsWith("file://")) {
                try {
                    StringTokenizer st = new StringTokenizer(transferData);
                    if (st.countTokens() > 1 && !allowMoreThanOneFile) {
                        app.getMessageHandler().showErrorMessage(i18n.ONE_FILE_DROP_MESSAGE);
                    }
                    while (st.hasMoreTokens()) {
                        String fileUrlStr = st.nextToken();
                        URI uri = new URI(fileUrlStr);
                        if (!uri.isAbsolute()) continue;
                        result.add(new File(uri));
                    }
                }
                catch (URISyntaxException e) {
                    s_log.error("handleUriListString: encountered an invalid URI: " + transferData, e);
                }
            } else {
                result.add(new File(transferData));
            }
        }
        return result;
    }

    private static List<File> handleJavaFileListFlavor(Transferable t, IApplication app, boolean allowMoreThanOneFile) throws UnsupportedFlavorException, IOException {
        List result = null;
        List transferData = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
        if (transferData == null || transferData.size() == 0) {
            s_log.error("Transferable.getTransferData returned a null/empty list");
            app.getMessageHandler().showErrorMessage(i18n.INTERNAL_ERROR_MESSAGE);
        } else if (transferData.size() > 1 && !allowMoreThanOneFile) {
            app.getMessageHandler().showErrorMessage(i18n.ONE_FILE_DROP_MESSAGE);
        } else {
            result = transferData;
            if (s_log.isInfoEnabled()) {
                s_log.info("drop: path=" + ((File)result.get(0)).getAbsolutePath());
            }
        }
        return result;
    }

    private static List<File> textURIListToFileList(String data) {
        ArrayList<File> list = new ArrayList<File>(1);
        StringTokenizer st = new StringTokenizer(data, "\r\n");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.startsWith("#")) continue;
            try {
                URI uri = new URI(s);
                File file = new File(uri);
                list.add(file);
            }
            catch (URISyntaxException uRISyntaxException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return list;
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    private static interface i18n {
        public static final String ONE_FILE_DROP_MESSAGE = DropedFileExtractor.access$000().getString("FileEditorDropTargetListener.oneFileDropMessage");
        public static final String INTERNAL_ERROR_MESSAGE = DropedFileExtractor.access$000().getString("FileEditorDropTargetListener.internalErrorMessage");
    }
}

