/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.preferences.shortcut;

import java.awt.Color;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.preferences.shortcut.ShortcutPrefsPanel;
import net.sourceforge.squirrel_sql.client.shortcut.Shortcut;
import net.sourceforge.squirrel_sql.client.shortcut.ShortcutUtil;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.JavabeanArrayDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.TableState;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class ShortcutPrefsCtrl {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ShortcutPrefsCtrl.class);
    private static final String PREF_KEY_ACTION_NAME_COL_WIDTH = "ShortcutPrefsCtrl.column.actionName.width";
    private static final String PREF_KEY_VALID_SHORTCUT_COL_WIDTH = "ShortcutPrefsCtrl.column.validShortcut.width";
    private static final String PREF_KEY_DEFAULT_SHORTCUT_COL_WIDTH = "ShortcutPrefsCtrl.column.defaultShortcut.width";
    public static final String COL_HEADER_ACTION_NAME = s_stringMgr.getString("ShortcutPrefsCtrl.column.actionName");
    public static final String COL_HEADER_VALID_SHORTCUT = s_stringMgr.getString("ShortcutPrefsCtrl.column.validKeyStroke");
    public static final String COL_HEADER_DEFAULT_SHORTCUT = s_stringMgr.getString("ShortcutPrefsCtrl.column.defaultKeyStroke");
    private ShortcutPrefsPanel _shortcutPrefsPanel = new ShortcutPrefsPanel();
    private KeyStroke _currentKeyStroke;
    private List<Shortcut> _shortcuts;
    private JavabeanArrayDataSet _shortcutDataSet;

    public void applyChanges() {
        Props.putInt(PREF_KEY_ACTION_NAME_COL_WIDTH, this._shortcutPrefsPanel.tblShortcuts.getColumnWidthForHeader(COL_HEADER_ACTION_NAME));
        Props.putInt(PREF_KEY_VALID_SHORTCUT_COL_WIDTH, this._shortcutPrefsPanel.tblShortcuts.getColumnWidthForHeader(COL_HEADER_VALID_SHORTCUT));
        Props.putInt(PREF_KEY_DEFAULT_SHORTCUT_COL_WIDTH, this._shortcutPrefsPanel.tblShortcuts.getColumnWidthForHeader(COL_HEADER_DEFAULT_SHORTCUT));
        Main.getApplication().getShortcutManager().save();
    }

    public JPanel getPanel() {
        this._shortcuts = Main.getApplication().getShortcutManager().getShortcuts();
        this._shortcutDataSet = new JavabeanArrayDataSet(Shortcut.class);
        this._shortcutDataSet.setColHeader("actionName", COL_HEADER_ACTION_NAME);
        this._shortcutDataSet.setColPos("actionName", 1);
        this._shortcutDataSet.setAbsoluteWidht("actionName", Props.getInt(PREF_KEY_ACTION_NAME_COL_WIDTH, 200));
        this._shortcutDataSet.setColHeader("validKeyStroke", COL_HEADER_VALID_SHORTCUT);
        this._shortcutDataSet.setColPos("validKeyStroke", 2);
        this._shortcutDataSet.setAbsoluteWidht("validKeyStroke", Props.getInt(PREF_KEY_VALID_SHORTCUT_COL_WIDTH, 200));
        this._shortcutDataSet.setColHeader("defaultKeyStroke", COL_HEADER_DEFAULT_SHORTCUT);
        this._shortcutDataSet.setColPos("defaultKeyStroke", 2);
        this._shortcutDataSet.setAbsoluteWidht("defaultKeyStroke", Props.getInt(PREF_KEY_DEFAULT_SHORTCUT_COL_WIDTH, 200));
        this._shortcutDataSet.setIgnoreProperty("userKeyStroke");
        this.displayShortcuts();
        this._shortcutPrefsPanel.tblShortcuts.getTable().setSelectionMode(0);
        this._shortcutPrefsPanel.tblShortcuts.getTable().getSelectionModel().setSelectionInterval(0, 0);
        this._shortcutPrefsPanel.tblShortcuts.addRowSelectionListener((nowSelectedIx, formerSelectedIx) -> this.onSelectedShortcutChanged());
        this._shortcutPrefsPanel.txtShortcut.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                ShortcutPrefsCtrl.this.onKeyPressed(e);
            }
        });
        this._shortcutPrefsPanel.btnApply.addActionListener(e -> this.onApply());
        this._shortcutPrefsPanel.btnRemove.addActionListener(e -> this.onRemove());
        this._shortcutPrefsPanel.btnRestoreDefault.addActionListener(e -> this.onRestore());
        this._shortcutPrefsPanel.btnRestoreAll.addActionListener(e -> this.onRestoreAll());
        this._shortcutPrefsPanel.tblShortcuts.getTable().getColoringService().setColoringCallback((row, column, isSelected) -> this.onGetCellColor(row, column, isSelected));
        this.onSelectedShortcutChanged();
        return this._shortcutPrefsPanel;
    }

    private Color onGetCellColor(int row, int column, boolean isSelected) {
        int modelColumn = this._shortcutPrefsPanel.tblShortcuts.getTable().getColumnModel().getColumn(column).getModelIndex();
        if (2 != modelColumn) {
            return null;
        }
        int modelRow = this._shortcutPrefsPanel.tblShortcuts.getTable().getSortableTableModel().transformToModelRow(row);
        this._shortcuts.get(modelRow);
        for (Shortcut shortcut : this._shortcuts) {
            if (shortcut == this._shortcuts.get(modelRow) || null == shortcut.getValidKeyStroke() || null == this._shortcuts.get(modelRow).getValidKeyStroke() || !Utilities.equalsRespectNull(shortcut.getValidKeyStroke(), this._shortcuts.get(modelRow).getValidKeyStroke())) continue;
            if (isSelected) {
                return new Color(255, 100, 100).darker();
            }
            return new Color(255, 100, 100);
        }
        if (this._shortcuts.get(modelRow).hasUserKeyStroke()) {
            if (isSelected) {
                return Color.green.darker();
            }
            return Color.green;
        }
        return null;
    }

    private void onSelectedShortcutChanged() {
        this.updateEnabled();
        if (0 == this._shortcutPrefsPanel.tblShortcuts.getSelectedModelRows().length) {
            this._shortcutPrefsPanel.txtSelectedShortcut.setText(s_stringMgr.getString("ShortcutPrefsPanel.txt.shortcut.formated", "<No selection>", "<No selection"));
            return;
        }
        Shortcut selectedShortcut = this.getSelectedShortcut();
        this._shortcutPrefsPanel.txtSelectedShortcut.setText(s_stringMgr.getString("ShortcutPrefsPanel.txt.shortcut.formated", selectedShortcut.getActionName(), selectedShortcut.getDefaultKeyStroke()));
    }

    private void displayShortcuts() {
        try {
            int[] selectedModelRows = this._shortcutPrefsPanel.tblShortcuts.getSelectedModelRows();
            TableState tableState = this._shortcutPrefsPanel.tblShortcuts.getResultSortableTableState();
            this._shortcutDataSet.setJavaBeanList(this._shortcuts);
            this._shortcutPrefsPanel.tblShortcuts.show(this._shortcutDataSet);
            this._shortcutPrefsPanel.tblShortcuts.applyResultSortableTableState(tableState);
            Runnable runnable = () -> this.handleSelectAfterUpdateEvenWhenValidShortcutIsSorted(selectedModelRows);
            SwingUtilities.invokeLater(runnable);
        }
        catch (DataSetException e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    private void handleSelectAfterUpdateEvenWhenValidShortcutIsSorted(int[] selectedModelRows) {
        if (selectedModelRows.length > 0) {
            int viewRow = this._shortcutPrefsPanel.tblShortcuts.getTable().getSortableTableModel().transformToViewRow(selectedModelRows[0]);
            this._shortcutPrefsPanel.tblShortcuts.getTable().getSelectionModel().setSelectionInterval(viewRow, viewRow);
            if (2 == this._shortcutPrefsPanel.tblShortcuts.getTable().getSortableTableModel().getSortedColumn()) {
                this._shortcutPrefsPanel.tblShortcuts.getTable().scrollToVisible(viewRow, 1);
            }
        }
    }

    private void onApply() {
        Shortcut selectedShortcut = this.getSelectedShortcut();
        if (null == this._currentKeyStroke) {
            throw new IllegalStateException("Should not happen. I.e. Apply button should be disabled when there is no _currentKeyStroke.");
        }
        selectedShortcut.setUserKeyStroke(this._currentKeyStroke);
        this.displayShortcuts();
    }

    private void onRemove() {
        Shortcut selectedShortcut = this.getSelectedShortcut();
        selectedShortcut.setUserKeyStrokeEmpty();
        this.displayShortcuts();
    }

    private void onRestore() {
        Shortcut selectedShortcut = this.getSelectedShortcut();
        selectedShortcut.restoreDefault();
        this.displayShortcuts();
    }

    private void onRestoreAll() {
        if (0 != JOptionPane.showConfirmDialog(this._shortcutPrefsPanel, s_stringMgr.getString("ShortcutPrefsCtrl.restore.all.question"))) {
            return;
        }
        for (Shortcut shortcut : this._shortcuts) {
            shortcut.restoreDefault();
        }
        this.displayShortcuts();
    }

    private Shortcut getSelectedShortcut() {
        int[] seletedModelRows = this._shortcutPrefsPanel.tblShortcuts.getSelectedModelRows();
        if (1 != seletedModelRows.length) {
            throw new IllegalStateException("Should not happen. I.e. Apply button should be disabled when no shortcut is selected.");
        }
        return this._shortcuts.get(seletedModelRows[0]);
    }

    private void onKeyPressed(KeyEvent e) {
        this._currentKeyStroke = KeyStroke.getKeyStrokeForEvent(e);
        String shortcutText = ShortcutUtil.getKeystrokeString(this._currentKeyStroke);
        if (0 != e.getModifiers() && (e.getKeyCode() == 16 || e.getKeyCode() == 18 || e.getKeyCode() == 17 || e.getKeyCode() == 524 || e.getKeyCode() == 157)) {
            shortcutText = null;
            this._currentKeyStroke = null;
        }
        String finalShortcutText = shortcutText;
        SwingUtilities.invokeLater(() -> this._shortcutPrefsPanel.txtShortcut.setText(finalShortcutText));
        this.updateEnabled();
        e.consume();
    }

    private void updateEnabled() {
        this._shortcutPrefsPanel.btnApply.setEnabled(null != this._currentKeyStroke && 1 == this._shortcutPrefsPanel.tblShortcuts.getSeletedRows().length);
        this._shortcutPrefsPanel.btnRestoreDefault.setEnabled(1 == this._shortcutPrefsPanel.tblShortcuts.getSeletedRows().length);
    }
}

