/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.overview;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.CallDepthComboModel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.ChartConfigController;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.ChartConfigMode;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.ChartConfigPanelTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.ChartConfigPanelTabMode;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.ChartHandler;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.ColumnComboModel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.TimeScale;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.DataScale;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.DataScaleTable;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.IndexedColumnFactory;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class ChartConfigPanelTabController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ChartConfigController.class);
    private IApplication _app;
    private ChartConfigPanelTabMode _chartConfigPanelTabMode;
    private ChartConfigPanelTab _chartConfigPanelTab;
    private DataScaleTable _dataScaleTable;

    public ChartConfigPanelTabController(IApplication app, ChartConfigPanelTabMode chartConfigPanelTabMode) {
        this._app = app;
        this._chartConfigPanelTabMode = chartConfigPanelTabMode;
        this._chartConfigPanelTab = new ChartConfigPanelTab(chartConfigPanelTabMode);
        if (chartConfigPanelTabMode != ChartConfigPanelTabMode.XY_CHART && chartConfigPanelTabMode != ChartConfigPanelTabMode.DIFFERENCES_CHART) {
            this._chartConfigPanelTab.cboCallDepth.setModel(new DefaultComboBoxModel<CallDepthComboModel>(CallDepthComboModel.createModels()));
            this._chartConfigPanelTab.cboCallDepth.setSelectedItem(CallDepthComboModel.getDefaultSelected());
        }
        if (this._chartConfigPanelTabMode == ChartConfigPanelTabMode.SINGLE_COLUMN) {
            this._chartConfigPanelTab.cboXColumns.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ChartConfigPanelTabController.this.onColumnSelected(e, ((ChartConfigPanelTabController)ChartConfigPanelTabController.this)._chartConfigPanelTab.cboXColumns);
                }
            });
        } else if (this._chartConfigPanelTabMode == ChartConfigPanelTabMode.TWO_COLUMN) {
            this._chartConfigPanelTab.cboYColumns.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ChartConfigPanelTabController.this.onColumnSelected(e, ((ChartConfigPanelTabController)ChartConfigPanelTabController.this)._chartConfigPanelTab.cboYColumns);
                }
            });
        } else if (this._chartConfigPanelTabMode == ChartConfigPanelTabMode.XY_CHART) {
            this._chartConfigPanelTab.cboYColumns.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ChartConfigPanelTabController.this.onColumnSelected(e, ((ChartConfigPanelTabController)ChartConfigPanelTabController.this)._chartConfigPanelTab.cboYColumns);
                }
            });
        } else if (this._chartConfigPanelTabMode == ChartConfigPanelTabMode.DIFFERENCES_CHART) {
            this._chartConfigPanelTab.cboTimeScale.setModel(new DefaultComboBoxModel<TimeScale>(TimeScale.values()));
            this._chartConfigPanelTab.cboYColumns.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ChartConfigPanelTabController.this.onColumnSelected(e, ((ChartConfigPanelTabController)ChartConfigPanelTabController.this)._chartConfigPanelTab.cboYColumns);
                }
            });
        }
        this._chartConfigPanelTab.btnChart.addActionListener(e -> this.onChart());
    }

    public void setDataScaleTable(DataScaleTable dataScaleTable) {
        this._dataScaleTable = dataScaleTable;
        if (this._chartConfigPanelTabMode == ChartConfigPanelTabMode.SINGLE_COLUMN) {
            this.fillColumnCombo(this._chartConfigPanelTab.cboXColumns, false);
        } else if (this._chartConfigPanelTabMode == ChartConfigPanelTabMode.TWO_COLUMN) {
            this.fillColumnCombo(this._chartConfigPanelTab.cboXColumns, false);
            this.fillColumnCombo(this._chartConfigPanelTab.cboYColumns, false);
        } else if (this._chartConfigPanelTabMode == ChartConfigPanelTabMode.XY_CHART) {
            this.fillColumnCombo(this._chartConfigPanelTab.cboXColumns, true);
            this.fillColumnCombo(this._chartConfigPanelTab.cboYColumns, true);
        } else if (this._chartConfigPanelTabMode == ChartConfigPanelTabMode.DIFFERENCES_CHART) {
            this.fillColumnCombo(this._chartConfigPanelTab.cboXColumns, true);
            this.fillColumnCombo(this._chartConfigPanelTab.cboYColumns, true);
        }
        this.onColumnSelected(null, this._chartConfigPanelTab.cboXColumns);
    }

    private void fillColumnCombo(JComboBox cboColumns, boolean numbersAndTemporalOnly) {
        ColumnComboModel formerSelectedItem = (ColumnComboModel)cboColumns.getSelectedItem();
        DefaultComboBoxModel<ColumnComboModel> defaultComboBoxModel = new DefaultComboBoxModel<ColumnComboModel>(ColumnComboModel.createColumnComboModels(this._dataScaleTable, numbersAndTemporalOnly));
        cboColumns.setModel(defaultComboBoxModel);
        cboColumns.setSelectedItem(formerSelectedItem);
        if (null == cboColumns.getSelectedItem() && 0 < cboColumns.getItemCount()) {
            cboColumns.setSelectedIndex(0);
        }
    }

    private void onColumnSelected(ItemEvent e, JComboBox cboColumns) {
        if (this._chartConfigPanelTabMode == ChartConfigPanelTabMode.XY_CHART) {
            return;
        }
        if (null == e || 1 == e.getStateChange()) {
            if (this._chartConfigPanelTabMode == ChartConfigPanelTabMode.DIFFERENCES_CHART) {
                ColumnComboModel selectedColumn = (ColumnComboModel)cboColumns.getSelectedItem();
                this._chartConfigPanelTab.cboTimeScale.setEnabled(IndexedColumnFactory.isTemporal(selectedColumn.getColumnDisplayDefinition()));
            } else {
                ColumnComboModel selectedColumn = (ColumnComboModel)cboColumns.getSelectedItem();
                this._chartConfigPanelTab.cboYAxisKind.setModel(new DefaultComboBoxModel<ChartConfigMode>(ChartConfigMode.getAvailableValues(selectedColumn.getColumnDisplayDefinition(), this._chartConfigPanelTabMode)));
            }
        }
    }

    private void onChart() {
        ColumnComboModel selectedXAxisColumn = (ColumnComboModel)this._chartConfigPanelTab.cboXColumns.getSelectedItem();
        DataScale xAxisDataScale = this._dataScaleTable.getDataScaleTableModel().getDataScaleAt(selectedXAxisColumn.getColumnIndexInDataScale());
        DataScale yAxisDataScale = null;
        if (this._chartConfigPanelTabMode != ChartConfigPanelTabMode.SINGLE_COLUMN) {
            ColumnComboModel selectedYAxisColumn = (ColumnComboModel)this._chartConfigPanelTab.cboYColumns.getSelectedItem();
            yAxisDataScale = this._dataScaleTable.getDataScaleTableModel().getDataScaleAt(selectedYAxisColumn.getColumnIndexInDataScale());
        }
        Integer callDepth = null;
        ChartConfigMode chartConfigMode = null;
        if (this._chartConfigPanelTabMode != ChartConfigPanelTabMode.XY_CHART && this._chartConfigPanelTabMode != ChartConfigPanelTabMode.DIFFERENCES_CHART) {
            CallDepthComboModel selItem = (CallDepthComboModel)this._chartConfigPanelTab.cboCallDepth.getSelectedItem();
            callDepth = selItem.getCallDepth();
            chartConfigMode = (ChartConfigMode)((Object)this._chartConfigPanelTab.cboYAxisKind.getSelectedItem());
        }
        TimeScale timeScale = null;
        if (this._chartConfigPanelTabMode == ChartConfigPanelTabMode.DIFFERENCES_CHART && this._chartConfigPanelTab.cboTimeScale.isEnabled()) {
            timeScale = (TimeScale)((Object)this._chartConfigPanelTab.cboTimeScale.getSelectedItem());
        }
        ChartHandler.doChart(xAxisDataScale, yAxisDataScale, this._dataScaleTable, callDepth, this._chartConfigPanelTabMode, chartConfigMode, GUIUtils.getOwningFrame(this._dataScaleTable), timeScale);
    }

    public ChartConfigPanelTab getPanel() {
        return this._chartConfigPanelTab;
    }
}

