/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.CellDataPopup;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BaseDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BaseKeyTextHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BinaryDisplayConverter;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BlobDescriptor;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DTProperties;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DefaultColumnRenderer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IRestorableTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextArea;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextField;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.EmptyWhereClausePart;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.IWhereClausePart;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.IsNullWhereClausePart;
import net.sourceforge.squirrel_sql.fw.gui.IntegerField;
import net.sourceforge.squirrel_sql.fw.gui.OkJPanel;
import net.sourceforge.squirrel_sql.fw.gui.ReadTypeCombo;
import net.sourceforge.squirrel_sql.fw.gui.RightLabel;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class DataTypeBlob
extends BaseDataTypeComponent
implements IDataTypeComponent {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DataTypeBlob.class);
    private boolean _isNullable;
    private JTable _table;
    private IRestorableTextComponent _textComponent;
    private DefaultColumnRenderer _renderer = DefaultColumnRenderer.getInstance();
    private static final String thisClassName = "net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeBlob";
    private static int LARGE_COLUMN_DEFAULT_READ_LENGTH = 255;
    private static boolean propertiesAlreadyLoaded = false;
    private static boolean _readBlobs = false;
    private static boolean _readCompleteBlobs = false;
    private static int _readBlobsSize = LARGE_COLUMN_DEFAULT_READ_LENGTH;

    public DataTypeBlob(JTable table, ColumnDisplayDefinition colDef) {
        this._table = table;
        this._colDef = colDef;
        this._isNullable = colDef.isNullable();
        DataTypeBlob.loadProperties();
    }

    private static void loadProperties() {
        if (!propertiesAlreadyLoaded) {
            _readBlobs = false;
            String readBlobsString = DTProperties.get(thisClassName, "readBlobs");
            if (readBlobsString != null && readBlobsString.equals("true")) {
                _readBlobs = true;
            }
            _readCompleteBlobs = false;
            String readCompleteBlobsString = DTProperties.get(thisClassName, "readCompleteBlobs");
            if (readCompleteBlobsString != null && readCompleteBlobsString.equals("true")) {
                _readCompleteBlobs = true;
            }
            _readBlobsSize = LARGE_COLUMN_DEFAULT_READ_LENGTH;
            String readBlobsSizeString = DTProperties.get(thisClassName, "readBlobsSize");
            if (readBlobsSizeString != null) {
                _readBlobsSize = Integer.parseInt(readBlobsSizeString);
            }
            propertiesAlreadyLoaded = true;
        }
    }

    @Override
    public String getClassName() {
        return "net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BlobDescriptor";
    }

    @Override
    public String renderObject(Object value) {
        return (String)this._renderer.renderObject(value);
    }

    @Override
    public boolean isEditableInCell(Object originalValue) {
        if (!_readBlobs) {
            return false;
        }
        return this.wholeBlobRead((BlobDescriptor)originalValue);
    }

    @Override
    public boolean needToReRead(Object originalValue) {
        return false;
    }

    @Override
    public JTextField getJTextField() {
        this._textComponent = new RestorableJTextField();
        ((RestorableJTextField)this._textComponent).addKeyListener(new KeyTextHandler());
        ((RestorableJTextField)this._textComponent).addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    MouseEvent tableEvt = SwingUtilities.convertMouseEvent((RestorableJTextField)DataTypeBlob.this._textComponent, evt, DataTypeBlob.this._table);
                    CellDataPopup.showDialog(DataTypeBlob.this._table, DataTypeBlob.this._colDef, tableEvt, true);
                }
            }
        });
        return (JTextField)((Object)this._textComponent);
    }

    @Override
    public Object validateAndConvert(String value, Object originalValue, StringBuffer messageBuffer) {
        BlobDescriptor bdesc;
        Byte[] byteClassData;
        if (value.equals("<null>")) {
            return null;
        }
        try {
            byteClassData = BinaryDisplayConverter.convertToBytes(value, 16, false);
        }
        catch (Exception e) {
            messageBuffer.append(e.toString() + "\n");
            return null;
        }
        byte[] byteData = new byte[byteClassData.length];
        for (int i = 0; i < byteClassData.length; ++i) {
            byteData[i] = byteClassData[i];
        }
        if (originalValue == null) {
            bdesc = new BlobDescriptor(null, byteData, true, true, 0);
        } else {
            bdesc = (BlobDescriptor)originalValue;
            bdesc = new BlobDescriptor(bdesc.getBlob(), byteData, true, true, 0);
        }
        return bdesc;
    }

    @Override
    public boolean useBinaryEditingPanel() {
        return true;
    }

    @Override
    public boolean isEditableInPopup(Object originalValue) {
        return this.wholeBlobRead((BlobDescriptor)originalValue);
    }

    @Override
    public JTextArea getJTextArea(Object value) {
        this._textComponent = new RestorableJTextArea();
        ((RestorableJTextArea)this._textComponent).setText(this.renderObject(value));
        ((RestorableJTextArea)this._textComponent).addKeyListener(new KeyTextHandler());
        return (RestorableJTextArea)this._textComponent;
    }

    @Override
    public Object validateAndConvertInPopup(String value, Object originalValue, StringBuffer messageBuffer) {
        return this.validateAndConvert(value, originalValue, messageBuffer);
    }

    private boolean wholeBlobRead(BlobDescriptor bdesc) {
        if (bdesc == null) {
            return true;
        }
        if (bdesc.getWholeBlobRead()) {
            return true;
        }
        try {
            System.out.println("reading bytes from BLOB");
            byte[] data = bdesc.getBlob().getBytes(1L, (int)bdesc.getBlob().length());
            bdesc.setBlobRead(true);
            bdesc.setData(data);
            bdesc.setWholeBlobRead(true);
            bdesc.setUserSetBlobLimit(0);
            return true;
        }
        catch (Exception ex) {
            bdesc.setBlobRead(false);
            bdesc.setWholeBlobRead(false);
            bdesc.setData(null);
            return false;
        }
    }

    @Override
    public Object readResultSet(ResultSet rs, int index, boolean limitDataRead) throws SQLException {
        return DataTypeBlob.staticReadResultSet(rs, index);
    }

    public static Object staticReadResultSet(ResultSet rs, int index) throws SQLException {
        Blob blob = rs.getBlob(index);
        if (rs.wasNull()) {
            return null;
        }
        if (_readBlobs) {
            int len;
            byte[] blobData = null;
            if (blob != null && (len = (int)blob.length()) > 0) {
                int charsToRead = len;
                if (!_readCompleteBlobs) {
                    charsToRead = _readBlobsSize;
                }
                if (charsToRead > len) {
                    charsToRead = len;
                }
                blobData = blob.getBytes(1L, charsToRead);
            }
            boolean wholeBlobRead = false;
            if (_readCompleteBlobs || blobData.length < _readBlobsSize) {
                wholeBlobRead = true;
            }
            return new BlobDescriptor(blob, blobData, true, wholeBlobRead, _readBlobsSize);
        }
        return new BlobDescriptor(blob, null, false, false, 0);
    }

    @Override
    public IWhereClausePart getWhereClauseValue(Object value, ISQLDatabaseMetaData md) {
        if (value == null || ((BlobDescriptor)value).getData() == null) {
            return new IsNullWhereClausePart(this._colDef);
        }
        return new EmptyWhereClausePart();
    }

    @Override
    public void setPreparedStatementValue(PreparedStatement pstmt, Object value, int position) throws SQLException {
        if (value == null || ((BlobDescriptor)value).getData() == null) {
            pstmt.setNull(position, this._colDef.getSqlType());
        } else {
            BlobDescriptor bdesc = (BlobDescriptor)value;
            pstmt.setBinaryStream(position, (InputStream)new ByteArrayInputStream(bdesc.getData()), bdesc.getData().length);
        }
    }

    @Override
    public Object getDefaultValue(String dbDefaultValue) {
        if (dbDefaultValue != null) {
            StringBuffer mbuf = new StringBuffer();
            Object newObject = this.validateAndConvert(dbDefaultValue, null, mbuf);
            if (mbuf.length() == 0) {
                return newObject;
            }
        }
        if (this._isNullable) {
            return null;
        }
        return null;
    }

    @Override
    public boolean canDoFileIO() {
        return true;
    }

    @Override
    public String importObject(FileInputStream inStream) throws IOException {
        int fileSize = inStream.available();
        byte[] buf = new byte[fileSize];
        int count = inStream.read(buf);
        if (count != fileSize) {
            throw new IOException("Could read only " + count + " bytes from a total file size of " + fileSize + ". Import failed.");
        }
        Byte[] bBytes = new Byte[count];
        for (int i = 0; i < count; ++i) {
            bBytes[i] = buf[i];
        }
        return BinaryDisplayConverter.convertToString(bBytes, 16, false);
    }

    @Override
    public void exportObject(FileOutputStream outStream, String text) throws IOException {
        Byte[] bBytes = BinaryDisplayConverter.convertToBytes(text, 16, false);
        StringBuffer messageBuffer = new StringBuffer();
        this.validateAndConvertInPopup(text, null, messageBuffer);
        if (messageBuffer.length() > 0) {
            throw new IOException(new String(messageBuffer));
        }
        byte[] bytes = new byte[bBytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = bBytes[i];
        }
        outStream.write(bytes);
        outStream.flush();
        outStream.close();
    }

    public static OkJPanel getControlPanel() {
        DataTypeBlob.loadProperties();
        return new BlobOkJPanel();
    }

    private static class BlobOkJPanel
    extends OkJPanel {
        private static final long serialVersionUID = 2859310264477848330L;
        private JCheckBox _showBlobChk = new JCheckBox(DataTypeBlob.access$400().getString("dataTypeBlob.readOnFirstLoad"));
        private RightLabel _typeDropLabel = new RightLabel(DataTypeBlob.access$400().getString("dataTypeBlob.read"));
        private ReadTypeCombo _blobTypeDrop = new ReadTypeCombo();
        private IntegerField _showBlobSizeField = new IntegerField(5);

        public BlobOkJPanel() {
            this._showBlobChk.setSelected(_readBlobs);
            this._showBlobChk.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    _blobTypeDrop.setEnabled(_showBlobChk.isSelected());
                    _typeDropLabel.setEnabled(_showBlobChk.isSelected());
                    _showBlobSizeField.setEnabled(_showBlobChk.isSelected() && _blobTypeDrop.getSelectedIndex() == 0);
                }
            });
            this._blobTypeDrop = new ReadTypeCombo();
            this._blobTypeDrop.setSelectedIndex(_readCompleteBlobs ? 1 : 0);
            this._blobTypeDrop.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    _showBlobSizeField.setEnabled(_blobTypeDrop.getSelectedIndex() == 0);
                }
            });
            this._showBlobSizeField = new IntegerField(5);
            this._showBlobSizeField.setInt(_readBlobsSize);
            this._blobTypeDrop.setEnabled(_readBlobs);
            this._typeDropLabel.setEnabled(_readBlobs);
            this._showBlobSizeField.setEnabled(_readBlobs && !_readCompleteBlobs);
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("dataTypeBlob.blobType")));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.anchor = 17;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            this.add((Component)this._showBlobChk, gbc);
            ++gbc.gridx;
            this.add((Component)this._typeDropLabel, gbc);
            ++gbc.gridx;
            this.add((Component)this._blobTypeDrop, gbc);
            ++gbc.gridx;
            this.add((Component)this._showBlobSizeField, gbc);
        }

        @Override
        public void ok() {
            _readBlobs = this._showBlobChk.isSelected();
            DTProperties.put(DataTypeBlob.thisClassName, "readBlobs", Boolean.valueOf(_readBlobs).toString());
            _readCompleteBlobs = this._blobTypeDrop.getSelectedIndex() != 0;
            DTProperties.put(DataTypeBlob.thisClassName, "readCompleteBlobs", Boolean.valueOf(_readCompleteBlobs).toString());
            _readBlobsSize = this._showBlobSizeField.getInt();
            DTProperties.put(DataTypeBlob.thisClassName, "readBlobsSize", Integer.toString(_readBlobsSize));
        }
    }

    private class KeyTextHandler
    extends BaseKeyTextHandler {
        private KeyTextHandler() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            char c = e.getKeyChar();
            JTextComponent _theComponent = (JTextComponent)((Object)DataTypeBlob.this._textComponent);
            String text = _theComponent.getText();
            if (DataTypeBlob.this._isNullable) {
                if (text.equals("<null>")) {
                    if (c == '\b' || c == '\u007f') {
                        DataTypeBlob.this._textComponent.restoreText();
                        e.consume();
                    } else {
                        DataTypeBlob.this._textComponent.updateText("");
                    }
                } else if ((c == '\b' || c == '\u007f') && text.length() <= 1) {
                    DataTypeBlob.this._textComponent.updateText("<null>");
                    e.consume();
                }
            } else {
                this.handleNotNullableField(text, c, e, DataTypeBlob.this._textComponent);
            }
        }
    }
}

