/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.laf;

import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.plugin.PluginResources;
import net.sourceforge.squirrel_sql.fw.gui.FontInfo;
import net.sourceforge.squirrel_sql.fw.util.FileWrapper;
import net.sourceforge.squirrel_sql.fw.util.FileWrapperFactory;
import net.sourceforge.squirrel_sql.fw.util.FileWrapperFactoryImpl;
import net.sourceforge.squirrel_sql.fw.util.MyURLClassLoader;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.laf.AbstractPlasticController;
import net.sourceforge.squirrel_sql.plugins.laf.DefaultLookAndFeelController;
import net.sourceforge.squirrel_sql.plugins.laf.ILookAndFeelController;
import net.sourceforge.squirrel_sql.plugins.laf.LAFPlugin;
import net.sourceforge.squirrel_sql.plugins.laf.LAFPreferences;
import net.sourceforge.squirrel_sql.plugins.laf.MetalLookAndFeelController;
import net.sourceforge.squirrel_sql.plugins.laf.PlasticLookAndFeelController;
import net.sourceforge.squirrel_sql.plugins.laf.SkinLookAndFeelController;
import net.sourceforge.squirrel_sql.plugins.laf.SubstanceLookAndFeelController;
import net.sourceforge.squirrel_sql.plugins.laf.TonicLookAndFeelController;
import net.sourceforge.squirrel_sql.plugins.laf.jtattoo.JTattooLookAndFeelController;

public class LAFRegister {
    private static final int FONT_KEYS_ARRAY_OTHER = 0;
    private static final int FONT_KEYS_ARRAY_MENU = 1;
    private static final int FONT_KEYS_ARRAY_STATIC = 2;
    private static ILogger s_log = LoggerController.createLogger(LAFRegister.class);
    private static final String[][] FONT_KEYS = new String[][]{{"EditorPane.font", "List.font", "TextArea.font", "TextField.font", "PasswordField.font", "Table.font", "TableHeader.font", "TextPane.font", "Tree.font"}, {"CheckBoxMenuItem.acceleratorFont", "CheckBoxMenuItem.font", "Menu.acceleratorFont", "Menu.font", "MenuBar.font", "MenuItem.acceleratorFont", "MenuItem.font", "PopupMenu.font", "RadioButtonMenuItem.acceleratorFont", "RadioButtonMenuItem.font"}, {"Button.font", "CheckBox.font", "ComboBox.font", "InternalFrame.titleFont", "Label.font", "ProgressBar.font", "RadioButton.font", "TabbedPane.font", "TitledBorder.font", "ToggleButton.font", "ToolBar.font", "ToolTip.font"}};
    private IApplication _app;
    private LAFPlugin _plugin;
    private MyURLClassLoader _lafClassLoader;
    private Map<String, ILookAndFeelController> _lafControllers = new HashMap<String, ILookAndFeelController>();
    private ILookAndFeelController _dftLAFController = new DefaultLookAndFeelController();
    private UIDefaults _origUIDefaults;
    private FileWrapperFactory fileWrapperFactory = new FileWrapperFactoryImpl();

    LAFRegister(IApplication app, LAFPlugin plugin) throws IllegalArgumentException {
        if (app == null) {
            throw new IllegalArgumentException("Null IApplication passed");
        }
        if (plugin == null) {
            throw new IllegalArgumentException("Null LAFPlugin passed");
        }
        this._app = app;
        this._plugin = plugin;
        this._origUIDefaults = (UIDefaults)UIManager.getDefaults().clone();
        this.installLookAndFeels();
        this.installLookAndFeelControllers(plugin);
        try {
            this.applyPreferences();
            this.setLookAndFeel(true);
        }
        catch (Throwable ex) {
            s_log.error((Object)"Error setting Look and Feel", ex);
        }
        try {
            this.updateApplicationFonts();
        }
        catch (Throwable ex) {
            s_log.error((Object)"Error updating application fonts", ex);
        }
    }

    LAFPlugin getPlugin() {
        return this._plugin;
    }

    public ClassLoader getLookAndFeelClassLoader() {
        return this._lafClassLoader;
    }

    ILookAndFeelController getLookAndFeelController(String lafClassName) {
        if (lafClassName == null) {
            throw new IllegalArgumentException("lafClassName == null");
        }
        ILookAndFeelController ctrl = this._lafControllers.get(lafClassName);
        if (ctrl == null) {
            ctrl = this._dftLAFController;
        }
        return ctrl;
    }

    void updateStatusBarFont() {
        if (this._plugin.getLAFPreferences().isStatusBarFontEnabled()) {
            this._app.getFontInfoStore().setStatusBarFontInfo(this._plugin.getLAFPreferences().getStatusBarFontInfo());
        }
    }

    void setLookAndFeel(boolean force) throws ClassNotFoundException, IllegalAccessException, InstantiationException, UnsupportedLookAndFeelException {
        LAFPreferences prefs = this._plugin.getLAFPreferences();
        String lafClassName = prefs.getLookAndFeelClassName();
        Class<?> lafClass = null;
        lafClass = this._lafClassLoader != null ? Class.forName(lafClassName, true, (ClassLoader)this._lafClassLoader) : Class.forName(lafClassName);
        LookAndFeel laf = (LookAndFeel)lafClass.newInstance();
        LookAndFeel curLaf = UIManager.getLookAndFeel();
        s_log.debug((Object)curLaf);
        if (force || curLaf == null || !curLaf.getName().equals(laf.getName())) {
            ILookAndFeelController lafCont = this.getLookAndFeelController(lafClassName);
            lafCont.aboutToBeInstalled(this, laf);
            if (!lafClassName.equals("net.sourceforge.squirrel_sql.plugins.laf.SubstanceLafPlaceholder") && !lafClassName.equals("net.sourceforge.squirrel_sql.plugins.laf.jtattoo.JTattooLafPlaceholder")) {
                if (s_log.isInfoEnabled()) {
                    s_log.info((Object)("Setting lookandfeel class: " + lafClassName));
                }
                if (this._lafClassLoader != null) {
                    UIManager.setLookAndFeel(laf);
                    UIManager.getLookAndFeelDefaults().put("ClassLoader", this._lafClassLoader);
                } else {
                    UIManager.setLookAndFeel(laf);
                }
            }
            lafCont.hasBeenInstalled(this, laf);
            this.updateAllFrames();
        }
    }

    void applyPreferences() {
        LAFPreferences prefs = this._plugin.getLAFPreferences();
        JFrame.setDefaultLookAndFeelDecorated(prefs.getCanLAFSetBorder());
        JDialog.setDefaultLookAndFeelDecorated(prefs.getCanLAFSetBorder());
    }

    void updateApplicationFonts() {
        int i;
        LAFPreferences prefs = this._plugin.getLAFPreferences();
        FontInfo fi = prefs.getMenuFontInfo();
        String[] keys = FONT_KEYS[1];
        for (i = 0; i < keys.length; ++i) {
            if (prefs.isMenuFontEnabled()) {
                if (fi == null) continue;
                UIManager.put(keys[i], fi.createFont());
                continue;
            }
            UIManager.put(keys[i], this._origUIDefaults.getFont(keys[i]));
        }
        fi = prefs.getStaticFontInfo();
        keys = FONT_KEYS[2];
        for (i = 0; i < keys.length; ++i) {
            if (prefs.isStaticFontEnabled()) {
                if (fi == null) continue;
                UIManager.put(keys[i], fi.createFont());
                continue;
            }
            UIManager.put(keys[i], this._origUIDefaults.getFont(keys[i]));
        }
        fi = prefs.getOtherFontInfo();
        keys = FONT_KEYS[0];
        for (i = 0; i < keys.length; ++i) {
            if (prefs.isOtherFontEnabled()) {
                if (fi == null) continue;
                UIManager.put(keys[i], fi.createFont());
                continue;
            }
            UIManager.put(keys[i], this._origUIDefaults.getFont(keys[i]));
        }
    }

    private void updateAllFrames() {
        Frame[] frames = Frame.getFrames();
        if (frames != null) {
            for (int i = 0; i < frames.length; ++i) {
                SwingUtilities.updateComponentTreeUI(frames[i]);
                frames[i].pack();
            }
        }
    }

    private void installLookAndFeels() {
        Map<String, URL> lafs = this.loadInstallProperties();
        ArrayList<URL> lafUrls = new ArrayList<URL>();
        String jarFilePath = this._plugin.getPluginJarFilePath();
        try {
            lafUrls.add(new File(jarFilePath).toURI().toURL());
        }
        catch (Exception e) {
            s_log.error((Object)("Unable to add the plugin jar file (" + jarFilePath + ") to the list of classloader URLs"));
        }
        Iterator<URL> it = lafs.values().iterator();
        while (it.hasNext()) {
            lafUrls.add(it.next());
        }
        try {
            URL[] urls = new URL[lafUrls.size()];
            this._lafClassLoader = new MyURLClassLoader(lafUrls.toArray(urls));
            for (String className : lafs.keySet()) {
                Class<?> lafClass = Class.forName(className, false, (ClassLoader)this._lafClassLoader);
                try {
                    LookAndFeel laf = (LookAndFeel)lafClass.newInstance();
                    if (!laf.isSupportedLookAndFeel()) continue;
                    UIManager.LookAndFeelInfo info = new UIManager.LookAndFeelInfo(laf.getName(), lafClass.getName());
                    UIManager.installLookAndFeel(info);
                }
                catch (Throwable th) {
                    s_log.error((Object)("Error occurred loading Look and Feel: " + lafClass.getName()), th);
                }
            }
        }
        catch (Throwable th) {
            s_log.error((Object)"Error occurred trying to load Look and Feel classes", th);
        }
    }

    private void installLookAndFeelControllers(LAFPlugin plugin) {
        AbstractPlasticController ctrl;
        try {
            this._lafControllers.put("com.l2fprod.gui.plaf.skin.SkinLookAndFeel", new SkinLookAndFeelController(plugin));
        }
        catch (Throwable ex) {
            s_log.error((Object)"Error installing SkinLookAndFeelController", ex);
        }
        try {
            ctrl = new PlasticLookAndFeelController(plugin, this);
            String[] ar = PlasticLookAndFeelController.LAF_CLASS_NAMES;
            for (int i = 0; i < ar.length; ++i) {
                this._lafControllers.put(ar[i], ctrl);
            }
        }
        catch (Throwable ex) {
            s_log.error((Object)"Error installing PlasticLookAndFeelController", ex);
        }
        try {
            ctrl = new MetalLookAndFeelController(plugin, this);
            this._lafControllers.put(MetalLookAndFeelController.METAL_LAF_CLASS_NAME, ctrl);
        }
        catch (Throwable ex) {
            s_log.error((Object)"Error installing PlasticLookAndFeelController", ex);
        }
        try {
            this._lafControllers.put("com.digitprop.tonic.TonicLookAndFeel", new TonicLookAndFeelController(plugin));
        }
        catch (Throwable ex) {
            s_log.error((Object)"Error installing SkinLookAndFeelController", ex);
        }
        try {
            this._lafControllers.put("net.sourceforge.squirrel_sql.plugins.laf.SubstanceLafPlaceholder", new SubstanceLookAndFeelController(plugin, this));
        }
        catch (Throwable ex) {
            s_log.error((Object)"Error installing SubstanceLookAndFeelController", ex);
        }
        try {
            this._lafControllers.put("net.sourceforge.squirrel_sql.plugins.laf.jtattoo.JTattooLafPlaceholder", new JTattooLookAndFeelController(plugin, this));
        }
        catch (Throwable ex) {
            s_log.error((Object)"Error installing JTattooLookAndFeelController", ex);
        }
        Iterator<ILookAndFeelController> it = this._lafControllers.values().iterator();
        while (it.hasNext()) {
            it.next().initialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, URL> loadInstallProperties() {
        HashMap<String, URL> lafs = new HashMap<String, URL>();
        FileWrapper stdLafJarDir = this._plugin.getLookAndFeelFolder();
        PluginResources rsrc = this._plugin.getResources();
        int i = 0;
        while (true) {
            try {
                String jarName;
                String className = rsrc.getString("classname" + i);
                if (className == null || className.length() == 0 || (jarName = rsrc.getString("jar" + i)) == null || jarName.length() == 0) break;
                FileWrapper file = this.fileWrapperFactory.create(stdLafJarDir, jarName);
                try {
                    if (file.isFile() && file.exists()) {
                        lafs.put(className, file.toURI().toURL());
                    }
                }
                catch (IOException ex) {
                    s_log.error((Object)("Error occurred reading Look and Feel jar: " + file.getAbsolutePath()), (Throwable)ex);
                }
            }
            catch (MissingResourceException ignore) {
                break;
            }
            ++i;
        }
        try {
            FileWrapper extraLafsDir = this._plugin.getUsersExtraLAFFolder();
            FileWrapper extraFile = this.fileWrapperFactory.create(extraLafsDir, "extralafs.properties");
            try (BufferedInputStream is = new BufferedInputStream(extraFile.getFileInputStream());){
                String className;
                Properties props = new Properties();
                props.load(is);
                int i2 = 0;
                while ((className = props.getProperty("classname" + i2)) != null) {
                    if (className.length() == 0) {
                        break;
                    }
                    String jarName = props.getProperty("jar" + i2);
                    if (jarName == null) break;
                    if (jarName.length() == 0) {
                        break;
                    }
                    FileWrapper file = this.fileWrapperFactory.create(extraLafsDir, jarName);
                    try {
                        if (file.isFile() && file.exists()) {
                            lafs.put(className, file.toURI().toURL());
                        }
                    }
                    catch (IOException ex) {
                        s_log.error((Object)("Error occurred reading Look and Feel jar: " + file.getAbsolutePath()), (Throwable)ex);
                    }
                    ++i2;
                }
            }
        }
        catch (IOException ex) {
            s_log.error((Object)"Error occurred loading extra LAFs property file", (Throwable)ex);
        }
        return lafs;
    }

    public void setFileWrapperFactory(FileWrapperFactory fileWrapperFactory) {
        Utilities.checkNull((String)"setFileWrapperFactory", (Object[])new Object[]{"fileWrapperFactory", fileWrapperFactory});
        this.fileWrapperFactory = fileWrapperFactory;
    }
}

