/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.rtffix;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.rtffix.SquirrelRtfToText;

class SquirrelStyledTextTransferable
implements Transferable {
    private String html;
    private byte[] rtfBytes;
    private static final DataFlavor[] FLAVORS = new DataFlavor[]{DataFlavor.fragmentHtmlFlavor, new DataFlavor("text/rtf", "RTF"), DataFlavor.stringFlavor, DataFlavor.plainTextFlavor};

    SquirrelStyledTextTransferable(String html, byte[] rtfBytes) {
        this.html = html;
        this.rtfBytes = rtfBytes;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(FLAVORS[0])) {
            return this.html;
        }
        if (flavor.equals(FLAVORS[1])) {
            return new ByteArrayInputStream(this.rtfBytes == null ? new byte[]{} : this.rtfBytes);
        }
        if (flavor.equals(FLAVORS[2])) {
            return this.rtfBytes == null ? "" : SquirrelRtfToText.getPlainText(this.rtfBytes);
        }
        if (flavor.equals(FLAVORS[3])) {
            String text = "";
            if (this.rtfBytes != null) {
                text = SquirrelRtfToText.getPlainText(this.rtfBytes);
            }
            return new StringReader(text);
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])FLAVORS.clone();
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (DataFlavor flavor1 : FLAVORS) {
            if (!flavor.equals(flavor1)) continue;
            return true;
        }
        return false;
    }
}

