/*
 * Decompiled with CFR 0.152.
 */
package com.unityjdbc.sourcebuilder;

import com.unityjdbc.sourcebuilder.SourceBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.JTextComponent;
import unity.annotation.GlobalSchema;
import unity.annotation.SourceDatabase;
import unity.io.FileManager;
import unity.jdbc.UnityConnection;
import unity.jdbc.UnityDriver;
import unity.util.EncryptDecrypt;

public class MyDataModel
extends AbstractTableModel
implements Comparator {
    private static final long serialVersionUID = 1L;
    private UnityConnection con = null;
    private ResultSet rs;
    private Statement stmt;
    private ArrayList<ArrayList<CellData>> results = new ArrayList();
    private ArrayList<String> columnNames = new ArrayList();
    private int count;
    private long queryStartTime;
    private JTextComponent messageBox;
    private int sortColumn = -1;
    private boolean sortAsc = false;

    public MyDataModel() {
        try {
            Class.forName("unity.jdbc.UnityDriver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("ClassNotFoundException: " + classNotFoundException.getMessage());
        }
    }

    @Override
    public Object getValueAt(int n, int n2) {
        try {
            if (n > this.results.size()) {
                return null;
            }
            if (n2 > this.columnNames.size()) {
                return null;
            }
            ArrayList<CellData> arrayList = this.results.get(n);
            CellData cellData = arrayList.get(n2);
            if (cellData.isMultiValue()) {
                return cellData.getDataArray();
            }
            return cellData.getData();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public int getRowCount() {
        return this.count;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames.get(n);
    }

    public Class getColumnClass(int n) {
        Object object = this.getValueAt(0, n);
        if (object != null) {
            return object.getClass();
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        ArrayList<CellData> arrayList = this.results.get(n);
        CellData cellData = arrayList.get(n2);
        return cellData.isMultiValue();
    }

    public void removeDatabase(String string) throws IOException {
        GlobalSchema globalSchema = this.con.getGlobalSchema();
        globalSchema.removeDatabase(string);
        globalSchema.exportSources(UnityDriver.getURLFilePath(globalSchema.getSourcesURL()));
    }

    public void removeTable(String string, String string2) throws IOException {
        GlobalSchema globalSchema = this.con.getGlobalSchema();
        globalSchema.removeTable(string, string2);
        globalSchema.updateSchemaFile(string);
    }

    public void removeField(String string, String string2, String string3) throws IOException {
        GlobalSchema globalSchema = this.con.getGlobalSchema();
        globalSchema.removeField(string, string2, string3);
        globalSchema.updateSchemaFile(string);
    }

    public void doQuery(String string, long l, JTextComponent jTextComponent, SourceBuilder sourceBuilder) {
        this.columnNames.clear();
        this.count = 0;
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
        this.queryStartTime = l;
        this.messageBox = jTextComponent;
        try {
            this.stmt = this.con.createStatement();
            this.rs = this.stmt.executeQuery(string);
            this.bufferResults(sourceBuilder);
            this.stmt.close();
        }
        catch (SQLException sQLException) {
            SourceBuilder.append(this.messageBox, "ERROR: " + sQLException + '\n');
        }
        catch (Exception exception) {
            SourceBuilder.append(this.messageBox, "ERROR: " + exception + '\n');
        }
        try {
            this.stmt.close();
        }
        catch (SQLException sQLException) {
            SourceBuilder.append(this.messageBox, "ERROR: " + sQLException + '\n');
        }
    }

    public void doExecuteUpdate(String string, long l, JTextComponent jTextComponent) {
        this.results = null;
        this.count = 0;
        this.columnNames.clear();
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
        this.queryStartTime = l;
        this.messageBox = jTextComponent;
        try {
            this.stmt = this.con.createStatement();
            int n = this.stmt.executeUpdate(string);
            if (n == 1) {
                SourceBuilder.append(this.messageBox, n + " row was affected.\n");
            } else {
                SourceBuilder.append(this.messageBox, n + " rows were affected.\n");
            }
        }
        catch (SQLException sQLException) {
            SourceBuilder.append(this.messageBox, "ERROR: " + sQLException + '\n');
        }
        try {
            this.stmt.close();
        }
        catch (SQLException sQLException) {
            SourceBuilder.append(this.messageBox, "ERROR: " + sQLException + '\n');
        }
    }

    public void closeDBConnection() {
        if (this.con != null) {
            try {
                this.con.close();
            }
            catch (SQLException sQLException) {
                System.err.println(sQLException);
            }
        }
        this.con = null;
    }

    public void makeDBConnection(String string) throws SQLException {
        this.con = null;
        this.con = (UnityConnection)DriverManager.getConnection(string);
    }

    public ArrayList<SourceDatabase> getDatabases() {
        if (this.con == null) {
            return null;
        }
        return this.con.getDatabases();
    }

    public GlobalSchema getSchema() {
        if (this.con == null) {
            return null;
        }
        return this.con.getGlobalSchema();
    }

    public void createEmptySourceGroup(String string, String string2) throws IOException {
        String string3 = "<SOURCES>\n</SOURCES>";
        if (string2 == null) {
            PrintWriter printWriter = FileManager.openTextOutputFile(string);
            printWriter.println(string3);
            printWriter.close();
        } else {
            OutputStream outputStream = FileManager.openOutputFile(string);
            EncryptDecrypt encryptDecrypt = new EncryptDecrypt(string2);
            try {
                outputStream = encryptDecrypt.getEncryptStream(outputStream);
                outputStream.write(string3.getBytes());
                outputStream.close();
            }
            catch (Exception exception) {
                throw new IOException(exception);
            }
        }
    }

    private void bufferResults(SourceBuilder sourceBuilder) throws Exception {
        ResultSet resultSet = this.rs;
        this.results = new ArrayList();
        ResultSetMetaData resultSetMetaData = this.rs.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        this.columnNames = new ArrayList();
        for (int i = 1; i <= n; ++i) {
            this.columnNames.add(resultSetMetaData.getColumnName(i));
        }
        this.count = 0;
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
        while (resultSet.next()) {
            ++this.count;
            if (!sourceBuilder.isExecuting()) break;
            if (this.count == 1 || this.count == 10 || this.count == 100 || this.count == 1000 || this.count == 10000 || this.count == 100000 || this.count % 100000 == 0) {
                long l = System.currentTimeMillis();
                long l2 = l - this.queryStartTime;
                SourceBuilder.append(this.messageBox, "Query result " + this.count + " at time: " + l2 + '\n');
                if (this.count <= 1000) {
                    this.fireTableDataChanged();
                }
            }
            if (this.count >= 10000000) continue;
            ArrayList<CellData> arrayList = new ArrayList<CellData>();
            for (int i = 1; i <= n; ++i) {
                CellData cellData;
                Object object = this.rs.getObject(i);
                if (!(object instanceof ArrayList)) {
                    cellData = new CellData(object, false, null);
                    arrayList.add(cellData);
                    continue;
                }
                cellData = new CellData(object, true, (ArrayList)object);
                arrayList.add(cellData);
            }
            this.results.add(arrayList);
        }
        this.fireTableDataChanged();
    }

    public void sortColumn(int n) {
        if (n == this.sortColumn) {
            this.sortAsc = !this.sortAsc;
        }
        this.sortColumn = n;
        Collections.sort(this.results, this);
    }

    public int compare(Object object, Object object2) {
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        ArrayList arrayList = (ArrayList)object;
        ArrayList arrayList2 = (ArrayList)object2;
        Comparable comparable = (Comparable)arrayList.get(this.sortColumn);
        Comparable comparable2 = (Comparable)arrayList2.get(this.sortColumn);
        if (this.sortAsc) {
            return comparable.compareTo(comparable2);
        }
        return comparable2.compareTo(comparable);
    }

    private class CellData
    implements Comparable {
        private Object data;
        private boolean multiValue;
        private ArrayList<Object> dataVals;

        public CellData(Object object, boolean bl, ArrayList<Object> arrayList) {
            this.data = object;
            this.multiValue = bl;
            this.dataVals = arrayList;
        }

        public Object getData() {
            return this.data;
        }

        public void setData(Object object) {
            this.data = object;
        }

        public boolean isMultiValue() {
            return this.multiValue;
        }

        public void setMultiValue(boolean bl) {
            this.multiValue = bl;
        }

        public ArrayList<Object> getDataArray() {
            return this.dataVals;
        }

        public void setDataArray(ArrayList<Object> arrayList) {
            this.dataVals = arrayList;
        }

        public int compareTo(Object object) {
            if (object.getClass() != CellData.class) {
                return -1;
            }
            CellData cellData = (CellData)object;
            Comparable comparable = cellData.isMultiValue() ? (Comparable)cellData.dataVals.get(0) : (Comparable)cellData.data;
            if (comparable == null) {
                return -1;
            }
            Comparable comparable2 = this.isMultiValue() ? (Comparable)this.dataVals.get(0) : (Comparable)this.data;
            if (comparable2 == null) {
                return 1;
            }
            return comparable.compareTo(comparable2);
        }
    }
}

