/*
 * Decompiled with CFR 0.152.
 */
package unity.engine;

import java.sql.SQLException;
import java.util.ArrayList;
import unity.engine.IServerConnection;
import unity.engine.Relation;
import unity.engine.Tuple;

public class TableData {
    private boolean buffering;
    protected ArrayList<byte[]> rows;
    protected Relation relation;
    private IServerConnection connection;
    protected boolean dataComplete;
    private long lastRowIndex;
    private int statementId;

    public TableData(IServerConnection iServerConnection, boolean bl, int n) {
        this.connection = iServerConnection;
        this.dataComplete = false;
        this.buffering = bl;
        this.lastRowIndex = -1L;
        this.statementId = n;
        if (this.buffering) {
            this.rows = new ArrayList(100);
        }
    }

    public int afterLast(Tuple tuple) throws SQLException {
        if (this.buffering) {
            if (this.dataComplete) {
                return this.rows.size() + 1;
            }
            while (this.next(tuple)) {
                this.rows.add(tuple.getBytes());
            }
            this.dataComplete = true;
            return this.rows.size() + 1;
        }
        if (this.lastRowIndex != -1L) {
            return (int)this.lastRowIndex + 1;
        }
        this.lastRowIndex = this.connection.getLast(this.statementId);
        return (int)this.lastRowIndex + 1;
    }

    public boolean get(int n, Tuple tuple) throws SQLException {
        if (n < 1) {
            return false;
        }
        if (this.buffering) {
            int n2 = n - 1;
            if (n2 >= this.rows.size()) {
                if (this.dataComplete) {
                    return false;
                }
                int n3 = n2 - this.rows.size() + 1;
                for (int i = 0; i < n3; ++i) {
                    if (!this.connection.next(this.statementId, tuple)) {
                        this.dataComplete = true;
                        return false;
                    }
                    this.rows.add(tuple.getBytes());
                }
                if (n2 >= this.rows.size() && this.dataComplete) {
                    return false;
                }
            }
            tuple.setBytes(this.rows.get(n2));
            return true;
        }
        return this.connection.get(this.statementId, n, tuple);
    }

    public void clear() {
        if (this.rows != null) {
            this.rows.clear();
        }
    }

    public boolean next(Tuple tuple) throws SQLException {
        try {
            return this.connection.next(this.statementId, tuple);
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    public void setRelation(Relation relation) {
        this.relation = relation;
    }
}

