/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import java.sql.SQLException;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.functions.Expression;
import unity.functions.Function;

public class F_Abs
extends Function {
    private static final long serialVersionUID = 1L;
    private Expression expr;

    public F_Abs(Expression expression) {
        this.expr = expression;
        this.returnType = this.expr.getReturnType();
    }

    @Override
    public Object evaluate(Tuple tuple) throws SQLException {
        Object object = this.expr.evaluate(tuple);
        if (object == null) {
            return null;
        }
        if (object instanceof Double) {
            return new Double(Math.abs((Double)object));
        }
        if (object instanceof Float) {
            return new Float(Math.abs(((Float)object).floatValue()));
        }
        if (object instanceof Integer) {
            return new Integer(Math.abs((Integer)object));
        }
        return null;
    }

    @Override
    public int getReturnType() {
        return this.returnType;
    }

    public static int[] getParamListTypes() {
        return new int[]{99999};
    }

    public static String getFunctionName() {
        return "ABS";
    }

    @Override
    public String toString(Relation relation) {
        return "ABS(" + this.expr.toString(relation) + ")";
    }
}

