/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.util.ArrayList;
import unity.annotation.AnnotatedSourceDatabase;
import unity.query.GQDatabaseRef;
import unity.query.GlobalQuery;
import unity.query.LQDeleteNode;
import unity.query.LQNode;
import unity.query.LQUpdateNode;
import unity.query.SubQuery;

public class GlobalUpdate {
    private AnnotatedSourceDatabase targetDB;
    private SubQuery queryPlan;
    private boolean hasGlobalSubQuery = false;
    private ArrayList<GlobalQuery> subqueries = null;
    private int type;
    private String statement;

    public void setPlan(SubQuery subQuery) {
        this.queryPlan = subQuery;
    }

    public SubQuery getPlan() {
        return this.queryPlan;
    }

    public String generateBaseSQL() {
        return this.queryPlan.getLogicalQueryTree().getRoot().generateSQL();
    }

    public String generateConditionSQL() {
        LQNode lQNode = this.queryPlan.getLogicalQueryTree().getRoot();
        if (lQNode instanceof LQDeleteNode) {
            return ((LQDeleteNode)lQNode).generateSubQuerySQL();
        }
        if (lQNode instanceof LQUpdateNode) {
            return ((LQUpdateNode)lQNode).getCondition().generateSQL();
        }
        return "";
    }

    public void setDatabase(AnnotatedSourceDatabase annotatedSourceDatabase) {
        this.targetDB = annotatedSourceDatabase;
    }

    public AnnotatedSourceDatabase getDatabase() {
        return this.targetDB;
    }

    public GlobalQuery getSubQuery() {
        return this.subqueries.get(0);
    }

    public String getSqlStmt() {
        if (this.queryPlan == null) {
            return "";
        }
        return this.queryPlan.getLogicalQueryTree().getRoot().generateSQL();
    }

    public boolean hasGlobalSubQuery() {
        return this.hasGlobalSubQuery;
    }

    public void setHasGlobalSubQuery(boolean bl) {
        this.hasGlobalSubQuery = bl;
    }

    public void addSubQuery(GlobalQuery globalQuery) {
        if (this.subqueries == null) {
            this.subqueries = new ArrayList();
        }
        this.subqueries.add(globalQuery);
    }

    public void checkGlobalQuery() {
        if (this.subqueries == null || this.subqueries.size() == 0) {
            this.hasGlobalSubQuery = false;
        } else {
            GlobalQuery globalQuery = this.subqueries.get(0);
            ArrayList<GQDatabaseRef> arrayList = globalQuery.getAllDBRefs();
            if (arrayList.size() > 1 || arrayList.get(0).getDatabase() != this.targetDB) {
                this.hasGlobalSubQuery = true;
            }
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public String getStatement() {
        return this.statement;
    }

    public void setStatement(String string) {
        this.statement = string;
    }
}

