/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.derby.prefs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import net.sourceforge.squirrel_sql.client.plugin.PluginQueryTokenizerPreferencesManager;
import net.sourceforge.squirrel_sql.client.plugin.gui.PluginQueryTokenizerPreferencesPanel;
import net.sourceforge.squirrel_sql.fw.preferences.IQueryTokenizerPreferenceBean;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.derby.prefs.DerbyPreferenceBean;

public class DerbyPluginPreferencesPanel
extends PluginQueryTokenizerPreferencesPanel {
    private static final long serialVersionUID = 1L;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DerbyPluginPreferencesPanel.class);
    private static final JCheckBox readClobsFullyCheckBox = new JCheckBox(i18n.READ_DERBY_CLOBS_FULLY_LABEL);

    public DerbyPluginPreferencesPanel(PluginQueryTokenizerPreferencesManager prefsMgr) {
        super(prefsMgr, "Derby");
    }

    protected JPanel createTopPanel() {
        JPanel result = super.createTopPanel();
        int lastY = this.lastY;
        this.addReadClobsFullyCheckBox(result, 0, lastY++);
        return result;
    }

    private void addReadClobsFullyCheckBox(JPanel result, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.gridwidth = 2;
        c.anchor = 17;
        c.insets = new Insets(5, 5, 0, 0);
        readClobsFullyCheckBox.setToolTipText(i18n.READ_DERBY_CLOBS_FULLY_TT);
        result.add((Component)readClobsFullyCheckBox, c);
    }

    protected void loadData() {
        super.loadData();
        IQueryTokenizerPreferenceBean prefs = this._prefsManager.getPreferences();
        DerbyPreferenceBean derbyPrefs = (DerbyPreferenceBean)prefs;
        readClobsFullyCheckBox.setSelected(derbyPrefs.isReadClobsFully());
    }

    protected void save() {
        IQueryTokenizerPreferenceBean prefs = this._prefsManager.getPreferences();
        DerbyPreferenceBean derbyPrefs = (DerbyPreferenceBean)prefs;
        derbyPrefs.setReadClobsFully(readClobsFullyCheckBox.isSelected());
        super.save();
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    static interface i18n {
        public static final String READ_DERBY_CLOBS_FULLY_LABEL = DerbyPluginPreferencesPanel.access$000().getString("DerbyPluginPreferencesPanel.readClobsFullyCheckBoxLabel");
        public static final String READ_DERBY_CLOBS_FULLY_TT = DerbyPluginPreferencesPanel.access$000().getString("DerbyPluginPreferencesPanel.readClobsFullyCheckBoxTT");
    }
}

