/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate;

import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernateConnection;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernateConnectionFactory;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernatePlugin;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibnerateConnectorListener;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.HibernateConfiguration;

public class HibnerateConnector {
    private HibernatePlugin _plugin;
    private HibnerateConnectorListener _hibnerateConnectorListener;

    public HibnerateConnector(HibernatePlugin plugin, HibnerateConnectorListener hibnerateConnectorListener) {
        this._plugin = plugin;
        this._hibnerateConnectorListener = hibnerateConnectorListener;
    }

    public void connect(final HibernateConfiguration cfg, ISession session) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                HibnerateConnector.this.doConnect(cfg);
            }
        };
        final Thread thread = new Thread(runnable);
        thread.setPriority(1);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                thread.run();
            }
        });
    }

    private void doConnect(HibernateConfiguration cfg) {
        try {
            HibernateConnection con = HibernateConnectionFactory.createHibernateConnection(cfg, this._plugin);
            this.sendConnection(con, cfg);
        }
        catch (Throwable t) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HibnerateConnector.this._hibnerateConnectorListener.connectFailed(t);
                }
            });
        }
    }

    private void sendConnection(final HibernateConnection con, final HibernateConfiguration cfg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HibnerateConnector.this._hibnerateConnectorListener.connected(con, cfg);
            }
        });
    }
}

