/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.mapping;

import javax.swing.JComponent;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.EmptyDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.HashtableDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSet;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.DetailAttribute;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.DetailAttributeDataSet;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.DetailPanel;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.MappedClassInfo;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.MappedClassInfoTreeWrapper;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.MappingRoot;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.PropertyInfoTreeWrapper;

public class DetailPanelController {
    private DetailPanel _detailPanel;

    public DetailPanelController(ISession session) {
        this._detailPanel = new DetailPanel(session);
    }

    public JComponent getDetailComponent() {
        return this._detailPanel;
    }

    void clearDetail() {
        try {
            this._detailPanel.tblDetails.show((IDataSet)new EmptyDataSet());
        }
        catch (DataSetException e) {
            throw new RuntimeException(e);
        }
    }

    public void selectionChanged(Object userObject) {
        try {
            if (userObject instanceof MappingRoot) {
                MappingRoot root = (MappingRoot)userObject;
                if (0 == root.getMappingProperties().size()) {
                    this._detailPanel.tblDetails.show((IDataSet)new EmptyDataSet());
                } else {
                    this._detailPanel.tblDetails.show((IDataSet)new HashtableDataSet(root.getMappingProperties()));
                }
            } else if (userObject instanceof MappedClassInfoTreeWrapper) {
                MappedClassInfoTreeWrapper mappedClassInfoTreeWrapper = (MappedClassInfoTreeWrapper)userObject;
                MappedClassInfo mci = mappedClassInfoTreeWrapper.getMappedClassInfo();
                DetailAttribute[] attributes = DetailAttribute.createDetailtAttributes(mci.getAttributes());
                this._detailPanel.tblDetails.show((IDataSet)new DetailAttributeDataSet(attributes));
            } else if (userObject instanceof PropertyInfoTreeWrapper) {
                PropertyInfoTreeWrapper propertyInfoTreeWrapper = (PropertyInfoTreeWrapper)userObject;
                this._detailPanel.tblDetails.show((IDataSet)new HashtableDataSet(propertyInfoTreeWrapper.getMappingProperties()));
            }
        }
        catch (DataSetException e) {
            throw new RuntimeException(e);
        }
    }
}

