/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.server;

import java.io.PrintWriter;
import java.io.StringWriter;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.SquirrelHibernateServerException;

public class HibernateServerExceptionUtil {
    public static Throwable prepareTransport(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Throwable deepestThrowable = HibernateServerExceptionUtil.getDeepestThrowable(t);
        deepestThrowable.printStackTrace(pw);
        pw.flush();
        sw.flush();
        String messageIncludingOriginalStackTrace = "Exception occurred on Hibernate Server Process: " + deepestThrowable.getMessage() + "\n";
        String stackTraceString = sw.toString();
        String deepestToString = deepestThrowable.toString();
        messageIncludingOriginalStackTrace = ("" + deepestThrowable.getMessage()).equals(deepestToString) || stackTraceString.startsWith(deepestToString) ? messageIncludingOriginalStackTrace + stackTraceString : messageIncludingOriginalStackTrace + deepestToString + "\n" + stackTraceString;
        return new SquirrelHibernateServerException(messageIncludingOriginalStackTrace, deepestThrowable.getMessage(), deepestToString, deepestThrowable.getClass().getName());
    }

    public static Throwable getDeepestThrowable(Throwable t) {
        Throwable parent = t;
        Throwable child = t.getCause();
        while (null != child) {
            parent = child;
            child = parent.getCause();
        }
        return parent;
    }

    public static Throwable prepareTransport(Throwable t, boolean server) {
        if (!server) {
            return t;
        }
        return HibernateServerExceptionUtil.prepareTransport(t);
    }
}

