/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects;

import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.MappedClassInfo;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.PersistentCollectionResult;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.SingleResult;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.TupelResult;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.TupelType;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.ViewObjectsUtil;

public class TupelResultController {
    private JTree _resultTree;
    private ArrayList<MappedClassInfo> _allMappedClassInfos;

    public TupelResultController(TupelType tupelType, JPanel pnlResults, ArrayList<MappedClassInfo> allMappedClassInfos) {
        this._allMappedClassInfos = allMappedClassInfos;
        this._resultTree = new JTree();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("DumyNode");
        DefaultTreeModel model = new DefaultTreeModel(root);
        this._resultTree.setModel(model);
        this._resultTree.setRootVisible(false);
        this.initRoot(tupelType, root);
        this._resultTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                TupelResultController.this.onTreeExpanded(event);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        pnlResults.removeAll();
        pnlResults.add(new JScrollPane(this._resultTree));
    }

    private void onTreeExpanded(TreeExpansionEvent event) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode kidNode = (DefaultMutableTreeNode)node.getChildAt(i);
            if (0 < kidNode.getChildCount()) continue;
            if (kidNode.getUserObject() instanceof PersistentCollectionResult) {
                ViewObjectsUtil.addPersistentCollectionKids(kidNode);
                continue;
            }
            if (!(kidNode.getUserObject() instanceof SingleResult)) continue;
            ViewObjectsUtil.addSingleResultKids(kidNode, (SingleResult)kidNode.getUserObject(), this._allMappedClassInfos);
        }
        ViewObjectsUtil.nodeStructurChanged(node, this._resultTree);
    }

    private void initRoot(TupelType tupelType, DefaultMutableTreeNode root) {
        for (TupelResult tupelResult : tupelType.getResults()) {
            DefaultMutableTreeNode tupelNode = new DefaultMutableTreeNode(tupelResult);
            root.add(tupelNode);
            for (SingleResult singleResult : tupelResult.getSingleResults()) {
                tupelNode.add(new DefaultMutableTreeNode(singleResult));
            }
        }
        ViewObjectsUtil.nodeStructurChanged(root, this._resultTree);
    }
}

