##
# @file xslt_base_class.py
#
# @copyright Copyright (C) 2013-2014 srcML, LLC. (www.srcML.org)
#
# The srcML Toolkit is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# The srcML Toolkit is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with the srcML Toolkit; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from abc import *

class xsltransform_base(object):
    __metaclass__ = ABCMeta

    @classmethod
    def __subclasshook__(cls, other):
        attr = getattr(other, "apply", None)
        if attr is None: 
            return False
        else:
            return callable(attr)

    @abstractmethod
    def apply(self, archive_pointer):
        raise NotImplementedError("This is an abstract method, that cannot and should never be called outside of the srcml library.")
        pass