/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for directly importing a srcML archive.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from srcML",
	           DefaultLabel = "srcML from srcML",
	           Description = "Import srcML file from disk.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigsrcML))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From srcML")]
	public class srcMLComponentsrcML : BaseComponent {

		private srcMLConfigsrcML config;

		public srcMLComponentsrcML(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigsrcML();
			Configuration = config;

		}

        public override void Compute()
		{

			srcMLArchive archive = new srcMLArchive(config.inputsrcML);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLConfigDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentDirectory.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigDirectory
	{
        public srcMLConfigDirectory() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public DirectoryPath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentFile.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigFile
	{
        public srcMLConfigFile() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public FilePath inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentURL.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigURL
	{
        public srcMLConfigURL() {

            markupLiteral = true;
            markupModifier = true;
            markupOperator = true;

        }

		public string inputSource
		{
			get;
			set;
		}

		public bool markupLiteral
		{
			get;
			set;
		}

		public bool markupModifier
		{
			get;
			set;
		}

		public bool markupOperator
		{
			get;
			set;
		}
	}
	
}

/*
    srcMLConfigsrcML.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab configuration for srcMLComponentsrcML.
*/
using System;
using TraceLab;
using TraceLabSDK;
using TraceLabSDK.Component.Config;

namespace srcMLComponent
{
	public class srcMLConfigsrcML
	{
        public srcMLConfigsrcML() {


        }

		public DirectoryPath inputsrcML
		{
			get;
			set;
		}

	}
	
}

/*
    srcMLComponentDirectory.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a Directory.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from Directory",
	           DefaultLabel = "srcML from Directory",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigDirectory))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From Directory")]
	public class srcMLComponentDirectory : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigDirectory config;

		public srcMLComponentDirectory(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigDirectory();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentDirectory() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
﻿/*
    srcMLComponentFile.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a File.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from File",
	           DefaultLabel = "srcML from File",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigFile))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From File")]
	public class srcMLComponentFile : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigFile config;

		public srcMLComponentFile(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigFile();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentFile() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive =  Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml_process.WaitForExit();

			srcMLArchive archive = new srcMLArchive(srcml_archive);
			Workspace.Store("archive", archive);

		}
	}
}
/*
    srcMLComponentURL.cs

    Copyright (C) 2013  SDML (www.srcML.org)
 
    This file is part of srcMLComponent Collection.

    srcMLComponent Collection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    srcMLComponent Collection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with srcMLComponent Collection.  If not, see <http://www.gnu.org/licenses/>.
  
    TraceLab component for converting source code into srcML format from a URL.
*/
using System;
using TraceLabSDK;
using TraceLabSDK.Types;
using System.Diagnostics;
using System.IO;

namespace srcMLComponent
{
	[Component(Name = "srcML from URL",
	           DefaultLabel = "srcML from URL",
	           Description = "Convert source code from a directoryto srcML archive.",
	           Author = "Michael John Decker",
	           Version = "1.0",
	 		   ConfigurationType=typeof(srcMLConfigURL))]
	[IOSpec(IOType = IOSpecType.Output, Name = "archive", DataType = typeof(srcMLArchive), Description = "srcML archive of source code")]
    [Tag("Importers.srcML.From URL")]
	public class srcMLComponentURL : BaseComponent {

        string directory = "\\Documents\\TraceLab\\Components\\";
		string src2srcml = "src2srcml.exe";
        static string[] file_names = { "src2srcml.exe", "bz2-1.dll", "iconv.dll", "libantlr2-0.dll", "libarchive-2.dll", "libexslt.dll", "libgcc_s_sjlj-1.dll"
                                          , "libgcrypt-11.dll", "libgnurx-0.dll", "libgpg-error-0.dll", "libsrcml.dll", "libstdc++-6.dll", "libxml2.dll", "libxslt.dll"
                                          , "zlib1.dll" };
        static byte[][] executables = { Properties.Resources.src2srcml, Properties.Resources.bz2_1, Properties.Resources.iconv, Properties.Resources.libantlr2_0
                                      , Properties.Resources.libarchive_2, Properties.Resources.libexslt, Properties.Resources.libgcc_s_sjlj_1
                                      , Properties.Resources.libgcrypt_11, Properties.Resources.libgnurx_0, Properties.Resources.libgpg_error_0
                                      , Properties.Resources.libsrcml, Properties.Resources.libstdc___6, Properties.Resources.libxml2, Properties.Resources.libxslt
                                      , Properties.Resources.zlib1 };

		private srcMLConfigURL config;

		public srcMLComponentURL(ComponentLogger log) : base(log) { 
		
			config = new srcMLConfigURL();
			Configuration = config;

            directory = Environment.GetEnvironmentVariable("userprofile") + directory;
            src2srcml = directory + src2srcml;
            extract_binary_resources();
		}

        ~srcMLComponentURL() {

            delete_binary_resources();

        }
      
        public void delete_binary_resources() {

            for(int i = 0; i < file_names.Length; ++i)
                if(File.Exists(directory + file_names[i]))
                    File.Delete(directory + file_names[i]);

        }

        public void extract_binary_resource(byte[] exe, string file_name)
        {

            // extract src2srcml resource
            using (FileStream file = new FileStream(file_name, FileMode.CreateNew))
            {
                file.Write(exe, 0, exe.Length);
            }

        }

        public void extract_binary_resources()
        {
            for (int i = 0; i < file_names.Length; ++i)
                if(!File.Exists(directory + file_names[i]))
                    extract_binary_resource(executables[i], directory + file_names[i]);
        }

        public override void Compute()
		{

			// your component implementation
			string args = "";
			if (config.markupLiteral)
				args += "--literal ";
			if(config.markupModifier)
				args += "--modifier ";
			if(config.markupOperator)
				args += "--operator ";
            
            string srcml_archive = Path.GetTempFileName();
			args += config.inputSource + " -o " + srcml_archive;

			Process src2srcml_process = Process.Start(src2srcml, args);
            src2srcml