/*
 * Decompiled with CFR 0.152.
 */
package att.grappa;

import att.grappa.Edge;
import att.grappa.Element;
import att.grappa.Graph;
import att.grappa.Grappa;
import att.grappa.GrappaBacker;
import att.grappa.GrappaBox;
import att.grappa.GrappaConstants;
import att.grappa.GrappaListener;
import att.grappa.GrappaNexus;
import att.grappa.GrappaPoint;
import att.grappa.GrappaSize;
import att.grappa.GrappaStyle;
import att.grappa.GrappaSupport;
import att.grappa.Node;
import att.grappa.Subgraph;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class GrappaPanel
extends JPanel
implements GrappaConstants,
ComponentListener,
AncestorListener,
PopupMenuListener,
MouseListener,
MouseMotionListener,
Printable,
Scrollable {
    Graph graph;
    Subgraph subgraph;
    GrappaBacker backer;
    boolean nodeLabels;
    boolean edgeLabels;
    boolean subgLabels;
    AffineTransform transform = null;
    AffineTransform oldTransform = null;
    AffineTransform inverseTransform = null;
    Vector elementVector = null;
    int nextElement = -1;
    boolean scaleToFit = false;
    GrappaSize scaleToSize = null;
    GrappaListener grappaListener = null;
    private Element pressedElement = null;
    private GrappaPoint pressedPoint = null;
    private int pressedModifiers = 0;
    private GrappaStyle selectionStyle = null;
    private GrappaStyle deletionStyle = null;
    private double scaleFactor = 1.0;
    private double scaleInfo = 1.0;
    private GrappaBox outline = null;
    private GrappaBox savedOutline = null;
    private GrappaBox zoomBox = null;
    private boolean inMenu = false;
    private boolean scaleChanged = false;
    private boolean paintActive = false;

    public GrappaPanel(Subgraph subgraph) {
        this(subgraph, null);
    }

    public GrappaPanel(Subgraph subgraph, GrappaBacker grappaBacker) {
        this.subgraph = subgraph;
        this.backer = grappaBacker;
        this.graph = subgraph.getGraph();
        this.addAncestorListener(this);
        this.addComponentListener(this);
        this.selectionStyle = (GrappaStyle)this.graph.getGrappaAttributeValue("grappaSelectionColor");
        this.deletionStyle = (GrappaStyle)this.graph.getGrappaAttributeValue("grappaDeletionColor");
    }

    public GrappaListener addGrappaListener(GrappaListener grappaListener) {
        GrappaListener grappaListener2 = this.grappaListener;
        this.grappaListener = grappaListener;
        if (this.grappaListener == null) {
            this.addMouseListener(null);
            this.addMouseMotionListener(null);
            this.setToolTipText(null);
        } else {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            String string = this.graph.getToolTipText();
            if (string == null) {
                string = Grappa.getToolTipText();
            }
            this.setToolTipText(string);
        }
        return grappaListener2;
    }

    public GrappaListener removeGrappaListener() {
        return this.addGrappaListener(null);
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        GrappaSize grappaSize = this.scaleToSize;
        boolean bl = this.scaleToFit;
        if (n >= 1) {
            return 1;
        }
        try {
            this.scaleToFit = false;
            this.scaleToSize = new GrappaSize(pageFormat.getImageableWidth(), pageFormat.getImageableHeight());
            ((Graphics2D)graphics).translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            this.paintComponent(graphics);
            Object var7_6 = null;
            this.scaleToSize = grappaSize;
            this.scaleToFit = bl;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.scaleToSize = grappaSize;
            this.scaleToFit = bl;
            throw throwable;
        }
        return 0;
    }

    public void paintComponent(Graphics graphics) {
        if (Grappa.synchronizePaint || this.graph.getSynchronizePaint()) {
            if (this.graph.setPaint(true)) {
                this.componentPaint(graphics);
                this.graph.setPaint(false);
            }
        } else {
            this.componentPaint(graphics);
        }
    }

    private void componentPaint(Graphics graphics) {
        Object object;
        double d;
        double d2;
        if (this.subgraph == null || !this.subgraph.reserve()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        long l = System.currentTimeMillis();
        this.elementVector = null;
        GrappaBox grappaBox = new GrappaBox(this.subgraph.getBoundingBox());
        if (grappaBox == null) {
            return;
        }
        GrappaSize grappaSize = (GrappaSize)this.subgraph.getAttributeValue("margin");
        if (grappaSize != null) {
            d2 = 72.0 * grappaSize.width;
            d = 72.0 * grappaSize.height;
            grappaBox.x -= d2;
            grappaBox.y -= d;
            grappaBox.width += 2.0 * d2;
            grappaBox.height += 2.0 * d;
        }
        this.subgLabels = this.subgraph.getShowSubgraphLabels();
        this.nodeLabels = this.subgraph.getShowNodeLabels();
        this.edgeLabels = this.subgraph.getShowEdgeLabels();
        if (Grappa.useAntiAliasing) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (Grappa.antiAliasText) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        if (Grappa.useFractionalMetrics) {
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        }
        graphics2D.setStroke(GrappaStyle.defaultStroke);
        this.oldTransform = this.transform;
        this.transform = new AffineTransform();
        if (this.scaleToFit || this.scaleToSize != null) {
            this.scaleFactor = 1.0;
            this.zoomBox = null;
            d2 = 0.0;
            d = 0.0;
            if (this.scaleToFit) {
                Cloneable cloneable;
                Container container = this.getParent();
                if (container instanceof JViewport) {
                    cloneable = ((JViewport)container).getSize();
                    d2 = ((Dimension)cloneable).width;
                    d = ((Dimension)cloneable).height;
                } else {
                    cloneable = this.getVisibleRect();
                    d2 = cloneable.width;
                    d = cloneable.height;
                }
            } else {
                d2 = this.scaleToSize.width;
                d = this.scaleToSize.height;
            }
            double d3 = d2 / grappaBox.getWidth();
            double d4 = d / grappaBox.getHeight();
            double d5 = 0.0;
            double d6 = 0.0;
            if (d3 < d4) {
                d5 = (d2 - d3 * grappaBox.getWidth()) / (2.0 * d3);
                d6 = (d - d3 * grappaBox.getHeight()) / (2.0 * d3);
                this.transform.scale(d3, d3);
                this.scaleInfo = d3;
            } else {
                d5 = (d2 - d4 * grappaBox.getWidth()) / (2.0 * d4);
                d6 = (d - d4 * grappaBox.getHeight()) / (2.0 * d4);
                this.transform.scale(d4, d4);
                this.scaleInfo = d4;
            }
            this.transform.translate(d5, d6);
            this.setSize(new Dimension((int)Math.ceil(d2), (int)Math.ceil(d)));
            this.setPreferredSize(new Dimension((int)Math.ceil(d2), (int)Math.ceil(d)));
            this.transform.translate(-grappaBox.getMinX(), -grappaBox.getMinY());
            this.scaleFactor = this.scaleInfo;
        } else if (this.zoomBox != null) {
            Rectangle rectangle;
            Container container = this.getParent();
            if (container instanceof JViewport) {
                object = ((JViewport)container).getSize();
                rectangle = new Rectangle(0, 0, ((Dimension)object).width, ((Dimension)object).height);
            } else {
                rectangle = this.getVisibleRect();
            }
            this.scaleFactor = 1.0;
            if (this.zoomBox.width != 0.0 && this.zoomBox.height != 0.0 && this.oldTransform != null) {
                object = new GrappaBox(this.oldTransform.createTransformedShape(this.zoomBox).getBounds2D());
                d = rectangle.width;
                double d7 = rectangle.height;
                double d8 = d / this.zoomBox.width;
                double d9 = d7 / this.zoomBox.height;
                double d10 = 0.0;
                double d11 = 0.0;
                this.scaleFactor = d8 < d9 ? d8 : d9;
                this.transform.scale(this.scaleFactor, this.scaleFactor);
                this.scaleInfo = this.scaleFactor;
                d = grappaBox.getWidth() * this.scaleFactor;
                d7 = grappaBox.getHeight() * this.scaleFactor;
                this.setSize(new Dimension((int)Math.ceil(d), (int)Math.ceil(d7)));
                this.setPreferredSize(new Dimension((int)Math.ceil(d), (int)Math.ceil(d7)));
                this.transform.translate(-grappaBox.getMinX(), -grappaBox.getMinY());
                if (container instanceof JViewport && this.inverseTransform != null) {
                    JViewport jViewport = (JViewport)container;
                    Point2D.Double double_ = new Point2D.Double(this.zoomBox.getCenterX(), this.zoomBox.getCenterY());
                    this.transform.transform(double_, double_);
                    Dimension dimension = jViewport.getExtentSize();
                    jViewport.setViewPosition(new Point((int)(((Point2D)double_).getX() - (double)dimension.width / 2.0), (int)(((Point2D)double_).getY() - (double)dimension.height / 2.0)));
                }
            }
            this.zoomBox = null;
            this.scaleFactor = this.scaleInfo;
        } else if (this.scaleFactor != 1.0) {
            Rectangle rectangle = this.getVisibleRect();
            object = null;
            Container container = null;
            if (this.scaleChanged) {
                container = this.getParent();
                if (container instanceof JViewport && this.inverseTransform != null) {
                    Point2D.Double double_ = new Point2D.Double(rectangle.x, rectangle.y);
                    object = new Point2D.Double(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
                    this.inverseTransform.transform(double_, double_);
                    this.inverseTransform.transform((Point2D)object, (Point2D)object);
                    ((Point2D)object).setLocation(((Point2D)double_).getX() + (((Point2D)object).getX() - ((Point2D)double_).getX()) / 2.0, ((Point2D)double_).getY() + (((Point2D)object).getY() - ((Point2D)double_).getY()) / 2.0);
                } else {
                    container = null;
                }
            }
            this.transform.scale(this.scaleFactor, this.scaleFactor);
            this.scaleInfo = this.scaleFactor;
            int n = (int)Math.ceil(grappaBox.getWidth() * this.scaleFactor);
            int n2 = (int)Math.ceil(grappaBox.getHeight() * this.scaleFactor);
            n = n < rectangle.width ? rectangle.width : n;
            n2 = n2 < rectangle.height ? rectangle.height : n2;
            this.setSize(new Dimension(n, n2));
            this.setPreferredSize(new Dimension(n, n2));
            this.transform.translate(-grappaBox.getMinX(), -grappaBox.getMinY());
            if (container != null) {
                JViewport jViewport = (JViewport)container;
                this.transform.transform((Point2D)object, (Point2D)object);
                Dimension dimension = jViewport.getExtentSize();
                jViewport.setViewPosition(new Point((int)(((Point2D)object).getX() - (double)dimension.width / 2.0), (int)(((Point2D)object).getY() - (double)dimension.height / 2.0)));
            }
        } else {
            Point2D.Double double_ = null;
            Container container = null;
            if (this.scaleChanged) {
                container = this.getParent();
                if (container instanceof JViewport && this.inverseTransform != null) {
                    object = this.getVisibleRect();
                    Point2D.Double double_2 = new Point2D.Double(((Rectangle)object).x, ((Rectangle)object).y);
                    double_ = new Point2D.Double(((Rectangle)object).x + ((Rectangle)object).width, ((Rectangle)object).y + ((Rectangle)object).height);
                    this.inverseTransform.transform(double_2, double_2);
                    this.inverseTransform.transform(double_, double_);
                    ((Point2D)double_).setLocation(((Point2D)double_2).getX() + (((Point2D)double_).getX() - ((Point2D)double_2).getX()) / 2.0, ((Point2D)double_2).getY() + (((Point2D)double_).getY() - ((Point2D)double_2).getY()) / 2.0);
                } else {
                    container = null;
                }
            }
            this.scaleInfo = 1.0;
            this.setSize(new Dimension((int)Math.ceil(grappaBox.getWidth()), (int)Math.ceil(grappaBox.getHeight())));
            this.setPreferredSize(new Dimension((int)Math.ceil(grappaBox.getWidth()), (int)Math.ceil(grappaBox.getHeight())));
            this.transform.translate(-grappaBox.getMinX(), -grappaBox.getMinY());
            if (container != null) {
                object = (JViewport)container;
                this.transform.transform(double_, double_);
                Dimension dimension = ((JViewport)object).getExtentSize();
                ((JViewport)object).setViewPosition(new Point((int)(((Point2D)double_).getX() - (double)dimension.width / 2.0), (int)(((Point2D)double_).getY() - (double)dimension.height / 2.0)));
            }
        }
        this.scaleChanged = false;
        if (this.scaleInfo < Grappa.nodeLabelsScaleCutoff) {
            this.nodeLabels = false;
        }
        if (this.scaleInfo < Grappa.edgeLabelsScaleCutoff) {
            this.edgeLabels = false;
        }
        if (this.scaleInfo < Grappa.subgLabelsScaleCutoff) {
            this.subgLabels = false;
        }
        try {
            this.inverseTransform = this.transform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            this.inverseTransform = null;
        }
        graphics2D.transform(this.transform);
        Rectangle rectangle = graphics2D.getClipBounds();
        --rectangle.x;
        --rectangle.y;
        rectangle.width += 2;
        rectangle.height += 2;
        object = this.graph;
        synchronized (object) {
            GrappaNexus grappaNexus = this.subgraph.grappaNexus;
            if (grappaNexus != null) {
                Color color = null;
                color = (Color)this.graph.getGrappaAttributeValue("grappaBackgroundColor");
                graphics2D.setPaint(color);
                graphics2D.fill(rectangle);
                if (grappaNexus.style.filled || grappaNexus.image != null) {
                    if (grappaNexus.style.filled) {
                        color = grappaNexus.color;
                        graphics2D.setPaint(color);
                        grappaNexus.fill(graphics2D);
                        graphics2D.setPaint(grappaNexus.style.line_color);
                    }
                    grappaNexus.drawImage(graphics2D);
                    if (GrappaStyle.defaultStroke != grappaNexus.style.stroke) {
                        graphics2D.setStroke(grappaNexus.style.stroke);
                        grappaNexus.draw(graphics2D);
                        graphics2D.setStroke(GrappaStyle.defaultStroke);
                    } else {
                        grappaNexus.draw(graphics2D);
                    }
                }
                if (this.backer != null && Grappa.backgroundDrawing) {
                    this.backer.drawBackground(graphics2D, this.graph, grappaBox, rectangle);
                }
                this.paintSubgraph(graphics2D, this.subgraph, rectangle, color);
            }
        }
        this.subgraph.release();
    }

    public AffineTransform getTransform() {
        return (AffineTransform)this.transform.clone();
    }

    public AffineTransform getInverseTransform() {
        return this.inverseTransform;
    }

    public void setToolTipText(String string) {
        super.setToolTipText(string);
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.inverseTransform == null || this.grappaListener == null) {
            return null;
        }
        Point2D point2D = this.inverseTransform.transform(mouseEvent.getPoint(), null);
        return this.grappaListener.grappaTip(this.subgraph, this.findContainingElement(this.subgraph, point2D), new GrappaPoint(point2D.getX(), point2D.getY()), mouseEvent.getModifiers(), this);
    }

    public void setScaleToFit(boolean bl) {
        this.scaleToFit = bl;
    }

    public void setScaleToSize(Dimension2D dimension2D) {
        this.scaleToSize = dimension2D == null ? null : new GrappaSize(dimension2D.getWidth(), dimension2D.getHeight());
    }

    public Subgraph getSubgraph() {
        return this.subgraph;
    }

    public void resetZoom() {
        this.scaleChanged = this.scaleFactor != 1.0;
        this.scaleFactor = 1.0;
        this.zoomBox = null;
    }

    public boolean hasOutline() {
        return this.savedOutline != null;
    }

    public void clearOutline() {
        this.savedOutline = null;
    }

    public GrappaBox zoomToOutline() {
        this.zoomBox = null;
        if (this.savedOutline != null) {
            this.scaleFactor = 1.0;
            this.zoomBox = new GrappaBox(this.savedOutline);
            this.savedOutline = null;
        }
        return this.zoomBox;
    }

    public GrappaBox zoomToOutline(GrappaBox grappaBox) {
        this.zoomBox = null;
        if (grappaBox != null) {
            this.scaleFactor = 1.0;
            this.zoomBox = new GrappaBox(grappaBox);
        }
        return this.zoomBox;
    }

    public double multiplyScaleFactor(double d) {
        double d2 = this.scaleFactor;
        this.zoomBox = null;
        this.scaleFactor *= d;
        if (this.scaleFactor == 0.0) {
            this.scaleFactor = d2;
        }
        this.scaleChanged = this.scaleFactor != d2;
        return d2;
    }

    private void paintSubgraph(Graphics2D graphics2D, Subgraph subgraph, Shape shape, Color color) {
        if (subgraph != this.subgraph && !subgraph.reserve()) {
            return;
        }
        Rectangle2D rectangle2D = subgraph.getBoundingBox();
        GrappaNexus grappaNexus = subgraph.grappaNexus;
        if (rectangle2D != null && grappaNexus != null && subgraph.visible && !grappaNexus.style.invis && shape.intersects(rectangle2D)) {
            int n;
            Enumeration enumeration = null;
            if (subgraph != this.subgraph) {
                graphics2D.setPaint(grappaNexus.color);
                if (grappaNexus.style.filled) {
                    color = grappaNexus.color;
                    grappaNexus.fill(graphics2D);
                    graphics2D.setPaint(grappaNexus.style.line_color);
                } else if (grappaNexus.color == color) {
                    graphics2D.setPaint(grappaNexus.style.line_color);
                }
                grappaNexus.drawImage(graphics2D);
                if (subgraph.isCluster() || Grappa.outlineSubgraphs) {
                    if (GrappaStyle.defaultStroke != grappaNexus.style.stroke) {
                        graphics2D.setStroke(grappaNexus.style.stroke);
                        grappaNexus.draw(graphics2D);
                        graphics2D.setStroke(GrappaStyle.defaultStroke);
                    } else {
                        grappaNexus.draw(graphics2D);
                    }
                }
            }
            if ((subgraph.highlight & 2) == 2) {
                graphics2D.setPaint(this.deletionStyle.line_color);
                if (GrappaStyle.defaultStroke != this.deletionStyle.stroke) {
                    graphics2D.setStroke(this.deletionStyle.stroke);
                    grappaNexus.draw(graphics2D);
                    graphics2D.setStroke(GrappaStyle.defaultStroke);
                } else {
                    grappaNexus.draw(graphics2D);
                }
            } else if ((subgraph.highlight & 1) == 1) {
                graphics2D.setPaint(this.selectionStyle.line_color);
                if (GrappaStyle.defaultStroke != this.selectionStyle.stroke) {
                    graphics2D.setStroke(this.selectionStyle.stroke);
                    grappaNexus.draw(graphics2D);
                    graphics2D.setStroke(GrappaStyle.defaultStroke);
                } else {
                    grappaNexus.draw(graphics2D);
                }
            }
            if (grappaNexus.lstr != null && this.subgLabels) {
                graphics2D.setFont(grappaNexus.font);
                graphics2D.setPaint(grappaNexus.font_color);
                n = 0;
                while (n < grappaNexus.lstr.length) {
                    graphics2D.drawString(grappaNexus.lstr[n], (int)grappaNexus.lpos[n].x, (int)grappaNexus.lpos[n].y);
                    ++n;
                }
            }
            enumeration = subgraph.subgraphElements();
            Subgraph subgraph2 = null;
            while (enumeration.hasMoreElements()) {
                subgraph2 = (Subgraph)enumeration.nextElement();
                if (subgraph2 == null) continue;
                this.paintSubgraph(graphics2D, subgraph2, shape, color);
            }
            enumeration = subgraph.nodeElements();
            while (enumeration.hasMoreElements()) {
                Node node = (Node)enumeration.nextElement();
                if (node == null || !node.reserve()) continue;
                grappaNexus = node.grappaNexus;
                if (grappaNexus != null && node.visible && !grappaNexus.style.invis && shape.intersects(grappaNexus.rawBounds2D())) {
                    graphics2D.setPaint(grappaNexus.color);
                    if (grappaNexus.style.filled) {
                        grappaNexus.fill(graphics2D);
                        graphics2D.setPaint(grappaNexus.style.line_color);
                    }
                    grappaNexus.drawImage(graphics2D);
                    if ((node.highlight & 2) == 2) {
                        graphics2D.setPaint(this.deletionStyle.line_color);
                        if (GrappaStyle.defaultStroke != this.deletionStyle.stroke) {
                            graphics2D.setStroke(this.deletionStyle.stroke);
                            grappaNexus.draw(graphics2D);
                            graphics2D.setStroke(GrappaStyle.defaultStroke);
                        } else {
                            grappaNexus.draw(graphics2D);
                        }
                    } else if ((node.highlight & 1) == 1) {
                        graphics2D.setPaint(this.selectionStyle.line_color);
                        if (GrappaStyle.defaultStroke != this.selectionStyle.stroke) {
                            graphics2D.setStroke(this.selectionStyle.stroke);
                            grappaNexus.draw(graphics2D);
                            graphics2D.setStroke(GrappaStyle.defaultStroke);
                        } else {
                            grappaNexus.draw(graphics2D);
                        }
                    } else if (GrappaStyle.defaultStroke != grappaNexus.style.stroke) {
                        graphics2D.setStroke(grappaNexus.style.stroke);
                        grappaNexus.draw(graphics2D);
                        graphics2D.setStroke(GrappaStyle.defaultStroke);
                    } else {
                        grappaNexus.draw(graphics2D);
                    }
                    if (grappaNexus.lstr != null && this.nodeLabels) {
                        graphics2D.setFont(grappaNexus.font);
                        graphics2D.setPaint(grappaNexus.font_color);
                        n = 0;
                        while (n < grappaNexus.lstr.length) {
                            graphics2D.drawString(grappaNexus.lstr[n], (int)grappaNexus.lpos[n].x, (int)grappaNexus.lpos[n].y);
                            ++n;
                        }
                    }
                }
                node.release();
            }
            enumeration = subgraph.edgeElements();
            while (enumeration.hasMoreElements()) {
                Edge edge = (Edge)enumeration.nextElement();
                if (edge == null || !edge.reserve()) continue;
                grappaNexus = edge.grappaNexus;
                if (grappaNexus != null && edge.visible && !grappaNexus.style.invis && shape.intersects(grappaNexus.rawBounds2D())) {
                    grappaNexus.drawImage(graphics2D);
                    if ((edge.highlight & 2) == 2) {
                        graphics2D.setPaint(this.deletionStyle.line_color);
                        grappaNexus.fill(graphics2D);
                        if (GrappaStyle.defaultStroke != this.deletionStyle.stroke) {
                            graphics2D.setStroke(this.deletionStyle.stroke);
                            grappaNexus.draw(graphics2D);
                            graphics2D.setStroke(GrappaStyle.defaultStroke);
                        } else {
                            grappaNexus.draw(graphics2D);
                        }
                    } else if ((edge.highlight & 1) == 1) {
                        graphics2D.setPaint(this.selectionStyle.line_color);
                        grappaNexus.fill(graphics2D);
                        if (GrappaStyle.defaultStroke != this.selectionStyle.stroke) {
                            graphics2D.setStroke(this.selectionStyle.stroke);
                            grappaNexus.draw(graphics2D);
                            graphics2D.setStroke(GrappaStyle.defaultStroke);
                        } else {
                            grappaNexus.draw(graphics2D);
                        }
                    } else {
                        graphics2D.setPaint(grappaNexus.color);
                        grappaNexus.fill(graphics2D);
                        if (GrappaStyle.defaultStroke != grappaNexus.style.stroke) {
                            graphics2D.setStroke(grappaNexus.style.stroke);
                            grappaNexus.draw(graphics2D);
                            graphics2D.setStroke(GrappaStyle.defaultStroke);
                        } else {
                            grappaNexus.draw(graphics2D);
                        }
                    }
                    if (grappaNexus.lstr != null && this.edgeLabels) {
                        graphics2D.setFont(grappaNexus.font);
                        graphics2D.setPaint(grappaNexus.font_color);
                        n = 0;
                        while (n < grappaNexus.lstr.length) {
                            graphics2D.drawString(grappaNexus.lstr[n], (int)grappaNexus.lpos[n].x, (int)grappaNexus.lpos[n].y);
                            ++n;
                        }
                    }
                }
                edge.release();
            }
        }
        subgraph.release();
    }

    private Element findContainingElement(Subgraph subgraph, Point2D point2D) {
        return this.findContainingElement(subgraph, point2D, null);
    }

    private Element findContainingElement(Subgraph subgraph, Point2D point2D, Element element) {
        Element[] elementArray = new Element[]{element, null};
        Element element2 = this.reallyFindContainingElement(subgraph, point2D, elementArray);
        if (element2 == null) {
            element2 = elementArray[1];
        }
        return element2;
    }

    private Element reallyFindContainingElement(Subgraph subgraph, Point2D point2D, Element[] elementArray) {
        Rectangle2D rectangle2D = subgraph.getBoundingBox();
        GrappaNexus grappaNexus = null;
        if (rectangle2D.contains(point2D)) {
            Element element;
            Enumeration enumeration;
            if ((Grappa.elementSelection & 2) == 2) {
                enumeration = subgraph.edgeElements();
                while (enumeration.hasMoreElements()) {
                    element = (Edge)enumeration.nextElement();
                    grappaNexus = element.grappaNexus;
                    if (grappaNexus == null || !grappaNexus.rawBounds2D().contains(point2D) || !grappaNexus.contains(point2D.getX(), point2D.getY())) continue;
                    if (elementArray[0] == null) {
                        return element;
                    }
                    if (elementArray[1] == null) {
                        elementArray[1] = element;
                    }
                    if (elementArray[0] != element) continue;
                    elementArray[0] = null;
                }
            }
            if ((Grappa.elementSelection & 1) == 1) {
                enumeration = subgraph.nodeElements();
                while (enumeration.hasMoreElements()) {
                    element = (Node)enumeration.nextElement();
                    grappaNexus = element.grappaNexus;
                    if (grappaNexus == null || !grappaNexus.rawBounds2D().contains(point2D) || !grappaNexus.contains(point2D)) continue;
                    if (elementArray[0] == null) {
                        return element;
                    }
                    if (elementArray[1] == null) {
                        elementArray[1] = element;
                    }
                    if (elementArray[0] != element) continue;
                    elementArray[0] = null;
                }
            }
            element = null;
            enumeration = subgraph.subgraphElements();
            while (enumeration.hasMoreElements()) {
                element = this.reallyFindContainingElement((Subgraph)enumeration.nextElement(), point2D, elementArray);
                if (element == null) continue;
                if (elementArray[0] == null) {
                    return element;
                }
                if (elementArray[1] == null) {
                    elementArray[1] = element;
                }
                if (elementArray[0] != element) continue;
                elementArray[0] = null;
            }
            if ((Grappa.elementSelection & 4) == 4) {
                if (elementArray[0] == null) {
                    return subgraph;
                }
                if (elementArray[1] == null) {
                    elementArray[1] = subgraph;
                }
                if (elementArray[0] == subgraph) {
                    elementArray[0] = null;
                }
            }
        }
        return null;
    }

    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    public void ancestorAdded(AncestorEvent ancestorEvent) {
        this.graph.addPanel(this);
    }

    public void ancestorRemoved(AncestorEvent ancestorEvent) {
        this.graph.removePanel(this);
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.revalidate();
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        this.inMenu = false;
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        this.inMenu = true;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.inverseTransform == null || this.grappaListener == null || this.inMenu) {
            return;
        }
        Point2D point2D = this.inverseTransform.transform(mouseEvent.getPoint(), null);
        this.grappaListener.grappaClicked(this.subgraph, this.findContainingElement(this.subgraph, point2D, this.subgraph.currentSelection != null && this.subgraph.currentSelection instanceof Element ? (Element)this.subgraph.currentSelection : null), new GrappaPoint(point2D.getX(), point2D.getY()), mouseEvent.getModifiers(), mouseEvent.getClickCount(), this);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.inverseTransform == null || this.grappaListener == null || this.inMenu) {
            return;
        }
        Point2D point2D = this.inverseTransform.transform(mouseEvent.getPoint(), null);
        this.outline = null;
        this.pressedElement = this.findContainingElement(this.subgraph, point2D);
        this.pressedPoint = new GrappaPoint(point2D.getX(), point2D.getY());
        this.pressedModifiers = mouseEvent.getModifiers();
        this.grappaListener.grappaPressed(this.subgraph, this.pressedElement, this.pressedPoint, this.pressedModifiers, this);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.inverseTransform == null || this.grappaListener == null || this.inMenu) {
            return;
        }
        int n = mouseEvent.getModifiers();
        Point2D point2D = this.inverseTransform.transform(mouseEvent.getPoint(), null);
        GrappaPoint grappaPoint = new GrappaPoint(point2D.getX(), point2D.getY());
        this.grappaListener.grappaReleased(this.subgraph, this.findContainingElement(this.subgraph, point2D), grappaPoint, n, this.pressedElement, this.pressedPoint, this.pressedModifiers, this.outline, this);
        if ((n & 0x10) != 0 && (n & 0x10) == n) {
            if (this.outline != null) {
                this.savedOutline = GrappaSupport.boxFromCorners(this.outline, this.pressedPoint.x, this.pressedPoint.y, grappaPoint.x, grappaPoint.y);
                this.outline = null;
            } else {
                this.savedOutline = null;
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.inverseTransform == null || this.grappaListener == null || this.inMenu) {
            return;
        }
        int n = mouseEvent.getModifiers();
        Point2D point2D = this.inverseTransform.transform(mouseEvent.getPoint(), null);
        GrappaPoint grappaPoint = new GrappaPoint(point2D.getX(), point2D.getY());
        this.grappaListener.grappaDragged(this.subgraph, grappaPoint, n, this.pressedElement, this.pressedPoint, this.pressedModifiers, this.outline, this);
        if ((n & 0x10) != 0 && (n & 0x10) == n) {
            this.outline = GrappaSupport.boxFromCorners(this.outline, this.pressedPoint.x, this.pressedPoint.y, grappaPoint.x, grappaPoint.y);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 1;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        int n3 = n == 1 ? (int)((double)rectangle.height * 0.9) : (int)((double)rectangle.width * 0.9);
        if (n3 < 1) {
            n3 = 1;
        }
        return n3;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }
}

