/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse;

import com.parctechnologies.eclipse.Platform_i386_linux;
import com.parctechnologies.eclipse.Platform_i386_macosx;
import com.parctechnologies.eclipse.Platform_i386_nt;
import com.parctechnologies.eclipse.Platform_i386_sunos5;
import com.parctechnologies.eclipse.Platform_ppc_macosx;
import com.parctechnologies.eclipse.Platform_sparc_sunos5;
import com.parctechnologies.eclipse.Platform_x86_64_linux;
import com.parctechnologies.eclipse.Platform_x86_64_macosx;
import com.parctechnologies.eclipse.Platform_x86_64_sunos5;
import java.io.File;

abstract class Platform {
    private static Platform single = null;

    Platform() {
    }

    public abstract boolean supportsEmbeddedEclipse();

    public abstract boolean supportsOutOfProcessEclipse();

    public static Platform getInstance() {
        if (single == null) {
            single = Platform.findPlatform();
        }
        return single;
    }

    abstract String getEclipsePlatformName();

    abstract File getExecutableSubdirectory(File var1);

    abstract String getSharedLibraryExtension();

    abstract void loadEclipseSharedLibrary(File var1) throws UnsatisfiedLinkError;

    File getLibrarySubdirectory(File file) {
        return new File(new File(file, "lib"), this.getEclipsePlatformName());
    }

    private static Platform findPlatform() {
        String string = System.getProperty("os.name");
        String string2 = System.getProperty("os.arch");
        if (string.startsWith("Windows")) {
            if (string2.equals("x86")) {
                return new Platform_i386_nt();
            }
        } else if (string.equals("Linux")) {
            if (string2.equals("i386") || string2.equals("x86")) {
                return new Platform_i386_linux();
            }
            if (string2.equals("x86_64") || string2.equals("amd64")) {
                return new Platform_x86_64_linux();
            }
        } else if (string.equals("SunOS") || string.equals("Solaris")) {
            if (string2.equals("sparc")) {
                return new Platform_sparc_sunos5();
            }
            if (string2.equals("i386") || string2.equals("x86")) {
                return new Platform_i386_sunos5();
            }
            if (string2.equals("x86_64") || string2.equals("amd64")) {
                return new Platform_x86_64_sunos5();
            }
        } else if (string.equals("Mac OS X") || string.equals("Darwin")) {
            if (string2.equals("ppc")) {
                return new Platform_ppc_macosx();
            }
            if (string2.equals("i386") || string2.equals("x86")) {
                return new Platform_i386_macosx();
            }
            if (string2.equals("x86_64") || string2.equals("amd64")) {
                return new Platform_x86_64_macosx();
            }
        }
        throw new RuntimeException("Unsupported platform: " + string + "/" + string2);
    }
}

