/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import com.parctechnologies.eclipse.CompoundTerm;
import com.parctechnologies.eclipse.visualisation.AnyElementType;
import com.parctechnologies.eclipse.visualisation.GraphData;
import com.parctechnologies.eclipse.visualisation.NumericBounds;
import com.parctechnologies.eclipse.visualisation.VisException;
import java.io.Serializable;

public class ElementType
implements Serializable {
    private static String changeable = "changeable";
    private static String any = "any";
    private static String numericBounds = "numeric_bounds";
    private static String graphData = "graph_data";
    protected String changeableSolver = null;

    protected ElementType() {
    }

    public String getChangeableSolver() {
        return this.changeableSolver;
    }

    static ElementType parseFromCompoundTerm(CompoundTerm compoundTerm) throws VisException {
        if (changeable.equals(compoundTerm.functor()) && compoundTerm.arity() == 2) {
            try {
                CompoundTerm compoundTerm2 = (CompoundTerm)compoundTerm.arg(1);
                CompoundTerm compoundTerm3 = (CompoundTerm)compoundTerm.arg(2);
                ElementType elementType = ElementType.parseFromCompoundTerm(compoundTerm3);
                elementType.changeableSolver = compoundTerm2.functor();
                return elementType;
            }
            catch (ClassCastException classCastException) {
                throw new VisException("Could not parse changeable element type from " + compoundTerm);
            }
        }
        if (any.equals(compoundTerm.functor())) {
            return new AnyElementType();
        }
        if (numericBounds.equals(compoundTerm.functor())) {
            return new NumericBounds();
        }
        if (graphData.equals(compoundTerm.functor())) {
            return new GraphData();
        }
        throw new VisException("Could not parse element type from " + compoundTerm);
    }
}

