/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation.viewers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;

public class FadeIcon
implements Icon {
    private int height;
    private int width;
    private Rectangle[] greenRect;
    private Rectangle[] redRect;
    private Color[] greenFadeColor = new Color[]{new Color(255, 255, 255), new Color(200, 255, 200), new Color(150, 255, 150), new Color(100, 255, 100)};
    private Color[] redFadeColor = new Color[]{new Color(255, 100, 100), new Color(255, 150, 150), new Color(255, 200, 200), new Color(255, 255, 255)};

    public FadeIcon(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.initialiseShapes();
    }

    private void initialiseShapes() {
        this.greenRect = new Rectangle[this.greenFadeColor.length];
        double d = 1.0 / (double)(this.greenFadeColor.length + 1);
        for (int i = 0; i < this.greenFadeColor.length; ++i) {
            this.greenRect[i] = new Rectangle((int)((double)this.width * 0.1), (int)((double)this.height * (d / 2.0 + d * (double)i)), (int)((double)this.width * 0.4), (int)((double)this.height * d));
        }
        this.redRect = new Rectangle[this.redFadeColor.length];
        double d2 = 1.0 / (double)(this.redFadeColor.length + 1);
        for (int i = 0; i < this.redFadeColor.length; ++i) {
            this.redRect[i] = new Rectangle((int)((double)this.width * 0.5), (int)((double)this.height * (d2 / 2.0 + d2 * (double)i)), (int)((double)this.width * 0.4), (int)((double)this.height * d2));
        }
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Rectangle rectangle;
        int n3;
        for (n3 = 0; n3 < this.greenFadeColor.length; ++n3) {
            rectangle = this.greenRect[n3];
            graphics.setColor(this.greenFadeColor[n3]);
            graphics.fillRect(n + rectangle.x, n2 + rectangle.y, rectangle.width, rectangle.height);
        }
        for (n3 = 0; n3 < this.redFadeColor.length; ++n3) {
            rectangle = this.redRect[n3];
            graphics.setColor(this.redFadeColor[n3]);
            graphics.fillRect(n + rectangle.x, n2 + rectangle.y, rectangle.width, rectangle.height);
        }
        graphics.setColor(component.getForeground());
    }
}

