/*
 * Decompiled with CFR 0.152.
 */
package ie.ucc.cccc.viz;

import ie.ucc.cccc.viz.Node;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class TreeGraph {
    static int[] tryCount;
    static int[] succCount;
    static int[] failCount;

    public static TreeGraph graph(Node node) {
        TreeGraph treeGraph = new TreeGraph();
        int n = treeGraph.depth(node, 0);
        tryCount = new int[n + 1];
        succCount = new int[n + 1];
        failCount = new int[n + 1];
        treeGraph.recordNodes(node, 0);
        return treeGraph;
    }

    public int depth(Node node, int n) {
        int n2 = n;
        for (Node node2 : node.getChildren()) {
            n2 = Math.max(n2, this.depth(node2, n + 1));
        }
        return n2;
    }

    public void recordNodes(Node node, int n) {
        this.recordNode(node, n);
        if (node.getChildren().size() > 0) {
            for (Node node2 : node.getChildren()) {
                this.recordNodes(node2, n + 1);
            }
        }
    }

    public void recordNode(Node node, int n) {
        switch (node.getType()) {
            case ROOT: {
                assert (n == 0);
                break;
            }
            case TRY: 
            case TRYC: {
                int n2 = n;
                tryCount[n2] = tryCount[n2] + 1;
                break;
            }
            case FAIL: 
            case FAILC: {
                int n3 = n;
                failCount[n3] = failCount[n3] + 1;
                break;
            }
            case SUCC: 
            case SUCCC: {
                int n4 = n - 1;
                succCount[n4] = succCount[n4] + 1;
                break;
            }
            default: {
                System.out.println("Unexpected node type");
            }
        }
    }

    public void plot(String string, String string2) {
        try {
            File file = new File(string, string2);
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            int n = tryCount.length;
            for (int i = 0; i < n; ++i) {
                printWriter.println(i + " " + tryCount[i] + " " + failCount[i] + " " + succCount[i]);
                System.out.println(i + " " + tryCount[i] + " " + failCount[i] + " " + succCount[i]);
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("no luck");
        }
    }
}

