/*
 * Decompiled with CFR 0.152.
 */
package ie.ucc.cccc.viz;

import ie.ucc.cccc.viz.Colors;
import ie.ucc.cccc.viz.CumulativeProfile;
import ie.ucc.cccc.viz.FullDomain;
import ie.ucc.cccc.viz.InvariantType;
import ie.ucc.cccc.viz.Tuple;
import ie.ucc.cccc.viz.VisualContext;
import ie.ucc.cccc.viz.VisualState;
import ie.ucc.cccc.viz.VisualizerLayout;
import java.io.PrintWriter;

public class VisualizerCumulative
extends VisualizerLayout {
    public VisualizerCumulative(VisualContext visualContext) {
        super(visualContext);
    }

    @Override
    void draw(PrintWriter printWriter, VisualState visualState) {
        int n;
        Tuple[] tupleArray = visualState.argumentTupleArray("tasks");
        FullDomain fullDomain = visualState.argumentDomain("limit");
        FullDomain fullDomain2 = visualState.argumentDomain("end");
        int n2 = tupleArray.length;
        this.setHeight(fullDomain.getMax());
        int n3 = 0;
        for (int i = 1; i < n2; ++i) {
            n = tupleArray[i].getField("start").getMax();
            int n4 = tupleArray[i].getField("dur").getMax();
            n3 = Math.max(n3, n + n4);
        }
        this.setWidth(n3);
        this.standardGrid(printWriter);
        int[] nArray = CumulativeProfile.computeProfile(tupleArray, this.width());
        for (n = 0; n < this.width(); ++n) {
            this.openRectSVG(printWriter, this.posX(n), this.posY(0.0), 1.0, nArray[n], Colors.UNASSIGNED_COLOR, 0.8);
        }
        this.drawLimit(printWriter, fullDomain);
        this.drawEnd(printWriter, fullDomain2);
    }

    @Override
    public InvariantType invariant(PrintWriter printWriter, VisualState visualState) {
        int n;
        Tuple[] tupleArray = visualState.argumentTupleArray("tasks");
        FullDomain fullDomain = visualState.argumentDomain("limit");
        FullDomain fullDomain2 = visualState.argumentDomain("end");
        int n2 = tupleArray.length;
        int n3 = 0;
        int n4 = 0;
        int n5 = tupleArray[1].getField("start").getMin();
        for (int i = 1; i < n2; ++i) {
            int n6 = tupleArray[i].getField("start").getMax();
            n = tupleArray[i].getField("start").getMin();
            int n7 = tupleArray[i].getField("dur").getMax();
            int n8 = tupleArray[i].getField("dur").getMin();
            int n9 = tupleArray[i].getField("res").getMin();
            n3 = Math.max(n3, n6 + n7);
            n4 += n8 * n9;
            n5 = Math.min(n5, n);
        }
        int[] nArray = CumulativeProfile.computeProfile(tupleArray, n3);
        InvariantType invariantType = InvariantType.TRUE;
        for (n = 0; n < n3; ++n) {
            if (nArray[n] > fullDomain.getMax()) {
                invariantType = invariantType.update(InvariantType.INCONSISTENT);
            }
            if (nArray[n] <= fullDomain.getMin()) continue;
            invariantType = invariantType.update(InvariantType.MISSING_PROPAGATION);
        }
        if (fullDomain2 != null) {
            if ((double)fullDomain2.getMax() < (double)n5 + Math.ceil(n4 / fullDomain.getMax())) {
                invariantType = invariantType.update(InvariantType.INCONSISTENT);
            }
            if ((double)fullDomain2.getMin() < (double)n5 + Math.ceil(n4 / fullDomain.getMax())) {
                invariantType = invariantType.update(InvariantType.MISSING_PROPAGATION);
            }
        }
        return invariantType;
    }
}

