/*
 * Decompiled with CFR 0.152.
 */
package ie.ucc.cccc.viz;

import ie.ucc.cccc.viz.Box;
import ie.ucc.cccc.viz.Colors;
import ie.ucc.cccc.viz.FullDomain;
import ie.ucc.cccc.viz.InvariantType;
import ie.ucc.cccc.viz.VisualContext;
import ie.ucc.cccc.viz.VisualState;
import ie.ucc.cccc.viz.VizFailed;
import ie.ucc.cccc.viz.VizFocus;
import java.io.PrintWriter;

public abstract class VisualizerDrawer {
    public VisualContext context;
    private static int scaleSVG = 100;

    public VisualizerDrawer(VisualContext visualContext) {
        this.context = visualContext;
    }

    abstract void draw(PrintWriter var1, VisualState var2);

    public InvariantType invariant(PrintWriter printWriter, VisualState visualState) {
        return InvariantType.TRUE;
    }

    public void drawBox(PrintWriter printWriter, VisualState visualState, Colors colors) {
        this.rawRectSVG(printWriter, this.context.getX(), this.context.getY(), this.context.getBoxWidth(), this.context.getBoxHeight(), colors, 0.2);
    }

    public Box getBox() {
        return new Box(this.context.getX(), this.context.getY(), this.context.getBoxWidth(), this.context.getBoxHeight());
    }

    public int leftX() {
        return this.context.getX() + 1;
    }

    public int labelX() {
        return this.context.getX();
    }

    public int topY() {
        return this.context.getY() + 1;
    }

    public int labelY() {
        return this.context.getY();
    }

    public int width() {
        return this.context.getWidth();
    }

    public int height() {
        return this.context.getHeight();
    }

    public double posX(double d) {
        return (double)this.leftX() + d - (double)this.context.getIndexStart();
    }

    public double posY(double d) {
        return (double)this.topY() + d - (double)this.context.getMin();
    }

    public int left2X() {
        return this.context.getX() + this.width() + 2;
    }

    public int label2X() {
        return this.context.getX() + this.width() + 1;
    }

    public int top2Y() {
        return this.topY() + this.height() + 1;
    }

    public int label2Y() {
        return this.topY() + this.height();
    }

    public int min() {
        return this.context.getMin();
    }

    public int max() {
        return this.context.getMax();
    }

    public void setWidth(int n) {
        this.context.setWidth(n);
    }

    public void setHeight(int n) {
        this.context.setHeight(n);
    }

    public void setMin(int n) {
        this.context.setMin(n);
    }

    public void setMax(int n) {
        this.context.setMax(n);
    }

    public void standardGrid(PrintWriter printWriter) {
        int n;
        this.gridSVG(printWriter, this.leftX(), this.topY(), this.width(), this.height());
        for (n = this.context.getMin(); n <= this.context.getMax(); ++n) {
            this.textSVG(printWriter, (double)this.labelX(), this.posY(n), n, Colors.LABEL_TEXT_COLOR);
        }
        for (n = 1; n <= this.width(); ++n) {
            this.textSVG(printWriter, this.posX(n), (double)this.labelY(), n, Colors.LABEL_TEXT_COLOR);
        }
    }

    public Colors domainBasedColor(FullDomain fullDomain) {
        if (fullDomain.size() > 1) {
            return Colors.UNASSIGNED_COLOR;
        }
        return Colors.ASSIGN_COLOR;
    }

    public Colors booleanColor(FullDomain fullDomain) {
        if (fullDomain.isFixed()) {
            return this.booleanColor(fullDomain.getIntValue());
        }
        return Colors.UNASSIGNED_COLOR;
    }

    public Colors booleanColor(FullDomain fullDomain, FullDomain fullDomain2) {
        if (!fullDomain.isFixed()) {
            return Colors.UNASSIGNED_COLOR;
        }
        if (fullDomain2 == null || fullDomain2.size() == 0) {
            if (fullDomain.getIntValue() == 0) {
                return Colors.OLD_ZERO_COLOR;
            }
            return Colors.OLD_ONE_COLOR;
        }
        return this.booleanColor(fullDomain.getIntValue());
    }

    public Colors booleanColor(int n) {
        if (n == 0) {
            return Colors.ZERO_COLOR;
        }
        return Colors.ONE_COLOR;
    }

    public boolean isInFocus(VizFocus vizFocus) {
        return vizFocus != null && vizFocus.getGroup().equals(this.context.getGroup());
    }

    public boolean isFailed(VizFailed vizFailed) {
        return vizFailed != null && vizFailed.getGroup().equals(this.context.getGroup());
    }

    public void drawCount(PrintWriter printWriter, double d, double d2, double d3, int n, int n2, int n3, int n4) {
        this.rectSVG(printWriter, d, d2, n, 1.0, Colors.TOO_LOW_COLOR);
        this.rectSVG(printWriter, d + (double)n, d2, n2 - n, 1.0, Colors.ALLOWED_COLOR);
        this.rectSVG(printWriter, d + (double)n2, d2, d3 - (double)n2, 1.0, Colors.TOO_HIGH_COLOR);
        this.rectSVG(printWriter, d, d2 + 0.5, n3, 0.5, Colors.FIXED_COLOR);
        this.rectSVG(printWriter, d + (double)n3, d2 + 0.5, n4, 0.5, Colors.POSSIBLE_COLOR);
        if (n3 >= n && n3 + n4 <= n2) {
            this.hollowRectSVG(printWriter, d, d2, d3, 1.0, Colors.BORDER_COLOR);
        } else {
            this.hollowRectSVG(printWriter, d, d2, d3, 1.0, Colors.FOCUS_COLOR);
        }
    }

    public void unitSquareSVG(PrintWriter printWriter, double d, double d2, Colors colors) {
        printWriter.println("<rect x=\"" + d * (double)scaleSVG + "\" y=\"" + d2 * (double)scaleSVG + "\" width=\"" + scaleSVG + "\" height=\"" + scaleSVG + "\" style=\"stroke-width:5;stroke:" + Colors.BORDER_COLOR + ";fill:" + colors + ";\"/>");
    }

    public void unitSquareSVG(PrintWriter printWriter, double d, double d2, Colors colors, double d3) {
        printWriter.println("<rect x=\"" + d * (double)scaleSVG + "\" y=\"" + d2 * (double)scaleSVG + "\" width=\"" + scaleSVG + "\" height=\"" + scaleSVG + "\" style=\"stroke-width:5;stroke:" + Colors.BORDER_COLOR + ";fill:" + colors + ";opacity:" + d3 + ";\"/>");
    }

    public void hollowRectSVG(PrintWriter printWriter, double d, double d2, double d3, double d4, Colors colors) {
        this.hollowRectSVG(printWriter, d, d2, d3, d4, colors, 0.1);
    }

    public void hollowRectSVG(PrintWriter printWriter, double d, double d2, double d3, double d4, Colors colors, double d5) {
        printWriter.println("<rect x=\"" + d * (double)scaleSVG + "\" y=\"" + d2 * (double)scaleSVG + "\" width=\"" + d3 * (double)scaleSVG + "\" height=\"" + d4 * (double)scaleSVG + "\" style=\"stroke-width:" + d5 * (double)scaleSVG + ";stroke:" + colors + ";fill:none;\"/>");
    }

    public void openRectSVG(PrintWriter printWriter, double d, double d2, double d3, double d4, Colors colors, double d5) {
        printWriter.println("<rect x=\"" + d * (double)scaleSVG + "\" y=\"" + d2 * (double)scaleSVG + "\" width=\"" + d3 * (double)scaleSVG + "\" height=\"" + d4 * (double)scaleSVG + "\" style=\"stroke:none;fill:" + colors + ";opacity:" + d5 + ";\"/>");
    }

    public void openRectSVG(PrintWriter printWriter, double d, double d2, double d3, double d4, Colors colors) {
        printWriter.println("<rect x=\"" + d * (double)scaleSVG + "\" y=\"" + d2 * (double)scaleSVG + "\" width=\"" + d3 * (double)scaleSVG + "\" height=\"" + d4 * (double)scaleSVG + "\" style=\"stroke:none;fill:" + colors + ";\"/>");
    }

    public void roundedRectSVG(PrintWriter printWriter, double d, double d2, double d3, double d4, Colors colors, double d5) {
        printWriter.println("<rect x=\"" + d * (double)scaleSVG + "\" y=\"" + d2 * (double)scaleSVG + "\" width=\"" + d3 * (double)scaleSVG + "\" height=\"" + d4 * (double)scaleSVG + "\" rx=\"50\" ry=\"50\" style=\"stroke:black;stroke-width:5;fill:" + colors + ";opacity:" + d5 + ";\"/>");
    }

    public void roundedRectSVG(PrintWriter printWriter, double d, double d2, double d3, double d4, Colors colors) {
        printWriter.println("<rect x=\"" + d * (double)scaleSVG + "\" y=\"" + d2 * (double)scaleSVG + "\" width=\"" + d3 * (double)scaleSVG + "\" height=\"" + d4 * (double)scaleSVG + "\" rx=\"50\" ry=\"50\" style=\"stroke:black;stroke-width:5;fill:" + colors + ";\"/>");
    }

    public void rectSVG(PrintWriter printWriter, double d, double d2, double d3, double d4, Colors colors) {
        printWriter.println("<rect x=\"" + d * (double)scaleSVG + "\" y=\"" + d2 * (double)scaleSVG + "\" width=\"" + d3 * (double)scaleSVG + "\" height=\"" + d4 * (double)scaleSVG + "\" style=\"stroke-width:10;stroke:" + Colors.BORDER_COLOR + ";fill:" + colors + ";\"/>");
    }

    public void rectSVG(PrintWriter printWriter, double d, double d2, double d3, double d4, Colors colors, double d5) {
        printWriter.println("<rect x=\"" + d * (double)scaleSVG + "\" y=\"" + d2 * (double)scaleSVG + "\" width=\"" + d3 * (double)scaleSVG + "\" height=\"" + d4 * (double)scaleSVG + "\" style=\"stroke-width:10;stroke:" + Colors.BORDER_COLOR + ";fill:" + colors + ";opacity:" + d5 + ";\"/>");
    }

    public final void rawRectSVG(PrintWriter printWriter, double d, double d2, double d3, double d4, Colors colors, double d5) {
        printWriter.println("<rect x=\"" + d * (double)scaleSVG + "\" y=\"" + d2 * (double)scaleSVG + "\" width=\"" + d3 * (double)scaleSVG + "\" height=\"" + d4 * (double)scaleSVG + "\" style=\"stroke-width:10;stroke:" + Colors.BORDER_COLOR + ";fill:" + colors + ";opacity:" + d5 + ";\"/>");
    }

    public void lineSVG(PrintWriter printWriter, double d, double d2, double d3, double d4, Colors colors) {
        this.lineSVG(printWriter, d, d2, d3, d4, colors, 0.1);
    }

    public void lineSVG(PrintWriter printWriter, double d, double d2, double d3, double d4, Colors colors, double d5) {
        printWriter.println("<line x1=\"" + d * (double)scaleSVG + "\" y1=\"" + d2 * (double)scaleSVG + "\" x2=\"" + d3 * (double)scaleSVG + "\" y2=\"" + d4 * (double)scaleSVG + "\" style=\"stroke-width:" + d5 * (double)scaleSVG + ";stroke:" + colors + ";fill:none;\"/>");
    }

    public void textSVG(PrintWriter printWriter, double d, double d2, int n, Colors colors) {
        this.textSVG(printWriter, d, d2, Integer.toString(n), colors);
    }

    public void textSVG(PrintWriter printWriter, double d, double d2, String string, Colors colors) {
        this.textSVG(printWriter, d + 0.5, d2 + 0.75, 0.5, string, colors);
    }

    public void textSVG(PrintWriter printWriter, double d, double d2, double d3, int n, Colors colors) {
        this.textSVG(printWriter, d, d2, d3, Integer.toString(n), colors);
    }

    public void textSVG(PrintWriter printWriter, double d, double d2, double d3, String string, Colors colors) {
        printWriter.println("<text x=\"" + (double)scaleSVG * d + "\" y=\"" + (double)scaleSVG * d2 + "\" style=\"stroke:none;fill:" + colors + ";font-family:Arial,sans-serif;font-size:" + d3 * (double)scaleSVG + "px;text-anchor:middle;\">");
        printWriter.println(string);
        printWriter.println("</text>");
    }

    public void textStartSVG(PrintWriter printWriter, double d, double d2, double d3, String string, Colors colors) {
        printWriter.println("<text x=\"" + (double)scaleSVG * d + "\" y=\"" + (double)scaleSVG * d2 + "\" style=\"stroke:none;fill:" + colors + ";font-family:Arial,sans-serif;font-size:" + d3 * (double)scaleSVG + "px;text-anchor:start;\">");
        printWriter.println(string);
        printWriter.println("</text>");
    }

    public void gridSVG(PrintWriter printWriter, int n, int n2, int n3, int n4) {
        int n5;
        printWriter.print("<path d=\"");
        for (n5 = n; n5 <= n + n3; ++n5) {
            printWriter.print("M" + n5 * scaleSVG + "," + n2 * scaleSVG + " l0," + n4 * scaleSVG + " ");
        }
        for (n5 = n2; n5 <= n2 + n4; ++n5) {
            printWriter.print("M" + n * scaleSVG + "," + n5 * scaleSVG + " l" + n3 * scaleSVG + ",0 ");
        }
        printWriter.println("\" style=\"stroke-width:5;stroke:" + Colors.GRID_COLOR + ";fill:none\"/>");
    }

    public void pathStartSVG(PrintWriter printWriter) {
        printWriter.print("<path d=\"");
    }

    public void pathEndSVG(PrintWriter printWriter, Colors colors) {
        printWriter.println("\" style=\"stroke-width:5;stroke:" + colors + ";fill:none\"/>");
    }

    public void pathMoveSVG(PrintWriter printWriter, double d, double d2) {
        printWriter.print("M" + d * (double)scaleSVG + "," + d2 * (double)scaleSVG + " ");
    }

    public void pathLineSVG(PrintWriter printWriter, double d, double d2) {
        printWriter.print("L" + d * (double)scaleSVG + "," + d2 * (double)scaleSVG + " ");
    }
}

