/*
 * Decompiled with CFR 0.152.
 */
package ie.ucc.cccc.viz;

import ie.ucc.cccc.viz.Box;
import ie.ucc.cccc.viz.InvariantType;
import ie.ucc.cccc.viz.Node;
import ie.ucc.cccc.viz.NodeType;
import ie.ucc.cccc.viz.State;
import ie.ucc.cccc.viz.StateStack;
import ie.ucc.cccc.viz.Tool;
import ie.ucc.cccc.viz.Tools;
import ie.ucc.cccc.viz.Tree;
import ie.ucc.cccc.viz.VisualState;
import ie.ucc.cccc.viz.Visualizer;
import ie.ucc.cccc.viz.VizArgument;
import ie.ucc.cccc.viz.VizCollection;
import ie.ucc.cccc.viz.VizDVar;
import ie.ucc.cccc.viz.VizFailed;
import ie.ucc.cccc.viz.VizFocus;
import ie.ucc.cccc.viz.VizInteger;
import ie.ucc.cccc.viz.VizParent;
import ie.ucc.cccc.viz.VizParentStack;
import ie.ucc.cccc.viz.VizTuple;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Viz {
    private static Tools tools;
    private static PrintWriter idx;
    private static Tree tree;
    private static int countInvariant;

    public static void main(String[] stringArray) throws SAXException, IOException, ParserConfigurationException {
        if (stringArray.length != 3) {
            System.out.println("Usage: viz configfile treefile vizfile");
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.println(stringArray[i]);
            }
            return;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        Viz.runViz(string, string2, string3);
    }

    public static void runViz(String string, String string2, String string3) throws SAXException, IOException, ParserConfigurationException {
        Iterator<Tool> iterator;
        countInvariant = 0;
        System.out.println("Running: viz " + string + " " + string2 + " " + string3);
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        ConfigHandler configHandler = new ConfigHandler();
        sAXParser.parse(new File(string), (DefaultHandler)configHandler);
        System.out.println(string + " contains " + configHandler.numNodes + " nodes ");
        tools = configHandler.getTools();
        SAXParserFactory sAXParserFactory2 = SAXParserFactory.newInstance();
        SAXParser sAXParser2 = sAXParserFactory2.newSAXParser();
        TreeHandler treeHandler = new TreeHandler();
        try {
            sAXParser2.parse(new File(string2), (DefaultHandler)treeHandler);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("Caught " + illegalArgumentException);
        }
        System.out.println(string2 + " contains " + treeHandler.numNodes + " nodes ");
        tree = treeHandler.tree;
        try {
            iterator = new File(tools.getDirectory(), tools.getIdx() + ".idx");
            idx = new PrintWriter(new FileWriter((File)((Object)iterator)));
        }
        catch (IOException iOException) {
            System.out.println("Can not create idx file");
        }
        if (tools.hasVizTools()) {
            iterator = SAXParserFactory.newInstance();
            SAXParser object = ((SAXParserFactory)((Object)iterator)).newSAXParser();
            VizHandler vizHandler = new VizHandler();
            object.parse(new File(string3), (DefaultHandler)vizHandler);
            System.out.println(string3 + " contains " + vizHandler.numNodes + " nodes ");
        }
        idx.close();
        for (Tool tool : tools.getTreeTools()) {
            tool.handleTree(tree);
        }
        if (countInvariant > 0) {
            System.out.println("There were " + countInvariant + " Invariant violations.");
        }
    }

    static String getAttribute(String string, Attributes attributes) {
        return Viz.getAttribute(string, attributes, null);
    }

    static String getAttribute(String string, Attributes attributes, String string2) {
        String string3 = attributes.getValue(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    static int getInteger(String string, Attributes attributes) {
        return Viz.getInteger(string, attributes, 0);
    }

    static int getInteger(String string, Attributes attributes, int n) {
        String string2 = attributes.getValue(string);
        if (string2 == null) {
            return n;
        }
        return Integer.parseInt(string2);
    }

    static void markTreeNode(InvariantType invariantType, int n) {
        ++countInvariant;
        Node node = tree.getMap().get(n);
        if (node != null) {
            node.setInvariantType(invariantType);
        }
    }

    private static class VizHandler
    extends DefaultHandler {
        private int numNodes = 0;
        private State state = null;
        private VisualState visualState = null;
        private Map<Integer, Visualizer> visualizerMap = new HashMap<Integer, Visualizer>();
        private Box box = new Box(0, 0, 1, 1);
        private VizParentStack stack;
        private StateStack stateStack = new StateStack();

        private VizHandler() {
        }

        @Override
        public void startDocument() {
            this.stack = new VizParentStack();
            System.out.println("Started Viz Document");
        }

        @Override
        public void endDocument() {
            System.out.println("End Viz Document");
        }

        @Override
        public void processingInstruction(String string, String string2) {
            System.out.println("Process target" + string + " data " + string2);
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) {
            ++this.numNodes;
            if (string3.equals("visualization")) {
                this.stateStack.push(new State(0, -1, null));
            } else if (string3.equals("state")) {
                int n = this.getTreeNode(attributes);
                int n2 = tree.findParent(n);
                while (((State)this.stateStack.peek()).getTreeNode() != n2) {
                    this.stateStack.pop();
                }
                this.state = new State(this.getId(attributes), n, (State)this.stateStack.peek());
                this.stateStack.push(this.state);
            } else if (string3.equals("visualizer_state")) {
                this.visualState = new VisualState(this.getVisualizer(attributes), this.state);
                this.stack.push(this.visualState);
                this.state.addVisualizerState(this.visualState);
            } else if (string3.equals("visualizer")) {
                int n = this.getId(attributes);
                Visualizer visualizer = new Visualizer(n, this.getType(attributes), this.getDisplay(attributes), this.getX(attributes), this.getY(attributes), this.getWidth(attributes), this.getHeight(attributes), this.getGroup(attributes), this.getMin(attributes), this.getMax(attributes), this.getIndexStart(attributes));
                this.box.expandBox(visualizer.getBox());
                this.visualizerMap.put(n, visualizer);
            } else if (string3.equals("dvar")) {
                ((VizParent)this.stack.peek()).add(new VizDVar(this.getIndex(attributes), this.getDomain(attributes)));
            } else if (string3.equals("integer")) {
                ((VizParent)this.stack.peek()).add(new VizInteger(this.getIndex(attributes), this.getValue(attributes)));
            } else if (string3.equals("focus")) {
                assert (this.stack.peek() == this.visualState);
                this.visualState.focus(new VizFocus(this.getIndex(attributes), this.getGroup(attributes), this.getType(attributes)));
            } else if (string3.equals("failed")) {
                assert (this.stack.peek() == this.visualState);
                this.visualState.failed(new VizFailed(this.getIndex(attributes), this.getGroup(attributes), this.getValue(attributes)));
            } else if (string3.equals("tuple")) {
                VizTuple vizTuple = new VizTuple(this.getIndex(attributes));
                ((VizParent)this.stack.peek()).add(vizTuple);
                this.stack.push(vizTuple);
            } else if (string3.equals("collection")) {
                VizCollection vizCollection = new VizCollection(this.getIndex(attributes));
                ((VizParent)this.stack.peek()).add(vizCollection);
                this.stack.push(vizCollection);
            } else if (string3.equals("argument")) {
                VizArgument vizArgument = new VizArgument(this.getIndex(attributes));
                ((VizParent)this.stack.peek()).add(vizArgument);
                this.stack.push(vizArgument);
            } else {
                System.out.println("start:" + this.state.getId() + "  uri" + string + " local " + string2 + " qname " + string3);
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            if (string3.equals("state")) {
                String string4 = "tree";
                for (Tool tool : tools.getTreeTools()) {
                    string4 = tool.getFileroot();
                }
                for (Tool tool : tools.getVizTools()) {
                    tool.handleState(this.state, this.box);
                    idx.println(string4 + Math.max(0, this.state.getTreeNode()) + ".svg " + tool.getFileroot() + this.state.getId() + ".svg");
                }
                this.state = null;
            } else if (string3.equals("tuple")) {
                this.stack.pop();
            } else if (string3.equals("collection")) {
                this.stack.pop();
            } else if (string3.equals("argument")) {
                this.stack.pop();
            } else if (string3.equals("visualizer_state")) {
                this.stack.pop();
                this.visualState = null;
            } else if (string3.equals("visualizer")) {
                // empty if block
            }
        }

        private Visualizer getVisualizer(Attributes attributes) {
            return this.visualizerMap.get(this.getId(attributes));
        }

        private int getId(Attributes attributes) {
            return Viz.getInteger("id", attributes);
        }

        private int getTreeNode(Attributes attributes) {
            return Viz.getInteger("tree_node", attributes);
        }

        private String getIndex(Attributes attributes) {
            return Viz.getAttribute("index", attributes);
        }

        private int getValue(Attributes attributes) {
            return Viz.getInteger("value", attributes);
        }

        private int getX(Attributes attributes) {
            return Viz.getInteger("x", attributes);
        }

        private int getY(Attributes attributes) {
            return Viz.getInteger("y", attributes);
        }

        private int getWidth(Attributes attributes) {
            return Viz.getInteger("width", attributes);
        }

        private int getHeight(Attributes attributes) {
            return Viz.getInteger("height", attributes);
        }

        private int getMin(Attributes attributes) {
            return Viz.getInteger("min", attributes);
        }

        private int getMax(Attributes attributes) {
            return Viz.getInteger("max", attributes);
        }

        private String getDomain(Attributes attributes) {
            return Viz.getAttribute("domain", attributes);
        }

        private String getGroup(Attributes attributes) {
            return Viz.getAttribute("group", attributes, "0");
        }

        private String getType(Attributes attributes) {
            return Viz.getAttribute("type", attributes);
        }

        private String getDisplay(Attributes attributes) {
            return Viz.getAttribute("display", attributes);
        }

        private int getIndexStart(Attributes attributes) {
            return Viz.getInteger("indexstart", attributes, 1);
        }
    }

    private static class TreeHandler
    extends DefaultHandler {
        private Tree tree;
        private int numNodes = 0;

        private TreeHandler() {
        }

        private int getId(Attributes attributes) {
            return Viz.getInteger("id", attributes);
        }

        private int getParent(Attributes attributes) {
            return Viz.getInteger("parent", attributes);
        }

        private String getName(Attributes attributes) {
            return Viz.getAttribute("name", attributes);
        }

        private String getChoice(Attributes attributes) {
            return Viz.getAttribute("choice", attributes);
        }

        private int getSize(Attributes attributes) {
            return Viz.getInteger("size", attributes);
        }

        private int getValue(Attributes attributes) {
            return Viz.getInteger("value", attributes);
        }

        private String getVersion(Attributes attributes) {
            return Viz.getAttribute("version", attributes);
        }

        @Override
        public void startDocument() {
            this.tree = new Tree();
            System.out.println("Started Tree Document");
        }

        @Override
        public void endDocument() {
            this.tree.buildParentLists();
            System.out.println("End Tree Document");
        }

        @Override
        public void processingInstruction(String string, String string2) {
            System.out.println("Process target" + string + " data " + string2);
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if (this.numNodes % 10000 == 0 && this.numNodes > 0) {
                System.out.println(this.numNodes);
            }
            if (this.numNodes > 2000000) {
                ++this.numNodes;
                this.tree.buildParentLists();
                System.out.println("End Tree Document");
                throw new IllegalArgumentException("too long");
            }
            if (string3.equals("tree")) {
                String string4 = this.getVersion(attributes);
                if (!string4.equals("1.0")) {
                    System.out.println("Wrong version " + string4);
                }
            } else if (string3.equals("root")) {
                int n = this.getId(attributes);
                this.tree.addNode(NodeType.ROOT, n);
                ++this.numNodes;
            } else if (string3.equals("succ")) {
                int n = this.getId(attributes);
                this.tree.markSucc(n);
            } else {
                int n = this.getId(attributes);
                int n2 = this.getParent(attributes);
                String string5 = this.getName(attributes);
                int n3 = this.getSize(attributes);
                if (string3.equals("try")) {
                    int n4 = this.getValue(attributes);
                    NodeType nodeType = NodeType.TRY;
                    this.tree.addNode(nodeType, n, n2, string5, n3, n4);
                } else if (string3.equals("fail")) {
                    int n5 = this.getValue(attributes);
                    NodeType nodeType = NodeType.FAIL;
                    this.tree.addNode(nodeType, n, n2, string5, n3, n5);
                } else if (string3.equals("tryc")) {
                    String string6 = this.getChoice(attributes);
                    NodeType nodeType = NodeType.TRYC;
                    this.tree.addNode(nodeType, n, n2, string5, n3, string6);
                } else if (string3.equals("failc")) {
                    String string7 = this.getChoice(attributes);
                    NodeType nodeType = NodeType.FAILC;
                    this.tree.addNode(nodeType, n, n2, string5, n3, string7);
                } else {
                    System.out.println("Wrong node type >" + string3 + "<");
                    NodeType nodeType = NodeType.FAIL;
                }
                ++this.numNodes;
            }
        }
    }

    private static class ConfigHandler
    extends DefaultHandler {
        private Tools tools = new Tools();
        private int numNodes = 0;

        private ConfigHandler() {
        }

        private Tools getTools() {
            return this.tools;
        }

        private String getShow(Attributes attributes) {
            return Viz.getAttribute("show", attributes, "tree");
        }

        private String getType(Attributes attributes) {
            return Viz.getAttribute("type", attributes, "layout");
        }

        private String getDisplay(Attributes attributes) {
            return Viz.getAttribute("display", attributes, "compact");
        }

        private String getRepeat(Attributes attributes) {
            return Viz.getAttribute("repeat", attributes, "final");
        }

        private int getWidth(Attributes attributes) {
            return Viz.getInteger("width", attributes, 500);
        }

        private int getHeight(Attributes attributes) {
            return Viz.getInteger("height", attributes, 500);
        }

        private String getDirectory(Attributes attributes) {
            return Viz.getAttribute("directory", attributes, "TREE");
        }

        private String getIdx(Attributes attributes) {
            return Viz.getAttribute("idx", attributes, "aaa");
        }

        private String getFileRoot(Attributes attributes) {
            return Viz.getAttribute("fileroot", attributes, "tree");
        }

        private String getVersion(Attributes attributes) {
            return Viz.getAttribute("version", attributes);
        }

        @Override
        public void startDocument() {
            System.out.println("Started Config Document");
        }

        @Override
        public void endDocument() {
            System.out.println("End Document");
        }

        @Override
        public void processingInstruction(String string, String string2) {
            System.out.println("Process target" + string + " data " + string2);
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if (string3.equals("configuration")) {
                String string4 = this.getVersion(attributes);
                this.tools.setDirectory(this.getDirectory(attributes));
                this.tools.setIdx(this.getIdx(attributes));
                if (!string4.equals("1.0")) {
                    System.out.println("Wrong version " + string4);
                }
            } else if (string3.equals("tool")) {
                ++this.numNodes;
                this.tools.addTool(new Tool(this.tools, this.getShow(attributes), this.getType(attributes), this.getDisplay(attributes), this.getRepeat(attributes), this.getWidth(attributes), this.getHeight(attributes), this.getFileRoot(attributes)));
            } else {
                System.out.println("Wrong Element Structure " + string3);
                ++this.numNodes;
            }
        }
    }
}

