/*
 * Decompiled with CFR 0.152.
 */
package att.grappa;

import att.grappa.GrappaColor;
import att.grappa.GrappaConstants;
import att.grappa.GrappaSupport;
import att.grappa.GrappaSupportPrintf;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.util.HashMap;

public class GrappaStyle
implements GrappaConstants,
Cloneable {
    private int elementType;
    public static final String DEFAULT_SET_STRING = "__default__";
    public static final int STYLE_SOLID = 0;
    public static final int STYLE_DASHED = 1;
    public static final int STYLE_DOTTED = 2;
    public static final int STYLE_DASH = 3;
    public static final int STYLE_DASH_PHASE = 4;
    public static final int STYLE_LINE_WIDTH = 5;
    public static final int STYLE_LINE_COLOR = 6;
    public static final int STYLE_FILLED = 7;
    public static final int STYLE_DIAGONALS = 8;
    public static final int STYLE_ROUNDED = 9;
    public static final int STYLE_CAP_BUTT = 10;
    public static final int STYLE_CAP_ROUND = 11;
    public static final int STYLE_CAP_SQUARE = 12;
    public static final int STYLE_JOIN_BEVEL = 13;
    public static final int STYLE_JOIN_MITER = 14;
    public static final int STYLE_JOIN_ROUND = 15;
    public static final int STYLE_MITER_LIMIT = 16;
    public static final int STYLE_FIXED_SIZE = 17;
    public static final int STYLE_INVIS = 18;
    public static final int STYLE_OLD_BOLD = 100;
    public static final int STYLE_OLD_ITALIC = 101;
    public static final int STYLE_OLD_PLAIN = 102;
    public static final Color STYLE_LINE_COLOR_DEFAULT = GrappaColor.getColor("black", null);
    public static final int STYLE_LINE_STYLE_DEFAULT = 0;
    public static final float STYLE_LINE_WIDTH_DEFAULT = 1.0f;
    public static final int STYLE_CAP_DEFAULT = 0;
    public static final int STYLE_JOIN_DEFAULT = 2;
    public static final float STYLE_MITER_LIMIT_DEFAULT = 0.0f;
    public static final float[] STYLE_DASH_DEFAULT = null;
    public static final float STYLE_DASH_PHASE_DEFAULT = 0.0f;
    public static final boolean STYLE_ROUNDED_DEFAULT = false;
    public static final boolean STYLE_DIAGONALS_DEFAULT = false;
    public static final boolean STYLE_FILLED_DEFAULT = false;
    public static final boolean STYLE_INVIS_DEFAULT = false;
    public static final boolean STYLE_FIXED_SIZE_DEFAULT = false;
    static BasicStroke defaultStroke = new BasicStroke(1.0f, 0, 2, 0.0f, STYLE_DASH_DEFAULT, 0.0f);
    static String defaultStrokeString = GrappaStyle.generateStrokeString(1.0f, 0, 2, 0.0f, STYLE_DASH_DEFAULT, 0.0f);
    private static HashMap<String, Integer> styleTypes = new HashMap(20);
    private static HashMap<String, Stroke> strokeCache = new HashMap(4);
    Color line_color = STYLE_LINE_COLOR_DEFAULT;
    int line_style = 0;
    float line_width = 1.0f;
    int cap = 0;
    int join = 2;
    float miter_limit = 0.0f;
    float[] dash = STYLE_DASH_DEFAULT;
    float dash_phase = 0.0f;
    boolean rounded = false;
    boolean diagonals = false;
    boolean filled = false;
    boolean invis = false;
    boolean fixed_size = false;
    Integer font_style = null;
    BasicStroke stroke = defaultStroke;

    public GrappaStyle(int type, String style) {
        if ((type & 0xF) != type) {
            throw new RuntimeException("type must specify node, edge or subgraph");
        }
        this.elementType = type;
        this.updateStyle(style);
    }

    public void updateStyle(String style) {
        this.stroke = defaultStroke;
        this.line_color = STYLE_LINE_COLOR_DEFAULT;
        this.line_style = 0;
        this.line_width = 1.0f;
        this.cap = 0;
        this.join = 2;
        this.miter_limit = 0.0f;
        this.dash = STYLE_DASH_DEFAULT;
        this.dash_phase = 0.0f;
        this.rounded = false;
        this.diagonals = false;
        this.filled = false;
        this.invis = false;
        this.fixed_size = false;
        this.font_style = null;
        if (style == null) {
            return;
        }
        int len = style.length();
        if (len == 0 || style.equals(DEFAULT_SET_STRING)) {
            return;
        }
        String option_string = null;
        Integer option_obj = null;
        int option = -1;
        int last_option = -1;
        boolean in_parens = false;
        boolean keyword_ok = true;
        boolean parens_ok = false;
        int i = 0;
        int offset = 0;
        while (i < len) {
            char c;
            if (Character.isWhitespace(c = style.charAt(i++))) continue;
            if (c == '(') {
                if (in_parens) {
                    throw new RuntimeException("style attribute has nested parentheses");
                }
                if (!parens_ok) {
                    throw new RuntimeException("style attribute has parentheses without keyword");
                }
                if (last_option < 0) {
                    throw new RuntimeException("style attribute (" + option_string + ") has unexpected modifier");
                }
                in_parens = true;
                keyword_ok = true;
                parens_ok = false;
                continue;
            }
            if (c == ')') {
                if (!in_parens) {
                    throw new RuntimeException("style attribute has unmatched right parenthesis");
                }
                in_parens = false;
                keyword_ok = false;
                parens_ok = false;
                continue;
            }
            if (c == ',') {
                if (in_parens) {
                    throw new RuntimeException("style attribute has comma within parentheses");
                }
                keyword_ok = true;
                parens_ok = false;
                continue;
            }
            if (!keyword_ok) {
                throw new RuntimeException("style attribute (" + option_string + ") has bad format");
            }
            offset = i - 1;
            if (in_parens) {
                int pcnt = 0;
                while (i < len && ((c = style.charAt(i)) != ')' || pcnt > 0)) {
                    if (c == '(') {
                        ++pcnt;
                    } else if (c == ')') {
                        --pcnt;
                    }
                    ++i;
                }
            } else {
                while (i < len && (c = style.charAt(i)) != ',' && c != ' ' && c != '(' && c != ')') {
                    ++i;
                }
            }
            option_string = style.substring(offset, i);
            if (in_parens) {
                if (last_option == -1) {
                    throw new RuntimeException("style attribute modifier (" + option_string + ") is unexpected");
                }
                switch (last_option) {
                    case 3: {
                        this.line_style = last_option;
                        try {
                            this.dash = GrappaSupport.floatArrayForTuple(option_string);
                            break;
                        }
                        catch (NumberFormatException nfe) {
                            throw new RuntimeException("dash style attribute modifier (" + option_string + ") is not a comma-delimited floating point tuple");
                        }
                    }
                    case 4: {
                        try {
                            this.dash_phase = Float.valueOf(option_string).floatValue();
                            break;
                        }
                        catch (NumberFormatException nfe) {
                            throw new RuntimeException("dash phase style attribute modifier (" + option_string + ") is not a floating point number");
                        }
                    }
                    case 5: {
                        try {
                            this.line_width = Float.valueOf(option_string).floatValue();
                            break;
                        }
                        catch (NumberFormatException nfe) {
                            throw new RuntimeException("line width style attribute modifier (" + option_string + ") is not a floating point number");
                        }
                    }
                    case 16: {
                        try {
                            this.miter_limit = Float.valueOf(option_string).floatValue();
                            break;
                        }
                        catch (NumberFormatException nfe) {
                            throw new RuntimeException("miter limit style attribute modifier (" + option_string + ") is not a floating point number");
                        }
                    }
                    case 6: {
                        this.line_color = GrappaColor.getColor(option_string, null);
                        break;
                    }
                    case 7: {
                        this.filled = Boolean.valueOf(option_string);
                        break;
                    }
                    case 18: {
                        this.invis = Boolean.valueOf(option_string);
                        break;
                    }
                    case 8: {
                        this.diagonals = Boolean.valueOf(option_string);
                        break;
                    }
                    case 9: {
                        this.rounded = Boolean.valueOf(option_string);
                        break;
                    }
                    case 17: {
                        this.fixed_size = Boolean.valueOf(option_string);
                        break;
                    }
                    default: {
                        throw new RuntimeException("style attribute (" + option_string + ") has bad format");
                    }
                }
                last_option = -1;
                continue;
            }
            option_obj = styleTypes.get(option_string.toLowerCase());
            if (DEFAULT_SET_STRING.equals(option_string)) continue;
            if (option_obj == null || !(option_obj instanceof Integer)) {
                throw new RuntimeException("style attribute (" + option_string + ") is unrecognized or badly implemented");
            }
            option = option_obj;
            last_option = -1;
            switch (option) {
                case 0: {
                    this.line_style = option;
                    this.dash = null;
                    this.dash_phase = 0.0f;
                    break;
                }
                case 1: {
                    this.line_style = option;
                    this.dash = new float[]{12.0f, 12.0f};
                    this.dash_phase = 0.0f;
                    break;
                }
                case 2: {
                    this.line_style = option;
                    this.dash = new float[]{2.0f, 2.0f};
                    this.dash_phase = 0.0f;
                    break;
                }
                case 7: {
                    last_option = option;
                    this.filled = true;
                    break;
                }
                case 18: {
                    last_option = option;
                    this.invis = true;
                    break;
                }
                case 8: {
                    last_option = option;
                    this.diagonals = true;
                    break;
                }
                case 9: {
                    last_option = option;
                    this.rounded = true;
                    break;
                }
                case 10: {
                    this.cap = 0;
                    break;
                }
                case 11: {
                    this.cap = 1;
                    break;
                }
                case 12: {
                    this.cap = 2;
                    break;
                }
                case 13: {
                    this.cap = 2;
                    break;
                }
                case 14: {
                    this.cap = 0;
                    break;
                }
                case 15: {
                    this.cap = 1;
                    break;
                }
                case 17: {
                    last_option = option;
                    this.fixed_size = true;
                    break;
                }
                case 100: {
                    this.font_style = new Integer(1);
                    break;
                }
                case 101: {
                    this.font_style = new Integer(2);
                    break;
                }
                case 102: {
                    this.font_style = new Integer(0);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 16: {
                    last_option = option;
                    break;
                }
                default: {
                    throw new RuntimeException("style attribute (" + option_string + ") has bad format");
                }
            }
            if (last_option == -1) continue;
            parens_ok = true;
        }
        if (in_parens) {
            throw new RuntimeException("style attribute has unmatched left parenthesis");
        }
        String strokeString = GrappaStyle.generateStrokeString(this.line_width, this.cap, this.join, this.miter_limit, this.dash, this.dash_phase);
        this.stroke = (BasicStroke)strokeCache.get(strokeString);
        if (this.stroke == null) {
            this.stroke = new BasicStroke(this.line_width, this.cap, this.join, this.miter_limit, this.dash, this.dash_phase);
            strokeCache.put(strokeString, this.stroke);
        }
    }

    private static String generateStrokeString(float lineWidth, int capType, int joinType, float miterLimit, float[] dashSpec, float dashPhase) {
        StringBuilder strokeStringBuffer = new StringBuilder();
        strokeStringBuffer.append(lineWidth);
        strokeStringBuffer.append(',');
        strokeStringBuffer.append(capType);
        strokeStringBuffer.append(',');
        strokeStringBuffer.append(joinType);
        strokeStringBuffer.append(',');
        strokeStringBuffer.append(miterLimit);
        strokeStringBuffer.append(',');
        if (dashSpec == null) {
            strokeStringBuffer.append("null");
        } else {
            strokeStringBuffer.append('{');
            strokeStringBuffer.append(dashSpec[0]);
            for (int i = 1; i < dashSpec.length; ++i) {
                strokeStringBuffer.append(',');
                strokeStringBuffer.append(dashSpec[i]);
            }
            strokeStringBuffer.append('}');
        }
        strokeStringBuffer.append(',');
        strokeStringBuffer.append(dashPhase);
        return strokeStringBuffer.toString();
    }

    public String toAttributeString() {
        return GrappaStyle.generateStyleString(this.line_color, this.line_style, this.line_width, this.cap, this.join, this.miter_limit, this.dash, this.dash_phase, this.rounded, this.diagonals, this.filled, this.invis, this.fixed_size, this.font_style, false, this.elementType);
    }

    public String toString() {
        return GrappaStyle.generateStyleString(this.line_color, this.line_style, this.line_width, this.cap, this.join, this.miter_limit, this.dash, this.dash_phase, this.rounded, this.diagonals, this.filled, this.invis, this.fixed_size, this.font_style, true, this.elementType);
    }

    private static String generateStyleString(Color color, int lineStyle, float lineWidth, int capType, int joinType, float miterLimit, float[] dashSpec, float dashPhase, boolean roundedFlag, boolean diagonalsFlag, boolean filledFlag, boolean invisFlag, boolean fixedSizeFlag, Integer fontStyle, boolean showAll, int type) {
        StringBuilder styleStringBuffer = null;
        String tmpstr = null;
        Object[] args = new Object[]{"%g", null};
        if (showAll || color != STYLE_LINE_COLOR_DEFAULT && STYLE_LINE_COLOR_DEFAULT != null && !STYLE_LINE_COLOR_DEFAULT.equals(color)) {
            if (styleStringBuffer == null) {
                styleStringBuffer = new StringBuilder();
            } else {
                styleStringBuffer.append(',');
            }
            styleStringBuffer.append("lineColor(");
            tmpstr = GrappaColor.getColorName(color);
            if (tmpstr == null) {
                float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
                styleStringBuffer.append(GrappaSupportPrintf.sprintf(new Object[]{"%g,%g,%g", new Float(hsb[0]), new Float(hsb[1]), new Float(hsb[2])}));
            } else {
                styleStringBuffer.append(tmpstr);
            }
            styleStringBuffer.append(')');
        }
        if (showAll || lineStyle != 0) {
            if (styleStringBuffer == null) {
                styleStringBuffer = new StringBuilder();
            } else {
                styleStringBuffer.append(',');
            }
            switch (lineStyle) {
                case 0: {
                    styleStringBuffer.append("solid");
                    break;
                }
                case 1: {
                    styleStringBuffer.append("dashed");
                    break;
                }
                case 2: {
                    styleStringBuffer.append("dotted");
                    break;
                }
                case 3: {
                    if (dashSpec == null) {
                        styleStringBuffer.append("solid");
                        break;
                    }
                    styleStringBuffer.append("dash(");
                    args[1] = new Float(dashSpec[0]);
                    styleStringBuffer.append(GrappaSupportPrintf.sprintf(args));
                    for (int i = 1; i < dashSpec.length; ++i) {
                        styleStringBuffer.append(',');
                        args[1] = new Float(dashSpec[i]);
                        styleStringBuffer.append(GrappaSupportPrintf.sprintf(args));
                    }
                    styleStringBuffer.append(')');
                    break;
                }
                default: {
                    throw new InternalError("unexpected lineStyle (" + lineStyle + ")");
                }
            }
        }
        if (showAll || lineWidth != 1.0f) {
            if (styleStringBuffer == null) {
                styleStringBuffer = new StringBuilder();
            } else {
                styleStringBuffer.append(',');
            }
            styleStringBuffer.append("lineWidth(");
            args[1] = new Float(lineWidth);
            styleStringBuffer.append(GrappaSupportPrintf.sprintf(args));
            styleStringBuffer.append(')');
        }
        if (showAll || capType != 0) {
            if (styleStringBuffer == null) {
                styleStringBuffer = new StringBuilder();
            } else {
                styleStringBuffer.append(',');
            }
            switch (capType) {
                case 0: {
                    styleStringBuffer.append("capButt");
                    break;
                }
                case 1: {
                    styleStringBuffer.append("capRound");
                    break;
                }
                case 2: {
                    styleStringBuffer.append("capSquare");
                    break;
                }
                default: {
                    throw new InternalError("unexpected cap type (" + capType + ")");
                }
            }
        }
        if (showAll || joinType != 2) {
            if (styleStringBuffer == null) {
                styleStringBuffer = new StringBuilder();
            } else {
                styleStringBuffer.append(',');
            }
            switch (joinType) {
                case 2: {
                    styleStringBuffer.append("joinBevel");
                    break;
                }
                case 0: {
                    styleStringBuffer.append("joinMiter");
                    break;
                }
                case 1: {
                    styleStringBuffer.append("joinRound");
                    break;
                }
                default: {
                    throw new InternalError("unexpected join type (" + joinType + ")");
                }
            }
        }
        if (showAll || miterLimit != 0.0f) {
            if (styleStringBuffer == null) {
                styleStringBuffer = new StringBuilder();
            } else {
                styleStringBuffer.append(',');
            }
            styleStringBuffer.append("miterLimit(");
            args[1] = new Float(miterLimit);
            styleStringBuffer.append(GrappaSupportPrintf.sprintf(args));
            styleStringBuffer.append(')');
        }
        if (showAll || dashPhase != 0.0f) {
            if (styleStringBuffer == null) {
                styleStringBuffer = new StringBuilder();
            } else {
                styleStringBuffer.append(',');
            }
            styleStringBuffer.append("dashPhase(");
            args[1] = new Float(dashPhase);
            styleStringBuffer.append(GrappaSupportPrintf.sprintf(args));
            styleStringBuffer.append(')');
        }
        if (type > 0 && (type & 1) == 1 && (showAll || roundedFlag)) {
            if (styleStringBuffer == null) {
                styleStringBuffer = new StringBuilder();
            } else {
                styleStringBuffer.append(',');
            }
            if (roundedFlag) {
                styleStringBuffer.append("rounded");
            } else {
                styleStringBuffer.append("rounded(false)");
            }
        }
        if (type > 0 && (type & 1) == 1 && (showAll || diagonalsFlag)) {
            if (styleStringBuffer == null) {
                styleStringBuffer = new StringBuilder();
            } else {
                styleStringBuffer.append(',');
            }
            if (diagonalsFlag) {
                styleStringBuffer.append("diagonals");
            } else {
                styleStringBuffer.append("diagonals(false)");
            }
        }
        if (type > 0 && (type & 5) != 0 && (showAll || filledFlag)) {
            if (styleStringBuffer == null) {
                styleStringBuffer = new StringBuilder();
            } else {
                styleStringBuffer.append(',');
            }
            if (filledFlag) {
                styleStringBuffer.append("filled");
            } else {
                styleStringBuffer.append("filled(false)");
            }
        }
        if (type > 0 && (type & 7) != 0 && (showAll || invisFlag)) {
            if (styleStringBuffer == null) {
                styleStringBuffer = new StringBuilder();
            } else {
                styleStringBuffer.append(',');
            }
            if (invisFlag) {
                styleStringBuffer.append("invis");
            } else {
                styleStringBuffer.append("invis(false)");
            }
        }
        if (showAll || fixedSizeFlag) {
            if (styleStringBuffer == null) {
                styleStringBuffer = new StringBuilder();
            } else {
                styleStringBuffer.append(',');
            }
            if (fixedSizeFlag) {
                styleStringBuffer.append("fixedSize");
            } else {
                styleStringBuffer.append("fixedSize(false)");
            }
        }
        if (fontStyle != null) {
            if (styleStringBuffer == null) {
                styleStringBuffer = new StringBuilder();
            } else {
                styleStringBuffer.append(',');
            }
            if (fontStyle == 1) {
                styleStringBuffer.append("bold");
            } else if (fontStyle == 2) {
                styleStringBuffer.append("italic");
            } else {
                styleStringBuffer.append("plain");
            }
        }
        tmpstr = styleStringBuffer == null ? "" : styleStringBuffer.toString();
        return tmpstr;
    }

    public Color getLineColor() {
        return this.line_color;
    }

    public int getLineStyle() {
        return this.line_style;
    }

    public float getLineWidth() {
        return this.line_width;
    }

    public int getCapStyle() {
        return this.cap;
    }

    public int getJoinStyle() {
        return this.join;
    }

    public float getMiterLimit() {
        return this.miter_limit;
    }

    public float[] getDash() {
        if (this.dash == null) {
            return null;
        }
        return (float[])this.dash.clone();
    }

    public float getDashPhase() {
        return this.dash_phase;
    }

    public boolean getRounded() {
        return this.rounded;
    }

    public boolean getDiagonals() {
        return this.diagonals;
    }

    public boolean getFilled() {
        return this.filled;
    }

    public boolean getInvis() {
        return this.invis;
    }

    public boolean getFixedSize() {
        return this.fixed_size;
    }

    public int getFontStyle() {
        if (this.font_style == null) {
            return 0;
        }
        return this.font_style;
    }

    public Object clone() {
        try {
            GrappaStyle copy = (GrappaStyle)super.clone();
            copy.dash = this.getDash();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    static {
        styleTypes.put("solid", new Integer(0));
        styleTypes.put("dashed", new Integer(1));
        styleTypes.put("dotted", new Integer(2));
        styleTypes.put("dash", new Integer(3));
        styleTypes.put("dashphase", new Integer(4));
        styleTypes.put("dash_phase", new Integer(4));
        styleTypes.put("width", new Integer(5));
        styleTypes.put("linewidth", new Integer(5));
        styleTypes.put("line_width", new Integer(5));
        styleTypes.put("setlinewidth", new Integer(5));
        styleTypes.put("color", new Integer(6));
        styleTypes.put("linecolor", new Integer(6));
        styleTypes.put("line_color", new Integer(6));
        styleTypes.put("filled", new Integer(7));
        styleTypes.put("invis", new Integer(18));
        styleTypes.put("diagonals", new Integer(8));
        styleTypes.put("rounded", new Integer(9));
        styleTypes.put("capbutt", new Integer(10));
        styleTypes.put("cap_butt", new Integer(10));
        styleTypes.put("capround", new Integer(11));
        styleTypes.put("cap_round", new Integer(11));
        styleTypes.put("capsquare", new Integer(12));
        styleTypes.put("cap_square", new Integer(12));
        styleTypes.put("joinbevel", new Integer(13));
        styleTypes.put("join_bevel", new Integer(13));
        styleTypes.put("joinmiter", new Integer(14));
        styleTypes.put("join_miter", new Integer(14));
        styleTypes.put("joinround", new Integer(15));
        styleTypes.put("join_round", new Integer(15));
        styleTypes.put("miterlimit", new Integer(16));
        styleTypes.put("miter_limit", new Integer(16));
        styleTypes.put("fixedsize", new Integer(17));
        styleTypes.put("fixed_size", new Integer(17));
        styleTypes.put("bold", new Integer(100));
        styleTypes.put("italic", new Integer(101));
        styleTypes.put("normal", new Integer(102));
        styleTypes.put("plain", new Integer(102));
        strokeCache.put(defaultStrokeString, defaultStroke);
    }
}

