/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse;

import com.parctechnologies.eclipse.EclipseConnectionImpl;
import com.parctechnologies.eclipse.QueueListener;
import java.io.IOException;
import java.io.OutputStream;

public class ToEclipseQueue
extends OutputStream {
    private String name;
    private int id;
    private EclipseConnectionImpl eclipse;
    private QueueListener listener = null;
    private boolean isClosed = false;
    private boolean systemQueue = false;

    ToEclipseQueue(int n, String string, EclipseConnectionImpl eclipseConnectionImpl) {
        this.eclipse = eclipseConnectionImpl;
        this.id = n;
        this.name = string;
    }

    int getID() {
        return this.id;
    }

    boolean isSystemQueue() {
        return this.systemQueue;
    }

    void setSystemQueue(boolean bl) {
        this.systemQueue = bl;
    }

    @Override
    public void write(int n) throws IOException {
        this.testClosed();
        this.eclipse.writeByteToStream(this.id, (byte)n);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.testClosed();
        this.eclipse.writeToStream(this.id, byArray, n, n2);
    }

    public void setListener(QueueListener queueListener) throws IOException {
        this.testClosed();
        this.listener = queueListener;
    }

    public void removeListener() throws IOException {
        this.testClosed();
        this.listener = null;
    }

    void notifyRequest() {
        if (this.listener != null) {
            this.listener.dataRequest(this);
        }
    }

    @Override
    public void flush() throws IOException {
        this.testClosed();
        this.eclipse.flushStream(this.id);
    }

    @Override
    public void close() throws IOException {
        this.testClosed();
        this.close_cleanup();
        this.eclipse.closeToEclipseStreamEclipseSide(this.id);
        this.eclipse.closeToEclipseStreamJavaSide(this.id);
    }

    void close_cleanup() {
        try {
            this.removeListener();
        }
        catch (IOException iOException) {
            System.err.println("Error: removal of listener threw an IOException.");
            System.err.flush();
        }
        this.isClosed = true;
    }

    private void testClosed() throws IOException {
        if (this.isClosed) {
            throw new IOException("Operation not possible: stream closed.");
        }
    }
}

