/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import java.awt.Component;
import java.awt.Label;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;

class RectQuadTree {
    private RectQuadTree[] child;
    private int type;
    private static final int NONEMPTY_LEAF = 0;
    private static final int EMPTY_LEAF = 1;
    private static final int INTERIOR = 2;
    private static final int DEFAULT_MIN_SIDE = 20;
    private Collection intersectingComponents;
    private Rectangle bounds;
    private int maxDepth;

    private RectQuadTree(Rectangle rectangle, int n) {
        this.bounds = rectangle;
        this.maxDepth = n;
        this.type = 1;
    }

    private static int depthGivenBounds(Rectangle rectangle) {
        int n = Math.min(rectangle.width, rectangle.height);
        int n2 = (int)(Math.log((double)n / 20.0) / Math.log(2.0)) - 1;
        return n2;
    }

    public RectQuadTree(Rectangle rectangle) {
        this(rectangle, RectQuadTree.depthGivenBounds(rectangle));
    }

    public void addComponent(Component component) {
        this.addComponent(component, component.getBounds());
    }

    public void removeComponent(Component component) {
        this.removeComponent(component, component.getBounds());
    }

    public Collection getComponentsWithin(Rectangle rectangle) {
        HashSet hashSet = new HashSet();
        this.addIntersectingComponentsWithin(rectangle, hashSet);
        return hashSet;
    }

    private void addComponent(Component component, Rectangle rectangle) {
        if (this.type == 1) {
            if (this.maxDepth == 0 || rectangle.contains(this.bounds)) {
                this.type = 0;
                this.initialiseIntersectingComponents();
                this.intersectingComponents.add(component);
            } else {
                this.type = 2;
                this.initialiseChild();
                this.addComponent(component, rectangle);
            }
            return;
        }
        if (this.type == 0) {
            if (this.maxDepth == 0 || rectangle.contains(this.bounds)) {
                this.intersectingComponents.add(component);
            } else {
                this.type = 2;
                this.initialiseChild();
                for (int i = 0; i < this.child.length; ++i) {
                    this.child[i].type = 0;
                    this.child[i].initialiseIntersectingComponents();
                    this.child[i].intersectingComponents.addAll(this.intersectingComponents);
                }
                this.intersectingComponents = null;
                this.addComponent(component, rectangle);
            }
            return;
        }
        if (this.type == 2) {
            for (int i = 0; i < this.child.length; ++i) {
                if (!rectangle.intersects(this.child[i].bounds)) continue;
                this.child[i].addComponent(component, rectangle);
            }
        }
    }

    private void addIntersectingComponents(Collection collection) {
        if (this.type == 1) {
            return;
        }
        if (this.type == 0) {
            collection.addAll(this.intersectingComponents);
            return;
        }
        if (this.type == 2) {
            for (int i = 0; i < this.child.length; ++i) {
                this.child[i].addIntersectingComponents(collection);
            }
        }
    }

    private void addIntersectingComponentsWithin(Rectangle rectangle, Collection collection) {
        if (this.type == 1) {
            return;
        }
        if (this.type == 0) {
            for (Component component : this.intersectingComponents) {
                if (!component.getBounds().intersects(rectangle)) continue;
                collection.add(component);
            }
        }
        if (this.type == 2) {
            for (int i = 0; i < this.child.length; ++i) {
                if (rectangle.contains(this.child[i].bounds)) {
                    this.child[i].addIntersectingComponents(collection);
                    continue;
                }
                if (!rectangle.intersects(this.child[i].bounds)) continue;
                this.child[i].addIntersectingComponentsWithin(rectangle, collection);
            }
        }
    }

    private void removeComponent(Component component, Rectangle rectangle) {
        if (this.type == 1) {
            return;
        }
        if (this.type == 0) {
            this.intersectingComponents.remove(component);
            if (this.intersectingComponents.isEmpty()) {
                this.intersectingComponents = null;
                this.type = 1;
            }
            return;
        }
        if (this.type == 2) {
            int n;
            int n2 = 0;
            int n3 = 0;
            for (n = 0; n < this.child.length; ++n) {
                if (rectangle.intersects(this.child[n].bounds)) {
                    this.child[n].removeComponent(component, rectangle);
                }
                if (this.child[n].type == 1) {
                    ++n2;
                    continue;
                }
                if (this.child[n].type != 0) continue;
                ++n3;
            }
            if (n2 == this.child.length) {
                this.type = 1;
                this.child = null;
                return;
            }
            if (n3 == this.child.length && this.child[0].intersectingComponents.equals(this.child[1].intersectingComponents) && this.child[1].intersectingComponents.equals(this.child[2].intersectingComponents) && this.child[2].intersectingComponents.equals(this.child[3].intersectingComponents)) {
                n = 1;
                Iterator iterator = this.child[0].intersectingComponents.iterator();
                while (iterator.hasNext() && n != 0) {
                    Component component2 = (Component)iterator.next();
                    if (component2.getBounds().contains(this.bounds)) continue;
                    n = 0;
                }
                if (n != 0) {
                    this.type = 0;
                    this.intersectingComponents = this.child[0].intersectingComponents;
                    this.child = null;
                }
            }
        }
    }

    private void initialiseChild() {
        this.child = new RectQuadTree[4];
        int n = this.bounds.width / 2;
        int n2 = this.bounds.width - n;
        int n3 = this.bounds.height / 2;
        int n4 = this.bounds.height - n3;
        int n5 = this.maxDepth - 1;
        this.child[0] = new RectQuadTree(new Rectangle(this.bounds.x, this.bounds.y, n, n3), n5);
        this.child[1] = new RectQuadTree(new Rectangle(this.bounds.x + n, this.bounds.y, n2, n3), n5);
        this.child[2] = new RectQuadTree(new Rectangle(this.bounds.x, this.bounds.y + n3, n, n4), n5);
        this.child[3] = new RectQuadTree(new Rectangle(this.bounds.x + n, this.bounds.y + n3, n2, n4), n5);
    }

    private void initialiseIntersectingComponents() {
        this.intersectingComponents = new HashSet();
    }

    private static void test() {
        int n;
        int n2;
        int n3;
        int n4 = 7;
        int n5 = 50;
        int n6 = 25;
        int n7 = 2000;
        int n8 = 2000;
        int n9 = 2000;
        Random random = new Random(1L);
        Component[] componentArray = new Component[n5];
        RectQuadTree rectQuadTree = new RectQuadTree(new Rectangle(0, 0, n8, n9), n4);
        for (n3 = 0; n3 < n5; ++n3) {
            componentArray[n3] = new Label("");
            n2 = random.nextInt(n8 / 2);
            n = random.nextInt(n9 / 2);
            componentArray[n3].setBounds(random.nextInt(n8 - n2), random.nextInt(n9 - n), n2, n);
            rectQuadTree.addComponent(componentArray[n3]);
            System.out.println("added component to rqt with bounds " + String.valueOf(componentArray[n3].getBounds()));
        }
        System.out.println("Tests for 20 x 20: " + RectQuadTree.tests(rectQuadTree, n7, componentArray, 20, 20));
        System.out.println("Tests for 20 x 500: " + RectQuadTree.tests(rectQuadTree, n7, componentArray, 20, 500));
        System.out.println("Tests for 500 x 20: " + RectQuadTree.tests(rectQuadTree, n7, componentArray, 500, 20));
        System.out.println("Tests for 500 x 500: " + RectQuadTree.tests(rectQuadTree, n7, componentArray, 500, 500));
        for (n3 = 0; n3 < n6; ++n3) {
            int n10 = random.nextInt(n5);
            rectQuadTree.removeComponent(componentArray[n10]);
            n2 = random.nextInt(n8 / 2);
            n = random.nextInt(n9 / 2);
            componentArray[n10] = new Label("");
            componentArray[n10].setBounds(random.nextInt(n8 - n2), random.nextInt(n9 - n), n2, n);
            rectQuadTree.addComponent(componentArray[n10]);
            System.out.println("replaced component : new one has bounds " + String.valueOf(componentArray[n10].getBounds()));
        }
        System.out.println("Post-replacement tests for 20 x 20: " + RectQuadTree.tests(rectQuadTree, n7, componentArray, 20, 20));
        System.out.println("Post-replacement tests for 20 x 500: " + RectQuadTree.tests(rectQuadTree, n7, componentArray, 20, 500));
        System.out.println("Post-replacement tests for 500 x 20: " + RectQuadTree.tests(rectQuadTree, n7, componentArray, 500, 20));
        System.out.println("Post-replacement tests for 500 x 500: " + RectQuadTree.tests(rectQuadTree, n7, componentArray, 500, 500));
    }

    private static boolean tests(RectQuadTree rectQuadTree, int n, Component[] componentArray, int n2, int n3) {
        Random random = new Random(2L);
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            Rectangle rectangle = new Rectangle(random.nextInt(rectQuadTree.bounds.width - n2), random.nextInt(rectQuadTree.bounds.height - n3), n2, n3);
            if (RectQuadTree.test(rectQuadTree, rectangle, componentArray)) continue;
            System.out.println("test failed for testRect = " + String.valueOf(rectangle));
            bl = false;
        }
        return bl;
    }

    private static boolean test(RectQuadTree rectQuadTree, Rectangle rectangle, Component[] componentArray) {
        Collection collection = rectQuadTree.getComponentsWithin(rectangle);
        HashSet<Component> hashSet = new HashSet<Component>();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!componentArray[i].getBounds().intersects(rectangle)) continue;
            hashSet.add(componentArray[i]);
        }
        return collection.equals(hashSet);
    }
}

