
// Number of context handled by the driver and DSP
// -----------------------------------------------
#define MAX_CONTEXT     2

// Global typedef
//***************

typedef PDWORD   HANDLE_PIPE, * PHANDLE_PIPE;


// BoardType definitions
// CAUTION: the boards definition of this file must be the same as
//          the boards definition in file pcxdef.h
//

#define UNKNOWN_BOARD                   PCX_NO_PRESENT

#define LXES_BOARD                      LXES
#define LX6464ES_BOARD                  LX6464ES


// Values for the PORT_INFO structure
// ----------------------------------
// piClockType field
// INDEPENDANT_CLOCK must be 0 because it is the reset value
#define INDEPENDANT_CLOCK   0
#define SLAVE_CLOCK         1
#define MASTER_CLOCK        2

// Global typedef
// **************


// Shared defines
//****************
//#define UER_PROFESSIONAL_MODE   1
//#define UER_CONSUMER_MODE       2

// Shared typedef
//***************

typedef struct _DRIVER_INFO {
    BYTE            drRelease;
    BYTE            drNver;
    BYTE            drTver;
    BYTE            drBver;

#define RESET_GAIN_MUTE     0
#define RESET_GAIN_NO       1       
#define RESET_GAIN_0DBFS    2
#define RESET_GAIN_LCMV1    3   // reset gains so as to simulate LCM V1

    BYTE            drDoNotCheckForVersionState;
    BOOLEAN         drResetAnalogLevelsAction;
    BYTE            drUnused[2];
    LPSTR           drPath;
} DRIVER_INFO, *PDRIVER_INFO, FAR *LPDRIVER_INFO;

typedef LPDRIVER_INFO   *DRIVER_INFO_HANDLE;


typedef struct  _DSP_INFO {
    BYTE    dsEtat;
    BYTE    dsZero1;
    WORD    dsFatalError;
    DWORD   dsDspVersion;	/**<firmware version 0x00MMmmbb. Update needed if MM or mm do not match the driver.*/
    DWORD   dsMaskIndexAppli;
	// assuming only one DSP 
	WORD	dsManagedPhysicalOutputNumber;	/**<count of outputs managed by the card (one CPU).*/
	WORD	dsManagedPhysicalInputNumber;	/**<count of inputs managed by the card (one CPU).*/
    WORD	dsManagedVirtualOutputNumber;
    WORD	dsManagedVirtualInputNumber;
    DWORDLONG	dsMaskVPOut;
    DWORDLONG	dsMaskVVOut;
    DWORDLONG	dsMaskVPIn;
    DWORDLONG	dsMaskVVIn;
    BYTE    dsMaxBoardOutStream;
    BYTE    dsMaxPipeOutStream;
    DWORDLONG   dsContextMaskOutPipes[MAX_CONTEXT];
    DWORD   dsContextID[MAX_CONTEXT];

} DSP_INFO, *PDSP_INFO;

// FH modification 12/02/97
// ciAmmccPort, ciDspPort and cixiPort were moved to
// PORT_INFO structure

typedef struct _BOARD_FILES_INFO {
	char* bfiBoardName;
    WORD bfiBoard ;
    WORD bfiCSID ;
    char* bfiEePromName ;
    char* bfiBootName ;
    char* bfiXilinx1Name;
    char* bfiXilinx2Name;
    char* bfiDefaultDspName ;
} BOARD_FILES_INFO, *PBOARD_FILES_INFO ;  


typedef struct  _BOARD_INFO
{
    PBYTE               portMEM;
    PBYTE               portPLX;
    PBYTE               portDSP;
    DWORD               portMEMsize;
    DWORD               portPLXsize;
    DWORD               portDSPsize;
    BYTE                biCarac;        // Indicates whether the other fields are relevant.
    BYTE                biType;         // Family of the board. ( group boards with same behaviour )
    BYTE                biTypeNoAlias;  // Type of the board. ( exact board )
    BYTE                biFlavor;       // Flavor of the board. ( handle variants ) 
    WORD                biCSID;         // We don't have to deal with CSID ( PCI specific )
    WORD                biUnused1;
    DWORD               biNumIrq;

    DSP_INFO            biTbDspInfo[MAX_BOARD_DSP];
    
    PBOARD_FILES_INFO   bipFiles;       // refered to by IOCOmmands

#define biBoardName         bipFiles->bfiBoardName

    DWORDLONG           biPipeClockMask[2];

    // Gives the index of the application that wants to be notified of events.
    WORD                biGpioAppliIndex;
    BYTE                biUnused3;
    // Indicates the a GPIO event occurred and that the application didn't read yet.
    BOOLEAN             biGpioEvent;
    // Mask for the Input GPIO's that have to be notified
    DWORD               biGpioNotifyMask;
    // Last Value notified of Input GPIO
    DWORD               biGpioNotifyLastRead;
    // Fifo for Input of GPIO
    DWORD               biGpioFifo[GPIO_NP2_FIFO_SIZE];
    WORD                biGpioFifoReadIndex;
    WORD                biGpioFifoWriteIndex;

} BOARD_INFO, *PBOARD_INFO, FAR *LPBOARD_INFO;

typedef LPBOARD_INFO    *BOARD_INFO_HANDLE;

// Values for biCarac field of BOARD_INFO record.
//
#define CARAC_FREE    0  // Must be equal to zero because must correspond
                         // to a BZERO operation.
#define CARAC_GHOST   1  // The board is no more managed but its features can still
                         // be used for clean up operations.
#define CARAC_USED    2

#define CARAC_HELD    3

#define NO_MASK_PIPE_OUT 0
#define NO_MASK_PIPE_IN  1


// Mask for all the boards
//
#define ALL_BOARDS      0x000000FF      // MAX_BOARD (8) boards


// Values for DRIVER_TRACE_REQ_INFO.driRequest
//
#define REQUEST_NULL                   0
#define REQUEST_DRIVER_INFO            1
#define REQUEST_GENERAL_INFO           2
#define REQUEST_PORT_INFO              3
#define REQUEST_REG_IMAGE_INFO         4
#define REQUEST_BOARD_REGISTER_SET     5
#define REQUEST_BOARD_INFO             6
#define REQUEST_BOARD_LEVEL_INFO       7
#define REQUEST_APPLI_INFO             8
#define REQUEST_VOIE_INFO              9
#define REQUEST_PIPE_INFO              10
#define REQUEST_STREAM_INFO            11
#define REQUEST_GEN_BUFFER_INFO        12
#define REQUEST_BUFFER_INFO            13
#define REQUEST_PHYS_MAP_INFO          14
#define REQUEST_FORCE                  15

// Bit values in AppliInfo Carac field
// ------------------------------------
#define AI_ALLOCATED_MASK        0x01
#define AI_PRIVATE_ATTRIB_MASK   0x02
#define AI_DHS_ATTRIB_MASK       0x04


typedef struct  _APPLI_INFO {
    BYTE            Carac;
    BYTE            Reserved[7];
    LPDWORD         AdrBlkReq;
    LPDWORD         AdrBlkReqBoardPnp;
    LPDWORD         AdrBlkReqGpio;
    APP_STR_INFO    TbNomAppli;
    DWORD           WindowHandle;
    DWORD           WindowMessage;
    WORD            Error;
} APPLI_INFO, *PAPPLI_INFO;

typedef struct _VOIE_INFO {
    BYTE    Nat;            // 0: physical, 1: virtual audio
    BYTE    IndexAppli;     // 1-based 
    BYTE    AppAudioNum;    // 0-based audio index [0 to 1 on the pipe]
    BYTE    NumPipe;        // 0-based index of the Pipe Info Structure (below)
    WORD    AudioNum;       // 0-based DSP audio index [0 to 7 on 882]
} VOIE_INFO, *PVOIE_INFO;

typedef struct _PIPE__INFO {
    BYTE                    piNumPipeForDsp;
    BYTE                    piNumBoard;
    BYTE                    piNbAudio;
    BYTE                    piNbMaxFlux;
    DWORD                   piStreamMask;
    DWORDLONG               piPhysAudioMask;
    DWORDLONG               piPipeAudioMask;
    LPBC_HEADER_INFO        piAdrBlkReq;
    LPWAIT_NOTIFY_REQ_INFO  piAdrNotifyReq;         // ## FS (25/04/1997) --
    HANDLE_PIPE             piVioHandle;
    BOOLEAN                 piConversionEnded;      // ## FS (04/03/1997) --
    BOOLEAN                 piPendingNotify;        // ## FS (25/04/1997) --
    BOOLEAN                 piNotifiedNotReadYet;   // ## FS (16/04/1998) --
    BOOLEAN                 piResetAnaLevelsAction; 
    HANDLE_BUFFER           piHandleBuffers;
    DWORD                   piClockBoardNum;
    DWORD                   piFrequency;
    DWORD                   piSyncInputNum;
    DWORDLONG               piPipeInClockMask;
    DWORDLONG               piPipeOutClockMask;
    BYTE                    piClockSource;
    BOOLEAN                 piPipeIsOffline;        // ## MBR (12/03/2002) --
    WORD                    piError;
    DWORDLONG               piErrorPipe;
    DWORD                   piErrorStream;
	PVOID                   piParentIchWave;
} PIPE__INFO, *PPIPE__INFO;


/**
*   LEVEL_INFO
*/
typedef struct LEVEL_INFO
{
    LONG liMinReal;                   /**< min real value */
    LONG liMinCoded;                  /**< min coded value */
    LONG liMaxCoded;                  /**< max coded value */
} LEVEL_INFO, *PLEVEL_INFO;

/**
*   BOARD_LEVEL__INFO
*/
typedef struct BOARD_LEVEL__INFO
{
    LEVEL_INFO bliInputLevel;         /**< Input  levels of the board */
    LEVEL_INFO bliOutputLevel;        /**< Output levels of the board */
} BOARD_LEVEL__INFO, *PBOARD_LEVEL__INFO;


#define SI_MAX_STREAM_BUFFER	8

typedef struct  _STREAM_INFO {

    LPBC_HEADER_INFO    siAdrBuffer;
    LPBC_HEADER_INFO    siAdrNextBufferToGive;
    LONG                siReleasedBuffers;
    BOOLEAN             siAPINP;			// a APINP stream (uses its own buffer pool)
    BYTE                siUnused1[3];       // fill up to multiple of 4 Bytes
    struct _STREAM_INFO *siAdrNextStream;

    // FS - 06/03/1997 - make a double-chain used by Sound Transfer
    // ************************************************************
    struct _STREAM_INFO *siAdrPreviousStream;
    WORD			siFirstAudioNum;		// number of first board audio ( valid after pipe allocation)
    BOOLEAN 		siFirstAudioValid;		// number of first board audio may be zero, only first stream get this number
    BYTE			siUnused;				// fill up to multiple of 4 Bytes
	DWORD			siBufferAddr2Index[SI_MAX_STREAM_BUFFER];
    DWORD           siPCMSampleSize;
} STREAM_INFO, *PSTREAM_INFO;


typedef struct _GEN_BUFFER_INFO {
    DWORD   gbBuffTotalNb;          // Total number of buffers
    DWORD   gbBuffAvailNb;          // Remaining buffers available
    DWORD   gbBuffSize;             // Size of a buffer (bytes)
    DWORD   gbBigBuffNb;            // Number of special big buffers (ASIO)
    DWORD   gbBigBuffSize;          // Size of a big buffer (bytes)
} GEN_BUFFER_INFO, * PGEN_BUFFER_INFO, FAR *LPGEN_BUFFER_INFO;

typedef LPGEN_BUFFER_INFO   *GEN_BUFFER_INFO_HANDLE;

typedef struct  _BUFFER_INFO {
    BYTE    biCarac;        // 1: buffer available, 0: no buffer or reserved one
    BYTE    Padding[3];
    PVOID   biAddress1;

} BUFFER_INFO, *PBUFFER_INFO, FAR *LPBUFFER_INFO;

typedef LPBUFFER_INFO   *BUFFER_INFO_HANDLE;


#ifdef __STDC__
  #define _CDECL_
#else
  #define _CDECL_ _cdecl
#endif


// We must retain the physical address of buffers
// and whether they are mapped or not in a user space
// --------------------------------------------------
typedef struct _PHYS_MAP_INFO_
{
    PHYSICAL_ADDRESS    pmPhysAddr  ;   // the physical address of the buffer
    BOOLEAN             pmIsMapped  ;   // Is buffer mapped in a user space ?
    BOOLEAN             pmIsReserved;   // Is buffer reserved by a process ?
    HANDLE              pmProcess   ;   // The process where the buffer is mapped into
    DWORD               pmSize      ;   // size of buffer
    PVOID               pmVirtAddr  ;   // the mapped virtual address
} PHYS_MAP_INFO, *PPHYS_MAP_INFO ;

