// *************************************************************************
//
//  COPYRIGHT 1996-1998 DIGIGRAM. ALL RIGHTS RESERVED.
//
//  DIGIGRAM
//
// **************************************************************************
//
//  AH_ASYN.C
//
//  Project:                :   PCX***_E Driver
//
//  File description        :   part of API_HDL.C (code of async. functions)
//
//  Author                  :   Frdric Huv / FS
//
//  Creation date           :   07/08/96
//  Last modification date  :   16/04/98
//
// **************************************************************************
//
//  API_HDL.C is splitted into 4 subparts. This file contains the code and
// only the code of the asynchronous commands of the driver.
//
// **************************************************************************

// Local functions
// ****************

// *************************************************************************
//
// STATIC VOID SignalAsyncProcessed( IN LPDWORD, IN PDWORD )
//
// Input Parameters:
// *****************
//
//  LPDWORD PmReply :   the reply block of the asynchronous command
//  PDWORD  PmIrp   :   corresponding Irp under WindowsNT
//
//
// *************************************************************************
//
//  For each audio of the pipe, resets levels to their default values
//
// *************************************************************************
STATIC VOID SignalAsyncProcessed(
    IN  LPDWORD PmReply ,
    IN  PDWORD  PmIrp   )
{
    ((LPRESP_HEADER_INFO) PmReply)->rhT = PROCESSED ;

  //{ OCT : The IRP might have been cancelled...
  //  ...in that case, we'd better not try to use it
  if( ((LPRESP_HEADER_INFO) PmReply)->rhCptr != ED_CANCELLED )
  {
    if ( PmIrp != NULL )
    {
        WNTSetEvent( PmIrp, STATUS_SUCCESS );
    }
    else
    {
        DOUT(DBG_ERROR, ("Async Event signaled - No IRP !!"));
    }
  }
  //} OCT
}


// *************************************************************************
//
// STATIC VOID InvalidCmd10( PmBlocRequete, PmBlocRetour, PmIrp )
//
// Input Parameters:
// *****************
//
//  LPDWORD PmBlocRequete : Asynchronous command request bloc
//  PDWORD  PmIrp         : corresponding IRP under WindowsNT, NULL otherwise
//
// Output Parameters:
// **************************
//
//  LPDWORD PmBlocRetour  : Asynchronous command response bloc
//
// *************************************************************************
//
//  Common entry points for an invalid or not implemented yet command
// within the family
//
// *************************************************************************
STATIC VOID InvalidCmd10(
    IN  LPDWORD PmBlocRequete   ,
    OUT LPDWORD PmBlocRetour    ,
    IN  PDWORD  PmIrp           )
{
    LPRESP_HEADER_INFO  LcLPResp;

    LcLPResp = (LPRESP_HEADER_INFO) PmBlocRetour ;
    LOAD_PCX_ERROR( LcLPResp->rhCptr, ED_INVALID_CMD_FAM10 );

    SignalAsyncProcessed( PmBlocRetour, PmIrp ) ;
}

// *************************************************************************
//
// STATIC VOID WaitErrorFct( PmBlocRequete, PmBlocRetour, PmIrp )
//
// Input Parameters:
// *****************
//
//  LPDWORD PmBlocRequete : Asynchronous command request bloc
//  PDWORD  PmIrp         : corresponding IRP under WindowsNT
//
// Output Parameters:
// **************************
//
//  LPDWORD PmBlocRetour  : Asynchronous command response bloc
//
// *************************************************************************
//
//  Process the Wait Error command.
//
// *************************************************************************
STATIC VOID WaitErrorFct(
    IN  LPDWORD PmBlocRequete   ,
    OUT LPDWORD PmBlocRetour    ,
    IN  PDWORD  PmIrp           )
{
    LPWAIT_ERROR_REQ_INFO    LcLPtrReq;
    LPBC_HEADER_INFO         LcLPtrReqHeader;
    LPWAIT_ERROR_RESP_INFO   LcLPtrRep;
    LPRESP_HEADER_INFO       LcLPtrRepHeader;
    BYTE                     LcAppIndex;

    // Initialisation of pointers
    LcLPtrReq = (LPWAIT_ERROR_REQ_INFO)PmBlocRequete;
    LcLPtrReqHeader = (LPBC_HEADER_INFO)PmBlocRequete;
    LcLPtrRep = (LPWAIT_ERROR_RESP_INFO)PmBlocRetour ;
    LcLPtrRepHeader = (LPRESP_HEADER_INFO)PmBlocRetour;

    LcAppIndex = DecodeHandle( LcLPtrReqHeader->hdHandle );

    LcLPtrRep->wepError         = TbAppliInfo[LcAppIndex].Error;
    LcLPtrRep->wepStreamMask    = 0;
    LcLPtrRep->wepInPipeMask64.QuadPart = 0;
    LcLPtrRep->wepOutPipeMask64.QuadPart = 0;

    // There is no error waiting at the application level.
    // ---------------------------------------------------
    if ( LcLPtrRep->wepError == SUCCESS )
    {
        WORD                        j;
        WORD                        k;
        PVOIE_INFO                  LcPtVoie;
        PPIPE_INFO                  LcPtPipe;
        BOOLEAN                     LcFin = FALSE;

        // ----------------------------------------------------------------
        // Verify if an error is waiting on a pipe owned by the application
        // ----------------------------------------------------------------

        // Search all the pipes owned by the application.
        // Loop on the output audios, then on the input audios.
        // ----------------------------------------------------
        for ( j = 0 ; ( LcFin == FALSE ) && ( j < 2 ) ; j++ )
        {
            if ( j == 0 ) {
                k         = MAX_DRV_OUTPIPE;
                LcPtPipe  = TbPipeOutInfo;
            } else {
                k         = MAX_DRV_INPIPE;
                LcPtPipe  = TbPipeInInfo;
            }

            for ( WORD LcNumPipe = 0 ; ( LcFin == FALSE ) && ( LcNumPipe < k ) ; LcNumPipe++ )
            {
                if( LcPtPipe[LcNumPipe].piNbAudio == 0)
                    continue;

                ASSERT( LcPtPipe[LcNumPipe].piNumBoard < MAX_BOARD );
                if( j == 0 ) {
                    ASSERT( LcPtPipe[LcNumPipe].piNumPipeForDsp < MAX_BOARD_OUTPUTS );
                    LcPtVoie = &TbVoieOutInfo[LcPtPipe[LcNumPipe].piNumBoard][LcPtPipe[LcNumPipe].piNumPipeForDsp];
                } else {
                    ASSERT( LcPtPipe[LcNumPipe].piNumPipeForDsp < MAX_BOARD_INPUTS );
                    LcPtVoie = &TbVoieInInfo[LcPtPipe[LcNumPipe].piNumBoard][LcPtPipe[LcNumPipe].piNumPipeForDsp];
                }

                // The current audio is owned by the application.
                // ----------------------------------------------

                // MBR (24/09/2004) : compare with (LcAppIndex + 1) and not LcAppIndex
                //
                if ( LcPtVoie->IndexAppli == (LcAppIndex + 1) )
                {
                    // There is an error on the pipe using this audio.
                    // -----------------------------------------------
                    if ( LcPtPipe[LcNumPipe].piError != SUCCESS )
                    {
                        LcLPtrRep->wepError         = LcPtPipe[LcNumPipe].piError;
                        LcLPtrRep->wepStreamMask    = LcPtPipe[LcNumPipe].piErrorStream;
                        if(j == 0) {    // OPER_PLAY
                            LcLPtrRep->wepInPipeMask64.QuadPart  = 0;
                            LcLPtrRep->wepOutPipeMask64.QuadPart = LcPtPipe[LcNumPipe].piErrorPipe;
                        } else {        // OPER_REC
                            LcLPtrRep->wepInPipeMask64.QuadPart  = LcPtPipe[LcNumPipe].piErrorPipe;
                            LcLPtrRep->wepOutPipeMask64.QuadPart = 0;
                        }
                        // Reset the error
                        // ----------------
                        LcPtPipe[LcNumPipe].piError        = SUCCESS;
                        LcPtPipe[LcNumPipe].piErrorStream  = 0;
                        LcPtPipe[LcNumPipe].piErrorPipe    = 0;

                        LcFin = TRUE;
                    }
                }
            }
        }
    }
    else
    // There is an error waiting at the application level.
    // ---------------------------------------------------
    {
        // Reset the error
        // ----------------
        TbAppliInfo[LcAppIndex].Error = SUCCESS ;
    }

    if ( LcLPtrRep->wepError != SUCCESS )
    {
        DOUT(DBG_PRINT, ("WaitErrorFct : Error found"));

        SignalAsyncProcessed( PmBlocRetour, PmIrp ) ;
    }
    else
    {
        // ***********************************
        // Memorize the Response block adresse
        // ***********************************
        (LcLPtrReq->weqForDriver).deeAdrBlkResp  = LcLPtrRepHeader  ;
        (LcLPtrReq->weqForDriver).deeIrp         = PmIrp ;

        TbAppliInfo[LcAppIndex].AdrBlkReq = (LPDWORD) LcLPtrReq ;

        DOUT(DBG_PRINT, ("WaitErrorFct : Error wait"));
    }

    // Fill Response bloc
    // *******************
    // ## FM (07/10/97) -- No more needed ? LcLPtrRepHeader->rhCptr = SUCCESS;
}


// *************************************************************************
//
// STATIC VOID WaitEndOfPlayFct( IN LPDWORD, IN LPDWORD, IN PDWORD )
//
// Input Parameters:
// *****************
//
//  LPDWORD PmBlocRequete : Asynchronous command request bloc
//  PDWORD  PmIrp         : corresponding IRP under WindowsNT
//
// Output Parameters:
// *****************
//
//  LPDWORD PmBlocRetour  : Asynchronous command response bloc
//
//
//Return value:
// ************
//
// *************************************************************************
//
//  Process the Wait End Of Play command.
//  Update the Wait End Of Play command response bloc.
//
// *************************************************************************
STATIC VOID WaitEndOfPlayFct(
    IN  LPDWORD     PmBlocRequete   ,
    OUT LPDWORD     PmBlocRetour    ,
    IN  PDWORD      PmIrp           )
{
    LPWAIT_ENDOF_PLAY_REQ_INFO    LcLPtrReq;
    LPBC_HEADER_INFO              LcLPtrReqHeader;
    LPRESP_HEADER_INFO            LcLPtrRepHeader;
    BYTE                          LcAppIndex;
    WORD                          LcNumPipe;
    WORD                          LcRet;
    TARGET_INFO                   LcTarget;
    BOOLEAN                       LcEndOfPlayRequested;
    PDSP_INFO                     LcPtDsp;
    PPIPE_INFO                    LcPipeInfPtr;
    PVOIE_INFO                    LcVoieInfPtr;
    WORD                          LcCurrentBoard;

    // Initialisation of pointers
    LcLPtrReq = (LPWAIT_ENDOF_PLAY_REQ_INFO)PmBlocRequete;
    LcLPtrReqHeader = (LPBC_HEADER_INFO)PmBlocRequete;
    LcLPtrRepHeader = (LPRESP_HEADER_INFO)PmBlocRetour;

    LcAppIndex = DecodeHandle( LcLPtrReqHeader->hdHandle );


    // Retrieve and verify pipe mask
    // --------------------------------
    LcRet = ChkPmOneOutputPipeMask(
                            LcAppIndex,
                            LcLPtrReq->wpqOutPipeMask64.QuadPart,
                            &LcNumPipe,
                            &LcPipeInfPtr,
                            &LcVoieInfPtr,
                            &LcTarget );

    if ( LcRet != SUCCESS )
    {
        LcLPtrRepHeader->rhCptr = LcRet ;
        SignalAsyncProcessed( PmBlocRetour, PmIrp );
        return ;
    }

    // ***********************************
    // Memorize the Response block adresse
    // ***********************************
    (LcLPtrReq->wpqForDriver).deeAdrBlkResp = LcLPtrRepHeader ;
    (LcLPtrReq->wpqForDriver).deeIrp        = PmIrp ;

    // Transfer remaining sound for this pipe
    // ---------------------------------------
    LcEndOfPlayRequested =     TRUE;
    LcPipeInfPtr->piAdrBlkReq = (LPBC_HEADER_INFO) LcLPtrReq;

    // FS - 17/11/96: driver stops talking to a dead DSP
    // --------------------------------------------------

	LcCurrentBoard = LcTarget.tgCarte;
    LcPtDsp = &APH_Board_Info_Array[LcCurrentBoard].biTbDspInfo[0];
    LcRet = LcPtDsp->dsFatalError;

    if ( LcRet != SUCCESS )
    {
        // DSP has crashed - give up this pipe
        // to avoid a driver stall
        // ------------------------------------
        APHKeepPipeError( &LcTarget, LcRet );
    }
    else
    {
        LcRet = CUR_PROTOCOL_PTR->IBuffer_TransferSoundPipe(   &LcTarget,
																LcEndOfPlayRequested,
																LcPipeInfPtr->piNbMaxFlux );
    }

    // Fill Response bloc
    // *******************
    LcLPtrRepHeader->rhCptr = LcRet;
    return;
}

// *************************************************************************
//
// STATIC VOID WaitEndOfRecordFct( IN LPDWORD, IN LPDWORD, IN PDWORD )
//
// Input Parameters:
// *****************
//
//  LPDWORD PmBlocRequete : Asynchronous command request bloc
//  PDWORD  PmIrp         : corresponding IRP under WindowsNT
//
// Output Parameters:
// *****************
//
//  LPDWORD PmBlocRetour  : Asynchronous command response bloc
//
// *************************************************************************
//
//  Process the Wait End Of Record command.
//  Update the Wait End Of Record command response bloc.
//
// *************************************************************************
//
// NB: only valid for offline conversion
//
// *************************************************************************
STATIC VOID WaitEndOfRecordFct(
    IN  LPDWORD     PmBlocRequete   ,
    OUT LPDWORD     PmBlocRetour    ,
    IN  PDWORD      PmIrp           )
{
    LPWAIT_ENDOF_RECORD_REQ_INFO    LcLPtrReq       ;
    LPBC_HEADER_INFO                LcLPtrReqHeader ;
    LPRESP_HEADER_INFO              LcLPtrRepHeader ;
    BYTE                            LcAppIndex      ;
    WORD                            LcRet           ;
    WORD                            LcPipeIndex     ;
    TARGET_INFO                     LcTarget        ;
    PDSP_INFO                       LcPtDsp         ;
    PPIPE_INFO                      LcPipeInfPtr    ;
    PVOIE_INFO                      LcVoieInfPtr    ;
    WORD                            LcCurrentBoard   ;

    // Initialisation of pointers
    LcLPtrReq = (LPWAIT_ENDOF_RECORD_REQ_INFO)PmBlocRequete;
    LcLPtrReqHeader = (LPBC_HEADER_INFO)PmBlocRequete;
    LcLPtrRepHeader = (LPRESP_HEADER_INFO)PmBlocRetour;

    LcAppIndex = DecodeHandle( LcLPtrReqHeader->hdHandle );



    // Retrieve and verify pipe mask
    // --------------------------------
    LcRet = ChkPmOneInputPipeMask(  LcAppIndex,
                                    LcLPtrReq->wrqInPipeMask64.QuadPart,
                                    &LcPipeIndex,
                                    &LcPipeInfPtr,
                                    &LcVoieInfPtr,
                                    &LcTarget );
	
	LcCurrentBoard = LcTarget.tgCarte;

    if ( LcRet != SUCCESS )
    {
        LcLPtrRepHeader->rhCptr = LcRet ;
        SignalAsyncProcessed( PmBlocRetour, PmIrp );
        return ;
    }

    // ***********************************
    // Memorize the Response block adresse
    // ***********************************
    (LcLPtrReq->wrqForDriver).deeAdrBlkResp = LcLPtrRepHeader ;
    (LcLPtrReq->wrqForDriver).deeIrp        = PmIrp ;

    // Transfer remaining sound for this pipe
    // ---------------------------------------
    LcPipeInfPtr->piAdrBlkReq = (LPBC_HEADER_INFO) LcLPtrReq;

    // FS - 17/11/96: driver stops talking to a dead DSP
    // --------------------------------------------------
    LcPtDsp = &APH_Board_Info_Array[LcCurrentBoard].biTbDspInfo[0];
    LcRet = LcPtDsp->dsFatalError;

    if ( LcRet != SUCCESS )
    {
        // DSP has crashed - give up this pipe
        // to avoid a driver stall
        // ------------------------------------
        APHKeepPipeError( &LcTarget, LcRet );
    }
    else
    {
        LcRet = CUR_PROTOCOL_PTR->IBuffer_TransferSoundPipe(	&LcTarget,
																FALSE,
																LcPipeInfPtr->piNbMaxFlux );

        if ( LcRet != SUCCESS )
        {
            APHKeepDspError( LcPtDsp, LcRet );
        }
    }

    // FS - 04/03/1997
    if ( LcPipeInfPtr->piConversionEnded )
    {
        LcPipeInfPtr->piAdrBlkReq = NULL;
        LcPipeInfPtr->piConversionEnded = FALSE ; // FS - 04/03/1997

        // Fill Response bloc
        // ******************
        LcLPtrRepHeader->rhCptr = SUCCESS;

        SignalAsyncProcessed(
                (LPDWORD) LcLPtrRepHeader                ,
                (PDWORD)  LcLPtrReq->wrqForDriver.deeIrp ) ;

    }
}

// *************************************************************************
//
// STATIC VOID WaitForNotificationFct( IN LPDWORD, IN LPDWORD, IN PDWORD )
//
// Input Parameters:
// *****************
//
//  LPDWORD PmBlocRequete : Asynchronous command request bloc
//  PDWORD  PmIrp         : corresponding IRP under WindowsNT
//
// Output Parameters:
// *****************
//
//  LPDWORD PmBlocRetour  : Asynchronous command response bloc
//
// *************************************************************************
//
//  Process the Wait "Notification of Differed Requests" command.
//
// *************************************************************************
STATIC VOID     WaitForNotificationFct(
    IN  LPDWORD     PmBlocRequete   ,
    OUT LPDWORD     PmBlocRetour    ,
    IN  PDWORD      PmIrp           )
{
    LPWAIT_NOTIFY_REQ_INFO  LcLPtrReq;
    LPBC_HEADER_INFO        LcLPtrReqHeader;
    LPRESP_HEADER_INFO      LcLPtrRespHeader;
    TARGET_INFO             LcTarget;
    PVOIE_INFO              LcVoieInfPtr;
    PPIPE_INFO              LcPipeInfPtr;
    BYTE                    LcAppIndex;
    WORD                    LcPipeIndex;
    WORD                    LcRet   = SUCCESS;

    // Initialisation of pointers
    LcLPtrReq       = (LPWAIT_NOTIFY_REQ_INFO)  PmBlocRequete;
    LcLPtrReqHeader = (LPBC_HEADER_INFO)        PmBlocRequete;
    LcLPtrRespHeader= (LPRESP_HEADER_INFO)      PmBlocRetour;

    LcLPtrRespHeader->rhSize = 0 ;

    LcAppIndex = DecodeHandle( LcLPtrReqHeader->hdHandle );


    LcRet = ChkPmOneInOrOutPipeMask(    LcAppIndex,
                                        LcLPtrReq->wnrOutPipeMask64.QuadPart,
                                        LcLPtrReq->wnrInPipeMask64.QuadPart,
                                        &LcPipeIndex,
                                        &LcPipeInfPtr,
                                        &LcVoieInfPtr,
                                        &LcTarget );

    if ( LcRet != SUCCESS )
    {
        LcLPtrRespHeader->rhCptr = LcRet ;
        SignalAsyncProcessed( PmBlocRetour, PmIrp );
        return ;
    }

    // Initialize the driver reserved area
    // of the request block
    // ------------------------------------
    (LcLPtrReq->wnrForDriver).deeAdrBlkResp = LcLPtrRespHeader ;
    (LcLPtrReq->wnrForDriver).deeIrp        = PmIrp ;

    // Check if a notification has been received yet
    // if so signal immediately, otherwise remember the
    // request and store the address of the request block
    // --------------------------------------------------
    if ( LcPipeInfPtr->piPendingNotify == TRUE )
    {
        // Update reply block
        // ------------------
        LcLPtrRespHeader->rhCptr = SUCCESS ;

        // ## FS (25/11/97) -- missing reinit of the pending flag
        // that cause missing further notifications
        // bug fix for FA#78
        // ------------------------------------------------------
        LcPipeInfPtr->piPendingNotify = FALSE ;

        SignalAsyncProcessed(
                (LPDWORD) LcLPtrRespHeader ,
                (PDWORD)  PmIrp            );

        // ## FS (16/04/1998) -- FA #152
        // A command has been notified but
        // no read has occured yet
        // --------------------------------
        LcPipeInfPtr->piNotifiedNotReadYet = TRUE ;

    }
    else
    {
        // Store the request
        LcPipeInfPtr->piAdrNotifyReq = LcLPtrReq ;
    }

    return;
}

// *************************************************************************
//
// STATIC VOID WaitBoardPnpFct( PmBlocRequete, PmBlocRetour, PmIrp )
//
// Input Parameters:
// *****************
//
//  LPDWORD PmBlocRequete : Asynchronous command request bloc
//  PDWORD  PmIrp         : corresponding IRP under WindowsNT
//
// Output Parameters:
// **************************
//
//  LPDWORD PmBlocRetour  : Asynchronous command response bloc
//
// *************************************************************************
//
//  Process the Wait Board Pnp command.
//
// *************************************************************************
STATIC VOID WaitBoardPnpFct(
    IN  LPDWORD PmBlocRequete   ,
    OUT LPDWORD PmBlocRetour    ,
    IN  PDWORD  PmIrp           )
{
    LPWAIT_BOARD_PNP_REQ_INFO  LcLPtrReq;
    LPBC_HEADER_INFO           LcLPtrReqHeader;
    LPWAIT_BOARD_PNP_RESP_INFO LcLPtrRep;
    LPRESP_HEADER_INFO         LcLPtrRepHeader;
    BYTE                       LcAppIndex;

    // Initialisation of pointers
    LcLPtrReq = (LPWAIT_BOARD_PNP_REQ_INFO)PmBlocRequete;
    LcLPtrReqHeader = (LPBC_HEADER_INFO)PmBlocRequete;
    LcLPtrRep = (LPWAIT_BOARD_PNP_RESP_INFO)PmBlocRetour ;
    LcLPtrRepHeader = (LPRESP_HEADER_INFO)PmBlocRetour;

    LcAppIndex = DecodeHandle( LcLPtrReqHeader->hdHandle );

    // ***********************************
    // Memorize the Response block adresse
    // ***********************************
    (LcLPtrReq->wpqForDriver).deeAdrBlkResp  = LcLPtrRepHeader  ;
    (LcLPtrReq->wpqForDriver).deeIrp         = PmIrp ;

    TbAppliInfo[LcAppIndex].AdrBlkReqBoardPnp  = (LPDWORD) LcLPtrReq ;

    DOUT(DBG_PRINT, ("WaitBoardPnpFct"));
}

// *************************************************************************
//
// STATIC VOID WaitGpioEventFct( PmBlocRequete, PmBlocRetour, PmIrp )
//
// Input Parameters:
// *****************
//
//  LPDWORD PmBlocRequete : Asynchronous command request bloc
//  PDWORD  PmIrp         : corresponding IRP under WindowsNT
//
// Output Parameters:
// **************************
//
//  LPDWORD PmBlocRetour  : Asynchronous command response bloc
//
// *************************************************************************
//
//  Process the Wait Gpio Event command.
//
// *************************************************************************
STATIC VOID WaitGpioEventFct(
    IN  LPDWORD PmBlocRequete   ,
    OUT LPDWORD PmBlocRetour    ,
    IN  PDWORD  PmIrp           )
{
    LPWAIT_GPIO_REQ_INFO     LcLPtrReq;
    LPBC_HEADER_INFO         LcLPtrReqHeader;
    LPWAIT_GPIO_RESP_INFO    LcLPtrRep;
    LPRESP_HEADER_INFO       LcLPtrRepHeader;
    BYTE                     LcAppIndex;
    PAPPLI_INFO              LcPtAppli;
    WORD                     i;

    // Initialisation of pointers
    LcLPtrReq = (LPWAIT_GPIO_REQ_INFO)PmBlocRequete;
    LcLPtrReqHeader = (LPBC_HEADER_INFO)PmBlocRequete;
    LcLPtrRep = (LPWAIT_GPIO_RESP_INFO)PmBlocRetour ;
    LcLPtrRepHeader = (LPRESP_HEADER_INFO)PmBlocRetour;

    LcAppIndex = DecodeHandle( LcLPtrReqHeader->hdHandle );
    LcPtAppli  = &(TbAppliInfo[LcAppIndex]) ;

    // ------------------------------------------------------------------
    // Search whether a GPIO event occured and has not yet been notified.
    // ------------------------------------------------------------------

    // Loop on all the boards
    //
    for ( i = 0 ; i < MAX_BOARD ; i++ )
    {
        // Theses GPIOs are managed by the application.
        //
        if ( APH_Board_Info_Array[i].biGpioAppliIndex == LcAppIndex )
        {
            // -------------------------------------------------
            // A GPIO event occurred on the current board
            // and has not yet been notified to the application.
            // -------------------------------------------------

            if ( APH_Board_Info_Array[i].biGpioEvent == TRUE )
            {
                // Retreive the event.
                APH_Board_Info_Array[i].biGpioEvent = FALSE;

                // Fill Response bloc
                // ******************
                (LcLPtrReq->wpqForDriver).deeAdrBlkResp  = LcLPtrRepHeader  ;
                (LcLPtrReq->wpqForDriver).deeIrp         = PmIrp ;
                LcLPtrRepHeader->rhCptr = SUCCESS ;
                LcLPtrRep->wgrBoardMask = UTIMaskWord( i ) ;

                // Terminate the Wait request
                // **************************
                SignalAsyncProcessed(
                        (LPDWORD) LcLPtrRepHeader                ,
                        (PDWORD)  LcLPtrReq->wpqForDriver.deeIrp ) ;

                return;
            }
        }
    }

    // ----------------------------------------
    // No GPIO event is waiting to be notified.
    // ----------------------------------------

    // ***********************************
    // Memorize the Response block adresse
    // ***********************************
    (LcLPtrReq->wpqForDriver).deeAdrBlkResp  = LcLPtrRepHeader  ;
    (LcLPtrReq->wpqForDriver).deeIrp         = PmIrp ;
    
    TbAppliInfo[LcAppIndex].AdrBlkReqGpio    = (LPDWORD) LcLPtrReq ;

    DOUT(DBG_PRINT, ("WaitGpioEventFct"));
}

// *************************************************************************
//                  PLAY - RECORD functions
// *************************************************************************

// *************************************************************************
//
// STATIC VOID InvalidCmd9( PmBlocRequete, PmBlocRetour, PmIrp )
//
// Input Parameters:
// *****************
//
//  LPDWORD PmBlocRequete : Play Record command request bloc
//  PDWORD  PmIrp         : corresponding IRP under WindowsNT, NULL otherwise
//
// Output Parameters:
// **************************
//
//  LPDWORD PmBlocRetour  : Play Record command response bloc
//
// *************************************************************************
//
//  Common entry points for an invalid or not implemented yet command
// within the family
//
// *************************************************************************
STATIC VOID InvalidCmd9(
    IN  LPDWORD PmBlocRequete   ,
    OUT LPDWORD PmBlocRetour    ,
    IN  PDWORD  PmIrp           )
{
    LPRESP_HEADER_INFO  LcLPResp;

    LcLPResp = (LPRESP_HEADER_INFO) PmBlocRetour ;
    LOAD_PCX_ERROR( LcLPResp->rhCptr, ED_INVALID_CMD_FAM9 );

    SignalAsyncProcessed( PmBlocRetour, PmIrp ) ;
}


// *************************************************************************
//                  PLAY subfunctions
// *************************************************************************

// *************************************************************************
//
// STATIC VOID PlayFct( IN LPDWORD, OUT LPDWORD, IN PDWORD )
//
// Input Paramaters:
// *****************
//
//  LPDWORD PmBlocRequete : Play command request bloc
//  PDWORD  PmIrp         : corresponding IRP under WindowsNT, NULL otherwise
//
// Output Parameters:
// ******************
//
//  LPDWORD PmBlocRetour  : Play command response bloc
//
// *************************************************************************
//
//  Process the play command.
//  Update the play command response bloc.
//
// *************************************************************************
STATIC VOID PlayFct(
    IN  LPDWORD PmBlocRequete   ,
    OUT LPDWORD PmBlocRetour    ,
    IN  PDWORD  PmIrp           )
{
    LPPLAY_REQ_INFO         LcLPtrReq;
    LPBC_HEADER_INFO        LcLPtrReqHeader;
    LPRESP_HEADER_INFO      LcLPtrRepHeader;
    TARGET_INFO             LcTargetInf;
    BYTE                    LcAppIndex;
    WORD                    LcNumStream;
    BYTE                    LcCurrentBoard;
    WORD                    LcRet;
    PPIPE_INFO              LcPipeInfPtr;
    PVOIE_INFO              LcVoieInfPtr;
    WORD                    LcPipeIndex;

    // Initialisation of pointers
    LcLPtrReq       = (LPPLAY_REQ_INFO) PmBlocRequete;
    LcLPtrReqHeader = (LPBC_HEADER_INFO) PmBlocRequete;
    LcLPtrRepHeader = (LPRESP_HEADER_INFO) PmBlocRetour;

    // $$ FM (11/09/1999) -- To fool the tools when buffer size is 12 Ko
    //                       (to be used for debugging purpose only)
    //
    if ( LcLPtrReq->plqDataLength == 0L ) {
        LcLPtrRepHeader->rhCptr = SUCCESS ;
        SignalAsyncProcessed( PmBlocRetour, PmIrp ) ;
        return ;
    }

    LcAppIndex = DecodeHandle( LcLPtrReqHeader->hdHandle );

    LcRet = ChkPmOneOutputPipeMask(
                LcAppIndex,
                LcLPtrReq->plqOutPipeMask64.QuadPart,
                &LcPipeIndex,
                &LcPipeInfPtr,
                &LcVoieInfPtr,
                &LcTargetInf );

    if ( LcRet != SUCCESS )
    {
        LcLPtrRepHeader->rhCptr = LcRet;
        SignalAsyncProcessed( PmBlocRetour, PmIrp ) ;
        return ;
    }

    // ************************************************
    // Memorize the Response block adresse
    // and other parameters for asynchronous processing
    // ************************************************
    (LcLPtrReq->plqForDriver).dprAdrBlkResp     = LcLPtrRepHeader ;
    (LcLPtrReq->plqForDriver).dprParent         = PmIrp ;
    (LcLPtrReq->plqForDriver).dprHandleBuffer   = LcPipeInfPtr->piHandleBuffers;

    // Seek the stream number
    LcNumStream = UTIDWMask2Word( LcLPtrReq->plqStreamMask );

    if ( LcNumStream >= LcPipeInfPtr->piNbMaxFlux )
    {
        LOAD_PCX_ERROR( LcLPtrRepHeader->rhCptr, ED_INVALID_STREAM );
        SignalAsyncProcessed( PmBlocRetour, PmIrp ) ;
        return ;
    }

    LcCurrentBoard = LcPipeInfPtr->piNumBoard;

    // Fill TARGET_INFO structure
    LcTargetInf.tgMaskFlux = UTIMaskDWord( LcNumStream );

    LcRet = CUR_PROTOCOL_PTR->IBuffer_GiveStreamBuffer(	&LcTargetInf,
														(LPBC_HEADER_INFO)LcLPtrReq,
														LcPipeInfPtr->piNbMaxFlux );

    if ( LcRet != SUCCESS )
    {
        LcLPtrRepHeader->rhCptr = LcRet;
        SignalAsyncProcessed( PmBlocRetour, PmIrp ) ;
    }
    else
    {
        TbOutStreamBytePos[LcPipeIndex][LcNumStream] += (PCX_TIME)LcLPtrReq->plqDataLength;
    }

    return;
}

// *************************************************************************
//
// STATIC VOID RecordFct( IN LPDWORD, OUT LPDWORD, IN PDWORD )
//
// Input Paramaters:
// *****************
//
//  LPDWORD PmBlocRequete : Record command request bloc
//  PDWORD  PmIrp         : corresponding IRP under WindowsNT, NULL otherwise
//
// Output Parameters:
// ******************
//
//  LPDWORD PmBlocRetour  : Record command response bloc
//
// *************************************************************************
//
//  Process the RecordStream command.
//  Update the RecordStream command response bloc.
//
// *************************************************************************
STATIC VOID RecordFct(
    IN  LPDWORD PmBlocRequete   ,
    OUT LPDWORD PmBlocRetour    ,
    IN  PDWORD  PmIrp           )
{
    TARGET_INFO             LcTargetInf;
    LPRECORD_REQ_INFO       LcLPtrReq;
    LPBC_HEADER_INFO        LcLPtrReqHeader;
    LPRESP_HEADER_INFO      LcLPtrRepHeader;
    PPIPE_INFO              LcPipeInfPtr;
    PVOIE_INFO              LcVoieInfPtr;
    DWORD                   LcBuffSize;
    WORD                    LcNumStream;
    WORD                    LcRet = ED_INVALID_PIPE;
    WORD                    LcPipeIndex;
    BYTE                    LcCurrentBoard;
    BYTE                    LcAppIndex;


    // Initialisation of pointers
    LcLPtrReq = (LPRECORD_REQ_INFO)PmBlocRequete;
    LcLPtrReqHeader = (LPBC_HEADER_INFO)PmBlocRequete;
    LcLPtrRepHeader = (LPRESP_HEADER_INFO)PmBlocRetour;

    LcAppIndex = DecodeHandle( LcLPtrReqHeader->hdHandle );

    LcRet = ChkPmOneInputPipeMask(  LcAppIndex,
                                    LcLPtrReq->rcqInPipeMask64.QuadPart,
                                    &LcPipeIndex,
                                    &LcPipeInfPtr,
                                    &LcVoieInfPtr,
                                    &LcTargetInf );
    if ( LcRet != SUCCESS )
    {
        LcLPtrRepHeader->rhCptr = LcRet;
        SignalAsyncProcessed( PmBlocRetour, PmIrp ) ;
        return ;
    }

    // max size tested in API
    //if ( LcLPtrReq->rcqDataLength > LcBuffSize )
    //{
    //    LOAD_PCX_ERROR( LcLPtrRepHeader->rhCptr, ED_INVALID_BUFFER );
    //    SignalAsyncProcessed( PmBlocRetour, PmIrp ) ;
    //    return ;
    //}

    if ( LcLPtrReq->rcqDataLength == 0L )
    {
        // Retrieve the buffer general information
        // ----------------------------------------
        BUFGetFeatures( NULL, NULL, &LcBuffSize );

        LcLPtrReq->rcqDataLength = LcBuffSize ;
    }

    // ************************************************
    // Memorize the Response block adresse
    // and other parameters for asynchronous processing
    // ************************************************
    (LcLPtrReq->rcqForDriver).dprAdrBlkResp     = LcLPtrRepHeader ;
    (LcLPtrReq->rcqForDriver).dprParent         = PmIrp ;
    (LcLPtrReq->rcqForDriver).dprHandleBuffer   = LcPipeInfPtr->piHandleBuffers;

    // Seek the stream number
    LcNumStream = UTIDWMask2Word( LcLPtrReq->rcqStreamMask );

    if ( LcNumStream >= LcPipeInfPtr->piNbMaxFlux )
    {
        LOAD_PCX_ERROR( LcLPtrRepHeader->rhCptr, ED_INVALID_STREAM );
        SignalAsyncProcessed( PmBlocRetour, PmIrp ) ;
        return ;
    }

    LcCurrentBoard = LcPipeInfPtr->piNumBoard;

    // Fill TARGET_INFO structure
    LcTargetInf.tgMaskFlux = UTIMaskDWord( LcNumStream );

    LcRet = CUR_PROTOCOL_PTR->IBuffer_GiveStreamBuffer(	&LcTargetInf,
														(LPBC_HEADER_INFO)LcLPtrReq,
														LcPipeInfPtr->piNbMaxFlux );

    if ( LcRet != SUCCESS )
    {
        LcLPtrRepHeader->rhCptr = LcRet;
        SignalAsyncProcessed( PmBlocRetour, PmIrp ) ;
    }

    return;
}


