// *************************************************************************
//
//  COPYRIGHT 1996-2000 DIGIGRAM. ALL RIGHTS RESERVED.
//
//  DIGIGRAM
//
// **************************************************************************
// **************************************************************************
//
//  API_HDL.C is splitted into 4 subparts. This file contains the code and
// only the code of the general commands of the driver.
//
// **************************************************************************

        {
        WORD  LcCurrentBoard = LcLPtrRequest->driParam1;
        WORD  LcOperation = LcLPtrRequest->driParam2;
        switch (LcOperation) {
            
        case SUBREQ_FORCE_RESYNCSSI : // -----------------  resync SSI -----------------------
            {
            ASSERT(CUR_PROTOCOL_PTR);
            LcRet = CUR_PROTOCOL_PTR->IClock_BoardModifyClock(	TRUE,       // Synchronize the FIFO
                                                                FALSE );    // Compute the frequency
            DbgPrint ("REQUEST_FORCE : Resync SSI = %lx\n" ,LcRet);
            } // 
            break;

        case SUBREQ_FORCE_CLEAR_DBG : // ---------------  clear debug area --------------
            {
            ASSERT(CUR_PROTOCOL_PTR);
            DWORD LcDummy;
            
            LcRet = CUR_PROTOCOL_PTR->IDiag_DSPTrace( 7, // clear debug area
                                                      0,
                                                      0,
                                                      &LcDummy,
                                                      &LcDummy );

            DbgPrint ("REQUEST_FORCE : Clear Debug Area\n" ,LcRet);

            } //
            break;

         case SUBREQ_FORCE_WRITE_CODEC_REG : // ---------------  write codec register --------------
             {
                DbgPrint ("BOOT DSP NOT available\n");
                LcRet = ED_INVALID_DSP_SOFTWARE;
             }
            break;

         case SUBREQ_FORCE_DSP_TYPE : // ---------------------------
             {
                DbgPrint ("BOOT DSP NOT available\n");
                LcRet = ED_INVALID_DSP_SOFTWARE;
             }
            break;

         case SUBREQ_FORCE_DUMP_MAILBOX : // ----------------------------
            ASSERT(APH_Commands_Array[LcCurrentBoard]);
            DWORD LcMailbox ;
            for (BYTE i = 1; i < 8; i++) {
                LcMailbox = CUR_COMMANDS_PTR->PIOReadPLXMailBox(i);
                DbgPrint ("PLX MAILBOX(%d) = 0x%lx\n" ,i,LcMailbox);
            };
            break;
         case SUBREQ_FORCE_IRQB : // ----------------------------
             {
                DbgPrint ("BOOT DSP NOT available\n");
                LcRet = ED_INVALID_DSP_SOFTWARE;
             }
            break;
         case SUBREQ_FORCE_SET_MUTE_OUT : // ----------------------------
             {
                DbgPrint ("BOOT DSP NOT available\n");
                LcRet = ED_INVALID_DSP_SOFTWARE;
             }
            break;
         case SUBREQ_FORCE_XTAL_CLOCK : // ----------------------------
             {
                DbgPrint ("BOOT DSP NOT available\n");
                LcRet = ED_INVALID_DSP_SOFTWARE;
             }
            break;
         case SUBREQ_TRIGGER_IRB_TIMER : // ----------------------------
            ASSERT(CUR_PROTOCOL_PTR);
            LcRet = CUR_PROTOCOL_PTR->IDiag_DspSetTimerInterrupt(LcLPtrRequest->driParam3);
            DbgPrint("FORCE SUBREQ_TRIGGER_IRB_TIMER Samples = %d\n",LcLPtrRequest->driParam3);
            break;
         case SUBREQ_SET_SPEED_RATIO : // ----------------------------
             {
                DbgPrint ("BOOT DSP NOT available\n");
                LcRet = ED_INVALID_DSP_SOFTWARE;
             }
            break;
         case SUBREQ_DUMP_MEM_LXES:
             {
                LPDWORD LcBuffer = (LPDWORD) LcLPtrReply->driBuffer;
                int LcMax = sizeof(LcLPtrReply->driBuffer) / sizeof(DWORD);
                if(LcMax > 40) LcMax = 40;

                for (int i=0; i < LcMax; i++)
                {
                    DWORD x = CUR_COMMANDS_PTR->PIOReadMemBar(i);
                    *LcBuffer++ = x;
                    DOUT(DBG_WARNING, ("DUMP LXES MEM(%d) = %x\n", i, x));
                }
                LcLPtrReply->driBufferLen = LcMax * sizeof(DWORD);
             }
             break;

         case SUBREQ_DUMP_RESET_LXES:
             {
                DbgPrint ("REQUEST_FORCE : reset LXES\n");
				
				(CESIOCommands*)(CUR_COMMANDS_PTR)->HALXilinxReset(TRUE);
             }
             break;

		 case SUBREQ_PARK_MICROBLAZE:
             {
                DbgPrint ("REQUEST_FORCE : stop microblaze\n");
				
				(CESIOCommands*)(CUR_PROTOCOL_PTR)->IDiag_HaltEmbedded();
             }
             break;

        }

        } // REQUEST_FORCE
        break;


