// *************************************************************************
//
//  COPYRIGHT 1996-2000 DIGIGRAM. ALL RIGHTS RESERVED.
//
//  DIGIGRAM
//
// **************************************************************************

#ifndef _DRVDEF_H_
#define _DRVDEF_H_

// Included files
// **************

#include "pcxver.h"

#define NP_DRIVER

#ifdef __cplusplus
extern "C" {
#endif

#define DEPRECATE_DDK_FUNCTIONS 1

#ifdef NTBUFFER_NTDDK_H
    #include <ntddk.h>
#else
#ifdef SIMLXES
#include "../allpc/fake_ddk.h"
#else
    #include <wdm.h>
#endif
#endif

#ifdef __cplusplus
}
#endif

    #include <stdarg.h>
    #include <stdio.h>
    #include <tchar.h>

    #ifndef FAR
        #define FAR
    #endif

    typedef float           FLOAT       ;   // unused within the driver

    typedef unsigned short  WORD        ;
    typedef unsigned long   DWORD       ;
    typedef unsigned int    UINT        ;
    typedef unsigned char   BYTE        ;
    typedef unsigned __int64 DWORDLONG  ;

    typedef WORD            *PWORD      ;
    typedef DWORD           *PDWORD     ;
    typedef UINT            *PUINT      ;
    typedef BYTE            *PBYTE      ;
    typedef DWORDLONG       *PDWORDLONG ;

    typedef WORD FAR        *LPWORD     ;
    typedef DWORD FAR       *LPDWORD    ;
    typedef UINT FAR        *LPUINT     ;
    typedef BYTE FAR        *LPBYTE     ;
    typedef DWORDLONG FAR   *PDWORDLONG ;

    typedef VOID FAR        *LPVOID     ;



#include "..\allpc\basicdef.h"



// ---------------------------------------------------------
// Union for accessing every part (WORD, or BYTE) of a DWORD
// ---------------------------------------------------------
typedef union
{
  DWORD l;

  struct
  {
    WORD l;
    WORD h;
  } w;

#define wl      w.l
#define wh      w.h

  struct
  {
    BYTE ll;
    BYTE ml;
    BYTE mh;
    BYTE hh;
  } b;

#define bll     b.ll
#define bml     b.ml
#define bmh     b.mh
#define bhh     b.hh

} DATA_INFO, *PDATA_INFO ;




// Type definitions
// ****************

#define MAX_FILE_PATH_LEN       144     // DOS limitation, others are
#define MAX_FILE_NAME_LEN       12      // kept compatible to those values

typedef BYTE            FileName[MAX_FILE_NAME_LEN] ;
typedef BYTE            FilePath[MAX_FILE_PATH_LEN] ;


// Basic string type definition
// ----------------------------
#define STRING_SIZE         200

typedef CHAR                STRING_TYPE[STRING_SIZE] ;



// File handle
// -----------
    typedef HANDLE              FHANDLE;


// Macro definitions
// *****************

//  Memory allocation
// ------------------
#define PCX_UNDEFD_TAG		'AxcP'
#define PCX_HRWDM_TAG		'BxcP'
#define PCX_COMMON_TAG		'CxcP'
#define PCX_MINTOPO_TAG		'DxcP'
#define PCX_MINWAVE_TAG		'ExcP'
#define PCX_ICHWAVE_TAG		'FxcP'
#define PCX_ICHW_NEW_TAG	'GxcP'
#define PCX_BOOT_NEW_TAG	'HxcP'
#define PCX_COM_NEW_TAG		'IxcP'
#define PCX_IOACCESS_TAG	'JxcP'
#define PCX_IOCMDS_TAG		'KxcP'
#define PCX_NPPROT_TAG		'LxcP'


#define DDK_ALLOC_WITH_TAG(pool,size,tag)   ExAllocatePoolWithTag(pool,size,tag)
#define DDK_ALLOC(size)                     ExAllocatePoolWithTag(PagedPool,size,PCX_UNDEFD_TAG)

#ifdef DBG_VIEWER
#define DDK_FREE_WITH_TAG(address,tag)      ExFreePoolWithTag(address,tag)
#define DDK_FREE(address)                   ExFreePoolWithTag(address,PCX_UNDEFD_TAG)
#else
#define DDK_FREE_WITH_TAG(address,tag)      ExFreePool(address)
#define DDK_FREE(address)                   ExFreePool(address)
#endif

#define BZERO2(b,t,n)   RtlZeroMemory(b,(n) * sizeof(t))
#define MEMSET2(b,v,t,n)    RtlFillMemory(b, (n) * sizeof(t), v)
#define MEMCPY(a,b,c)   RtlCopyMemory(a,b,c)

#define BZERO(b,s)      BZERO2(b,BYTE,s)

//  String manipulation
// --------------------

#define STRLEN(s)          strlen(s)
#define STRCMP(a,b)        strcmp(a,b)
#define STRNCPY(d,s,n)     strncpy(d,s,n)
#define VSNPRINTF(a,b,c,d) _vsnprintf(a,b,c,d)
//    #define VSNPRINTF(a,b,c,d) RtlStringCbVPrintfA(a,b,c,d)
//    -> #include <NtStrsafe.h>


// IO access
// ---------

    typedef DWORDLONG         TTIME;

    #define UNIV_INP(a)       READ_PORT_UCHAR( (PUCHAR)( a ))
    #define UNIV_INW(a)       READ_PORT_USHORT( (PUSHORT)( a ))
    #define UNIV_INPL(a)      READ_PORT_ULONG( (PULONG)( a ))
    #define UNIV_OUTP(a,v)    WRITE_PORT_UCHAR( (PUCHAR)( a ), (UCHAR)( v ))
    #define UNIV_OUTW(a,v)    WRITE_PORT_USHORT( ((PUSHORT) ( a )), ((USHORT) ( v )) )
    #define UNIV_OUTPL(a,v)   WRITE_PORT_ULONG( ((PULONG) ( a )), ((ULONG) ( v )) )

// Memory transfert for PCXNP board
// --------------------------------
#ifndef SIMLXES
    #include "nt_lib.h"
#endif

// TAG_DEBUG_DRIVER : DEB

// BoardType definitions
// CAUTION: the boards definition of this file must be the same as
//          the boards definition in file pcxdef.h
//

#define UNKNOWN_BOARD                   PCX_NO_PRESENT

#define LXES_BOARD                      LXES
#define LX6464ES_BOARD                  LX6464ES


// Values for the PORT_INFO structure
// ----------------------------------
// piClockType field
// INDEPENDANT_CLOCK must be 0 because it is the reset value
#define INDEPENDANT_CLOCK   0
#define SLAVE_CLOCK         1
#define MASTER_CLOCK        2

// Global typedef
// **************

// TAG_DEBUG_DRIVER : FIN


#endif //_DRVDEF_H_

