// *************************************************************************
//
//  COPYRIGHT 1996-2000 DIGIGRAM. ALL RIGHTS RESERVED.
//  Portions Copyright (c) 1998-1999 Intel Corporation
//  Portions Copyright (c) 1998-1999 Microsoft Corporation. 
//
// **************************************************************************

#ifndef _ICHWAVE_H_
#define _ICHWAVE_H_


//*****************************************************************************
// Defines
//*****************************************************************************

// The scatter gather entries
//
const int MAX_BDL_ENTRIES = 16;

// Mask for accessing the scatter gather entries with a counter.
//
const int BDL_MASK = 15;

//
// These defines reflect what the DMA is supposed to be.
//
const int DMA_ENGINE_OFF   = 0;
const int DMA_ENGINE_ON    = 1;
const int DMA_ENGINE_PAUSE = 2;

#define ES_MAX_BITWIDTH 24
#define ES_MIN_BITWIDTH 16

// min and max rate without FrequencyRatio
#define ES_MAX_RATE     48000
#define ES_MIN_RATE     44100

//
// Structure to describe the Sound buffers passed down to VIO module
//
typedef struct _REQUEST_INFO
{
    LARGE_INTEGER Mapping;
	DWORD Size;
	ULONG Tag;
    BYTE  IndexLX;
} REQUEST_INFO, *PREQUEST_INFO ;


//*****************************************************************************
// Classes
//*****************************************************************************

/*****************************************************************************
 * CMiniportWaveICHStream
 *****************************************************************************
 * ICH wave miniport stream.
 */
class CMiniportWaveICHStream : public IMiniportWavePciStream,
                               public IDrmAudioStream,
                               public CUnknown
{
private:
    //
    // CMiniportWaveICHStream private variables
    //
    CMiniportWaveICH *          m_Wave;             // Miniport Object
    ULONG                       m_Pin;              // This stream handles.
    BOOLEAN                     m_Capture;          // TRUE=Capture,FALSE=Render

    ULONG                       m_CurrentRate;      // Current Sample Rate
    PSERVICEGROUP               m_ServiceGroup;     // service group helps with DPCs
    ULONG                       m_TagCounter;
    PPORTWAVEPCISTREAM          m_PortStream;       // Port Stream Interface
    PKSDATAFORMAT_WAVEFORMATEX  m_DataFormat;       // Data Format
    ULONG                       m_SampleSize;       // SampleSize (=4 if stereo 16 bit)

    ULONG                       m_DMAEngineState;   // DMA engine state (STOP, PAUSE, RUN)
    ULONGLONG                   m_TotalBytesReleased;// factor in position calculation
    ULONGLONG                   m_PositionOffset;   // offset of StreamPosition after WAKEUP

    DEVICE_POWER_STATE          m_PowerState;       // Current power state of the device.

    TARGET_INFO                 m_Target;           // Stream handle

    REQUEST_INFO                m_RequestInfo[MAX_BDL_ENTRIES];
	LONG						m_ReqInfoGetNewIndex;
	LONG						m_ReqInfoReleaseIndex;
	LONG						m_ReqInfoPending;
	BOOL						m_InGetNewMap;
	BOOL						m_InReleaseMap;

    WORD                        m_ChannelNumber;    // ## FM (02/08/2000)

    DWORDLONG                   m_MyInPipeMask;
    DWORDLONG                   m_MyOutPipeMask;

    KSPIN_LOCK                  m_MapLock;          // for processing mappings.

    /*************************************************************************
     * CMiniportWaveICHStream methods
     *************************************************************************
     *
     * These are private member functions used internally by the object.  See
     * ICHWAVE.CPP for specific descriptions.
     */

    // Called when new mappings have to be processed.
    //
    NTSTATUS GetNewMappings (BOOL PmOnlyOne);

    // Called when we want to release some mappings.
    //
    NTSTATUS ReleaseUsedMappings (void);

    //
    // DMA start/stop/pause/reset routines.
    //
    NTSTATUS ResetDMA (void);
    NTSTATUS PauseDMA (void);
    NTSTATUS ResumeDMA (void);

    NTSTATUS PrepareHardware( BOOL PmReservePipe );

public:

	CProtocol* m_pDsp;

    /*************************************************************************
     * The following two macros are from STDUNK.H.  DECLARE_STD_UNKNOWN()
     * defines inline IUnknown implementations that use CUnknown's aggregation
     * support.  NonDelegatingQueryInterface() is declared, but it cannot be
     * implemented generically.  Its definition appears in ICHWAVE.CPP.
     * DEFINE_STD_CONSTRUCTOR() defines inline a constructor which accepts
     * only the outer unknown, which is used for aggregation.  The standard
     * create macro (in ICHWAVE.CPP) uses this constructor.
     */
    DECLARE_STD_UNKNOWN ();
    DEFINE_STD_CONSTRUCTOR (CMiniportWaveICHStream);

    ~CMiniportWaveICHStream ();

    /*************************************************************************
     * Include IMiniportWavePciStream (public/exported) methods.
     *************************************************************************
     */
    IMP_IMiniportWavePciStream;

    /*************************************************************************
     * Include IDrmAudioStream (public/exported) methods.
     *************************************************************************
     */
    IMP_IDrmAudioStream;

    /*************************************************************************
     * CMiniportWaveICHStream methods
     *************************************************************************
     */

    //
    // Initializes the Stream object.
    //
    NTSTATUS Init
    (
        IN  CMiniportWaveICH    *Miniport_,
        IN  PPORTWAVEPCISTREAM  PortStream_,
        IN  ULONG               Pin_,
        IN  BOOLEAN             Capture_,
        IN  PKSDATAFORMAT       DataFormat_,
        IN  ULONG               Entry_,
        IN  WORD                ChannelNumber_,
        OUT PSERVICEGROUP *     ServiceGroup_
    );

    //
    // This method is called when the device changes power states.
    //
    NTSTATUS PowerChangeNotify
    (
        IN  POWER_STATE NewState
    );

    //
    // Friends
    //
    friend
    NTSTATUS CMiniportWaveICH::NotifyStream( BOOL PmIsRecord, DWORD PmAudio, BOOL PmDirectCall );
};



#endif
