// **************************************************************************
//
// COPYRIGHT 1996-1998 DIGIGRAM. ALL RIGHT RESERVED.
//
// DIGIGRAM
//
// **************************************************************************
//
// PcxDef_E.H
//
// Project              np driver
//                      Common file
//
// File desription  :   Common defines for both API and TOOLS interfaces
//
// Author           :   FS
// Creation date    :   04 December  1996
// Last modification:   12 November  1998
//
// ***************************************************************************
//
//   12 November 1998, DPI : New constants added for Virtual VPCX
//
//   10 August 1998, FS: Modifications since V04-R0x
//          - add CD-ROM input selection
//          - add MPEG Layer III
//
//   20 March 1998, DS: Modifications since V03-R50
//          - add PCXC board
//          - some other boards supported now
//
//   28 November 1997, FS: Modifications since V03-R40
//          - some new boards supported
//          - addition of a AUDIO_LEVEL_PRESENT_MASK to
//           identify whether a board has programmable analog audio levels
//
//   22 September 1997, FS: Modifications since V03-R30
//          - new boards supported now
//
//   29 July 1997, FS: Modifications since V03-R20
//
//   14 Decembre 1999, CDR: 2 define added to choose the API mode
//
//   16 Juillet 2002, JPB Add STREAM_FMT_LIN_32
// ***************************************************************************

#ifndef _PCXDEF_H_
//{

#define _PCXDEF_H_

#include "basicdef.h"

#ifdef DRIVER_WINNT
#ifndef VX_DRIVER
#define NP_DRIVER
#endif	// VX_DRIVER
#endif	// DRIVER_WINNT


#if (DBG || defined(_DEBUG))
#ifdef NP_DISPATCHER
#pragma message(">>> NP_DISPATCHER  _PCXDEF_H_<<<")
#endif  // NP_DISPATCHER
#ifdef VX_DRIVER
#pragma message(">>> VX_DRIVER  _PCXDEF_H_<<<")
#endif	// VX_DRIVER
#ifdef NP_DRIVER
#pragma message(">>> NP_DRIVER  _PCXDEF_H_<<<")
#endif	// NP_DRIVER
#endif	// debug

// ********************************************************************
// Constant definitions
// ********************************************************************

// General constants
// *****************
#define MAX_STEREO_OUTAUDIO_BOARD   12
#define MAX_STEREO_INAUDIO_BOARD    12
#define SIZE_MAX_APP_NAME           15

// for the old API (those value are defined in dispatcher.ini for the new API)
#if (defined(_WIN32)||(!defined(VX_DRIVER)))
#define MAX_INPIPE                  32
#define MAX_OUTPIPE                 32
#define MAX_INOUTPIPE               32    /**<the max of the 2 lignes above.*/
#else
#define MAX_INPIPE                  16    /**<for WAVE16, keep the segment < 64k.*/
#define MAX_OUTPIPE                 16
#define MAX_INOUTPIPE               16
#endif


#if (defined(NP_DRIVER)||(defined(VX_DRIVER)))
#define MAX_BOARD                   8
#else
#define MAX_BOARD                   16
#endif

// Amount of application that can be simultaneously registred under Virtual PCX
// (1 application registring twice = 2 application registring once)
#define MAX_VPCXAPP_COUNT           10 // Obsolete, do not use anymore

#define MAX_APP                     128
#define MAX_INSTANCE                32 //nbre max d'instance de driver

// API identifiers
// ***************
#define PCX_API                     0x00
#define PCX_API_VIRTUAL             0x01
#define VPCX_API                    PCX_API_VIRTUAL
#define PCX_OLD_API_ALL             0x02
#define PCX_API_ALL                 PCX_OLD_API_ALL
#define NCX_API                     0x03
#define RCX_API                     0x04
#define MIXART_API                  0x05
#define TOTAL_API                   0x05 //Total number of api
#define PCX_NEW_API_ALL             0x06
#define PCX_NEW_API_ALL_BUT_VPCX    0x07

// PIPE, LIST, BOARD handle
#define PIPEHANDLE                  0x01
#define BOARDHANDLE                 0x02
#define ELEMENTHANDLE               0x04
#define LISTHANDLE                  0x08

// Status of a board
#define MISSING                     0
#define PRESENT                     1

// Flags for PCXInitialize (PINIT_INFO->iiFlags)
// ***********************
#define VX_FLAG                       0x00000001 /**< Do not filter VX Board for All Drivers.*/
#define HOST_PREPROCESSING_FLAG       0x00000002 /**< Specially for Preprocessing decoding on host.*/
#define VX_NP_FLAG                    0x00000004 /**< Do not Filter VX Board on NP2 Driver.*/
#define VX_HR_FLAG                    0x00000008 /**< Do not Filter VX Board on HR Driver.*/
#define VX_VX822V2_FLAG               0x00000010 /**< Do not Filter VX822v2.*/ 
#define LX_FLAG						  0x00000020 /**< Do not Filter LXES cards.*/
#define IGNORE_INSTALL_SETTINGS_FLAG  0x80000000 /**< Ignore Registry INIFLAGS Settings.*/

// End of flag description

// Virtual board identifiers
// *************************
#define PCX_VIRTUAL_BOARD_NUM       15
#define PCX_VIRTUAL_BOARD           (1 << PCX_VIRTUAL_BOARD_NUM) // 0x8000

// System info masks
// --
// For PCX API interface, see :
//     SYSTEM_FEATURES_INFO
// ****************************
#define PCX_SYSTEM_INFO_AVAILABLE   0x01
#define VPCX_SYSTEM_INFO_AVAILABLE  0x02

// Time units for PCXAudio.dll
// ***************************
#define MS_UNIT       0
#define SAMPLE_UNIT   1
#define BYTES_UNIT    2
#define FRAME_UNIT    3

// BoardType definitions values
// --
// For PCX API interface, see :
//     CARD_FEATURES_INFO
// ****************************
#define PCX_NO_PRESENT              0
#define PCX9                        1
#define PCX11                       2
#define PCX20                       3
#define PCX80                       4
#define PCX11PLUS                   5
#define PCX20_V2                    6
#define PCXC                        10
#define PCXPOCKET                   15
#define PCXPOCKET_AD                16
#define PCXPOCKET_V2                17
#define PCX801                      20
#define PCX821                      21
#define PCX800                      22
#define PCX820                      23
#define PCX440                      24
#define PCX221                      25
#define PCX822                      26
#define PCX442                      27
#define PCX441                      28

#define LCM220                      30
#define LCM440                      31
#define LAM420                      32
#define LCM440_V2                   33
#define LCM220_V2                   34
#define LCM200_V2                   35
#define LCM420_V2                   36
#define PCX11PLUS24                 40
#define PCX924                      41
#define PCX22                       42
#define AEQ24                       43
#define PCX924_MIC                  51

// PCX HR boards
// ****************************
#define HR_FIRST                    60
#define VX882_HR                    60
#define PCX882_HR                   61
#define VX881_HR                    62
#define PCX881_HR                   63
#define VX1222_HR                   64
#define PCX1222_HR                  65
#define VX1221_HR                   66
#define PCX1221_HR                  67
#define HR_LAST                     79

// Extended board type
//********************
#define PCXVXNP                     0
#define PCXVX_V2                    1
#define EBT_IS_VX                   2

// Specific boards
// ****************************
#define BK_PC_CARD_FRONT_END        127
#define SBA220                      128

#define VPCX_FIRST                  129
#define VPCX_WAVE_BOARD             129
#define VPCX_PC_BOARD               130
#define VPCX_DSOUND_BOARD           131
#define VPCX                        VPCX_WAVE_BOARD
#define VPCX_LAST                   149

// VX boards
// ****************************
#define VX_FIRST                    150
#define VX222                       150
#define VX222_MIC                   152
#define VX820                       155
#define VX822                       156
#define VXPOCKET                    170
#define VXPOCKET_440                176
#define VX_LAST                     179

// PCX pocket board
// ****************************
#define PCXPOCKET_V3                180
#define PCXPOCKET_240               181
#define PCXPOCKET_440               182

// NCX boards
// ****************************
#define NCX_FIRST                   200
#define NCX220_56002                200
#define NCX400_56002                201
#define NCX040_56002                202
#define NCX200_56002                203
#define NCX020_56002                204
#define NCX220_56303                205
#define NCX400_56303                206
#define NCX040_56303                207
#define NCX200_56303                208
#define NCX020_56303                209
#define NCX_LAST                    229

// RCX boards
// ****************************
#define RCX_FIRST                   230
#define RCX220                      230
#define RCX_LAST                    239

// miXart Boards
// ****************************
    // Board Type
    // **********
#define MIXART_FIRST                250
#define MIXART                      250
#define MIXART_8                    MIXART
#define MIXART_LAST                 250
    // Extended board type
    //********************
#define MIXART8                     0
#define MIXART8_AES                 1
#define MIXART8_COBRANET            2
#define MIXART8_ETHERSOUND          3

// LXES Boards
// ****************************
    // Board Type
    // **********
#define LXES_FIRST                  251
#define LXES                        251
#define LXES_LAST                   251
    // Extended board type
    //********************
#define LX6464ES                    0

// LAST board type 255,   Last extended 255
// ****************************************


// BusType definitions values
// --
// For PCX API interface, see :
//     CARD_FEATURES_INFO
// ****************************
#define ISABUS                      1
#define PCIBUS                      2
#define PCCARDBUS                   3
#define ETHERNETBUS                 4
#define USBBUS                      5
#define UNKNOWNBUS                  99

// Address range masks
// --
// For PCX API interface, see :
//     CARD_FEATURES_INFO
// ****************************
#define BOARD_ADDRESS_MASK          0xFFFFFFFE
#define BOARD_ADDRESS_SPACE_MASK    0x00000001
#define BOARD_ADDRESS_MEM_SPACE     0x00
#define BOARD_ADDRESS_IO_SPACE      0x01

// PipeAttributes definitions bits
// --
// For PCX API interface, see :
//     PIPE_DECL_INFO
// *******************************
#define PIPE_IN                     0x01
#define PIPE_OUT                    0x00
#define PIPE_OFFLINE                0x02
#define PIPE_ONLINE                 0x00

// AudioAttributes definitions bits
// --
// For PCX API interface, see :
//     AUDIO_DECL_INFO
// ********************************
#define AUDIO_VIRTUAL_DEVICE        0x04
#define AUDIO_PHYSICAL              0x01
#define AUDIO_VIRTUAL               0x00
#define AUDIO_IN                    0x02
#define AUDIO_OUT                   0x00

// ApplicationAttributes definitions bits
// --
// For PCX API interface, see :
//     APP_DECL_INFO
// **************************************
#define APP_PRIVATE                 0x01
#define APP_PUBLIC                  0x00

// StreamFormats definitions bits
// --
// For PCX API interface, see :
//     sdFormat in STREAM_DECL_INFO
//     dtlPlayFormats/dtlRecordFormats in DSP_TO_LOAD_INFO
// *******************************************************
#define STREAM_FMT_MPEGI            0x00000020
#define STREAM_FMT_MPEGII           0x00000040
#define STREAM_FMT_MPEGIII          0x00000800
#define STREAM_FMT_LIN_8            0x00000080
#define STREAM_FMT_LIN_16           0x00000100
#define STREAM_FMT_LIN_24           0x00000200
#define STREAM_FMT_CELP             0x00000400
#define STREAM_FMT_GSM              0x00001000
#define STREAM_FMT_AAC              0x00002000
#define STREAM_FMT_WMA              0x00004000
#define STREAM_FMT_LIN_32           0x00008000
#define STREAM_FMT_LIN_MULTICHANNEL 0x00010000

// StreamFormats definitions bits
// --
// For PCX API interface, see :
//     sdMisc in STREAM_DECL_INFO
//     hfPlayFormats/hfRecordFormats in HOST_FORMAT_INFO
// *****************************************************
#define HOST_MPEGIII                  0x00000001
#define HOST_AAC                      0x00000002
#define LAST_BUFFER_TO_HOST           0x80000000

// Mute values
// ***********
#define MUTE_ON                     1
#define MUTE_OFF                    0

// Level values
// ************
#define MAX_DIGITAL_LEVEL           ((FLOAT) + 18.0)
#define MAX_ANALOG_LEVEL            ((FLOAT) + 0.0)
#define LEVEL_0DB                   ((FLOAT) 0.0)
#define LEVEL_NEGATIVE_INFINITY     ((FLOAT)-110.0)

// No object specified
// ********************
#define NO_PIPE                     0x00000000
#define NO_STREAM                   0x00000000

/**
* ---- -- Defines for the old CARD_FEATURES_INFO enumeration scheme -- -----
*/

#define AUDIO_ANALOG_PRESENT_MASK           0x01 // in ciPhysicalXXXFeature
#define AUDIO_LEVEL_PRESENT_MASK            0x10 // in ciPhysicalXXXFeature
#define AUDIO_COBRANET_PRESENT_MASK         0x40 // in ciPhysicalXXXFeature
#define AUDIO_MORE_FEATURES_MASK            0x80 // in ciPhysicalXXXFeature : ciPhysicalXXXFeature2 must be read
#define AUDIO_DIGITAL_PRESENT_MASK				0x02 // in ciPhysicalOutFeature only
#define AUDIO_DIGITAL_SYNCHRO_PRESENT_MASK		0x02 // in ciPhysicalInFeature only
#define AUDIO_DIGITAL_DATA_PRESENT_MASK			0x04 // in ciPhysicalInFeature only
#define AUDIO_ANALOG_MICRO_PRESENT_MASK			0x08 // in ciPhysicalInFeature only
#define AUDIO_CD_ANALOG_INPUT_PRESENT_MASK		0x20 // in ciPhysicalInFeature only

// *******************************************************************

#define AUDIO_ETHERSOUND_PRESENT_MASK       0x02 // in ciPhysicalXXXFeature2
#define AUDIO_SRC_PRESENT_MASK              0x10 // in ciPhysicalXXXFeature2, Sample Rate Converters may be assigned to this IO
#define AUDIO_SRC_IO_SHARED_MASK            0x20 // in ciPhysicalXXXFeature2, src is shared between an Input and the matching Output
#define AUDIO_SRC_OUT_DISABLES_DIGITAL_INPUT_MASK   0x01 // in ciPhysicalOutFeature2, assigning the SRC to the digital output disables the digital input
#define AUDIO_MIXED_MICRO_PRESENT_MASK				0x01 // in ciPhysicalInFeature2 only
#define AUDIO_ON_SYNC_CONNECTOR_PRESENT_MASK		0x08 // in ciPhysicalInFeature2 only

// *******************************************************************

#define AUDIO_LINE_IN_LEVEL_PRESENT_MASK		0x01 // in ciExtraPhysicalInFeature
#define AUDIO_MICRO_IN_LEVEL_PRESENT_MASK		0x02 // in ciExtraPhysicalInFeature
#define AUDIO_CD_IN_LEVEL_PRESENT_MASK			0x04 // in ciExtraPhysicalInFeature
#define AUDIO_MIC_IN_48V_PRESENT_MASK			0x08 // in ciExtraPhysicalInFeature
#define AUDIO_MIC_IN_COMPRESSOR_PRESENT_MASK	0x10 // in ciExtraPhysicalInFeature

/**
* ---- -- Defines for the new AUDIO_FEATURES_INFO enumeration scheme -- -----
*/
#define	AFI_GAIN_DIGITAL_PIPE				0x08 // afiLevelFeatures : a digital (post-mix) gain can be applied to this audio 
#define	AFI_VU_METERS						0x10 // afiLevelFeatures : VU-meters can be read for this audio
#define	AFI_PEAK_METERS						0x20 // afiLevelFeatures : Peak-meters can be read for this audio

// Source selector values for sound data input
// --
// For PCX API interface, see :
//      ipspADSelect in IN_PIPE_SET_PARAM_INFO
// ********************************************
#define DATA_FROM_NO_INPUT          0
#define DATA_FROM_ANALOG            0x01
#define DATA_FROM_DIGITAL_SYNCHRO   0x02
#define DATA_FROM_DIGITAL_DATA      0x04
#define DATA_FROM_MICRO             0x08
#define DATA_FROM_CD                0x20
#define DATA_FROM_COBRANET          0x40
#define DATA_FROM_SYNC_CONNECTOR    0x41
//      ipspADProperties in IN_PIPE_SET_PARAM_INFO
// ********************************************
#define IN_NO_PROPERTIES            0
#define IN_PROPERTIES_MIC_48V       0x1
#define IN_PROPERTIES_UER_SYNC  	0x2
#define IN_PROPERTIES_UER_ASYNC  	0x4

// Values for uer type of a pipe
// --
// For PCX API interface, see :
//     opspUer in OUT_PIPE_SET_PARAMETER_INFO
//     uiMode in UER_INFO
// ******************************************
#define UER_NO_MODE                 0
#define UER_MODE_UNKNOWN            0
#define UER_PROFESSIONAL            1
#define UER_CONSUMER                2
#define UER_MODE_MASK				3

#define UER_SRC_OUT_MASK            0x10

#define UER_IS_AUDIO_MODE           0x00
#define UER_IS_DATA_MODE            0x20
#define UER_AUDIO_DATA_MASK         0x20
#define UER_IS_NO_COPYRIGHT         0x00
#define UER_IS_COPYRIGHT            0x40
#define UER_COPYRIGHT_MASK          0x40
#define UER_IS_CHANNEL_UNDEFINED    0x00
#define UER_IS_CHANNEL_STEREO       0x80
#define UER_CHANNEL_MODE_MASK       0x80


// Values for presence of uer data
// --
// For PCX API interface, see :
//     uiData in UER_INFO
// ***********************************
#define UER_DATA_UNKNOWN            0
#define UER_NO_DATA                 1
#define UER_DATA_PRESENT            2

// Values for Video Format (see PCXSetPipeExternalClock or VIDEO_CLOCK_INFO)
#define VIDEO_NTSC_Sqr 0x00ul
#define VIDEO_PAL_Sqr  0x01ul
#define	VIDEO_NTSC_601 0x02ul
#define	VIDEO_PAL_601  0x03ul
#define	VIDEO_NTSC_4Fsc 0x04ul

// Min and Max for equalization levels
// ***********************************
#define MPEG_EQUAL_LEVEL_MIN       ((FLOAT)-58.5)
#define MPEG_EQUAL_LEVEL_MAX       ((FLOAT)+18.0)

// Value to know which API is being
// used, old or new
// ***********************************
#define DISP_OLD_MODE 0
#define DISP_NEW_MODE 1
#define DISP_LAST_MODE 1

// Values used for APP_INFO and APP_DECL_INFO
// adAppInfoEx and aiAppInfoEx :
#define APP_INFO_EX_DHS     0x04ul

// Values for field ?cValidationMask1 in structure UER_CLOCK_INFO, WORD_CLOCK_INFO, VIDEO_CLOCK_INFO or INTERNAL_CLOCK_INFO
#define DISABLE_INPUT_CONSISTENCY	0x01ul
#define UER_DISABLE_INPUT_CONSISTENCY DISABLE_INPUT_CONSISTENCY
#define	VALID_CARD_NUMBER			0x02ul
#define UER_SYNC_DATA				DISABLE_INPUT_CONSISTENCY
#define UER_ASYNC_DATA				0x04ul

#endif  // _PCXDEF_H_
//}

