// *************************************************************************
//
//  COPYRIGHT 1996-2000 DIGIGRAM. ALL RIGHTS RESERVED.
//
//  DIGIGRAM
//
// **************************************************************************

#ifndef _APIDEF_H_
#define _APIDEF_H_

// Included files
// **************

#include <stdio.h>
#include <string.h>

#include <windows.h>
#include <stdlib.h>
#include <memory.h>
#include <tchar.h>


#include "basicdef.h"

// no more typdrv.h
#define NP_DRIVER

#include "pcxver.h"

// Version of the API
// ------------------
#define PCX_API_VERSION_NUMBER     PCX_VERSION_NUMBER
#define PCX_API_VERSION_RELEASE    PCX_VERSION_RELEASE
#define PCX_API_VERSION_TYPE       PCX_VERSION_TYPE
#define PCX_API_VERSION_SUBRELEASE PCX_VERSION_SUBRELEASE


// Constant definitions
// ******************** 
#ifndef WIN32
  #define INVALID_HANDLE_VALUE (HANDLE) -1
#endif

// Type definitions
// ****************

//#ifndef HANDLE
//#define HANDLE  VOID *
//#endif

//#ifndef BOOL
//#define BOOL    BOOLEAN
//#endif

#if !defined(WIN32) && !defined(macintosh)
// No unicode support, force to Ansi
typedef CHAR    WCHAR;
typedef LPCHAR  LPTSTR;
#endif

typedef struct _BOTH_STR_INFO {
    LPSTR   bsAnsiString ;
#ifdef WIN32
    LPWSTR  bsUnicodeString ;
#endif
} BOTH_STR_INFO, * PBOTH_STR_INFO ;

// Macro definitions
// *****************

// Macro definition to declare constant strings both in ANSI and UNICODE
//
#ifdef WIN32
#define _BOTH_TEXT(str)  { (LPSTR)(str) , (LPWSTR)( L ## str) }
#else
#define _BOTH_TEXT(str)  { (LPSTR)(str) }
#endif


// Macro definition for trace
// --------------------------
// Use this macro like this: TRACE(("un: %d\n",1));
// Don't forget the two braces
//#ifdef _TRACE
//#define TRACE(x) printf x
//#else
//#if !defined(macintosh)
//#define TRACE(x)
//#else
//#define TRACE(x) ST_Printf(0, 0, x)
//#endif
//#endif


//  Memory allocation
// ------------------
#if defined(WIN32)

STATIC void* TryMalloc(DWORD PmSize)
{
    __try
    {
        return malloc(PmSize);
    }
    __except(EXCEPTION_EXECUTE_HANDLER)
    {
        ;//OutputDebugString(_T("LXESAPI : exception raised with malloc()\n"));
    }
    return NULL;
}
  //#define MALLOC2(t,n)        (t *) malloc((n) * sizeof(t))
  #define MALLOC2(t,n)        (t *) TryMalloc((n) * sizeof(t))

STATIC void TryFree(void *PmAddress)
{
    if ( PmAddress )
    {
        __try
        {
            free(PmAddress);
        }
        __except(EXCEPTION_EXECUTE_HANDLER)
        {
            ;//OutputDebugString(_T("LXESAPI : exception raised with free()\n"));
        }
    }
}
  //#define FREE(b)             if ( b ) free(b)
  #define FREE(b)             TryFree(b)

  #define BZERO2(b,t,n)       memset((LPBYTE) (b), 0, (size_t) ((n) * sizeof(t)))
  #define MEMSET2(b,v,t,n)    memset((LPBYTE) (b), v, (size_t) ((n) * sizeof(t)))
#else
STATIC void * FixAlloc(WORD Pm_Size) {
      HGLOBAL Lc_Hdl;
      void    *Lc_BufferAddress;

      Lc_Hdl = GlobalAlloc(GPTR | GMEM_SHARE, Pm_Size);
      if (Lc_Hdl) {
        UINT Lc_PageLockCount;
        Lc_PageLockCount = GlobalPageLock( Lc_Hdl);
        if (Lc_PageLockCount != 0) {
          Lc_BufferAddress = GlobalLock(Lc_Hdl);
          return Lc_BufferAddress;
        } else {
          GlobalFree( Lc_Hdl);
          return NULL;
        }
      } else {
        return NULL;
      }
  }

STATIC BOOL FixFree( void *Pm_Ptr) {
      HGLOBAL Lc_Hdl;
      Lc_Hdl = (HGLOBAL)( (DWORD)Pm_Ptr >> 16);
      GlobalUnlock( Lc_Hdl);
      GlobalPageUnlock( Lc_Hdl);
      return ( (BOOL) GlobalFree( Lc_Hdl) );
  }

  #define MALLOC2(t,n)        ((t *) FixAlloc((n) * sizeof(t)))
  #define FREE(b)             if ( b ) FixFree(b)
  #define BZERO2(b,t,n)       memset((LPBYTE) (b), 0, (size_t) ((n) * sizeof(t)))
  #define MEMSET2(b,v,t,n)    memset((LPBYTE) (b), v, (size_t) ((n) * sizeof(t)))
#endif

#define MALLOC(t)       MALLOC2(t,1)
#define BZERO(b,s)      BZERO2(b,BYTE,s)

//  String manipulation
// --------------------
#define FSTRCPY(d,s)     strcpy(d,s)
#define FSTRNCPY(d,s,n)  strncpy(d,s,n)
#define FSTRNICMP(d,s,n) strnicmp(d,s,n)
#define STRCAT(d,s)      strcat(d,s)
#define FSTRLEN(s)       strlen(s)

#endif
