// *************************************************************************
//
//  COPYRIGHT 1996-2000 DIGIGRAM. ALL RIGHTS RESERVED.
//
//  DIGIGRAM
//
// **************************************************************************


// Include files
// *************
#include <memory.h>

#include "apidef.h"
#include "ifapidrv.h"  // private interface between driver API

#include "pcxerr_e.h"  // shared list of errror codes

#include "genasync.h"

#include "common.h"             // this file interface

#include <winioctl.h>
#include <crtdbg.h> /*for ASSERT*/

#include "CreateFileMapping.h"


// Exported variables
// ******************

// for Get command
HANDLE               PCX_HSharedMem = NULL;
PSSharedMemory       PCX_PSharedMem = NULL;
EFFECT_MX_PARAM_INFO TbAudioInMXSettings[MAX_INPIPE];
EFFECT_EQ_PARAM_INFO TbAudioInEQSettings[MAX_INPIPE][3 /*bands*/];
MY_PIPE_INFO         *TbPipeInfo_IN;
MY_PIPE_INFO         *TbPipeInfo_OUT;


//HANDLE hInstance = 0;
PCX_HANDLE RegisterTab[MAX_PCX_HANDLE];
PCX_HANDLE* g_pDHSAppHandleDLL;

// Local defines
//**************

#define TIMEOUT_MUTEX 5000

// Local variables
// ***************

// FS - 10/10/1996
// As of today, use statically allocated and shared request/reply blocks
// This may change when porting to NT
//
STATIC DWORD COMBuffSyncReq[MAX_REQ_SIZE];
STATIC DWORD COMBuffSyncResp[MAX_RESP_SIZE];

STATIC HANDLE DriverId = INVALID_HANDLE_VALUE;   // driver device ID
STATIC HANDLE hLocalMutex = INVALID_HANDLE_VALUE;
STATIC HANDLE hGlobalMutex = INVALID_HANDLE_VALUE;

// ## FS (04/11/97) -- Since release 4.2 of MS Developper Studio
// the doc tells that DeviceIoControl should not be called
// with a NULL overlapped pointer on a DriverId handle
// opened with the FILE_FLAG_OVERLAPPED
//
STATIC OVERLAPPED oDummySyncOverlapped = {0,0,0,0,INVALID_HANDLE_VALUE};


// ****************************************************************************
// VOID COMCallDriver()
// ************************
//
// Input parameters :
// ****************
// BC_HEADER_INFO     PmReq: points to the request block already filled by API.
// DWORD              PmReqSize: the size of the request block. Only needed if
//                            the request block has not been allocated by
//                            COMFillBcHeader
// RESP_HEADER_HANDLE PmRespHdl: points to a response block already allocated
//                      or must point to NULL
// PVOID              PmOverlapped : for NT/95 only, point to the Overlapped structure
//
// Output parameters :
// ****************
// RESP_HEADER_INFO *PmResp: points to the response block filled by the driver.
//
// ****************************************************************************
// This function is used to send a command to the driver. It returns a
// reply command block filled-in and allocates it if necessary.
//
// ****************************************************************************
VOID COMCallDriver(
    IN    LPBC_HEADER_INFO    PmReq,
    IN    DWORD               PmReqSize,
    INOUT RESP_HEADER_HANDLE  PmRespHdl,
    IN    PVOID               PmOverlapped )
{
    LPRESP_HEADER_INFO  LcRespPtr;
    BOOL                LcSynchroCmd = FALSE;

    // FS - 10/10/1996
    // Preliminary patch to bring back all references to
    // allocated request/reply blocks inside this module
    // unless allocated elsewhere (for asynchronous commands)
    // ------------------------------------------------------
    if ( *PmRespHdl == 0 )
    {
       *PmRespHdl = (LPRESP_HEADER_INFO) COMBuffSyncResp;
       LcSynchroCmd = TRUE;
    }
    LcRespPtr = *PmRespHdl;

    // ## FS (11/12/97) -- sanitary reset
    // ----------------------------------
    BZERO2(LcRespPtr, BYTE, PmReq->hdBrSize);

    // FS - 09/10/1996
    // the command is not yet processed. Do not rely on the driver
    // to clear this bit
    // -----------------------------------------------------------
    LcRespPtr->rhT = NOT_PROCESSED;

    // FS - 25/02/1997
    // the command is not yet processed. Do no rely on the driver
    // to reset for asynchronous commands
    // -----------------------------------------------------------
    LcRespPtr->rhCptr = SUCCESS;

    if ( DriverId != INVALID_HANDLE_VALUE )
    {
        DWORD      LcdwOutByteNb;
        BOOL       LcRet;

        if (LcSynchroCmd)
        {
            _ASSERT((PmReqSize == 0) || (PmReqSize == PmReq->hdRequestSize));
            _ASSERT(PmReq->hdRequestSize <= MAX_REQ_SIZE);

            LcRet = DeviceIoControl(
                        DriverId        ,
                        IOCTL_PCX_COMMAND,
                        PmReq           ,
                        PmReq->hdRequestSize,   // was MAX_REQ_SIZE
                        LcRespPtr       ,
                        PmReq->hdBrSize ,
                        &LcdwOutByteNb  ,
                        &oDummySyncOverlapped );
        }
        else
        {
            _ASSERT(PmReqSize == PmReq->hdRequestSize);

            LcRet = DeviceIoControl(
                        DriverId            ,
                        IOCTL_PCX_COMMAND   ,
                        PmReq               ,
                        PmReqSize           ,
                        LcRespPtr           ,
                        PmReq->hdBrSize     ,
                        &LcdwOutByteNb      ,
                        PmOverlapped       );
        }

        if( ! LcRet )
        {
            DWORD LcErr = GetLastError();
            if(LcErr == ERROR_ACCESS_DENIED)
            {
#ifdef _DEBUG
                OutputDebugString(_T("LXESAPI : error STATUS_DELETE_PENDING !\n"));
#endif
                CLOSE_HANDLE(DriverId);
            }
            
        }
        // ## MBR (02/09/03) -- no more support for synchronous asynchronous
        //                      family's ED_PENDING_OPERATION response
    }
    else
    {
        LcRespPtr->rhCptr = EA_DRIVER_NOT_LOADED;
    }

}



// ****************************************************************************
// VOID COMAsynchronCommandFinishedOrAborted()
// ************************
//
// Input parameters :
// ****************
// PVOID    PmOverlapped: pointer to structure OVERLAPPED.
//
// Output parameters :
// ****************
// BOOL     bRet: TRUE if command is finished or aborted.
//
// ****************************************************************************
// This function is used to see if a asynchron command is finished/cancelled
// Useful when commands like PCXWait*** were cancelled by the system.
// This happens when Windows NT/2000 Threads ended that called this function !
// ****************************************************************************
BOOL COMAsynchronCommandFinishedOrAborted( IN PVOID  PmOverlapped )
{
    DWORD dwNumberOfBytes;
    BOOL  bRet = GetOverlappedResult(
                        DriverId,           // handle to file, pipe, or device
                        PmOverlapped,       // overlapped structure
                        &dwNumberOfBytes,   // bytes transferred
                        FALSE );            // wait option

    if(!bRet)
    {
        DWORD dwError = GetLastError();

        if(dwError == ERROR_OPERATION_ABORTED)
        {
#ifdef _DEBUG
            OutputDebugString(_T("LXESAPI : Asynchron Command was cancelled !\n"));
#endif //_DEBUG
            bRet = TRUE;
        }
    }

    return bRet;
}

// ****************************************************************************
// BOOL COMCreateLocalMutex()
// *************************
//
// Input parameters :
// ****************
// LPSECURITY_ATTRIBUTES    pSecurityHeritable: pointer to structure SECURITY_ATTRIBUTES.
//
// Output parameters :
// ****************
// BOOL     bRet: TRUE if mutex object has been successfully created.
//
// ****************************************************************************
// This function create the local mutex object
//
// ****************************************************************************
EXTERN BOOL COMCreateLocalMutex(LPSECURITY_ATTRIBUTES pSecurityHeritable )
{

	hLocalMutex = CreateMutex(pSecurityHeritable,FALSE,NULL);
	if (hLocalMutex == NULL)
		return FALSE;
	else
		return TRUE;
}

// ****************************************************************************
// VOID COMCloseLocalMutex()
// *************************
//
// ****************************************************************************
// This function close the local mutex object
//
// ****************************************************************************
EXTERN VOID COMCloseLocalMutex(VOID)
{
	CLOSE_HANDLE(hLocalMutex);
}


#define API_GLOBAL_MUTEX_NAME	_T("Global\\DigigramMutexLXESapi")


// ****************************************************************************
// BOOL COMCreateGlobalMutex()
// *************************
//
// Input parameters :
// ****************
// LPSECURITY_ATTRIBUTES    pSecurityHeritable: pointer to structure SECURITY_ATTRIBUTES.
//
// Output parameters :
// ****************
// BOOL     bRet: TRUE if mutex object has been successfully created.
//
// ****************************************************************************
// This function create the global mutex object
//
// ****************************************************************************
EXTERN BOOL COMCreateGlobalMutex(LPSECURITY_ATTRIBUTES pSecurityHeritable )
{
	
	hGlobalMutex = CreateMutex(pSecurityHeritable,FALSE,API_GLOBAL_MUTEX_NAME);
	if (hGlobalMutex == NULL)
		return FALSE;
	else
		return TRUE;
}

// ****************************************************************************
// BOOL COMCreateDummySyncOverlapped()
// *************************
//
// Output parameters :
// ****************
// BOOL     bRet: TRUE if overlapped object has been successfully created.
//
// ****************************************************************************
// This function create the overlapped synchronisation object
//
// ****************************************************************************
EXTERN BOOL COMCreateDummySyncOverlapped(VOID )
{
	
	oDummySyncOverlapped.Offset     = 0 ; // MSDN says: should be zero!
	oDummySyncOverlapped.OffsetHigh = 0 ; // MSDN says: should be zero!
	oDummySyncOverlapped.hEvent     = CreateEvent(NULL,FALSE,FALSE,NULL);
	
	if (oDummySyncOverlapped.hEvent == NULL)
	{
		COMCloseLocalMutex();
		COMCloseGlobalMutex();
		return FALSE;
	}
	
	return TRUE;
	
}

extern BOOL FindDeviceInterfaceName(IN const PTCHAR szDriverName, OUT PTCHAR szFileName);


// ****************************************************************************
// BOOL COMCreateDriverHandle()
// *************************
//
// Output parameters :
// ****************
// BOOL     bRet: TRUE if driver handle has been successfully created.
//
// ****************************************************************************
// This function create the driver handle
//
// ****************************************************************************
EXTERN BOOL COMCreateDriverHandle(VOID )
{
	_TCHAR               LcszBuf[_MAX_PATH];
	
    BOOL LcRet = FindDeviceInterfaceName(TEXT("LXESWDM"), LcszBuf);

    // The driver open and close must be protected.
	if ((!LcRet) || (!COMWaitGlobalExmut()))
	{
		CLOSE_HANDLE(hLocalMutex);
		CLOSE_HANDLE(hGlobalMutex);
		CLOSE_HANDLE(oDummySyncOverlapped.hEvent);
		return FALSE;
	}

	DriverId = CreateFile(LcszBuf, GENERIC_READ | GENERIC_WRITE,
					  FILE_SHARE_READ|FILE_SHARE_WRITE, NULL, OPEN_EXISTING,
					  FILE_ATTRIBUTE_NORMAL | FILE_FLAG_OVERLAPPED, NULL);

	COMReleaseGlobalExmut();

	// check success
	if ( DriverId == INVALID_HANDLE_VALUE )
	{
		CLOSE_HANDLE(hLocalMutex);
		CLOSE_HANDLE(hGlobalMutex);
		CLOSE_HANDLE(oDummySyncOverlapped.hEvent);
		return FALSE;
	}
	else
	{
		// Check if driver/API versions match
		// -----------------------------------
		WORD    LcError ;
	
		_tcscpy(LcszBuf,_T(""));
		
		LcError = GENInitAndCheckVersion( FALSE, LcszBuf ) ;
		
		if ( LcError != SUCCESS )
		{
			CLOSE_HANDLE(DriverId);
			COMCloseLocalMutex();
			COMCloseGlobalMutex();
			CLOSE_HANDLE(oDummySyncOverlapped.hEvent);
			return FALSE;
		}
	}
	return TRUE;
}

// ****************************************************************************
// VOID COMCloseDriver()
// *************************
//
// ****************************************************************************
// This function close the local mutex object
//
// ****************************************************************************
EXTERN VOID COMCloseDriver(VOID)
{
	CLOSE_HANDLE(DriverId);
	CLOSE_HANDLE(oDummySyncOverlapped.hEvent);
	
}



// ****************************************************************************
// BOOL COMCloseGlobalMutex()
// *************************
//
// ****************************************************************************
// This function close the global mutex object
//
// ****************************************************************************
EXTERN VOID COMCloseGlobalMutex(VOID)
{
	CLOSE_HANDLE(hGlobalMutex);
}

// ****************************************************************************
// BOOL COMWaitGlobalExmut()
// *************************
//
// ****************************************************************************
// This function waits for the global mutual exclusion object under NT
//
// ****************************************************************************
EXTERN BOOL COMWaitGlobalExmut( void )
{
    DWORD LcdwWaitResult;

    LcdwWaitResult = WaitForSingleObject(hGlobalMutex,TIMEOUT_MUTEX);
    if ((LcdwWaitResult == WAIT_TIMEOUT) ||
        (LcdwWaitResult == WAIT_FAILED))
       return FALSE;
    else
       return TRUE;
}

// ****************************************************************************
// BOOL COMReleaseGlobalExmut()
// ************************
//
// ****************************************************************************
// This function release the global mutual exclusion object under NT
//
// ****************************************************************************
EXTERN BOOL COMReleaseGlobalExmut( void )
{
    return ReleaseMutex(hGlobalMutex);
}

// ****************************************************************************
// BOOL COMWaitExmut()
// ************************
//
// ****************************************************************************
// This function waits for a local mutual exclusion object under NT
//
// ****************************************************************************
EXTERN BOOL COMWaitExmut( void )
{
    DWORD LcdwWaitResult;

    if (hLocalMutex == INVALID_HANDLE_VALUE) return FALSE;

    LcdwWaitResult = WaitForSingleObject(hLocalMutex,TIMEOUT_MUTEX);
    if ((LcdwWaitResult == WAIT_TIMEOUT) ||
        (LcdwWaitResult == WAIT_FAILED))
       return FALSE;
    else
       return TRUE;
}

// ****************************************************************************
// BOOL COMReleaseExmut()
// ************************
//
// ****************************************************************************
// This function release the local mutual exclusion object under NT
//
// ****************************************************************************
EXTERN BOOL COMReleaseExmut( void )
{
    return ReleaseMutex(hLocalMutex);
}

#ifndef NPHD_DIAGDLL // pour l'api seulement, le dllmain de la dll de diag est ailleurs
// *************************************************************************
// BOOL WINAPI DllMain
// ************************************
//
// Input Parameters :
// ******************
//      hInst              : DLL instance handle
//      ul_reason_for_call : One of the four possible reasons
//      lpReserved         : Not used
//
// Output Parameters :
// *******************
//      None
//
// Error codes :
// **************
//      Have signification only with DLL_PROCESS_ATTACH
//      If return FALSE, DLL is not loaded.
//
// *************************************************************************
// PCX calls : None
//
// *************************************************************************

BOOL WINAPI DllMain(HANDLE hInst, ULONG ul_reason_for_call, LPVOID lpReserved)
{
 BOOL                 LcbFirst;
 BOOL                 LcbValRet = TRUE;
 SECURITY_ATTRIBUTES  LcSecurityHeritable;
 SECURITY_DESCRIPTOR  LcGlobalSecurityDescriptor;
 SECURITY_ATTRIBUTES  LcGlobalSecurityAttributes;
 _TCHAR               LcszBuf[_MAX_PATH];
 int                  i;
 _TCHAR*              LcszSharedMemName;
 DWORD Lc_ShMemSize;


  switch (ul_reason_for_call)
  {
    /* A new process is attempting to access the DLL; one thread is assume */
    case DLL_PROCESS_ATTACH :
//       hInstance = hInst;
       
       // No application registered at this time.
       for(i=0;i<MAX_PCX_HANDLE;i++)
           RegisterTab[i]=0;

       g_pDHSAppHandleDLL = NULL;

       // Create the local Mutex
       LcSecurityHeritable.nLength = sizeof(SECURITY_ATTRIBUTES);
       LcSecurityHeritable.lpSecurityDescriptor = NULL;
       LcSecurityHeritable.bInheritHandle = TRUE;
       hLocalMutex = CreateMutex(&LcSecurityHeritable,FALSE,NULL);
       if (hLocalMutex == NULL)
       {
        OutputDebugString(_T("LXESAPI : Can't allocate local Mutex\n"));
        return FALSE;
       }
       // Create the global mutex or open it if already existing
       if (!InitializeSecurityDescriptor( &LcGlobalSecurityDescriptor,
                                          SECURITY_DESCRIPTOR_REVISION)) {
         CLOSE_HANDLE(hLocalMutex);
         return FALSE;
       }
       // Add a NULL DACL to the security descriptor..
       if (!SetSecurityDescriptorDacl(  &LcGlobalSecurityDescriptor,
                                        TRUE,
                                        (PACL) NULL,
                                        FALSE)) {
         CLOSE_HANDLE(hLocalMutex);
         return FALSE;
       }
       LcGlobalSecurityAttributes.nLength               = sizeof(LcGlobalSecurityAttributes);
       LcGlobalSecurityAttributes.lpSecurityDescriptor  = &LcGlobalSecurityDescriptor;
       LcGlobalSecurityAttributes.bInheritHandle        = TRUE;

       hGlobalMutex = CreateMutex(&LcGlobalSecurityAttributes ,FALSE, API_GLOBAL_MUTEX_NAME);
       if (hGlobalMutex == NULL)
       {
        CLOSE_HANDLE(hLocalMutex);
        OutputDebugString(_T("LXESAPI : Can't allocate global Mutex\n"));
        return FALSE;
       }

       oDummySyncOverlapped.Offset     = 0 ; // MSDN says: should be zero!
       oDummySyncOverlapped.OffsetHigh = 0 ; // MSDN says: should be zero!
       oDummySyncOverlapped.hEvent     = CreateEvent(NULL,FALSE,FALSE,NULL);
       if (oDummySyncOverlapped.hEvent == NULL)
       {
        CLOSE_HANDLE(hLocalMutex);
        CLOSE_HANDLE(hGlobalMutex);
        OutputDebugString(_T("LXESAPI : Can't allocate sync event\n"));
        return FALSE;
       }

        // Create a handle on the driver
        LcbValRet = FindDeviceInterfaceName(TEXT("LXESWDM"), LcszBuf);

       // The driver open and close must be protected.
       if ((!LcbValRet) || (!COMWaitGlobalExmut()))
       {
        CLOSE_HANDLE(hLocalMutex);
        CLOSE_HANDLE(hGlobalMutex);
        CLOSE_HANDLE(oDummySyncOverlapped.hEvent);
        return FALSE;
       }

       DriverId = CreateFile(LcszBuf,
         GENERIC_READ | GENERIC_WRITE,
         FILE_SHARE_READ|FILE_SHARE_WRITE,
         NULL, OPEN_EXISTING,
         FILE_ATTRIBUTE_NORMAL | FILE_FLAG_OVERLAPPED,
         NULL);

       COMReleaseGlobalExmut();

       // check success
       if ( DriverId == INVALID_HANDLE_VALUE )
       {
           CLOSE_HANDLE(hLocalMutex);
           CLOSE_HANDLE(hGlobalMutex);
           CLOSE_HANDLE(oDummySyncOverlapped.hEvent);
           OutputDebugString(_T("LXESAPI : Driver not found\n"));
           return FALSE;
       }
       // Check if driver/API versions match
       // -----------------------------------
       else
       {
        WORD    LcError ;

        _tcscpy(LcszBuf,_T(""));

        LcError = GENInitAndCheckVersion( FALSE, LcszBuf ) ;

        if ( ( LcError != SUCCESS ) || ( *LcszBuf ) )
        {
			_TCHAR LcText[256];
			_stprintf(LcText, _T("LXESAPI : %s\n"), LcszBuf );
			OutputDebugString(LcText);
        }

        if ( LcError != SUCCESS )
        {
            CLOSE_HANDLE(DriverId);
            CLOSE_HANDLE(hLocalMutex);
            CLOSE_HANDLE(hGlobalMutex);
            CLOSE_HANDLE(oDummySyncOverlapped.hEvent);
            return FALSE;
        }
       }

       // creation de la mem partagee
       // 
       LcszSharedMemName = _T("Global\\LXES_dllSharedMem"); // name of map object
       Lc_ShMemSize = sizeof(SSharedMemory);

       PCX_HSharedMem = CreateFileMapping( 
                                (HANDLE) INVALID_HANDLE_VALUE,   // use paging file
                                &LcGlobalSecurityAttributes,     // no security attributes
                                PAGE_READWRITE,             // read/write access
                                0,                          // size: high 32-bits
                                Lc_ShMemSize,               // size: low 32-bits
                                LcszSharedMemName);         // name of map object
        if (!PCX_HSharedMem)
        {
            // try to allocate the shared memory with the service :
            PCX_HSharedMem = DigigramCreateFileMapping(
                                (HANDLE) INVALID_HANDLE_VALUE,   // use paging file
                                &LcGlobalSecurityAttributes,     // no security attributes
                                PAGE_READWRITE,             // read/write access
                                0,                          // size: high 32-bits
                                Lc_ShMemSize,               // size: low 32-bits
                                LcszSharedMemName);         // name of map object
        }

        if (!PCX_HSharedMem)
        {   
            OutputDebugString(_T("Cannot create SharedMem"));
            CLOSE_HANDLE(DriverId);
            CLOSE_HANDLE(hLocalMutex);
            CLOSE_HANDLE(hGlobalMutex);
            CLOSE_HANDLE(oDummySyncOverlapped.hEvent);
            return FALSE;
        }

        // The first process to attach will initialize memory. 
        LcbFirst = (GetLastError() != ERROR_ALREADY_EXISTS);  

        // Get a pointer to the file-mapped shared memory.
        PCX_PSharedMem = (PSSharedMemory)MapViewOfFile( 
                                    PCX_HSharedMem,  // object to map view of
                                    FILE_MAP_WRITE,     // read/write access
                                    0,                  // high offset:  map from
                                    0,                  // low offset:   beginning
                                    0);                 // default: map entire file
        if (!PCX_PSharedMem) {
          //LOGFCT ne doit pas etre utilise !!
          OutputDebugString(_T("MapViewOfFile failed"));
          CLOSE_HANDLE(DriverId);
          CLOSE_HANDLE(hLocalMutex);
          CLOSE_HANDLE(hGlobalMutex);
          CLOSE_HANDLE(oDummySyncOverlapped.hEvent);
          CLOSE_HANDLE(PCX_HSharedMem);
          return FALSE;
        }

        TbPipeInfo_IN = (MY_PIPE_INFO*)PCX_PSharedMem->PipeInfoIn;
        TbPipeInfo_OUT= (MY_PIPE_INFO*)PCX_PSharedMem->PipeInfoOut;

		g_pDHSAppHandleDLL = &(PCX_PSharedMem->DHSAppHandleDLL);

        // The first process to attach will initialize memory. 
        if(LcbFirst)
        {
            BZERO2(PCX_PSharedMem, BYTE, Lc_ShMemSize);
        }

      break;

    /* A new thread of an existing process is attempting to access the DLL */
    case DLL_THREAD_ATTACH :
      break;

    /* A process is detaching from the DLL */
    case DLL_PROCESS_DETACH :

       // The driver open and close must be protected.
       if (!COMWaitGlobalExmut())
       {
        return FALSE;
       }

       // Unregister all previously registered applications.
       for(i=0;i<MAX_PCX_HANDLE;i++)
       {
		   if ( RegisterTab[i]!=0 )
		   {
			   if (g_pDHSAppHandleDLL == NULL
				   || RegisterTab[i] != *g_pDHSAppHandleDLL)
			   {
				   PCXUnRegister(RegisterTab[i]);
			   }
		   }
	   }

      CLOSE_HANDLE(DriverId);

      COMReleaseGlobalExmut();

      CLOSE_HANDLE(hLocalMutex);
      CLOSE_HANDLE(hGlobalMutex);
      CLOSE_HANDLE(oDummySyncOverlapped.hEvent);

      if(PCX_PSharedMem)
      {
          UnmapViewOfFile( PCX_PSharedMem );
          PCX_PSharedMem = NULL;
      }
      CLOSE_HANDLE(PCX_HSharedMem);

      break;

    /* One of the additionnal threads (not the first one) of a process is */
    /* detaching from the DLL                                             */
    case DLL_THREAD_DETACH :
      break;

    default :
      break;
  }
  return LcbValRet;
}
#endif

// ****************************************************************************
// VOID COMFillBcHeader()
// ***************************
//
// Input parameters :
// ****************
//
// BYTE         PmFamily: field family of the header
// BYTE         PmComNum: field command number of the header
// APP_HANDLE   PmHandle: field application handle of the header
// WORD         PmBreqSize: field request block size of the header
// WORD         PmBrspSize: field response block size of the header
// BC_HEADER_HANDLE PmHdHdl: points to a the beginning of an already allocated
//                       header or must point to NULL
//
// Output parameters :
// *******************
//
// BC_HEADER_HANDLE PmHdHdl: points to a the beginning of the header filled in
//
//
// ****************************************************************************
//
// This function fills in the header of a control block, and allocate it if
// necessary
//
// ****************************************************************************
VOID COMFillBcHeader(
    IN    BYTE                PmFamily,
    IN    BYTE                PmComNum,
    IN    APP_HANDLE          PmHandle,
    IN    DWORD               PmBreqSize,
    IN    WORD                PmBrspSize,
    INOUT BC_HEADER_HANDLE    PmHdHdl )
{
    LPBC_HEADER_INFO    LcHdPtr;

    // FS - 10/10/1996
    // Preliminary patch to bring back all references to
    // allocated request/reply blocks inside this module
    // unless allocated elsewhere (for asynchronous commands)
    // ------------------------------------------------------
    if ( *PmHdHdl == 0 ) *PmHdHdl = (LPBC_HEADER_INFO) COMBuffSyncReq;
    LcHdPtr = *PmHdHdl;

    // ## FS (11/12/97) -- sanitary reset
    // *IMPORTANT* the default TIME_INFO used in differable
    // commands assumes that the request block is reset to 0
    // ------------------------------------------------------
    BZERO2(LcHdPtr, BYTE, PmBreqSize);

    LcHdPtr->hdFamily = PmFamily;
    LcHdPtr->hdComNum = PmComNum;
    LcHdPtr->hdHandle = PmHandle;

    //  Let's verify the requested size does not exceed
    // the allocated bound

    _ASSERT( PmBrspSize <= MAX_RESP_SIZE);

    LcHdPtr->hdBrSize = PmBrspSize;
    LcHdPtr->hdRequestSize = PmBreqSize;
}

