// *************************************************************************
//
//  COPYRIGHT 1996-2000 DIGIGRAM. ALL RIGHTS RESERVED.
//
//  DIGIGRAM
//
// **************************************************************************

// Include header file
// *******************
#include "util.h"

// ****************************************************************************
// EXTERN WORD UTIMaskWord()
// ***************************
//
// Input parameters :
// ****************
//
//      WORD PmVal  :   the value that is to be converted to a mask
//
// Output parameters :
// *******************
//
//      NONE
// 
// Return value :
// **************
//
//      The resulting WORD mask with bit PmVal is set
//
// ****************************************************************************
//
// Converts a value to a mask where the corresponding bit is set
//
// ****************************************************************************
WORD    UTIMaskWord( IN WORD Pmval )
{
    WORD LcMask;
    
    LcMask = 1;
    LcMask = ( LcMask << Pmval );
    return LcMask;
}

// ****************************************************************************
// EXTERN DWORD UTIMaskDWord()
// ***************************
//
// Input parameters :
// ****************
//
//      WORD PmVal  :   the value that is to be converted to a mask
//
// Output parameters :
// *******************
//
//      NONE
// 
// Return value :
// **************
//
//      The resulting DWORD mask with bit PmVal is set
//
// ****************************************************************************
//
// Converts a value to a mask where the corresponding bit is set
//
// ****************************************************************************
DWORD    UTIMaskDWord( IN WORD Pmval )
{
    DWORD LcMask;
    
    LcMask = 1;
    LcMask = ( LcMask << Pmval );
    return LcMask;
}

// ****************************************************************************
// EXTERN WORD UTIDWMask2Word()
// ***************************
//
// Input parameters :
// ****************
//
//      DWORD PmMask  :   a mask with at least one bit set
//
// Output parameters :
// *******************
//
//      NONE
// 
// Return value :
// **************
//
//      The number of the first set-bit found in the mask
//
// ****************************************************************************
//
//  Scan the mask bits from right to left, and returns the position of
// the first set_bit encountered
//                                 
// ****************************************************************************
WORD    UTIDWMask2Word( IN DWORD PmMask )
{
    WORD LcValue = 0;
    
    while (   ( LcValue < (sizeof(DWORD)*8) )
           && !( PmMask & 0x00000001 ) )
    {
        LcValue++;
        PmMask = PmMask >> 1;
    }

    return LcValue;
}
