// *************************************************************************
//
//  COPYRIGHT 1996-2000 DIGIGRAM. ALL RIGHTS RESERVED.
//
//  DIGIGRAM
//
// **************************************************************************

#if !defined(_ESIOCOMMANDS_H__INCLUDED_)
#define _ESIOCOMMANDS_H__INCLUDED_

#include "PIOCommands.h"

typedef enum
{
    eReg_BASE,
    eReg_CSM,
    eReg_CRM1,
    eReg_CRM2,
    eReg_CRM3,
    eReg_CRM4,
    eReg_CRM5,
    eReg_CRM6,
    eReg_CRM7,
    eReg_CRM8,
    eReg_CRM9,
    eReg_CRM10,
    eReg_CRM11,
    eReg_CRM12,

    eReg_ICR,
    eReg_CVR,
    eReg_ISR,
    eReg_RXHTXH,
    eReg_RXMTXM,
    eReg_RHLTXL,
    eReg_RESETDSP,

    eReg_CSUF,
    eReg_CSES,
    eReg_CRESMSB,
    eReg_CRESLSB,
    eReg_ADMACESMSB,
    eReg_ADMACESLSB,
    eReg_CONFES,

    eMaxPortLx

} LXPORT;

/**
* CESIOCommands class is used for a LXES cards as a communication interface with the card
* It is derived from CPIOCommands which is used as a common class for all cards.
* Instanciate an object of this class for a LXES and use the public methods of CPIOCommands
*/
class CESIOCommands : public CPIOCommands
{
public:
    /**
    *   Constructor. Create instance for a LXES card
    *   @param pIOPCIDevice  IN pointer to a IOPCIDevice object
    */
	CESIOCommands(IOPCIDevice* pIOPCIDevice, PKSPIN_LOCK pMsgSpinLock);
    /**
    *   Destructor
    */
	virtual ~CESIOCommands();

	virtual PKSPIN_LOCK GetMsgSpinLock(){return m_MsgLockPtr;}

    virtual DWORD   PIOReadPLXMailBox( BYTE PmMailBoxNumber);
    virtual BOOL    PIOWritePLXMailBox( BYTE PmMailBoxNumber, DWORD PmData);

    virtual VOID    PIODisableIrq( );
    virtual VOID    PIOEnableIrq( );
    virtual WORD    PIOSendMessage( INOUT PCMD_RMH_INFO PmPtrCmdRmh);

    virtual WORD    PIOSetClock( DWORD PmFreq, WORD PmClockType, DWORD PmSyncInputNum, BYTE PmClockFormat);
    virtual BOOL    PIOTestConfig( INOUT PWORD PmDspType );

    virtual WORD    PIOUpdateESConfig( DWORD PmConfES );
    virtual PVOID   PIOGetCSUFAddr(){ return m_aLXES[eReg_CSUF];}
    virtual DWORD   PIOReadMemBar(int offset){ return READ_REGISTER_ULONG(m_aLXES[eReg_BASE] + offset);}

    virtual BOOL    PIOCheckESPipeline();
    virtual BOOL    PIOWriteCRES(DWORD CresMsb, DWORD CresLsb, BOOL bBroadcast);
    virtual BOOL    PIOReadCRES(PDWORD addrCresMsb, DWORD nbDword );

    // not adequate, return
    virtual BOOL    PIOLoadXilinxFirst() { return TRUE;}
    virtual WORD    PIODownloadBootStrap( IN PBYTE PmEepromFile, DWORD PmEepromLength, IN PBYTE PmBootFile, DWORD PmBootLength ){ return SUCCESS;}
    virtual WORD    PIOEnablePhantomPowerSupply( WORD PmAudio, BOOL PmPermanent, BOOL PmEnable ) {return ED_INVALID_BOARD_AUDIO;}
	virtual WORD    PIOSetConfigSRC( WORD PmAudio, IN  SRC_CONFIG PmSrcConfig ) {return ED_INVALID_BOARD_AUDIO;}
    virtual WORD    PIOGetConfigSRC( WORD PmAudio, OUT SRC_CONFIG* PmSrcConfig, OUT BYTE* PmSrcRatio ) {return ED_INVALID_BOARD_AUDIO;}

    virtual WORD    PIOGetMACAddress( PBYTE PmMACAddressPtr /* array of 6 bytes */);
    virtual VOID    PIOGetESConfig( PDWORD PmConfES );

    virtual DWORD   PIOGetFrequencyRatio(){return m_FrequencyRatio;}
private :


protected:

    // not adequate, return error
    virtual BOOL    HALDspLoad( DWORD PmNbDSPBuff,IN LPFIRMWARE_BUFFER PmDSPBuff ){ return FALSE;}
    virtual BOOL    HALSendItDsp( DWORD PmNoIt ){return FALSE;}
    virtual DWORD   HALResetCHK( ){return ED_DSP_CRASHED;}
    virtual DWORD   HALReadRMHStatus( INOUT PCMD_RMH_INFO PmPtrCmdRmh ){ return ED_DSP_CRASHED;}

    virtual BOOL    HALXilinxReset( BOOL PmFirstXilinx );
    virtual BOOL    HALTestXilinx( ){ return FALSE;}
    virtual VOID    HALXlxOutFile( IN PBYTE PmTheFile, DWORD PmFileSize){ return;}

    virtual BOOL    HALSetAudioAnalogLevel( WORD PmBoardAudio, BOOL PmIsRecord ){ return FALSE; }
    virtual WORD    HALSetAudioSource( IN  WORD PmAudioNum, IN  BYTE  PmSource ){ return ED_INVALID_BOARD_AUDIO;}
    virtual BOOL    HALWriteOneCBit( WORD PmAudio, WORD PmBitIndex, BYTE PmBit ){ return FALSE;}
    virtual BOOL	HALReadCBitsBasic( WORD PmSyncInputNum, OUT PBYTE PmMode, OUT PDWORD PmFreq, OUT PBYTE PmUerExtra){ return FALSE;}
	virtual BOOL	HALReadCByte( WORD PmSyncInputNum, IN DWORD PmByteID, OUT PBYTE PmCByte ){ return FALSE;}
    virtual BOOL    HALSetInAudioEffect( WORD PmAudio, BOOL PmActivate, LONG PmCompThreshold, LONG PmCompRatio, LONG PmNoiseThreshold, LONG PmOutputGain ){return FALSE;}
    virtual WORD    HALGetAudioUer(  WORD PmSyncInputNum, OUT PBYTE PmSyncPtr, OUT PBYTE PmDataPtr,	OUT PDWORD  PmPhysFreq, IN  BOOL  PmWaitLong = FALSE){ return ED_INVALID_BOARD_AUDIO;}
    virtual BOOL    HALHandleCodecSpeedModes( DWORD PmFrequency, BOOLEAN PmUnMuteWhenDone ) {return FALSE;}

    virtual BOOL    HALWaitForBitValue_Timeout_ByteReg( IN PCXPORT          Pm8BitPort,
                                                        IN BYTE             PmBitToTest,
                                                        IN BOOLEAN          PmValue,
                                                        IN WORD             PmTimeout){ return FALSE;}
    // end error methods

    virtual BOOL    HALWaitForBitValue_Timeout_DWordReg( IN PCXPORT  Pm32BitPort,
                                                         IN DWORD    PmBitToTest,
                                                         IN BOOLEAN  PmValue,
                                                         IN WORD     PmTimeout);
    virtual DWORD   PIOTestAndAckIt( );

    virtual DWORD   HALDefaultConfig( );
    virtual WORD    HALSetClockDependency(  IN BYTE PmClockType );

	PKSPIN_LOCK		m_MsgLockPtr;
private:

    ULONG           m_WindowSize;
    PULONG          m_aLXES[eMaxPortLx];

    DWORD           m_ConfES;
    DWORD           m_FrequencyRatio;

	
	friend VOID DriverDebugFct( LPDWORD, LPDWORD );

};

#endif // !defined(_ESIOCOMMANDS_H__INCLUDED_)
 