// *************************************************************************
//
//  COPYRIGHT 1996-2000 DIGIGRAM. ALL RIGHTS RESERVED.
//
//  DIGIGRAM
//
// **************************************************************************

// Include header file
// *******************

#include "shared.h"            // debug mode
//#include "eeprom.h"            // 

#include "pcxerr_e.h"

#include "pci_conf.h"
#include "PIOCommands.h"
#include "lxprotocol.h"

#include "nt_lib.h"
#include "ntbuffer.h"

#include "minwave.h"

#include "ESIOCommands.h"


// Local definition
// ****************

#define FREE_ENTRY               0

// TAG_DEBUG_DRIVER : DEB

// Values for DRIVER_TRACE_REQ_INFO.driRequest
//
#define REQUEST_NULL                   0
#define REQUEST_DRIVER_INFO            1
#define REQUEST_GENERAL_INFO           2
#define REQUEST_PORT_INFO              3
#define REQUEST_REG_IMAGE_INFO         4
#define REQUEST_BOARD_REGISTER_SET     5
#define REQUEST_BOARD_INFO             6
#define REQUEST_BOARD_LEVEL_INFO       7
#define REQUEST_APPLI_INFO             8
#define REQUEST_VOIE_INFO              9
#define REQUEST_PIPE_INFO              10
#define REQUEST_STREAM_INFO            11
#define REQUEST_GEN_BUFFER_INFO        12
#define REQUEST_BUFFER_INFO            13
#define REQUEST_PHYS_MAP_INFO          14
#define REQUEST_FORCE                  15

// Bit values in AppliInfo Carac field
// ------------------------------------
#define AI_ALLOCATED_MASK        0x01
#define AI_PRIVATE_ATTRIB_MASK   0x02
#define AI_DHS_ATTRIB_MASK       0x04

// TAG_DEBUG_DRIVER : FIN

#define NOT_USED                 0xFF
#define REGISTER_HANDLE          0xFF
#define DEALLOCATE_BUFFER_VALUE  0xFFFF
#define CMD_DSP_DEALLOC          0xFFFF
#define MAX_BUFF_LIMIT           0x7FFF

#define VIRTUAL_AUDIO            0x01

// Local Mask definition
#define MASK_CARTEDSP      0xFE
#define MASK_CARTE         0x0F
#define MASK_DSP           0x07
#define MASK_1             1

// Out audio set levels  (OUT_AUDIO_SET_LEVEL_REQ_INFO)
// ************************************************
// Bits to validate levels (oslqValidationMask1)
// #define OUT_AUDIO_SET_LEVEL_ANALOG_MASK    0x00000001
// #define OUT_AUDIO_SET_LEVEL_DIGITAL_MASK   0x00000002
// #define OUT_AUDIO_SET_LEVEL_MONITOR_MASK   0x00000004
// #define OUT_AUDIO_SET_LEVEL_MUTE_MASK      0x00000008
// #define OUT_AUDIO_SET_LEVEL_MUTE_M1_MASK   0x00000010
// #define OUT_AUDIO_SET_LEVEL_MUTE_M2_MASK   0x00000020

#define OUT_AUDIO_SET_NUM_LEVEL (   OUT_AUDIO_SET_LEVEL_DIGITAL_MASK \
                                  | OUT_AUDIO_SET_LEVEL_MONITOR_MASK \
                                  | OUT_AUDIO_SET_LEVEL_MUTE_MASK    \
                                  | OUT_AUDIO_SET_LEVEL_MUTE_M1_MASK \
                                  | OUT_AUDIO_SET_LEVEL_MUTE_M2_MASK )

// In audio set levels  (IN_AUDIO_SET_LEVEL_REQ_INFO)
// **************************************************
// Bits to validate levels (islqValidationMask1)
#define IN_AUDIO_SET_LEVEL_ANALOG_MASK          0x00000001
#define IN_AUDIO_SET_LEVEL_DIGITAL_MASK         0x00000002
#define IN_AUDIO_SET_LEVEL_MICRO_MASK           0x00000004

// Out stream set levels
// *********************
#define OUT_STREAM_SET_PAN_LEVEL_CGV1           0x00000001
#define OUT_STREAM_SET_PAN_LEVEL_CGV2           0x00000002
#define OUT_STREAM_SET_PAN_LEVEL_CDV1           0x00000004
#define OUT_STREAM_SET_PAN_LEVEL_CDV2           0x00000008
#define OUT_STREAM_SET_LEVEL_STREAM1            0x00000010
#define OUT_STREAM_SET_LEVEL_STREAM2            0x00000020
#define OUT_STREAM_SET_MUTE_STREAM1             0x00000040
#define OUT_STREAM_SET_MUTE_STREAM2             0x00000080

#define UER_FREQUENCY_48k                       48000
#define UER_FREQUENCY_44_1k                     44100
#define UER_FREQUENCY_32k                       32000

#define MIN_RESP_HEADER_SIZE ( 4 * sizeof( DWORD ) )

// Local typedefs
// **************

// TAG_DEBUG_DRIVER : DEB

typedef struct  _APPLI_INFO {
    BYTE            Carac;
    BYTE            Reserved[7];
    LPDWORD         AdrBlkReq;
    LPDWORD         AdrBlkReqBoardPnp;
    LPDWORD         AdrBlkReqGpio;
    APP_STR_INFO    TbNomAppli;
    DWORD           WindowHandle;
    DWORD           WindowMessage;
    WORD            Error;
} APPLI_INFO, *PAPPLI_INFO;

typedef struct _VOIE_INFO {
    BYTE    Nat;            // 0: physical, 1: virtual audio
    BYTE    IndexAppli;     // 1-based 
    BYTE    AppAudioNum;    // 0-based audio index [0 to 1 on the pipe]
    BYTE    NumPipe;        // 0-based index of the Pipe Info Structure (below)
    WORD    AudioNum;       // 0-based DSP audio index [0 to 7 on 882]
} VOIE_INFO, *PVOIE_INFO;

typedef struct _PIPE_INFO {
    BYTE                    piNumPipeForDsp;
    BYTE                    piNumBoard;
    BYTE                    piNbAudio;
    BYTE                    piNbMaxFlux;
    DWORD                   piStreamMask;
    DWORDLONG               piPhysAudioMask;
    DWORDLONG               piPipeAudioMask;
    LPBC_HEADER_INFO        piAdrBlkReq;
    LPWAIT_NOTIFY_REQ_INFO  piAdrNotifyReq;         // ## FS (25/04/1997) --
    HANDLE_PIPE             piVioHandle;
    BOOLEAN                 piConversionEnded;      // ## FS (04/03/1997) --
    BOOLEAN                 piPendingNotify;        // ## FS (25/04/1997) --
    BOOLEAN                 piNotifiedNotReadYet;   // ## FS (16/04/1998) --
    BOOLEAN                 piResetAnaLevelsAction; 
    HANDLE_BUFFER           piHandleBuffers;
    DWORD                   piClockBoardNum;
    DWORD                   piFrequency;
    DWORD                   piSyncInputNum;
    DWORDLONG               piPipeInClockMask;
    DWORDLONG               piPipeOutClockMask;
    BYTE                    piClockSource;
    BOOLEAN                 piPipeIsOffline;        // ## MBR (12/03/2002) --
    WORD                    piError;
    DWORDLONG               piErrorPipe;
    DWORD                   piErrorStream;
	PVOID                   piParentIchWave;
} PIPE_INFO, *PPIPE_INFO;

// TAG_DEBUG_DRIVER : FIN

// Type of any driver entry point
// for syncrhonous or asynchronous fonctions
// ------------------------------------------
typedef  VOID   (* APH_ENTRY_FCT)( IN LPDWORD, OUT LPDWORD );
typedef  VOID   (* APH_ASYNC_ENTRY_FCT)( IN LPDWORD, OUT LPDWORD, IN PDWORD );


// Description type of a single driver command
// i.e entry point
// -------------------------------------------
typedef struct _COMMAND_INFO {

    WORD            cmdNum;     // Number of the driver command within its family
                                // or 0 if not affected
    APH_ENTRY_FCT   cmdFct;     // Handling function of the command

#ifdef DBG_VIEWER
    PCHAR           cmdFctName;
#endif

} COMMAND_INFO, * PCOMMAND_INFO ;

// Description type of a single driver command
// i.e entry point
// -------------------------------------------
typedef struct _ASYNC_COMMAND_INFO {

    WORD                cmdNum;     // Number of the driver command within
                                    // its family or 0 if not affected
    APH_ASYNC_ENTRY_FCT cmdFct;     // Handling function of the command

#ifdef DBG_VIEWER
    PCHAR               cmdFctName;
#endif

} ASYNC_COMMAND_INFO, * PASYNC_COMMAND_INFO ;


// Description type of a family of driver commands
// -----------------------------------------------
typedef struct _FAMILY_INFO {

    WORD            famNum;         // Number of the driver command family
                                    // or 0 if not affected
    WORD            famCmdNum;      // Number of command entries
                                    // within the family
    PCOMMAND_INFO   famCommands;    // The actual table of commands

} FAMILY_INFO, * PFAMILY_INFO ;

typedef struct _DISPATCH_INFO {

    WORD            dpFamNum;       // Number of family entries
    PFAMILY_INFO    dpFamilies;     // The actual table of families

} DISPATCH_INFO ;


// Local variables
// ***************

// FS - 03/12/96
// See also tables of driver entry points
// defined after the local function prototypes
// --------------------------------------------

// Variable used
STATIC    CHAR          DriverFilesPath[MAX_PCX_PATH_LEN];

STATIC    APPLI_INFO    TbAppliInfo[MAX_PCX_HANDLE];

STATIC    DRIVER_INFO   GeneralDriverInfo;

STATIC    VOIE_INFO     TbVoieInInfo[MAX_BOARD][MAX_BOARD_INPUTS];
STATIC    VOIE_INFO     TbVoieOutInfo[MAX_BOARD][MAX_BOARD_OUTPUTS];

STATIC    PIPE_INFO     TbPipeInInfo[MAX_DRV_INPIPE];
STATIC    PIPE_INFO     TbPipeOutInfo[MAX_DRV_OUTPIPE];

STATIC    PCX_TIME      TbOutStreamBytePos[MAX_DRV_OUTPIPE][MAX_STREAM_PIPE];

// Masks of all the started pipes.
//
STATIC    DWORDLONG     StartedPipeInMask  = 0;
STATIC    DWORDLONG     StartedPipeOutMask = 0;
	
	BYTE			APH_Boards_Count = 0;				// used to stop seeking for irrelevant dsp objects
	BOARD_INFO		APH_Board_Info_Array[MAX_BOARD];	// in a "single-card-driver", this would be in adapter common
	CProtocol*	    APH_Protocol_Array[MAX_BOARD];		// used to access to CNPProtocol objects
    CPIOCommands*	APH_Commands_Array[MAX_BOARD];		// used to access to CPIOCommands objects

// If a start on time code is asked:
//     StartOnTimeCodeInProgress : TRUE is a start on time code is asked and the
//                                 time-code start conditions are not yet filled.
//     StartOnTimeCodeBoardNum   : board testing the time-code start conditions.
//     StartOnTimeCode*Mask      : masks of pipes starting on the time-code start
//                                 conditions.
// StartOnTimeCodeBoardNum and StartOnTimeCode*Mask are relevant only if
// StartOnTimeCodeInProgress = TRUE.
//
STATIC    BOOLEAN       StartOnTimeCodeInProgress = FALSE;
STATIC    BYTE          StartOnTimeCodeBoardNum   = 0;
STATIC    DWORDLONG     StartOnTimeCodeInMask     = 0;
STATIC    DWORDLONG     StartOnTimeCodeOutMask    = 0;

// *************************************************************************
STATIC     TARGET_INFO  TbTargetInf[MAX_DRV_INPIPE + MAX_DRV_OUTPIPE];

// ## MBR (02/09/03) -- no more support for synchronous asynchronous
//                      family's ED_PENDING_OPERATION response
// STATIC      DWORD       LockedBoardsMask ;


// Entry points
// *************

// *************************************************************************
//                  General functions
// *************************************************************************
STATIC VOID     RegDeregFct(        IN LPDWORD, OUT LPDWORD );
STATIC VOID     SystemFeatureFct(   IN LPDWORD, OUT LPDWORD );
STATIC VOID     BoardHardFeatureFct(IN LPDWORD, OUT LPDWORD );
STATIC VOID     BoardSoftFeatureFct(IN LPDWORD, OUT LPDWORD );
STATIC VOID     BoardSyncClocksFct( IN LPDWORD, OUT LPDWORD );
STATIC VOID     ListAppliFct(       IN LPDWORD, OUT LPDWORD );
STATIC VOID     ListPipeFct(        IN LPDWORD, OUT LPDWORD );
STATIC VOID     DriverPathFct(      IN LPDWORD, OUT LPDWORD );
STATIC VOID     GetDspBuffersFct(   IN LPDWORD, OUT LPDWORD );
STATIC VOID     DspManageFct(       IN LPDWORD, OUT LPDWORD );
STATIC VOID     DspResourcesFct(    IN LPDWORD, OUT LPDWORD );
STATIC VOID     PipeDefFct(         IN LPDWORD, OUT LPDWORD );
STATIC VOID     PipeRemoveFct(      IN LPDWORD, OUT LPDWORD );
STATIC VOID     DspDebugFct(        IN LPDWORD, OUT LPDWORD );
STATIC VOID     DriverDebugFct(     IN LPDWORD, OUT LPDWORD );
STATIC VOID     DspRecoverFatalErr( IN LPDWORD, OUT LPDWORD );
STATIC VOID     GetApplicationAudioOwner( IN LPDWORD, OUT LPDWORD );
STATIC VOID     EffectContextFct(   IN LPDWORD, OUT LPDWORD );
STATIC VOID     TimeCodeFct(        IN LPDWORD, OUT LPDWORD );
STATIC VOID     ListSyncedPipesFct( IN LPDWORD, OUT LPDWORD );
STATIC VOID     InvalidCmd1(        IN LPDWORD, OUT LPDWORD );
STATIC VOID     GPIOFct(            IN LPDWORD, OUT LPDWORD );
STATIC VOID     BoostThreadFct(     IN LPDWORD, OUT LPDWORD );
STATIC VOID		IBLFct(				IN LPDWORD, OUT LPDWORD );
STATIC VOID		ESHWConfSetFct(		IN LPDWORD, OUT LPDWORD );

#ifdef DBG_VIEWER
#define ADD_CMD_TAB(a, b, c)	{a, b, c}
#else
#define ADD_CMD_TAB(a, b, c)	{a, b}
#endif


STATIC  COMMAND_INFO    GeneralCmdTab[] =
{
	ADD_CMD_TAB (	INVALID_CMD,            InvalidCmd1         , "InvalidCmd1"    ),
	ADD_CMD_TAB (   REG_CMD,                RegDeregFct         , "RegDeregFct"    ),
	ADD_CMD_TAB (   SYSTEM_FEATURE_CMD,     SystemFeatureFct    , "SystemFeatureF" ),
	ADD_CMD_TAB (   APP_LIST_CMD,           ListAppliFct        , "ListAppliFct"   ),
	ADD_CMD_TAB (   PIPES_LIST_CMD,         ListPipeFct         , "ListPipeFct"    ),
	ADD_CMD_TAB (   DRIVER_PATH_CMD,        DriverPathFct       , "DriverPathFct"  ),
	ADD_CMD_TAB (   DSP_MANAGE_CMD,         DspManageFct        , "DspManageFct"   ),
	ADD_CMD_TAB (   DSP_BUFF_ADDR_CMD,      GetDspBuffersFct    , "GetDspBuffersF" ),
	ADD_CMD_TAB (   IO_MANAGE_CMD,          InvalidCmd1         , "InvalidCmd1"    ),
	ADD_CMD_TAB (   PIPE_DEF_CMD,           PipeDefFct          , "PipeDefFct"     ),
	ADD_CMD_TAB (   PIPE_DEL_CMD,           PipeRemoveFct       , "PipeRemoveFct"  ),
	ADD_CMD_TAB (   BOARD_HARD_FEATURE_CMD, BoardHardFeatureFct , "BoardHardFeatu" ),
	ADD_CMD_TAB (   BOARD_SOFT_FEATURE_CMD, BoardSoftFeatureFct , "BoardSoftFeatu" ),
	ADD_CMD_TAB (   DSP_TRACE_CMD,          DspDebugFct         , "DspDebugFct"    ),
	ADD_CMD_TAB (   DSP_RECOVER_ERROR_CMD,  DspRecoverFatalErr  , "DspRec*FatalEr" ),
	ADD_CMD_TAB (   AUDIO_INFO_CMD,         GetApplicationAudioOwner , "GetApp*AudioOw" ),
	ADD_CMD_TAB (   EFFECT_CTXT_LOAD_CMD,   EffectContextFct    , "EffectContextF" ),
	ADD_CMD_TAB (   BOARD_CLOCK_CMD,        BoardSyncClocksFct  , "BoardSyncClock" ),
    ADD_CMD_TAB (   UNUSED_CMD,             InvalidCmd1         , "InvalidCmd1" ),
	ADD_CMD_TAB (   TIME_CODE_CMD,          TimeCodeFct         , "TimeCodeFct"    ),
	ADD_CMD_TAB (   DRIVER_TRACE_CMD,       DriverDebugFct      , "DriverDebugFct" ),
	ADD_CMD_TAB (   SYNCED_PIPES_CMD,       ListSyncedPipesFct  , "ListSyncedPipe" ),
	ADD_CMD_TAB (   GPIO_CMD,               GPIOFct             , "GPIOFct" ),
	ADD_CMD_TAB (   BOOST_THREAD_CMD,       BoostThreadFct      , "BoostThreadFct" ), // 23
    ADD_CMD_TAB (   DSP_RESOURCES_CMD,		DspResourcesFct     , "DspResourcesFct" ), // 24
    ADD_CMD_TAB (   IBL_CMD,                IBLFct				, "IBLFct" ), //25
    ADD_CMD_TAB (   ES_HW_CFG_CMD,          ESHWConfSetFct      , "ESHWConfSetFct" ), //26
};
#define GENERAL_CMD_ENTRIES     ( sizeof( GeneralCmdTab ) / sizeof( GeneralCmdTab[0] ) )

// ***********************************************************************
//                  Board Audio Control subfunctions
// ***********************************************************************
STATIC VOID     SetOutBoardAudioLevelsFct(  IN LPDWORD, OUT LPDWORD );
STATIC VOID     SetInBoardAudioLevelsFct(   IN LPDWORD, OUT LPDWORD );
STATIC VOID     SetInBoardAudioEffect(      IN LPDWORD, OUT LPDWORD );
STATIC VOID     SetInBoardAudioParam(       IN LPDWORD, OUT LPDWORD );
STATIC VOID     InvalidCmd2(                IN LPDWORD, OUT LPDWORD );

STATIC  COMMAND_INFO    BoardAudioControlCmdTab[] =
{
	ADD_CMD_TAB (   INVALID_CMD,                InvalidCmd2               , "InvalidCmd2"    ),
	ADD_CMD_TAB (   OUT_AUDIO_SET_LEVELS_CMD,   SetOutBoardAudioLevelsFct , "SetOutBoardA*L" ),
	ADD_CMD_TAB (   IN_AUDIO_SET_LEVELS_CMD,    SetInBoardAudioLevelsFct  , "SetInBoardA*Le" ),
	ADD_CMD_TAB (   IN_AUDIO_SET_EFFECT_CMD,    SetInBoardAudioEffect     , "SetInBoardA*Ef" ),
	ADD_CMD_TAB (   IN_AUDIO_SET_PARAM_CMD,     SetInBoardAudioParam      , "SetInBoardA*Pa" )
};
#define BOARD_AUDIO_CTRL_CMD_ENTRIES     ( sizeof( BoardAudioControlCmdTab ) / sizeof( BoardAudioControlCmdTab[0] ) )


// ***********************************************************************
//                 Pipe Control subfunctions
// ***********************************************************************
STATIC VOID     StartPipeFct(       IN LPDWORD, OUT LPDWORD );
STATIC VOID     PausePipeFct(       IN LPDWORD, OUT LPDWORD );
STATIC VOID     StopPipeFct(        IN LPDWORD, OUT LPDWORD );
STATIC VOID     SetOutPipeSettings( IN LPDWORD, OUT LPDWORD );
STATIC VOID     SetOutPipeEffects(  IN LPDWORD, OUT LPDWORD );
STATIC VOID     SetInPipeSettings(  IN LPDWORD, OUT LPDWORD );
STATIC VOID     OfflineLoopFct(     IN LPDWORD, OUT LPDWORD );
STATIC VOID     SampleClockPipeFct( IN LPDWORD, OUT LPDWORD );
STATIC VOID     NotifyPipeTimeFct(  IN LPDWORD, OUT LPDWORD );
STATIC VOID     PurgeDCmdsFct(      IN LPDWORD, OUT LPDWORD );
STATIC VOID     MonitoringChangeFct(IN LPDWORD, OUT LPDWORD );
STATIC VOID     InvalidCmd3(        IN LPDWORD, OUT LPDWORD );

STATIC  COMMAND_INFO    PipeControlCmdTab[] =
{
	ADD_CMD_TAB (   INVALID_CMD,            InvalidCmd3         , "InvalidCmd3"    ),
	ADD_CMD_TAB (   START_PIPES_CMD,        StartPipeFct        , "StartPipeFct"   ),
	ADD_CMD_TAB (   PAUSE_PIPES_CMD,        PausePipeFct        , "PausePipeFct"   ),
	ADD_CMD_TAB (   STOP_PIPES_CMD,			StopPipeFct         , "StopPipeFct"    ),
	ADD_CMD_TAB (   OUT_PIPES_SETTINGS_CMD, SetOutPipeSettings  , "SetOutPipeSett" ),
	ADD_CMD_TAB (   OUT_PIPES_EFFECTS_CMD,  SetOutPipeEffects   , "SetOutPipeEffe" ),
	ADD_CMD_TAB (   IN_PIPES_SETTINGS_CMD,  SetInPipeSettings   , "SetInPipeSetti" ),
	ADD_CMD_TAB (   OFFLINE_LOOPS_CMD,      OfflineLoopFct      , "OfflineLoopFct" ),
    ADD_CMD_TAB (   SAMPLE_CLOCK_CMD,       SampleClockPipeFct  , "SampleClockPip" ),
	ADD_CMD_TAB (   NOTIFY_TIME_CMD,        NotifyPipeTimeFct   , "NotifyPipeTime" ),
	ADD_CMD_TAB (   PURGE_DCMDS_CMD,        PurgeDCmdsFct       , "PurgeDCmdsFct" ),
	ADD_CMD_TAB (   CHANGE_MONIT_SOURCE_CMD,MonitoringChangeFct , "MonitoringChan" ),
};
#define PIPE_CTRL_CMD_ENTRIES     ( sizeof( PipeControlCmdTab ) / sizeof( PipeControlCmdTab[0] ) )

// ***********************************************************************
//                  Pipe Audio Control subfunctions
// ***********************************************************************
STATIC VOID     SetOutAudioLevelsFct(   IN LPDWORD, OUT LPDWORD );
STATIC VOID     SetInAudioLevelsFct(    IN LPDWORD, OUT LPDWORD );
STATIC VOID     SetInPipeAudioEffect(   IN LPDWORD, OUT LPDWORD );
STATIC VOID     InvalidCmd4(            IN LPDWORD, OUT LPDWORD );

STATIC  COMMAND_INFO    PipeAudioControlCmdTab[] =
{
	ADD_CMD_TAB (   INVALID_CMD,                InvalidCmd4          , "InvalidCmd4"    ),
	ADD_CMD_TAB (   OUT_AUDIO_SET_LEVELS_CMD,   SetOutAudioLevelsFct , "SetOutAudioLev" ),
	ADD_CMD_TAB (   IN_AUDIO_SET_LEVELS_CMD,    SetInAudioLevelsFct  , "SetInAudioLeve" ),
	ADD_CMD_TAB (   IN_AUDIO_SET_EFFECT_CMD,    SetInPipeAudioEffect , "SetInP*Aud*Eff" )
};
#define PIPE_AUDIO_CTRL_CMD_ENTRIES     ( sizeof( PipeAudioControlCmdTab ) / sizeof( PipeAudioControlCmdTab[0] ) )

// ***********************************************************************
//                 Pipe Stream Control subfunctions
// ***********************************************************************
STATIC VOID     StartStreamFct(     IN LPDWORD, OUT LPDWORD );
STATIC VOID     PauseStreamFct(     IN LPDWORD, OUT LPDWORD );
STATIC VOID     StopStreamFct(      IN LPDWORD, OUT LPDWORD );
STATIC VOID     SetOutStreamSettings(IN LPDWORD,OUT LPDWORD );
STATIC VOID     SetOutStreamLevels( IN LPDWORD, OUT LPDWORD );
STATIC VOID     SetOutStreamEffects( IN LPDWORD, OUT LPDWORD );
STATIC VOID     SetInStreamSettings(IN LPDWORD, OUT LPDWORD );
STATIC VOID     SetOutStreamLCurve( IN LPDWORD, OUT LPDWORD );
STATIC VOID     NotifyStreamTimeFct(IN LPDWORD, OUT LPDWORD );
STATIC VOID     CancelStreamBufFct( IN LPDWORD, OUT LPDWORD );
STATIC VOID     CancelBufPauseFct(  IN LPDWORD, OUT LPDWORD );
STATIC VOID     InvalidCmd5(        IN LPDWORD, OUT LPDWORD );

STATIC  COMMAND_INFO    PipeStreamControlCmdTab[] =
{
	ADD_CMD_TAB (   INVALID_CMD,                InvalidCmd5         , "InvalidCmd5"    ),
	ADD_CMD_TAB (   START_STREAM_CMD,           StartStreamFct      , "StartStreamFct" ),
	ADD_CMD_TAB (   PAUSE_STREAM_CMD,           PauseStreamFct      , "PauseStreamFct" ),
	ADD_CMD_TAB (   STOP_STREAM_CMD,            StopStreamFct       , "StopStreamFct"  ),
	ADD_CMD_TAB (   RESERVED_STREAM_CMD,        InvalidCmd5         , "InvalidCmd5"    ),  // reserved for backward compatibity
    ADD_CMD_TAB (   OUT_STREAM_SETTINGS_CMD,    SetOutStreamSettings, "SetOutStreamSe" ),
    ADD_CMD_TAB (   OUT_STREAM_LEVELS_CMD,      SetOutStreamLevels  , "SetOutStreamLe" ),
    ADD_CMD_TAB (   SET_OUT_STREAM_EFFECTS_CMD, SetOutStreamEffects , "SetOutStreamEf" ),
    ADD_CMD_TAB (   IN_STREAM_SETTINGS_CMD,     SetInStreamSettings , "SetInStreamSet" ),
    ADD_CMD_TAB (   OUT_STREAM_LCURVE_CMD,      SetOutStreamLCurve  , "SetOutStreamLC" ),
    ADD_CMD_TAB (   NOTIFY_STREAM_TIME_CMD,     NotifyStreamTimeFct , "NotifyStreamTi" ),
    ADD_CMD_TAB (   CANCEL_STR_BUFFER_CMD,      CancelStreamBufFct  , "CancelStreamBu" ),
    ADD_CMD_TAB (   CANCEL_BUFFER_PAUSE_CMD,    CancelBufPauseFct   , "CancelBufPause" ),
};
#define PIPE_STREAM_CTRL_CMD_ENTRIES     ( sizeof( PipeStreamControlCmdTab ) / sizeof( PipeStreamControlCmdTab[0] ) )

// *************************************************************************
//                  Status functions
// *************************************************************************

// ***********************************************************************
//                 Pipe Status subfunctions
// ***********************************************************************
STATIC VOID     PipeSampleCountFct( IN LPDWORD, OUT LPDWORD );
STATIC VOID     PipeStateFct(       IN LPDWORD, OUT LPDWORD );
STATIC VOID     PipeGetNotificationFct( IN LPDWORD, OUT LPDWORD );
STATIC VOID     PipeGetClockFct(    IN LPDWORD, OUT LPDWORD );
STATIC VOID     InvalidCmd6(        IN LPDWORD, OUT LPDWORD );

STATIC  COMMAND_INFO    PipeStatusCmdTab[] =
{
    ADD_CMD_TAB (   INVALID_CMD,                InvalidCmd6             , "InvalidCmd6" ),
    ADD_CMD_TAB (   SAMPLE_COUNTING_CMD,        PipeSampleCountFct      , "PSpl" ),
    ADD_CMD_TAB (   PIPE_STATE_CMD,             PipeStateFct            , "PSte" ),
    ADD_CMD_TAB (   PIPE_GET_NOTIFICATION_CMD,  PipeGetNotificationFct  , "PipeGetNotific" ),
    ADD_CMD_TAB (   PIPE_GET_CLOCK_CMD,         PipeGetClockFct         , "PipeGetClockFc" ),
};
#define PIPE_STAT_CMD_ENTRIES     ( sizeof( PipeStatusCmdTab ) / sizeof( PipeStatusCmdTab[0] ) )

// ***********************************************************************
//                 Pipe Audio Status subfunctions
// ***********************************************************************
STATIC VOID     GetAudioUerFct(         IN LPDWORD, OUT LPDWORD );
STATIC VOID     AudioVPMeterFct(        IN LPDWORD, OUT LPDWORD );
STATIC VOID     GetOutAudioLevelsFct(   IN LPDWORD, OUT LPDWORD );
STATIC VOID     GetInAudioLevelsFct(    IN LPDWORD, OUT LPDWORD );
STATIC VOID     InvalidCmd7(            IN LPDWORD, OUT LPDWORD );

STATIC  COMMAND_INFO    PipeAudioStatusCmdTab[] =
{
    ADD_CMD_TAB (   INVALID_CMD,                InvalidCmd7          , "InvalidCmd7"    ),
    ADD_CMD_TAB (   AUDIO_VU_PEAK_METERS_CMD,   AudioVPMeterFct      , "AVu" ),
    ADD_CMD_TAB (   UER_CMD,                    GetAudioUerFct       , "GetAudioUerFct" ),
    ADD_CMD_TAB (   OUT_AUDIO_GET_LEVELS_CMD,   GetOutAudioLevelsFct , "GetOutAudioLev" ),
    ADD_CMD_TAB (   IN_AUDIO_GET_LEVELS_CMD,    GetInAudioLevelsFct  , "GetInAudioLeve" ),
};
#define PIPE_AUDIO_STAT_CMD_ENTRIES     ( sizeof( PipeAudioStatusCmdTab ) / sizeof( PipeAudioStatusCmdTab[0] ) )

// ***********************************************************************
//                 Pipe Stream Status subfunctions
// ***********************************************************************
STATIC VOID     StreamVPMeter(       IN LPDWORD, OUT LPDWORD );
STATIC VOID     StreamStateFct(      IN LPDWORD, OUT LPDWORD );
STATIC VOID     StreamSampleFct(     IN LPDWORD, OUT LPDWORD );
STATIC VOID     StreamByteFct(		 IN LPDWORD, OUT LPDWORD );
STATIC VOID     StreamPositionFct(   IN LPDWORD, OUT LPDWORD );
STATIC VOID     StreamLevelsFct(     IN LPDWORD, OUT LPDWORD );
STATIC VOID     GetOutStreamEffects( IN LPDWORD, OUT LPDWORD );
STATIC VOID     InvalidCmd8(         IN LPDWORD, OUT LPDWORD );

STATIC  COMMAND_INFO    PipeStreamStatusCmdTab[] =
{
    ADD_CMD_TAB (   INVALID_CMD,                InvalidCmd8         , "InvalidCmd8"    ),
    ADD_CMD_TAB (   STREAM_VU_PEAK_METERS_CMD,  StreamVPMeter       , "SVu"  ),
    ADD_CMD_TAB (   STREAM_STATE_CMD,           StreamStateFct      , "?" ),
    ADD_CMD_TAB (   STREAM_SAMPLE_CMD,          StreamSampleFct     , "@" ),
    ADD_CMD_TAB (   STREAM_BYTE_CMD,            StreamByteFct       , "StreamByteFct" ),
    ADD_CMD_TAB (   STREAM_POSITION_CMD,        StreamPositionFct   , "^" ),
    ADD_CMD_TAB (   OUT_STREAM_GET_LEVELS_CMD,  StreamLevelsFct     , "StreamLevelsFct" ),
    ADD_CMD_TAB (   GET_OUT_STREAM_EFFECTS_CMD, GetOutStreamEffects , "GetOutStreamEf" ),
};
#define PIPE_STREAM_STAT_CMD_ENTRIES     ( sizeof( PipeStreamStatusCmdTab ) / sizeof( PipeStreamStatusCmdTab[0] ) )

// ***********************************************************************
//                  Play - RECORD functions
// *************************************************************************
STATIC VOID     PlayFct(            IN LPDWORD, OUT LPDWORD, IN PDWORD );
STATIC VOID     RecordFct(          IN LPDWORD, OUT LPDWORD, IN PDWORD );
STATIC VOID     InvalidCmd9(        IN LPDWORD, OUT LPDWORD, IN PDWORD );

STATIC  ASYNC_COMMAND_INFO    PlayRecordCmdTab[] =
{
    ADD_CMD_TAB (   INVALID_CMD,    InvalidCmd9             , "InvalidCmd9" ),
    ADD_CMD_TAB (   PLAY_CMD,       PlayFct                 , "P"     ),
    ADD_CMD_TAB (   RECORD_CMD,     RecordFct               , "R"   ),
};
#define PLAYREC_CMD_ENTRIES     ( sizeof( PlayRecordCmdTab ) / sizeof( PlayRecordCmdTab[0] ) )

// *************************************************************************
//                  Asynchronous functions
// *************************************************************************
STATIC VOID     WaitErrorFct(           IN LPDWORD, OUT LPDWORD, IN PDWORD );
STATIC VOID     WaitEndOfPlayFct(       IN LPDWORD, OUT LPDWORD, IN PDWORD );
STATIC VOID     WaitEndOfRecordFct(     IN LPDWORD, OUT LPDWORD, IN PDWORD );
STATIC VOID     WaitForNotificationFct( IN LPDWORD, OUT LPDWORD, IN PDWORD );
STATIC VOID     WaitBoardPnpFct(        IN LPDWORD, OUT LPDWORD, IN PDWORD );
STATIC VOID     WaitGpioEventFct(       IN LPDWORD, OUT LPDWORD, IN PDWORD );
STATIC VOID     InvalidCmd10(           IN LPDWORD, OUT LPDWORD, IN PDWORD );

STATIC  ASYNC_COMMAND_INFO    AsynchronousCmdTab[] = {
    ADD_CMD_TAB (   INVALID_CMD,            InvalidCmd10            , "InvalidCmd10" ),
    ADD_CMD_TAB (   WAIT_ERROR_CMD,         WaitErrorFct            , "WaitErrorFct" ),
    ADD_CMD_TAB (   WAIT_ENDOF_PLAY_CMD,    WaitEndOfPlayFct        , "WaitEndOfPlayF" ),
    ADD_CMD_TAB (   WAIT_ENDOF_RECORD_CMD,  WaitEndOfRecordFct      , "WaitEndOfRecor" ),
    ADD_CMD_TAB (   WAIT_NOTIFICATION_CMD,  WaitForNotificationFct  , "WaitForNotific" ),
    ADD_CMD_TAB (   WAIT_BOARD_PNP_CMD,     WaitBoardPnpFct         , "WaitBoardPnpFc" ),
    ADD_CMD_TAB (   WAIT_GPIO_EVENT_CMD,    WaitGpioEventFct        , "WaitGpioEventF" ),
};
#define ASYNC_CMD_ENTRIES     ( sizeof( AsynchronousCmdTab ) / sizeof( AsynchronousCmdTab[0] ) )

// *************************************************************************
//                  Driver private functions
// *************************************************************************
STATIC VOID     InvalidCmd11(       IN LPDWORD, OUT LPDWORD );

STATIC  COMMAND_INFO    PrivateCmdTab[] =
{
    ADD_CMD_TAB (   INVALID_CMD,            InvalidCmd11            , "InvalidCmd11" ),
    ADD_CMD_TAB (   RESERVED_PRIVATE_CMD,   InvalidCmd11            , "InvalidCmd11" ),
};
#define PRIVATE_CMD_ENTRIES     ( sizeof( PrivateCmdTab ) / sizeof( PrivateCmdTab[0] ) )

// ***********************************************************************
//                 Board Audio Status subfunctions
// ***********************************************************************
STATIC VOID     GetBoardAudioUerFct(         IN LPDWORD, OUT LPDWORD );
STATIC VOID     BoardAudioVPMeterFct(        IN LPDWORD, OUT LPDWORD );
STATIC VOID     GetOutBoardAudioLevelsFct(   IN LPDWORD, OUT LPDWORD );
STATIC VOID     GetInBoardAudioLevelsFct(    IN LPDWORD, OUT LPDWORD );
STATIC VOID     GetInAudioCByteFct(          IN LPDWORD, OUT LPDWORD );
STATIC VOID     InvalidCmd12(                IN LPDWORD, OUT LPDWORD );

STATIC  COMMAND_INFO    BoardAudioStatusCmdTab[] =
{
    ADD_CMD_TAB (   INVALID_CMD,                InvalidCmd12              , "InvalidCmd12"   ),
    ADD_CMD_TAB (   AUDIO_VU_PEAK_METERS_CMD,   BoardAudioVPMeterFct      , "BVu" ),
    ADD_CMD_TAB (   UER_CMD,                    GetBoardAudioUerFct       , "GetBoardAu*Uer" ),
    ADD_CMD_TAB (   OUT_AUDIO_GET_LEVELS_CMD,   GetOutBoardAudioLevelsFct , "GetOutBoardA*L" ),
    ADD_CMD_TAB (   IN_AUDIO_GET_LEVELS_CMD,    GetInBoardAudioLevelsFct  , "GetInBoardAudi" ),
    ADD_CMD_TAB (   IN_AUDIO_GET_CBYTE_CMD,     GetInAudioCByteFct        , "GetInAudioCByF" ),
};
#define BOARD_AUDIO_STAT_CMD_ENTRIES     ( sizeof( BoardAudioStatusCmdTab ) / sizeof( BoardAudioStatusCmdTab[0] ) )


// *************************************************************************
//                  Full list of entry points
// *************************************************************************

STATIC  FAMILY_INFO FamiliesTab[] =
{
    {   INVALID_FAM,            0,                              ((PCOMMAND_INFO) 0)     },
    {   GENE_FAM,               GENERAL_CMD_ENTRIES,            GeneralCmdTab           },
    {   IO_BOARD_CTRL_FAM,      BOARD_AUDIO_CTRL_CMD_ENTRIES,   BoardAudioControlCmdTab },
    {   PIPE_CTRL_FAM,          PIPE_CTRL_CMD_ENTRIES,          PipeControlCmdTab       },
    {   IO_PIPE_CTRL_FAM,       PIPE_AUDIO_CTRL_CMD_ENTRIES,    PipeAudioControlCmdTab  },
    {   STREAM_PIPE_CTRL_FAM,   PIPE_STREAM_CTRL_CMD_ENTRIES,   PipeStreamControlCmdTab },
    {   PIPE_STATUS_FAM,        PIPE_STAT_CMD_ENTRIES,          PipeStatusCmdTab        },
    {   IO_PIPE_STATUS_FAM,     PIPE_AUDIO_STAT_CMD_ENTRIES,    PipeAudioStatusCmdTab   },
    {   STREAM_PIPE_STATUS_FAM, PIPE_STREAM_STAT_CMD_ENTRIES,   PipeStreamStatusCmdTab  },
    {   PLAY_RECORD_FAM,        PLAYREC_CMD_ENTRIES,            (PCOMMAND_INFO) PlayRecordCmdTab   },
    {   ASYNC_EVT_FAM,          ASYNC_CMD_ENTRIES,              (PCOMMAND_INFO) AsynchronousCmdTab },
    {   PRIVATE_FAM,            PRIVATE_CMD_ENTRIES,            PrivateCmdTab           },
    {   IO_BOARD_STATUS_FAM,    BOARD_AUDIO_STAT_CMD_ENTRIES,   BoardAudioStatusCmdTab  },
};
#define FAMILY_ENTRIES     ( sizeof( FamiliesTab ) / sizeof( FamiliesTab[0] ) )

STATIC  DISPATCH_INFO   DispatchInfo = { FAMILY_ENTRIES, FamiliesTab };

// Local functions
// ****************

// *************************************************************************
//            Validity checks for parameters
// *************************************************************************
STATIC BOOLEAN  ControlTheHandle( IN LPDWORD, OUT LPDWORD );

STATIC BOOLEAN  CopyHeaderBlcRet( IN LPDWORD, OUT LPDWORD, IN PDWORD );

STATIC WORD     ChkPmOneOutputPipeMask( IN  BYTE          ,
                                        IN  DWORDLONG     ,
                                        OUT PWORD         ,
                                        OUT PPIPE_INFO   *,
                                        OUT PVOIE_INFO   *,
                                        OUT PTARGET_INFO );

STATIC WORD     ChkPmOneInputPipeMask(  IN BYTE          ,
                                        IN DWORDLONG     ,
                                        OUT PWORD        ,
                                        OUT PPIPE_INFO  *,
                                        OUT PVOIE_INFO  *,
                                        OUT PTARGET_INFO );

STATIC WORD     ChkPmOneInOrOutPipeMask(    IN  BYTE         ,
                                            IN  DWORDLONG    ,
                                            IN  DWORDLONG    ,
                                            OUT PWORD        ,
                                            OUT PPIPE_INFO  *,
                                            OUT PVOIE_INFO  *,
                                            OUT PTARGET_INFO );


STATIC WORD     ChkPmManyOutputPipeMask( IN BYTE, IN DWORDLONG );
STATIC WORD     ChkPmManyInputPipeMask(  IN BYTE, IN DWORDLONG );

STATIC WORD     ChkPmManyInOrOutPipeMask(   IN  BYTE,
                                            IN  DWORDLONG,
                                            IN  DWORDLONG );


// *************************************************************************
//       Application handle <-> internal index conversion functions
// *************************************************************************
STATIC inline BYTE EncodeHandle(
    IN BYTE PmIndex )
{
    return ( ++PmIndex );
}

STATIC inline BYTE DecodeHandle(
    IN BYTE PmHandle )
{
    return ( --PmHandle );
}

// *************************************************************************
//
// STATIC WORD ChkPmOneOutputPipeMask( IN BYTE, IN DWORDLONG,
//                                     OUT PWORD, OUT PPIPE_INFO *,
//                                     OUT PVOIE_INFO *, OUT PTARGET_INFO )
//
// Input Parameters:
// *****************
//
//  BYTE            PmAppIndex      :   the application index
//  DWORDLONG       PmPipeMask      :   the output pipe mask to check
//
//
// Output Parameters:
// ******************
//
//  PWORD           PmPipeIndexPtr    :  The pipe index if param is checked
//  PPIPE_INFO      *PmPipeInfoTabPtr :  The corresponding PIPE_INFO structure pointer adress
//  PVOIE_INFO      *PmVoieInfoTabPtr :  The corresponding VOIE_INFO structure pointer adress
//  PTARGET_INFO    PmTargetPtr       :  The TARGET_INFO pointer
//
//
// *************************************************************************
//
//  Verify a mask indicates an output pipe that belongs to the
// application. If so returns SUCCESS and gives the corresponding
// index, otherwise returns an appropriate error code.
//
// We fill as much as we can the TARGET_INFO.
//
// *************************************************************************
STATIC WORD ChkPmOneOutputPipeMask(
    IN  BYTE            PmAppIndex       ,
    IN  DWORDLONG       PmPipeMask       ,
    OUT PWORD           PmPipeIndexPtr   ,
    OUT PPIPE_INFO      *PmPipeInfoTabPtr,
    OUT PVOIE_INFO      *PmVoieInfoTabPtr,
    OUT PTARGET_INFO    PmTargetPtr )
{
    WORD    LcOutPipeIndex ;
    PVOIE_INFO  LcVoieInfo ;
    PPIPE_INFO  LcPipeInfo ;

    // verify this mask specify one pipe ...
    // **********************************************
    if ( PmPipeMask == 0 )
    {
        EXIT_PCX_ERROR( ED_INVALID_PIPE );
    }

    LcOutPipeIndex = UTI64Mask2Word( PmPipeMask ) ;

    // ... and only one pipe
    // **********************************************
    if ( PmPipeMask & ~UTIMask64bit( LcOutPipeIndex ) )
    {
        EXIT_PCX_ERROR( ED_MANY_PIPES_REFUSED );
    }

    // does the pipe actually belongs to the application ?
    // ***************************************************
    if (   ( LcOutPipeIndex >= MAX_DRV_OUTPIPE )
        || ( TbPipeOutInfo[LcOutPipeIndex].piNbAudio == 0)
        || ( TbPipeOutInfo[LcOutPipeIndex].piNumPipeForDsp >= MAX_BOARD_OUTPUTS)
        || ( TbPipeOutInfo[LcOutPipeIndex].piNumBoard >= MAX_BOARD))
    {
        EXIT_PCX_ERROR( ED_INVALID_PIPE );
    }

    LcPipeInfo = &TbPipeOutInfo[LcOutPipeIndex];
    LcVoieInfo = &TbVoieOutInfo[LcPipeInfo->piNumBoard][LcPipeInfo->piNumPipeForDsp];

    if (   ( LcVoieInfo->IndexAppli != (PmAppIndex + 1))
        || ( LcVoieInfo->NumPipe != LcOutPipeIndex) )
    {
        EXIT_PCX_ERROR( ED_INVALID_PIPE );
    }

    // Parameter is correct
    // ********************
    *PmPipeIndexPtr     = LcOutPipeIndex ;
    *PmPipeInfoTabPtr   = LcPipeInfo;
    *PmVoieInfoTabPtr   = LcVoieInfo;

    // Fill target info structure
    // ***************************
    PmTargetPtr->tgCarte            =   LcPipeInfo->piNumBoard;
    PmTargetPtr->tgPipe             =   LcPipeInfo->piNumPipeForDsp;
    PmTargetPtr->tgCaracPipeVoie    =   OPER_PLAY;
    PmTargetPtr->tgAudio            =   LcVoieInfo->AudioNum;
    PmTargetPtr->tgVioHandle        =   LcPipeInfo->piVioHandle;

    return SUCCESS ;
}

// *************************************************************************
//
// STATIC WORD ChkPmOneInputPipeMask( IN BYTE, IN DWORDLONG,
//                                    OUT PWORD, OUT PPIPE_INFO *,
//                                    OUT PVOIE_INFO *, OUT PTARGET_INFO )
//
// Input Parameters:
// *****************
//
//  BYTE            PmAppIndex      :   The application index
//  DWORDLONG       PmPipeMask      :   The input pipe mask to check
//
//
// Output Parameters:
// ******************
//
//  PWORD           PmPipeIndexPtr    :  The pipe index if param is checked
//  PPIPE_INFO      *PmPipeInfoTabPtr :  The corresponding PIPE_INFO structure pointer adress
//  PVOIE_INFO      *PmVoieInfoTabPtr :  The corresponding VOIE_INFO structure pointer adress
//  PTARGET_INFO    PmTargetPtr       :  The TARGET_INFO pointer
//
// *************************************************************************
//
//  Verify a mask indicates an input pipe that belongs to the
// application. If so returns SUCCESS and gives the corresponding
// index, otherwise returns an appropriate error code.
//
// We fill as much as we can the TARGET_INFO.
//
// *************************************************************************
STATIC WORD ChkPmOneInputPipeMask(
    IN  BYTE            PmAppIndex       ,
    IN  DWORDLONG       PmPipeMask       ,
    OUT PWORD           PmPipeIndexPtr   ,
    OUT PPIPE_INFO      *PmPipeInfoTabPtr,
    OUT PVOIE_INFO      *PmVoieInfoTabPtr,
    OUT PTARGET_INFO    PmTargetPtr )
{
    WORD    LcInPipeIndex ;
    PVOIE_INFO  LcVoieInfo;
    PPIPE_INFO  LcPipeInfo;

    // verify this mask specify one pipe ...
    // **********************************************
    if ( PmPipeMask == 0 )
    {
        EXIT_PCX_ERROR( ED_INVALID_PIPE );
    }

    LcInPipeIndex = UTI64Mask2Word( PmPipeMask ) ;

    // ... and only one pipe
    // **********************************************
    if ( PmPipeMask & ~UTIMask64bit( LcInPipeIndex ) )
    {
        EXIT_PCX_ERROR( ED_MANY_PIPES_REFUSED );
    }

    // does the pipe actually belongs to the application ?
    // ***************************************************
    if (   ( LcInPipeIndex >= MAX_DRV_INPIPE )
        || ( TbPipeInInfo[LcInPipeIndex].piNbAudio == 0)
        || ( TbPipeInInfo[LcInPipeIndex].piNumPipeForDsp >= MAX_BOARD_INPUTS)
        || ( TbPipeInInfo[LcInPipeIndex].piNumBoard >= MAX_BOARD))
    {
        EXIT_PCX_ERROR( ED_INVALID_PIPE );
    }

    LcPipeInfo = &TbPipeInInfo[LcInPipeIndex];
    LcVoieInfo = &TbVoieInInfo[LcPipeInfo->piNumBoard][LcPipeInfo->piNumPipeForDsp];

    if (   ( LcVoieInfo->IndexAppli != (PmAppIndex + 1))
        || ( LcVoieInfo->NumPipe != LcInPipeIndex) )
    {
        EXIT_PCX_ERROR( ED_INVALID_PIPE );
    }

    // Parameter is correct
    // ********************
    *PmPipeIndexPtr     = LcInPipeIndex ;
    *PmPipeInfoTabPtr   = LcPipeInfo;
    *PmVoieInfoTabPtr   = LcVoieInfo;

    // Fill target info structure
    // ***************************
    PmTargetPtr->tgCarte            =   LcPipeInfo->piNumBoard;
    PmTargetPtr->tgPipe             =   LcPipeInfo->piNumPipeForDsp;
    PmTargetPtr->tgCaracPipeVoie    =   OPER_REC;
    PmTargetPtr->tgAudio            =   LcVoieInfo->AudioNum;
    PmTargetPtr->tgVioHandle        =   LcPipeInfo->piVioHandle;

    return SUCCESS;
}

// *************************************************************************
//
// STATIC WORD ChkPmOneInOrOutPipeMask( IN BYTE, IN DWORDLONG, IN DWORDLONG
//                                      OUT PWORD, OUT PPIPE_INFO *,
//                                      OUT PVOIE_INFO *, OUT PWORD, OUT PTARGET_INFO )
//
// Input Parameters:
// *****************
//
//  BYTE            PmAppIndex      :   The application index
//  DWORDLONG       PmOutPipeMask   :   The output pipe mask to check or 0.
//  DWORDLONG       PnInPipeMask    :   The input pipe mask to check or 0.
//
//
// Output Parameters:
// ******************
//
//  PWORD           PmPipeIndexPtr    :  The pipe index if param is checked
//  PPIPE_INFO      *PmPipeInfoTabPtr :  The corresponding PIPE_INFO structure pointer adress
//  PVOIE_INFO      *PmVoieInfoTabPtr :  The corresponding VOIE_INFO structure pointer adress
//  PWORD           PmTabMaxIndexPtr  :  MAX_DRV_OUTPIPE for an ouput pipe, MAX_DRV_INPIPE for an input pipe
//  PTARGET_INFO    PmTargetPtr       :  The TARGET_INFO pointer
//
//
// *************************************************************************
//
//  Verify a mask indicates an output pipe that belongs to the
// application. If so returns SUCCESS and gives the corresponding
// index, otherwise returns an appropriate error code.
//
// We fill as much as we can the TARGET_INFO.
//
// *************************************************************************
STATIC WORD ChkPmOneInOrOutPipeMask(
    IN  BYTE            PmAppIndex       ,
    IN  DWORDLONG       PmOutPipeMask    ,
    IN  DWORDLONG       PmInPipeMask     ,
    OUT PWORD           PmPipeIndexPtr   ,
    OUT PPIPE_INFO      *PmPipeInfoTabPtr,
    OUT PVOIE_INFO      *PmVoieInfoTabPtr,
    OUT PTARGET_INFO    PmTargetPtr )
{
    if (  PmOutPipeMask == 0L )
    {
        return( ChkPmOneInputPipeMask(  PmAppIndex      ,
                                        PmInPipeMask    ,
                                        PmPipeIndexPtr  ,
                                        PmPipeInfoTabPtr,
                                        PmVoieInfoTabPtr,
                                        PmTargetPtr ) );
    }
    else
    {
        return( ChkPmOneOutputPipeMask( PmAppIndex      ,
                                        PmOutPipeMask   ,
                                        PmPipeIndexPtr  ,
                                        PmPipeInfoTabPtr,
                                        PmVoieInfoTabPtr,
                                        PmTargetPtr ) );
    }
}

// *************************************************************************
//
// STATIC WORD ChkPmManyOutputPipeMask( IN BYTE, IN DWORDLONG )
//
// Input Parameters:
// *****************
//
//  BYTE    PmAppIndex  :   the application index
//  DWORDLONG PmPipeMask :  the output pipe mask to check
//
// *************************************************************************
//
//  Verify a mask indicates an output pipe that belongs to the
// application. If so returns SUCCESS, otherwise returns
// an appropriate error code.
//
// *************************************************************************
STATIC WORD ChkPmManyOutputPipeMask(
    IN  BYTE    PmAppIndex      ,
    IN  DWORDLONG   PmPipeMask  )
{
    WORD    LcOutPipeIndex ;
    DWORDLONG   LcPipeMask ;
    PPIPE_INFO  LcOutPipeInfo;
    PVOIE_INFO  LcOutVoieInfo ;

    // verify this mask specify at least one pipe ...
    // **********************************************
    if ( PmPipeMask == 0 )
    {
        EXIT_PCX_ERROR( ED_INVALID_PIPE );
    }

    // Check all pipes in the mask, one by one
    // ***************************************
    LcPipeMask = PmPipeMask ;
    while ( LcPipeMask != 0 )
    {
        LcOutPipeIndex = UTI64Mask2Word( LcPipeMask ) ;

        // Remove this pipe from the mask
        // ******************************
        LcPipeMask &= ~UTIMask64bit( LcOutPipeIndex );

        // does the pipe actually belongs to the application ?
        // ***************************************************
        if (   ( LcOutPipeIndex >= MAX_DRV_OUTPIPE )
            || ( TbPipeOutInfo[LcOutPipeIndex].piNbAudio == 0)
            || ( TbPipeOutInfo[LcOutPipeIndex].piNumPipeForDsp >= MAX_BOARD_OUTPUTS)
            || ( TbPipeOutInfo[LcOutPipeIndex].piNumBoard >= MAX_BOARD))
        {
            EXIT_PCX_ERROR( ED_INVALID_PIPE );
        }

        LcOutPipeInfo = &TbPipeOutInfo[LcOutPipeIndex];
        LcOutVoieInfo = &TbVoieOutInfo[LcOutPipeInfo->piNumBoard][LcOutPipeInfo->piNumPipeForDsp];

        if (   ( LcOutVoieInfo->IndexAppli != (PmAppIndex + 1))
            || ( LcOutVoieInfo->NumPipe != LcOutPipeIndex) )
        {
            EXIT_PCX_ERROR( ED_INVALID_PIPE );
        }
    }

    // Parameter is correct
    // ********************
    return SUCCESS ;
}

// *************************************************************************
//
// STATIC WORD ChkPmManyInputPipeMask( IN BYTE, IN DWORDLONG )
//
// Input Parameters:
// *****************
//
//  BYTE    PmAppIndex  :   the application index
//  DWORDLONG PmPipeMask :  the input pipe mask to check
//
// *************************************************************************
//
//  Verify a mask indicates an input pipe that belongs to the
// application. If so returns SUCCESS, otherwise returns
// an appropriate error code.
//
// *************************************************************************
STATIC WORD ChkPmManyInputPipeMask(
    IN  BYTE        PmAppIndex,
    IN  DWORDLONG   PmPipeMask )
{
    WORD    LcInPipeIndex ;
    DWORDLONG   LcPipeMask ;
    PPIPE_INFO  LcInPipeInfo;
    PVOIE_INFO  LcInVoieInfo ;

    // verify this mask specify at least one pipe ...
    // **********************************************
    if ( PmPipeMask == 0 )
    {
        EXIT_PCX_ERROR( ED_INVALID_PIPE );
    }

    // Check all pipes in the mask, one by one
    // ***************************************
    LcPipeMask = PmPipeMask ;
    while ( LcPipeMask != 0 )
    {
        LcInPipeIndex = UTI64Mask2Word( LcPipeMask ) ;

        // Remove this pipe from the mask
        // ******************************
        LcPipeMask &= ~UTIMask64bit( LcInPipeIndex );

        // does the pipe actually belongs to the application ?
        // ***************************************************
        if (   ( LcInPipeIndex >= MAX_DRV_INPIPE )
            || ( TbPipeInInfo[LcInPipeIndex].piNbAudio == 0)
            || ( TbPipeInInfo[LcInPipeIndex].piNumPipeForDsp >= MAX_BOARD_INPUTS)
            || ( TbPipeInInfo[LcInPipeIndex].piNumBoard >= MAX_BOARD))
        {
            EXIT_PCX_ERROR( ED_INVALID_PIPE );
        }

        LcInPipeInfo = &TbPipeInInfo[LcInPipeIndex];
        LcInVoieInfo = &TbVoieInInfo[LcInPipeInfo->piNumBoard][LcInPipeInfo->piNumPipeForDsp];

        if (   ( LcInVoieInfo->IndexAppli != (PmAppIndex + 1))
            || ( LcInVoieInfo->NumPipe != LcInPipeIndex) )
        {
            EXIT_PCX_ERROR( ED_INVALID_PIPE );
        }
    }

    // Parameter is correct
    // ********************
    return SUCCESS ;
}

// *************************************************************************
//
// STATIC WORD ChkPmManyInOrOutPipeMask( IN BYTE, IN DWORDLONG, IN DWORDLONG )
//
// Input Parameters:
// *****************
//
//  BYTE    PmAppIndex      :   The application index
//  DWORDLONG PmOutPipeMask :   The output pipe mask to check or 0
//  DWORDLONG PmInPipeMask  :   The input pipe mask to check or 0
//
// *************************************************************************
//
//  Verify a mask indicates an output pipe or an input pipe that belongs to the
// application. If so returns SUCCESS, otherwise returns
// an appropriate error code.
//
// *************************************************************************
STATIC WORD ChkPmManyInOrOutPipeMask(
    IN  BYTE    PmAppIndex      ,
    IN  DWORDLONG   PmOutPipeMask,
    IN  DWORDLONG   PmInPipeMask )
{
    WORD        LcRet = ED_INVALID_PIPE;

    if ( PmOutPipeMask != 0L )
    {
        LcRet = ChkPmManyOutputPipeMask(    PmAppIndex   ,
                                            PmOutPipeMask );
        if ( LcRet != SUCCESS ) return( LcRet );
    }

    if ( PmInPipeMask != 0L )
    {
        LcRet = ChkPmManyInputPipeMask( PmAppIndex   ,
                                        PmInPipeMask );
        if ( LcRet != SUCCESS ) return( LcRet );
    }

    return( LcRet );
}

// *************************************************************************
//
// STATIC WORD LookupBoardAudio(
//
// Input Parameters:
// ****************
//
//  BYTE        PmBoardNum    :   the board number
//  BYTE        PmDspNum      :   the dsp number on the board
//  BYTE        PmAudioNum    :   the audio number on the board
//  WORD        PmAudioAttrib :   the audio attributes
//
// Output Parameters:
// *****************
//
//  PVOIE_INFO PmEntryPtr   :  entry for the pipe-allocated audio or NULL if
//                            not allocated
//
// Return value:
// ************
//
//  SUCCESS if scan completes successfully
//
// *************************************************************************
//
//  Lookup for a VOIE_INFO entry describing a board audio of a pipe declared
// by an application
//
// *************************************************************************
STATIC WORD  LookupBoardAudio(
    IN  BYTE        PmBoardNum,
    IN  BYTE        PmDspNum,
    IN  WORD        PmAudioNum,
    IN  WORD        PmAudioAttrib,
    OUT PVOIE_INFO  *PmEntryPtr )
{
    PVOIE_INFO                    LcPtVoie              ;
    BOOLEAN                       LcFound               = FALSE ;
    PDSP_INFO                     LcPtrDsp              ;
    DWORD                         LcManagedAudio        ;
    DWORDLONG                     LcFreeAudio           ;
    TARGET_INFO                   LcTarget              ;
    int                           LcNbAudioMax, j       ;

    // Initialize output parameters
    // ----------------------------
    *PmEntryPtr = NULL;

    // Let's process some controls
    // ---------------------------
    if ( PmBoardNum >= MAX_BOARD )
    {
        EXIT_PCX_ERROR( ED_INVALID_BOARD );
    }

    if ( PmDspNum )
    {
        EXIT_PCX_ERROR( ED_INVALID_DSP );
    }
	
    LcTarget.tgCarte = PmBoardNum;
//    LcTarget.tgDsp = 0;

    // Select the right table to scan for the audio
    // --------------------------------------------
    if ( PmAudioAttrib & AUDIO_IN )
    {
        LcPtVoie = &TbVoieInInfo[PmBoardNum][0];
        LcNbAudioMax = MAX_BOARD_INPUTS;

        // Select the audio masks for the DSP
        // ----------------------------------
        if ( PmAudioAttrib & AUDIO_PHYSICAL )
        {
            LcPtrDsp = &(APH_Board_Info_Array[PmBoardNum].biTbDspInfo[0]);
            LcManagedAudio = LcPtrDsp->dsManagedPhysicalInputNumber ;
            LcFreeAudio    = LcPtrDsp->dsMaskVPIn ;
        }
        else
        {
            LcPtrDsp = &(APH_Board_Info_Array[PmBoardNum].biTbDspInfo[0]);
            LcManagedAudio = 0 ;
            LcFreeAudio    = LcPtrDsp->dsMaskVVIn ;
        }

    }
    else
    {
        LcPtVoie = &TbVoieOutInfo[PmBoardNum][0];
        LcNbAudioMax = MAX_BOARD_OUTPUTS;

        // Select the audio masks for the DSP
        // ----------------------------------
        if ( PmAudioAttrib & AUDIO_PHYSICAL )
        {
            LcPtrDsp = &(APH_Board_Info_Array[PmBoardNum].biTbDspInfo[0]);
            LcManagedAudio = LcPtrDsp->dsManagedPhysicalOutputNumber ;
            LcFreeAudio    = LcPtrDsp->dsMaskVPOut ;
        }
        else
        {
            LcPtrDsp = &(APH_Board_Info_Array[PmBoardNum].biTbDspInfo[0]);
            LcManagedAudio = 0 ;
            LcFreeAudio    = LcPtrDsp->dsMaskVVOut ;
        }

    }

    // The dsp must be loaded and running
    // -----------------------------------
    // ## FS (27/03/1998) -- FA #149
    // We should make the difference between an invalid
    // DSP number, a DSP not loaded, and a crashed DSP
    // --------------------------------------------------------
    if ( APH_Board_Info_Array[PmBoardNum].biTbDspInfo[0].dsEtat == 0 )
    {
        EXIT_PCX_ERROR( ED_INVALID_DSP_SOFTWARE );
    }
    else if (   ( APH_Board_Info_Array[PmBoardNum].biTbDspInfo[0].dsEtat < DSP_FIRST_SOFT )
             || ( APH_Board_Info_Array[PmBoardNum].biTbDspInfo[0].dsEtat > DSP_LAST_SOFT ) )
    {
        EXIT_PCX_ERROR( ED_DSP_CRASHED );
    }

    // Check whether the audio exists
    // ------------------------------
    if( (LcManagedAudio <= PmAudioNum) ||
        (LcNbAudioMax <= PmAudioNum)    )
    {
        // The specified audio does not exist
        // or is not managed by the DSP
        // ---------------------------------
        EXIT_PCX_ERROR( ED_INVALID_BOARD_AUDIO );
    }

    // Check whether the audio is allocated
    // ------------------------------------
    if ( LcFreeAudio & UTIMask64bit(PmAudioNum) )
    {
        ASSERT( LcPtVoie[PmAudioNum].IndexAppli == 0 );

        // This audio is available
        // -----------------------
        return SUCCESS;
    }

    ASSERT( LcPtVoie[PmAudioNum].IndexAppli != 0 );

    LcFound = FALSE ;

            // VOIE_INFO structure: Nat => 0: physical 1: virtual
            // REQUEST BLOCK               1: physical 0: virtual
            // ---------------------------------------------------
            if ( !(PmAudioAttrib & AUDIO_PHYSICAL) )
            {
                // For virtual audio IO
                // Audio number (request block) == Board audio IO number
                // ---------------------------------------------------
                if (   ( LcPtVoie[PmAudioNum].Nat & VIRTUAL_AUDIO )
                    && ( LcPtVoie[PmAudioNum].AudioNum == PmAudioNum ) )
                {
                    // The audio matches
                    // -----------------
                    LcFound = TRUE;
                }
            }
            else
            {
                // For physical audio IO
                // Audio number (request block) == board audio IO number
                // ------------------------------------------------------
                if (   (!(LcPtVoie[PmAudioNum].Nat & VIRTUAL_AUDIO))
                    && (LcPtVoie[PmAudioNum].AudioNum == PmAudioNum ) )
                {
                    // The audio matches
                    // -----------------
                    LcFound = TRUE;
                }
            }

    // We do not found the requested application
    // ------------------------------------------
    if ( LcFound == FALSE )
    {
        // Problem - should never happen !!!
        // ---------------------------------
        DOUT(DBG_ERROR, ("!!! LookupBoardAudio !!!\n"));

        EXIT_PCX_ERROR( ED_INVALID_PIPE_AUDIO );
    }
    else
    {
        *PmEntryPtr = &LcPtVoie[PmAudioNum];
        return SUCCESS ;
    }
}


// DHS
#include "api\ah_dhs.c"




// *************************************************************************
//
// STATIC VOID PipeResetLevelsSubFct( IN WORD, IN BOOLEAN )
//
// Input Parameters:
// *****************
//
//  WORD PmPipeIndex:   the index of the pipe to reset
//  BOOLEAN PmIsInput:  Input pipe or output pipe
//
//
// *************************************************************************
//
//  For each audio of the pipe, resets levels to their default values
//
// *************************************************************************
STATIC VOID PipeResetLevelsSubFct(
    IN BYTE         PmAction,   /* RESET_GAIN_NO, RESET_GAIN_MUTE, RESET_GAIN_0DBFS*/
    IN WORD         PmPipeIndex ,
    IN BOOLEAN      PmIsInput   )
{
    PVOIE_INFO  LcPtVoie ;
    WORD        LcAudio, LcMaxAudios ;
    BYTE        LcCaracPipeVoie;
    WORD        LcCurrentBoard;

    if (PmAction == RESET_GAIN_NO) return;

    // For any audios
    // -----------------
    if ( PmIsInput )
    {
        ASSERT( PmPipeIndex < MAX_DRV_INPIPE);

        LcAudio = TbPipeInInfo[PmPipeIndex].piNumPipeForDsp;
        LcCurrentBoard = TbPipeInInfo[PmPipeIndex].piNumBoard;

        ASSERT( LcAudio < MAX_BOARD_INPUTS );
        ASSERT( LcCurrentBoard < MAX_BOARD );

        LcPtVoie = &TbVoieInInfo[LcCurrentBoard][LcAudio];
        LcMaxAudios = TbPipeInInfo[PmPipeIndex].piNbAudio;
        LcCaracPipeVoie = OPER_REC;
    }
    else
    {
        ASSERT( PmPipeIndex < MAX_DRV_OUTPIPE);

        LcAudio = TbPipeOutInfo[PmPipeIndex].piNumPipeForDsp;
        LcCurrentBoard = TbPipeOutInfo[PmPipeIndex].piNumBoard;

        ASSERT( LcAudio < MAX_BOARD_OUTPUTS );
        ASSERT( LcCurrentBoard < MAX_BOARD );

        LcPtVoie = &TbVoieOutInfo[LcCurrentBoard][LcAudio];
        LcMaxAudios = TbPipeOutInfo[PmPipeIndex].piNbAudio;
        LcCaracPipeVoie = OPER_PLAY;
    }

    // Scan for any audio belonging to the pipe
    // -----------------------------------------
    for ( LcAudio = 0 ; LcAudio < LcMaxAudios ; LcAudio ++ )
    {
        if ( ( LcPtVoie[LcAudio].IndexAppli == 0 )
            || ( LcPtVoie[LcAudio].NumPipe != PmPipeIndex ) )
        continue ;

        if ( LcPtVoie[LcAudio].Nat == 0 )
        {
            WORD LcAudioNum = LcPtVoie[LcAudio].AudioNum;

            // Physical audio, hence let's reset its analog level if any
            // ----------------------------------------------------------
            if(LcCaracPipeVoie == OPER_PLAY)
            {
                WORD LcDescAudioOut = CUR_COMMANDS_PTR->PIOGetDescAudioOut(LcAudioNum/2);
				if(LcDescAudioOut & AUDIO_LEVEL_MSK)
				{
                    // reset audio analog level only if not controlled by DHS
                    if( APHChkIsAudioDHSControlled(LcCurrentBoard, LcAudioNum, FALSE) == FALSE )
                    {
                        CUR_COMMANDS_PTR->PIOSetAudioAnalogLevel( LcAudioNum, LcCaracPipeVoie, INIT_ANALOG_LEVEL);
                    }
				}
            }
            else    // OPER_REC
            {
                WORD LcDescAudioIn = CUR_COMMANDS_PTR->PIOGetDescAudioIn(LcAudioNum/2);

                if(LcDescAudioIn & (AUDIO_LINE_IN_LEVEL_MSK || AUDIO_MICRO_IN_LEVEL_MSK))
                {
                    // reset audio analog level only if not controlled by DHS
                    if( APHChkIsAudioDHSControlled(LcCurrentBoard, LcAudioNum, TRUE) == FALSE )
                    {
                        IN_AUDIO_SET_LEVEL_REQ_INFO LcLevels;

                        LcLevels.iasliAnalogLevel = INIT_ANALOG_LEVEL;
                        LcLevels.iasliAnalogMute  = FALSE;
                        LcLevels.iasliPar1        = IN_AUDIO_SET_LEVEL_ANALOG_MASK      |
                                                    IN_AUDIO_SET_LEVEL_MUTE_ANALOG_MASK ;

                        if(LcDescAudioIn & AUDIO_MORE_FEATURES_MASK)   // VX222 MIC
                        {
                          BYTE LcPhyInFeat = CUR_COMMANDS_PTR->PIOGetPhysInFeature2(LcAudioNum/2);
                          if(LcPhyInFeat &  AUDIO_MIXED_MICRO_MSK)
                          {
                            LcLevels.iasliMicroLevel =  INIT_ANALOG_LEVEL;
                            LcLevels.iasliMicroMute  =  FALSE;
                            LcLevels.iasliPar1      |=  IN_AUDIO_SET_LEVEL_MICRO_MASK       |
                                                        IN_AUDIO_SET_LEVEL_MUTE_MICRO_MASK  ;
                          }
                        }

                        CUR_COMMANDS_PTR->PIOSetInAudioLevels(LcAudioNum, &LcLevels);
                    }
                }

                // reset Phantom Power Supply
                if( LcDescAudioIn & AUDIO_MIC_IN_48V_MSK )
                {
                    CUR_COMMANDS_PTR->PIOEnablePhantomPowerSupply( LcAudioNum, 0, FALSE );
                }

                // disable limiter & compressor
                if( LcDescAudioIn & AUDIO_MIC_IN_COMPR_MSK )
                {
                    IN_AUDIO_EFFECT_REQ_INFO LcInAudioEffects;

                    BZERO2( &LcInAudioEffects, IN_AUDIO_EFFECT_REQ_INFO, 1 );
                    LcInAudioEffects.iaqIdentifier = HW_EFFECT_NONE;

                    CUR_COMMANDS_PTR->PIOSetInAudioEffects( LcAudioNum, &LcInAudioEffects );
                }
            }
        }
    }
}

// *************************************************************************
//
//STATIC BOOLEAN ControlTheHandle( INOUT LPDWORD ,
//                              INOUT LPDWORD  )
//
//Input Parameters:
// ****************
//
//
//Output Paramaters:
// *****************
//
//Input / Output Paramaters:
// *************************
//
//  LPDWORD PmBlocRequete : command request bloc
//  LPDWORD PmBlocRetour  : command response bloc
//
//
//Return value:
// ************
//
//  True for a declared application, false otherwise
//
// *************************************************************************
//
//  Control if the application is declared.
//
// *************************************************************************
STATIC BOOLEAN ControlTheHandle( INOUT LPDWORD PmBlocRequete,
                  INOUT LPDWORD PmBlocRetour )
{
    LPBC_HEADER_INFO     LcLPtrHeader;
    LPRESP_HEADER_INFO   LcLPtrRep;
    WORD                 LcAppIndex;

    LcLPtrHeader = (LPBC_HEADER_INFO)PmBlocRequete;
    LcLPtrRep = (LPRESP_HEADER_INFO)PmBlocRetour;

    LcLPtrRep->rhCptr = SUCCESS;

    // FS - 18/11/96
    // Some functions does not require any handle
    // hdHandle field contains no significative value
    // -----------------------------------------------
    if ( LcLPtrHeader->hdFamily == GENE_FAM)
    {
      if(( (LcLPtrHeader->hdComNum ==  REG_CMD) && (LcLPtrHeader->hdHandle == REGISTER_HANDLE) )
        || (LcLPtrHeader->hdComNum ==  SYSTEM_FEATURE_CMD)
        || (LcLPtrHeader->hdComNum ==  BOARD_HARD_FEATURE_CMD)
        || (LcLPtrHeader->hdComNum ==  BOARD_SOFT_FEATURE_CMD)
        || (LcLPtrHeader->hdComNum ==  BOARD_CLOCK_CMD)
        || (LcLPtrHeader->hdComNum ==  DRIVER_PATH_CMD)
        || (LcLPtrHeader->hdComNum ==  DSP_BUFF_ADDR_CMD)
        || (LcLPtrHeader->hdComNum ==  AUDIO_INFO_CMD)
        || (LcLPtrHeader->hdComNum ==  APP_LIST_CMD)
        || (LcLPtrHeader->hdComNum ==  UNUSED_CMD)
        || (LcLPtrHeader->hdComNum ==  PIPES_LIST_CMD)
        ||((LcLPtrHeader->hdComNum ==  GPIO_CMD) && (LcLPtrHeader->hdHandle == NOT_USED))
        || (LcLPtrHeader->hdComNum ==  BOOST_THREAD_CMD)
        || (LcLPtrHeader->hdComNum ==  DSP_TRACE_CMD)
        || (LcLPtrHeader->hdComNum ==  DSP_RESOURCES_CMD)
        || (LcLPtrHeader->hdComNum ==  IBL_CMD)
        || (LcLPtrHeader->hdComNum ==  ES_HW_CFG_CMD)
        || (LcLPtrHeader->hdComNum ==  DRIVER_TRACE_CMD) )
      {
        return TRUE;
      }
    }
	else
    if ( LcLPtrHeader->hdFamily == IO_BOARD_STATUS_FAM)
    {
      if( LcLPtrHeader->hdComNum == IN_AUDIO_GET_CBYTE_CMD )
      {
        return TRUE;
      }
	}

    LcAppIndex = DecodeHandle( LcLPtrHeader->hdHandle );

	// if DirectSound apphandle, only some few commands allowed:
	//
	if( LcAppIndex == DS_FAKED_APPINDEX )
	{
		if( LcLPtrHeader->hdComNum != DSP_MANAGE_CMD )
		{
			LOAD_PCX_ERROR( LcLPtrRep->rhCptr, ED_INVALID_PCX_HANDLE );
			return FALSE;
		}
	}

    if ( ( LcAppIndex < MAX_PCX_HANDLE )
    && ( TbAppliInfo[LcAppIndex].Carac != FREE_ENTRY ) )
    {
        return TRUE;
    }
    else if ( (LcLPtrHeader->hdFamily == PRIVATE_FAM)
         && (LcLPtrHeader->hdHandle == DRIVER_KEY) )
    {
        // ! Driver is authentified and can perform its own commands !
        return TRUE;
    }
    else
    {
        // Fill the response bloc: UNDECLARED APPLICATION
        // **********************************************
        LOAD_PCX_ERROR( LcLPtrRep->rhCptr, ED_INVALID_PCX_HANDLE );
        return FALSE;
    }
}

// *************************************************************************
//                  Driver private functions
// *************************************************************************

// *************************************************************************
//
// STATIC VOID InvalidCmd11( PmBlocRequete, PmBlocRetour)
//
// Input Parameters:
// *****************
//
//  LPDWORD PmBlocRequete : command request bloc
//
// Output Parameters:
// **************************
//
//  LPDWORD PmBlocRetour  : command response bloc
//
// *************************************************************************
//
//  Common entry points for an invalid or not implemented yet command
// within the family
//
// *************************************************************************
STATIC VOID InvalidCmd11(
    IN  LPDWORD PmBlocRequete,
    OUT LPDWORD PmBlocRetour )
{
    LPRESP_HEADER_INFO  LcLPResp;

    LcLPResp = (LPRESP_HEADER_INFO) PmBlocRetour ;
    LOAD_PCX_ERROR( LcLPResp->rhCptr, ED_INVALID_CMD_FAM11 );
    LcLPResp->rhT = PROCESSED ;
}


// *************************************************************************
//                  Synchronous asynchronous functions
// *************************************************************************

#include "api\ah_syas.c"

// *************************************************************************
//                  Asynchronous functions
// *************************************************************************

#include "api\ah_async.c"

// *************************************************************************
//                  Status functions
// *************************************************************************

#include "api\ah_stat.c"

// *************************************************************************
//                  Control functions
// *************************************************************************

#include "api\ah_ctrl.c"


// *************************************************************************
//                  General functions
// *************************************************************************

#include "api\ah_gene.c"

// *************************************************************************
//
//STATIC BOOLEAN CopyHeaderBlcRet( IN LPDWORD, OUT LPDWORD, IN PDWORD )
//
// Input Parameters:
// ****************
//
//  LPDWORD PmBlocRequete : command request bloc
//  PDWORD  PmIrp         : corresponding IRP if any, or NULL
//
// Output Parameters:
// *****************
//
//  LPDWORD PmBlocRetour  : command response bloc
//
//
// Return value:
// *************
//
// TRUE if copy is ok, FALSE if there is BlocRetour is not long enough
//
// *************************************************************************
//
//  Copy the header of the request block into the response block.
//
// *************************************************************************
STATIC BOOLEAN  CopyHeaderBlcRet(
    IN  LPDWORD PmBlocRequete   ,
    OUT LPDWORD PmBlocRetour    ,
    IN  PDWORD  PmIrp           )
{
    LPBC_HEADER_INFO    LcLPtrRequest       = (LPBC_HEADER_INFO) PmBlocRequete;
    LPRESP_HEADER_INFO  LcLPtrReply         = (LPRESP_HEADER_INFO) PmBlocRetour;

    // FS - 15/10/1996
    // Check the reply bloc will be long enough to hold the reply
    // ----------------------------------------------------------
    if ( LcLPtrRequest->hdBrSize < MIN_RESP_HEADER_SIZE )
    {
        // Really too short, we cannot even send an error code back !
        // ----------------------------------------------------------
        return FALSE;
    }

    if ( LcLPtrRequest->hdBrSize < sizeof( RESP_HEADER_INFO ) )
    {
        LOAD_PCX_ERROR( LcLPtrReply->rhCptr, ED_REPLY_BLOC_TOO_SHORT );

        if ( PmIrp != NULL )
           SignalAsyncProcessed( PmBlocRetour, PmIrp );
        else
           LcLPtrReply->rhT = PROCESSED ;

        return FALSE;
    }

    // MBR (2001/08/08) optimize copy !
    if(PmBlocRetour != PmBlocRequete)
    {
        int i;
        int LcSize = sizeof(BC_HEADER_INFO) / sizeof(DWORD);

        for ( i = 0; i < LcSize ; i ++ )
        {
            PmBlocRetour[i] = PmBlocRequete[i];
        }
    }

    // set the size of data returned together with reply block
    LcLPtrReply->rhSize = 0;

    return TRUE;
}


// *************************************************************************
//
// STATIC VOID TraitHardItBoard(PmNumBoard)
//
//Input Parameters:
// ****************
//      WORD PmNumBoard : Numro de la carte
//
//
//Output Paramaters:
// *****************
//
//Return value:
// ************
//
// *************************************************************************
//
// Handle The hardware interrupt for this board.
//
// *************************************************************************
VOID TraitHardItBoard(IN WORD PmNumBoard )
{
    BOOLEAN     LcEndOfPlayRequested;
    WORD        LcCurrentPipe, LcNbPipe, i;
    PPIPE_INFO  LcPtPipe;
    PBOARD_INFO LcPtBoard;
    WORD        LcErrCode, LcCurrentBoard;
    BOOLEAN     LcEndStartOnTimeCode;
    BOOLEAN     LcFrequencyChange;

    // Prepare the target for this board
    // *********************************
    LcCurrentBoard = PmNumBoard;

    LcPtBoard = &(APH_Board_Info_Array[PmNumBoard]) ;

    // Handle the asynchronous events
    // *****************************

    // For all the dsp of the board
    // ----------------------------
    // If this DSP is used by at least one application
    // -----------------------------------------------
    if ( ! CUR_PROTOCOL_PTR->IDiag_IsDspRunning() )
        return;

    DWORDLONG LcNotifBufOutPipeMask;
    DWORDLONG LcNotifBufInPipeMask;
    ES_DRV_RESP LcES_Response;

    LcErrCode = CUR_PROTOCOL_PTR->IEvent_AsynchronousEvents( &LcEndStartOnTimeCode,
                                                             &LcFrequencyChange,
                                                             &LcNotifBufOutPipeMask,
                                                             &LcNotifBufInPipeMask,
                                                             &LcES_Response);
    if ( LcErrCode != SUCCESS )
    {
        DOUT(DBG_ERROR, ("ASYNC: %x", LcErrCode));

        // A fatal error has occured on the DSP
        // -------------------------------------
        APHKeepDspError( &LcPtBoard->biTbDspInfo[0], LcErrCode );
    }
    else if (    ( LcEndStartOnTimeCode != FALSE )
              && ( StartOnTimeCodeInProgress != FALSE ) )
    {
        StartOnTimeCodeInProgress = FALSE;
        StartOnTimeCodeBoardNum   = 0;
        StartOnTimeCodeInMask     = 0;
        StartOnTimeCodeOutMask    = 0;
    }
    else if ( LcFrequencyChange != FALSE )
    {
        DOUT( DBG_VSR|DBG_PROT_EVENT ,("Freq or GPIO Irq\n"));
        // GPIO Interrupt is the same as FrequencyChange ones
        APHTreatGpioIt(PmNumBoard);

        // Nota: we test piActualClkSource because the C bits have to be
        // updated and the DSP synchronization done even if biClockSource
        // = CLOCK_TYPE_NONE (because of side effects in the sequence CLOCK_TYPE_UER_SYNCHRO
        // then CLOCK_TYPE_NONE then UER frequency change then CLOCK_TYPE_UER_SYNCHRO).
        if( ( CUR_COMMANDS_PTR->PIOGetActualClkSource( ) == CLOCK_TYPE_UER_SYNCHRO ) ||
            ( CUR_COMMANDS_PTR->PIOGetActualClkSource( ) == CLOCK_TYPE_ETHERSOUND ) ||
            ( CUR_COMMANDS_PTR->PIOGetActualClkSource( ) == CLOCK_TYPE_WORD_CLOCK ) )
        {
            DWORD       LcFrequency   = 0;
            BOOLEAN     LcFirstChange = FALSE;

            // Read the real board frequency
            // -----------------------------
            LcErrCode = CUR_PROTOCOL_PTR->IClock_BoardGetClockFrequency( &LcFrequency,
																		 &LcFirstChange );

            // MBR (04/07/2001) : Test piActualClkSource before calling VIOGetBoardClockFrequency
            // because in case of GPIO interrupt PCX22 returns error on this function !

            if ( LcErrCode == SUCCESS )
            {
                DOUT( DBG_VSR ,("Freq EVENT Current = %dHz\n",CUR_COMMANDS_PTR->PIOGetActualClockFrequency( )) );
                DOUT( DBG_VSR ,("Freq EVENT New     = %dHz\n",LcFrequency) );
                DOUT( DBG_VSR ,("Freq EVENT SOurce  = %dHz\n",CUR_COMMANDS_PTR->PIOGetActualClkSource( )) );

                // The frequency computed by the DSP is good and
                // is different from the previous computed.
                // ------------------------------------------------
                if ( ( LcFrequency != 0 ) &&
                     ( LcFrequency != CUR_COMMANDS_PTR->PIOGetActualClockFrequency() ) )
                {
                    if ( LcFirstChange == FALSE )
                    {
                        // Synchronize the DSP.
                        // --------------------
                        LcErrCode = CUR_PROTOCOL_PTR->IClock_BoardModifyClock(	TRUE,   // Synchronize the FIFO
																				TRUE ); // Compute the frequency
                    }

                    // Nota: if the user never called PCXSetParamOutPipe or called
                    //       it with SET_NO_UER, then the C bits are set to professional.
                    //
                    //  APHUpdateCBitsOnBoard( PmNumBoard, LcFrequency );
                }

                // Tell the user that a frequency change occured.
                // ----------------------------------------------
                if ( ( ( LcFirstChange == TRUE ) &&
                       ( LcFrequency == 0 ) ) ||
                     ( ( LcFirstChange == FALSE ) &&
                       ( LcFrequency != CUR_COMMANDS_PTR->PIOGetActualClockFrequency() ) ) )
                {
                    // Nota: we don't warn the user about the frequency change
                    // if biClockSource = CLOCK_TYPE_NONE.
                    if ( CUR_COMMANDS_PTR->PIOGetActualClkSource() == CLOCK_TYPE_UER_SYNCHRO )
                    {
                        LcErrCode = WD_UER_FREQUENCY_MODIFICATION;
                    }
                    else
                    if ( CUR_COMMANDS_PTR->PIOGetActualClkSource() == CLOCK_TYPE_WORD_CLOCK )
                    {
                        LcErrCode = WD_WORD_CLOCK_FREQUENCY_MODIFICATION;
                    }
                }

                if( (LcFrequency == 0) /*&& (LcErrCode != SUCCESS)*/ && (LcFirstChange == FALSE) )
                {
                    LcErrCode = WD_EXTERNAL_CLOCK_LOST;
                }
                LOAD_PCX_ERROR( LcErrCode, LcErrCode );

                CUR_COMMANDS_PTR->PIOSetActualClockFrequency(LcFrequency);
            }

            if ( LcErrCode != SUCCESS )
            {
                APHKeepSeveralPipesError( LcCurrentBoard, LcErrCode );
            }

        } // if (CLOCK_TYPE_UER_SYNCHRO || CLOCK_TYPE_WORD_CLOCK)
    } // if (FrequencyChange)

    // Handle the sound transfers
    // ***************************

    // For all the pipes
    // -----------------
    for (i=0; i<2; i++)
    {
        TARGET_INFO LcTarget;
        BOOLEAN     LcIsCapture;
        DWORDLONG   LcDspPipesMask;

        // Prepare the target for this board
        // *********************************
        LcTarget.tgCarte = PmNumBoard;
    
        if(i == 0)
        {
            LcPtPipe = &TbPipeOutInfo[0];
            LcNbPipe = MAX_DRV_OUTPIPE;
            LcTarget.tgCaracPipeVoie = OPER_PLAY;
            LcIsCapture = FALSE;
            LcDspPipesMask = LcNotifBufOutPipeMask;
        }
        else
        {
            LcPtPipe = &TbPipeInInfo[0];
            LcNbPipe = MAX_DRV_INPIPE;
            LcTarget.tgCaracPipeVoie = OPER_REC;
            LcIsCapture = TRUE;
            LcDspPipesMask = LcNotifBufInPipeMask;
        }

		for (LcCurrentPipe=0; LcCurrentPipe<LcNbPipe; LcCurrentPipe++)
		{
            if( LcDspPipesMask == 0 )    // no stream/pipe finished a buffer
                break;

			// If this pipe belongs to the current board
			// -----------------------------------------
			if (   (LcPtPipe->piNbAudio != 0)
				&& (LcPtPipe->piNumBoard == PmNumBoard) )
			{
                DWORDLONG LcThisDspPipeMask = UTIMask64bit( LcPtPipe->piNumPipeForDsp );

                if( (LcDspPipesMask & LcThisDspPipeMask) == 0 )
                {
                    LcPtPipe += 1;
                    continue;         // continue with following pipe if this stream/pipe didn't finish a buffer
                }
                LcDspPipesMask &= ~LcThisDspPipeMask;

				PSTREAM_INFO LcPtStream  = (PSTREAM_INFO) LcPtPipe->piVioHandle   ;

				if( (LcPtStream != NULL) && (LcPtStream->siAPINP == 0) )
				{
					// Direct Sound Pipe !
					//
					if( LcPtPipe->piParentIchWave )
					{
                        // call service directly
                        //
						DSNDNotifyStream(LcPtPipe->piParentIchWave, LcIsCapture, LcPtPipe->piNumPipeForDsp, TRUE);
					}
				}
				else
				{
					// Transfer sound for this pipe
					// -----------------------------
					LcTarget.tgPipe =          LcPtPipe->piNumPipeForDsp;
					LcTarget.tgVioHandle =     LcPtPipe->piVioHandle;
					LcTarget.tgMaskFlux =      LcPtPipe->piStreamMask;
					// FS - 22/07/97: We cannot force a transfer on EndRecord
					//               StopStream/Pipe will do it
					// ------------------------------------------------------
					if (LcIsCapture)
					{
						LcEndOfPlayRequested =     FALSE;
					}
					else
					{
						LcEndOfPlayRequested =     (LcPtPipe->piAdrBlkReq != NULL);
					}

					// FS - 17/11/96: driver stops talking to a dead DSP
					// --------------------------------------------------
					LcErrCode = LcPtBoard->biTbDspInfo[0].dsFatalError;

					if ( LcErrCode != SUCCESS )
					{
						// DSP has crashed - give up this pipe
						// to avoid a driver stall
						// ------------------------------------
						APHKeepPipeError( &LcTarget, LcErrCode );
					}
					else
					{
						LcErrCode = CUR_PROTOCOL_PTR->IBuffer_TransferSoundPipe(&LcTarget,
																				LcEndOfPlayRequested,
																				LcPtPipe->piNbMaxFlux );
						if ( LcErrCode != SUCCESS )
						{
							// FS !!
							DOUT(DBG_ERROR, ("TFR: %x", LcErrCode));

							APHKeepDspError( &LcPtBoard->biTbDspInfo[0], LcErrCode );
						}
					}
				}
			}// Endif this pipe belongs to the current board
            // --------------------------------------------

            // Following pipe
            // --------------
            LcPtPipe += 1;
        }
   }// Endfor all the pipes
   // --------------------

}



// *************************************************************************
// *************************************************************************


// ****************************************************************************
// VOID IsApiNpPipeDefined(  )
// ***************************
//
// Input parameters :
// ****************
//      none
//
// Output parameters :
// *******************
//      none
//
// Return value :
// **************
//      BOOL : TRUE if at least one input or output pipe is defined
//
// ****************************************************************************
// used to know wether we can safely power down device (allow power down only
// when no pipe are defined)
// ****************************************************************************

int IsApiNpPipeDefined()
{
	int nPipeIndex;
	for( nPipeIndex=0; nPipeIndex<MAX_DRV_OUTPIPE; nPipeIndex++)
	{
		if (TbPipeOutInfo[nPipeIndex].piVioHandle)
        {
            // DirectSound Pipes allowed
            if(TbPipeOutInfo[nPipeIndex].piParentIchWave == NULL)
                return (TRUE);
        }
	}

	for( nPipeIndex=0; nPipeIndex<MAX_DRV_INPIPE; nPipeIndex++)
	{
		if (TbPipeInInfo[nPipeIndex].piVioHandle)
        {
            // DirectSound Pipes allowed
            if(TbPipeInInfo[nPipeIndex].piParentIchWave == NULL)
                return (TRUE);
        }
	}

/* DHS can go sleep now !
	for( nPipeIndex=0; nPipeIndex<MAX_DHS_PIPE; nPipeIndex++)
    {
        if(TbDhsInPipeInfo[nPipeIndex].Allocated) return (TRUE);
        if(TbDhsOutPipeInfo[nPipeIndex].Allocated) return (TRUE);
    }
*/
	return( FALSE);
}

// ****************************************************************************
// VOID APHInit(  )
// ***************************
//
// Input parameters :
// ****************
//      PPORT_INFO          PmPPortInfo: a pointer to the begining of the
//                                       TbPortInfo array.
//
// Output parameters :
// *******************
//      DRIVER_INFO_HANDLE  PmDriverInfo: a pointer that will hold
//                                        the address of DriverInfo
//      BOARD_INFO_HANDLE   PmBoardInfo : a pointer that will hold
//                                        the address of APH_Board_Info_Array
//      LPCHAR
//
// Return value :
// **************
//      NONE
//
// ****************************************************************************
//
// This function is intended to be called only during the driver startup
//
// ****************************************************************************
VOID APHInit(
    OUT DRIVER_INFO_HANDLE PmDriverInfo,
    OUT BOARD_INFO_HANDLE PmBoardInfo )
{
    WORD i;

    *PmDriverInfo = (LPDRIVER_INFO) &GeneralDriverInfo;
    *PmBoardInfo = (LPBOARD_INFO) APH_Board_Info_Array;

    // No Board, no Application, no pipe, no audio either...
    // ******************************************************
    BZERO2( APH_Board_Info_Array,    BOARD_INFO, MAX_BOARD );
    BZERO2( TbAppliInfo,    APPLI_INFO, MAX_PCX_HANDLE );
    BZERO2( TbPipeOutInfo,  PIPE_INFO,  MAX_DRV_OUTPIPE );
    BZERO2( TbPipeInInfo,   PIPE_INFO,  MAX_DRV_INPIPE );

	BZERO2( APH_Commands_Array, CPIOCommands*, MAX_BOARD );

    GeneralDriverInfo.drRelease = PCX_VERSION_RELEASE;
    GeneralDriverInfo.drNver    = PCX_VERSION_NUMBER;
    GeneralDriverInfo.drTver    = PCX_VERSION_TYPE;
    GeneralDriverInfo.drBver    = PCX_BUILD_NUMBER;

    for ( i = 0 ; i < MAX_BOARD ; i++ )
    {
        
		if (APH_Boards_Count <= i)
        {
			// don't init existing protocols
			// -----------------------------
            APH_Protocol_Array[i] = NULL;
        }
		
        // No application opened the GPIOs.
        APH_Board_Info_Array[i].biGpioAppliIndex = MAX_PCX_HANDLE;
    }

    // Fs - 25/11/96
    // Set path for driver file set
    // -----------------------------
    DriverFilesPath[0] = '\0';
    GeneralDriverInfo.drPath = DriverFilesPath;

#if MODE_DEBUG
    if ( (sizeof(TARGET_INFO)*MAX_BOARD) > SA_MAX_DATA ) {
        debp(0,** SIZE MISMATCH **\n") ;
        debp(1,** SIZE MISMATCH **\n") ;
        debp(2,** SIZE MISMATCH **\n") ;
        debp(3,** SIZE MISMATCH **\n") ;
        debp(4,** SIZE MISMATCH **\n") ;
        debp(5,** SIZE MISMATCH **\n") ;
    }
#endif

    DHSInit(FALSE);
}



// *************************************************************************
//
// BOOLEAN APHDispatch( INOUT LPDWORD, INOUT LPDWORD, IN PDWORD )
//
//  Input Parameters:
//  *****************
//
//  LPDWORD PmBlocRequete :  command request bloc
//  PDWORD  PmIrp         :  pointer onto IRP under WindowsNT, NULL otherwise
//
//  Output Parameters:
//  ******************
//
//  LPDWORD PmBlocRetour  :  command response bloc
//
//
//  Return value:
//  ************
//
// TRUE if the command family is processed (synchronous),
//  FALSE otherwise
//
// *************************************************************************
//
//  Process the command by calling the corresponding functions, these
//  fuctions are group by family
//
// *************************************************************************
BOOLEAN APHDispatch(
    IN  LPDWORD PmBlocRequete   ,
    OUT LPDWORD PmBlocRetour    ,
    IN  PDWORD  PmIrp           )
{
    LPRESP_HEADER_INFO  LcLPtrRep;
    PCOMMAND_INFO       LcPCommands;
    PASYNC_COMMAND_INFO LcPAsyncCommands;
    WORD                LcFamily, LcCommand;

    LcFamily  = (WORD)((LPBC_HEADER_INFO) PmBlocRequete)->hdFamily;
    LcCommand = (WORD)((LPBC_HEADER_INFO) PmBlocRequete)->hdComNum;

    // Under NT, we have to remember the request block
    // and use it as well for the reply for asynchronous commands
    // ----------------------------------------------------------
    if ( (LcFamily == PLAY_RECORD_FAM) ||
         (LcFamily == ASYNC_EVT_FAM) )
    {
        PmBlocRetour = PmBlocRequete ;
    }

    // Copy the header request block to the response block
    // ---------------------------------------------------
    if ( CopyHeaderBlcRet( PmBlocRequete, PmBlocRetour, PmIrp ) == FALSE )
    {
        return TRUE;
    }

    LcLPtrRep = (LPRESP_HEADER_INFO) PmBlocRetour;

    // The driver has not handle the command yet
    //
    LcLPtrRep->rhT = NOT_PROCESSED;

    // Check the family and command numbers are valid
    // -----------------------------------------------
    if (   ( LcFamily == 0 )
        || ( LcFamily >= DispatchInfo.dpFamNum )
        || ( DispatchInfo.dpFamilies[LcFamily].famNum == 0 ) )
    {
        LOAD_PCX_ERROR( LcLPtrRep->rhCptr, ED_INVALID_FAM );
        LcLPtrRep->rhT      = PROCESSED;
        return TRUE;
    }

    LcPCommands = DispatchInfo.dpFamilies[LcFamily].famCommands;

    if ( LcCommand >= DispatchInfo.dpFamilies[LcFamily].famCmdNum )
    {
        // Invalid Command call
        // ---------------------
        LcCommand = 0;
    }

    if ( ControlTheHandle( PmBlocRequete, PmBlocRetour ) == TRUE )
    {
        if ( (LcFamily != PLAY_RECORD_FAM) &&
             (LcFamily != ASYNC_EVT_FAM)  )
        {
            DOUT(DBG_PRINT, ("%s", LcPCommands[LcCommand].cmdFctName));

            // Call the corresponding entry point
            // ----------------------------------
            LcPCommands[LcCommand].cmdFct(
                        PmBlocRequete   ,
                        PmBlocRetour    );

            // Make sure the command is marked as processed
            // unless this is an asynchronous one
            // ---------------------------------------------
            LcLPtrRep->rhT = PROCESSED;

            return TRUE;
        }
        else
        {
            // Call the corresponding entry point
            // Asynchronous command have an extra parameters
            // (required under WindowsNT and Window95)
            // ----------------------------------

            // Reset the user event
            // --------------------
            WNTClearEvent( PmIrp ) ;

            LcPAsyncCommands = (PASYNC_COMMAND_INFO) LcPCommands ;

            DOUT(DBG_PRINT, ("%s", LcPAsyncCommands[LcCommand].cmdFctName));

            // Actually make the call
            // -----------------------
            LcPAsyncCommands[LcCommand].cmdFct(
                        PmBlocRequete   ,
                        PmBlocRetour    ,
                        PmIrp           );

            return(FALSE) ;
        }
    }
    else
    {
        // The application has not been declared
        // --------------------------------------
        LOAD_PCX_ERROR( LcLPtrRep->rhCptr, ED_INVALID_PCX_HANDLE );
        LcLPtrRep->rhT    = PROCESSED;
        return TRUE;
    }
}


// *************************************************************************
//
// VOID APHDispatch2( INOUT PVOID )
//
//  Input/Output Parameters:
//  ************************
//
//  PVOID PmReplyBlkPtr  :  command response bloc
//
// *************************************************************************
//
//  Handle postponed processing (memory mapping / unmapping in user
// space
//
// *************************************************************************
VOID APHDispatch2(
    INOUT PVOID PmReplyBlkPtr    )
{
    BYTE                LcFamily, LcCommand;
    LPADD_DESC_INFO     LcAddrPtr           ;

    // Retrieve Family and command numbers
    // to identify whether extra processing is needed
    // -----------------------------------------------
    LcFamily  = ((LPBC_HEADER_INFO)PmReplyBlkPtr)->hdFamily;
    LcCommand = ((LPBC_HEADER_INFO)PmReplyBlkPtr)->hdComNum;

    if ( LcFamily == GENE_FAM )
    {
        if ( LcCommand == PIPE_DEF_CMD )
        {
            LPPIPE_DEF_RESP_INFO    LcReplyPtr ;
            DWORD                   LcBuffersMapped ;

            LcReplyPtr = (LPPIPE_DEF_RESP_INFO)PmReplyBlkPtr;
            LcAddrPtr  = (LPADD_DESC_INFO)(LcReplyPtr + 1) ;

            LcBuffersMapped =
            NTBProceedMappings( (DWORD)LcReplyPtr->pdpBuffersNum, LcAddrPtr );

            // Problem with mapping : Return only the number of buffers that have been mapped successsfully
            if((DWORD)LcReplyPtr->pdpBuffersNum > LcBuffersMapped)
            {
                LOAD_PCX_ERROR( LcReplyPtr->RespHeader.rhCptr, WD_UNDER_ALLOCATE_BUFFER );
                LcReplyPtr->pdpBuffersNum = (WORD)LcBuffersMapped;
            }
        }
        else if ( LcCommand == DSP_BUFF_ADDR_CMD )
        {
            LPDSP_BUFF_RESP_INFO     LcReplyPtr ;

            LcReplyPtr = (LPDSP_BUFF_RESP_INFO) PmReplyBlkPtr ;
            LcAddrPtr  = (LPADD_DESC_INFO)(LcReplyPtr + 1) ;

            NTBProceedMappings( (DWORD)LcReplyPtr->dbReservedBuffers,
                                LcAddrPtr );

        }
        // All other requests that have some buffers to handle
        // may only unmap them. They use a union reply block
        // to locate the unmap requests
        //
        else if (   ( LcCommand == PIPE_DEL_CMD )
                 || ( LcCommand == DSP_MANAGE_CMD )
                 || ( LcCommand == EFFECT_CTXT_LOAD_CMD )
                 || (   ( LcCommand == REG_CMD )
                     && (((LPBC_HEADER_INFO)PmReplyBlkPtr)->hdHandle !=
                                                         REGISTER_HANDLE) ) )
        {
            LPANY_UNMAPPING_REPLY_INFO  LcReplyPtr ;

            // Unmap requests: the number of buffers
            // actually mapped is unknown
            // -------------------------------------
            LcReplyPtr = (LPANY_UNMAPPING_REPLY_INFO) PmReplyBlkPtr ;
            LcAddrPtr  = (LPADD_DESC_INFO)(LcReplyPtr->urAddrDescriptors) ;

            NTBProceedMappings( 0L, LcAddrPtr );
        }
        else
        {
            // Nothing to do
            // -------------
            // D1("Unknown function code");
        }
    }
    else
    {
        // Nothing to do
        // -------------
        // D1("Unknown family code");
    }

}


// *************************************************************************
//
// VOID APHCancel( INOUT PVOID, OUT PDWORD )
//
//  Input/Output Parameters:
//  ************************
//
//  PVOID   PmReplyBlkPtr  :  command response bloc
//  PDWORD  PmReplyBlkPtr  :  length of the response bloc
//
// *************************************************************************
//
//  Handle cancellation of IRPs
//
// FS - 01/04/1997 - In order to manage cancelled IRPs
//
// *************************************************************************
VOID APHCancel(
    INOUT   PVOID   PmReplyBlkPtr   ,
    OUT     PDWORD  PmReplySizePtr  )
{
    LPBC_HEADER_INFO    LcRequestPtr = (LPBC_HEADER_INFO) PmReplyBlkPtr ;
    LPRESP_HEADER_INFO  LcReplyPtr  = (LPRESP_HEADER_INFO)PmReplyBlkPtr ;
    BYTE                LcFamily, LcCommand ;
    BYTE                LcAppIndex  ;
    WORD                LcRet       ;
	WORD				LcCurrentBoard = 0;

    // Retrieve Family and command numbers
    // to identify whether extra processing is needed
    // -----------------------------------------------
    LcFamily  = LcRequestPtr->hdFamily;
    LcCommand = LcRequestPtr->hdComNum;

    // Set return status as cancelled
    // ------------------------------
    LcReplyPtr->rhCptr = ED_CANCELLED ;
    LcReplyPtr->rhT = PROCESSED ;
    *PmReplySizePtr = sizeof(RESP_HEADER_INFO);

    // Remove the buffer reference within driver structures
    // -----------------------------------------------------
    LcAppIndex = DecodeHandle( LcRequestPtr->hdHandle );
    switch( LcFamily )
    {
    case PLAY_RECORD_FAM:
        switch( LcCommand )
        {
            WORD            LcPipeIndex     ;
            WORD            LcNumStream     ;
            PPIPE_INFO      LcPipeInfPtr    ;
            PVOIE_INFO      LcVoieInfPtr    ;
            TARGET_INFO     LcTarget        ;

        case PLAY_CMD:
            LcRet = ChkPmOneOutputPipeMask( LcAppIndex,
                                    ((LPPLAY_REQ_INFO) LcRequestPtr)->plqOutPipeMask64.QuadPart,
                                    &LcPipeIndex,
                                    &LcPipeInfPtr,
                                    &LcVoieInfPtr,
                                    &LcTarget );

			LcCurrentBoard = LcTarget.tgCarte;

            if ( LcRet == SUCCESS )
            {
                // Seek the stream number
                LcNumStream = UTIDWMask2Word(
                            ((LPPLAY_REQ_INFO)LcRequestPtr)->plqStreamMask );

                // Update TARGET_INFO structure
                LcTarget.tgMaskFlux = UTIMaskDWord( LcNumStream );

                (void) CUR_PROTOCOL_PTR->IBuffer_CancelStreamBuffer( &LcTarget, LcRequestPtr );

                // MBR (2003/05/23) it's the driver that counts the playback bytes now
                // reset the counter for the stream here (the stream gets stopped here!)
                TbOutStreamBytePos[LcPipeIndex][LcNumStream] = 0;
            }
            break;

        case RECORD_CMD:
            LcRet = ChkPmOneInputPipeMask(  LcAppIndex,
                                    ((LPRECORD_REQ_INFO) LcRequestPtr)->rcqInPipeMask64.QuadPart,
                                    &LcPipeIndex,
                                    &LcPipeInfPtr,
                                    &LcVoieInfPtr,
                                    &LcTarget );

			LcCurrentBoard = LcTarget.tgCarte;

            if ( LcRet == SUCCESS )
            {
                // Seek the stream number
                LcNumStream = UTIDWMask2Word(
                            ((LPRECORD_REQ_INFO)LcRequestPtr)->rcqStreamMask );

                // Update TARGET_INFO structure
                LcTarget.tgMaskFlux = UTIMaskDWord( LcNumStream );

                (void) CUR_PROTOCOL_PTR->IBuffer_CancelStreamBuffer( &LcTarget, LcRequestPtr );
            }
            break;

        default:
            DOUT(DBG_ERROR, ("Should never come here"));
            break;
        }
        break;

    case ASYNC_EVT_FAM:
        switch( LcCommand )
        {
            WORD            LcNumPipe       ;
            PPIPE_INFO      LcPipeInfPtr    ;
            PVOIE_INFO      LcVoieInfPtr    ;
            TARGET_INFO     LcTarget        ;

        case WAIT_ERROR_CMD:

            TbAppliInfo[LcAppIndex].AdrBlkReq = NULL ;
            break ;

        case WAIT_GPIO_EVENT_CMD:
		
            TbAppliInfo[LcAppIndex].AdrBlkReqGpio = NULL ;
            break ;

        case WAIT_ENDOF_PLAY_CMD:

            LcRet = ChkPmOneOutputPipeMask(
                            LcAppIndex,
                            ((LPWAIT_ENDOF_PLAY_REQ_INFO) LcRequestPtr)->wpqOutPipeMask64.QuadPart,
                            &LcNumPipe,
                            &LcPipeInfPtr,
                            &LcVoieInfPtr,
                            &LcTarget );

            if ( LcRet == SUCCESS )
            {
                LcPipeInfPtr->piAdrBlkReq = NULL;
            }

            break ;

        case WAIT_ENDOF_RECORD_CMD:

            LcRet = ChkPmOneInputPipeMask(
                            LcAppIndex,
                            ((LPWAIT_ENDOF_RECORD_REQ_INFO) LcRequestPtr)->wrqInPipeMask64.QuadPart,
                            &LcNumPipe,
                            &LcPipeInfPtr,
                            &LcVoieInfPtr,
                            &LcTarget );

            if ( LcRet == SUCCESS )
            {
                LcPipeInfPtr->piAdrBlkReq = NULL;
            }

            break ;

        case WAIT_NOTIFICATION_CMD:

            LcRet = ChkPmOneInOrOutPipeMask(
                            LcAppIndex,
                            ((LPWAIT_NOTIFY_REQ_INFO) LcRequestPtr)->wnrOutPipeMask64.QuadPart,
                            ((LPWAIT_NOTIFY_REQ_INFO) LcRequestPtr)->wnrInPipeMask64.QuadPart,
                            &LcNumPipe,
                            &LcPipeInfPtr,
                            &LcVoieInfPtr,
                            &LcTarget );

            if ( LcRet == SUCCESS )
            {
                LcPipeInfPtr->piAdrNotifyReq = NULL;
            }

            break ;

        case WAIT_BOARD_PNP_CMD:

            TbAppliInfo[LcAppIndex].AdrBlkReqBoardPnp = NULL;
            break;

        default:
            DOUT(DBG_ERROR, ("Should never come here+"));
            break ;
        }
        // switch( LcCommand )
        break;

    default:
            DOUT(DBG_ERROR, ("Should never come here++"));
            break ;
    }
    // switch( LcFamily )

}

// *************************************************************************
//
// VOID APHTraitIt()
//
//Input Parameters:
// ****************
//
//
//Output Paramaters:
// *****************
//
//Return value:
// ************
//
// *************************************************************************
//
// This function is called when an hardware interrupt has happened.
//
// *************************************************************************
VOID APHTraitIt( )
{
    BOOLEAN LcThereIsAnIt;
    SHORT   LcCurrentBoard;

    // While there is a board requesting an interruption
    // *************************************************
    do
    {
        LcThereIsAnIt = FALSE;
        for (LcCurrentBoard=0; LcCurrentBoard<MAX_BOARD; LcCurrentBoard++)
        {
            if (APH_Board_Info_Array[LcCurrentBoard].biCarac != CARAC_USED) continue;

            if (CUR_PROTOCOL_PTR->IEvent_AsynchronousEventPending())
            {
                DOUT( DBG_PROT_EVENT ,("APHTraitIt : Irq on board %d",LcCurrentBoard));

                LcThereIsAnIt = TRUE;
                TraitHardItBoard(LcCurrentBoard);
            }
        }
    } while (LcThereIsAnIt);

    // EndWhile (a board is requesting an interruption)
    // ************************************************
}


// *************************************************************************
//
// VOID APHKeepPipeError(PmTarget,PmError)
//
//Input Parameters:
// ****************
//      PTARGET_INFO *PmTarget : Pointer to a target which has an error
//      WORD         PmError   : Error code
//
//Output Paramaters:
// *****************
//
//Return value:
// ************
//
// *************************************************************************
//
// Handles an error on a pipe. If a request bloc is pending, sends it
// to the application; keeps the error othewise.
//
// The PmTarget describes the pipe. If it is a stream error,
// PmTarget->tgMaskFlux contains the mask of the stream. Else, it must
// contain 0.
//
// *************************************************************************

VOID APHKeepPipeError(PTARGET_INFO PmTarget, WORD PmError)
{
    WORD                       k;
    LPWAIT_ERROR_REQ_INFO      LcLPtrReq;
    LPWAIT_ERROR_RESP_INFO     LcLPtrRepHeader;
    PAPPLI_INFO                LcPtAppli;
    BOOLEAN                    LcFound = FALSE;
    PPIPE_INFO                 LcPtPipe;
    WORD                       LcNbPipe;
    BOOLEAN                    LcIsCapture = (BOOLEAN)(PmTarget->tgCaracPipeVoie & OPER_REC);

    if(LcIsCapture)
    {
        LcNbPipe = MAX_DRV_INPIPE;
        LcPtPipe = &TbPipeInInfo[0];
    }
    else
    {
        LcNbPipe = MAX_DRV_OUTPIPE;
        LcPtPipe = &TbPipeOutInfo[0];
    }
    ASSERT( PmTarget->tgCarte < MAX_BOARD );

    // While the corresponding pipe has not been found
    // ***********************************************
    for ( k=0; ((k<LcNbPipe) && (!LcFound)); k++ )
    {
        // If the current pipe is the right
        // ********************************
        if ( (LcPtPipe->piNbAudio != 0) &&
             (LcPtPipe->piNumPipeForDsp == PmTarget->tgPipe) &&
             (LcPtPipe->piNumBoard == PmTarget->tgCarte))
        {
            BYTE LcIndexAppli;

            LcFound = TRUE;

            if( LcIsCapture )
            {
                ASSERT( PmTarget->tgPipe < MAX_BOARD_INPUTS );
                LcIndexAppli = TbVoieInInfo[PmTarget->tgCarte][PmTarget->tgPipe].IndexAppli;
            }
            else
            {
                ASSERT( PmTarget->tgPipe < MAX_BOARD_OUTPUTS );
                LcIndexAppli = TbVoieOutInfo[PmTarget->tgCarte][PmTarget->tgPipe].IndexAppli;
            }
            ASSERT(LcIndexAppli > 0);
            ASSERT(LcIndexAppli < MAX_PCX_HANDLE);

            LcPtAppli = &TbAppliInfo[LcIndexAppli-1];

            DOUT(DBG_ERROR, ("ERROR %x on %s Pipe(%d) StreamMask(%x)\n",
									PmError,
									LcIsCapture ? "REC" : "PLAY",
									PmTarget->tgPipe,
									PmTarget->tgMaskFlux));

            // If there is an error request block pending on its application
            // -------------------------------------------------------------
            if (LcPtAppli->AdrBlkReq != NULL)
            {
                // Update and free the Response block
                // ----------------------------------
                LcLPtrReq =
                 (LPWAIT_ERROR_REQ_INFO)LcPtAppli->AdrBlkReq;
                LcLPtrRepHeader =
                 (LPWAIT_ERROR_RESP_INFO)LcLPtrReq->weqForDriver.deeAdrBlkResp;
                LcPtAppli->AdrBlkReq = NULL;
                
                if ( LcIsCapture == FALSE )
                {
                    /* play*/
                    LcLPtrRepHeader->wepOutPipeMask64.QuadPart = UTIMask64bit(k);
                    LcLPtrRepHeader->wepInPipeMask64.QuadPart = 0;
                }
                else
                {
                    LcLPtrRepHeader->wepInPipeMask64.QuadPart = UTIMask64bit(k);
                    LcLPtrRepHeader->wepOutPipeMask64.QuadPart = 0;
                }

                LcLPtrRepHeader->wepStreamMask = PmTarget->tgMaskFlux;
                LcLPtrRepHeader->wepError = PmError;
                LcLPtrRepHeader->RespHeader.rhCptr = SUCCESS;

                // FS - 28/02/1997
                // Let's clear the error
                // ----------------------
                LcPtAppli->Error = SUCCESS ;

                SignalAsyncProcessed(
                        (LPDWORD) LcLPtrRepHeader                ,
                        (PDWORD)  LcLPtrReq->weqForDriver.deeIrp ) ;
            }
            // Else (there is no request block pending)
            // ----------------------------------------
            else
            {
                LcPtPipe->piError = PmError;

                LcPtPipe->piErrorPipe = UTIMask64bit(k);
                LcPtPipe->piErrorStream = PmTarget->tgMaskFlux;
            }
            // Endif (there is a request block pending)
            // ----------------------------------------
        }
        // Endif (the current pipe is the right)
        // *************************************

        LcPtPipe++ ;
    }
    // Endwhile
    // ********
}

// *************************************************************************
//
// VOID APHKeepSeveralPipesError( ... )
//
//Input Parameters:
// ****************
//      WORD         PmBoardNum: target.tgCarte
//      WORD         PmError   : Error code
//
// *************************************************************************
//
// Handles an error on each pipe which is on the board. If a request bloc is
// pending, sends it to the application; keeps the error othewise.
//
// The PmTarget describes the board.
//
// *************************************************************************
VOID APHKeepSeveralPipesError(
    IN  WORD            PmBoardNum,
    IN  WORD            PmError )
{
    WORD                        j;
    WORD                        k;
    WORD                        LcNbPipe;
    PPIPE_INFO                  LcPtPipe;
    TARGET_INFO                 LcTarget;

    LcTarget.tgCarte = PmBoardNum;

    // Search for all the pipes beeing on the board.
    // Loop on the output audios, then on the input audios.
    // ----------------------------------------------------
    for ( j = 0 ; j < 2 ; j++ )
    {
        if ( j == 0 )
        {
            LcNbPipe  = MAX_DRV_OUTPIPE;
            LcPtPipe  = TbPipeOutInfo;
            LcTarget.tgCaracPipeVoie = OPER_PLAY;
        }
        else
        {
            LcNbPipe  = MAX_DRV_INPIPE;
            LcPtPipe  = TbPipeInInfo;
            LcTarget.tgCaracPipeVoie = OPER_REC;
        }

        for ( k = 0 ; k < LcNbPipe ; k++ )
        {
            // The current audio is used, is not the second one of a stro pipe
            // (in which case the error has already been set on the pipe),
            // and is on the board
            // ---------------------------------------------
            if ( ( LcPtPipe[k].piNbAudio != 0 ) &&
                 ( LcPtPipe[k].piNumBoard == PmBoardNum ) )
            {
                LcTarget.tgPipe     = LcPtPipe[k].piNumPipeForDsp;
                LcTarget.tgMaskFlux = LcPtPipe[k].piStreamMask;

                APHKeepPipeError( &LcTarget, PmError );
            }
        }
    }
}

// *************************************************************************
//
// VOID APHKeepDspError(PmTarget,PmError)
//
//Input Parameters:
// ****************
//      PTARGET_INFO *PmTarget : Pointer to a target which has an error
//      WORD         PmError   : Error code
//
// *************************************************************************
//
// Handles a general error on a DSP. If a request bloc is pending, sends it
// to the application; keeps the error othewise.
//
// The PmTarget describes the Dsp.
//
// *************************************************************************
VOID APHKeepDspError(
    PDSP_INFO PmPtDsp,
    WORD PmError )
{
    LPWAIT_ERROR_REQ_INFO      LcLPtrReq;
    LPWAIT_ERROR_RESP_INFO     LcLPtrRepHeader;
    PAPPLI_INFO                LcPtAppli;
    DWORD                      LcAppMask;
    WORD                       LcAppNum ;

    if (   ( PmError == ED_DSP_TIMED_OUT )
        || ( PmError == ED_DSP_CRASHED ) )
    {
        LOAD_PCX_ERROR( PmPtDsp->dsFatalError, PmError ) ;
    }

    // For each application using this DSP
    // ------------------------------------
    LcAppMask = PmPtDsp->dsMaskIndexAppli ;

    while ( LcAppMask )
    {
        LcAppNum = UTIDWMask2Word( LcAppMask );
        LcAppMask &= ~UTIMaskDWord( LcAppNum );
        LcPtAppli = &(TbAppliInfo[LcAppNum]) ;

        if (LcPtAppli->AdrBlkReq != NULL)
        {
            // Update and free the Response block
            // ----------------------------------
            LcLPtrReq = (LPWAIT_ERROR_REQ_INFO)LcPtAppli->AdrBlkReq;
            LcLPtrRepHeader =
            (LPWAIT_ERROR_RESP_INFO)LcLPtrReq->weqForDriver.deeAdrBlkResp;
            LcPtAppli->AdrBlkReq = NULL;

            LcLPtrRepHeader->wepOutPipeMask64.QuadPart = 0;
            LcLPtrRepHeader->wepInPipeMask64.QuadPart = 0;
            LcLPtrRepHeader->wepStreamMask = 0;
            LcLPtrRepHeader->wepError = PmError;
            LcLPtrRepHeader->RespHeader.rhCptr = SUCCESS;

            SignalAsyncProcessed(
                (LPDWORD) LcLPtrRepHeader                ,
                (PDWORD)  LcLPtrReq->weqForDriver.deeIrp ) ;
        }
        // Else (there is no request block pending)
        // ----------------------------------------
        else
        {
            LcPtAppli->Error = PmError;
        }
        // Endif (there is a request block pending)
        // ----------------------------------------
    }
    // End for each appli
    // -------------------
}

// *************************************************************************
//
// VOID APHEndPlayPipe(PmTarget)
//
//Input Parameters:
// ****************
//      PTARGET_INFO *PmTarget : Pointer to a target pipe
//
//
//Output Paramaters:
// *****************
//
//Return value:
// ************
//
// *************************************************************************
//
// Handles the end of play for a pipe. If a request bloc is pending, it
// is given back to the application.
//
// *************************************************************************
VOID APHEndPlayPipe(IN PTARGET_INFO PmTarget)
{

    WORD                       k;
    LPWAIT_ENDOF_PLAY_REQ_INFO LcLPtrReq;
    LPRESP_HEADER_INFO         LcLPtrRepHeader;
    BOOLEAN                    LcFound;

    // While the corresponding pipe has not been found
    // ***********************************************
    for ( k=0, LcFound = FALSE; (k<(MAX_DRV_OUTPIPE)) && (!LcFound); k++ )
    {
        // If the current pipe is the right
        // ********************************
        if (  (TbPipeOutInfo[k].piNbAudio != 0)
            && (TbPipeOutInfo[k].piNumPipeForDsp == PmTarget->tgPipe)
            && (TbPipeOutInfo[k].piNumBoard == PmTarget->tgCarte) )
        {
            LcFound = TRUE;
            if (TbPipeOutInfo[k].piAdrBlkReq != NULL)
            {
                LcLPtrReq =
                       (LPWAIT_ENDOF_PLAY_REQ_INFO)TbPipeOutInfo[k].piAdrBlkReq;
                LcLPtrRepHeader =
                    (LPRESP_HEADER_INFO)LcLPtrReq->wpqForDriver.deeAdrBlkResp;

                TbPipeOutInfo[k].piAdrBlkReq = NULL;

                // Fill Response bloc
                // ******************
                LcLPtrRepHeader->rhCptr = SUCCESS;

                SignalAsyncProcessed(
                    (LPDWORD) LcLPtrRepHeader                ,
                    (PDWORD)  LcLPtrReq->wpqForDriver.deeIrp ) ;
            }
        }
        // Endif (the current pipe is the right)
        // *************************************
    }
    // Endwhile
    // ********
}

// *************************************************************************
//
// VOID APHEndRecordPipe(PmTarget)
//
// Input Parameters:
// *****************
//
//      PTARGET_INFO *PmTarget : Pointer to a target pipe
//
// *************************************************************************
//
// Handles the end of record (offline conversion) for a pipe.
// If a request bloc is pending, it is given back to the application.
//
// *************************************************************************
VOID APHEndRecordPipe(
    IN  PTARGET_INFO    PmTarget )
{
    LPWAIT_ENDOF_RECORD_REQ_INFO    LcLPtrReq       ;
    LPRESP_HEADER_INFO              LcLPtrRepHeader ;
    BOOLEAN             LcFound     ;
    WORD                k           ;

    // While the corresponding pipe has not been found
    // ***********************************************
    for ( k = 0, LcFound = FALSE ;
         ( k < MAX_BOARD_INPUTS ) && (!LcFound);
         k++ )
    {
        // If the current pipe is the right
        // ********************************
        if (  (TbPipeInInfo[k].piNbAudio != 0)
            && (TbPipeInInfo[k].piNumPipeForDsp == PmTarget->tgPipe)
            && (TbPipeInInfo[k].piNumBoard == PmTarget->tgCarte) )
        {
            LcFound = TRUE;

            if (TbPipeInInfo[k].piAdrBlkReq == NULL)
            {
                TbPipeInInfo[k].piConversionEnded = TRUE ; // FS - 04/03/1997
                break ;
            }

            LcLPtrReq =
                (LPWAIT_ENDOF_RECORD_REQ_INFO)TbPipeInInfo[k].piAdrBlkReq;
            LcLPtrRepHeader =
                (LPRESP_HEADER_INFO)LcLPtrReq->wrqForDriver.deeAdrBlkResp;

            TbPipeInInfo[k].piAdrBlkReq = NULL;
            TbPipeInInfo[k].piConversionEnded = FALSE ; // FS - 04/03/1997

            // Fill Response bloc
            // ******************
            LcLPtrRepHeader->rhCptr = SUCCESS;

            SignalAsyncProcessed(
                (LPDWORD) LcLPtrRepHeader                ,
                (PDWORD)  LcLPtrReq->wrqForDriver.deeIrp ) ;
        }
        // Endif (the current pipe is the right)
        // *************************************
    }
    // Endwhile
    // ********
}

// *************************************************************************
//
// VOID APHNotifyPipe( IN TARGET_INFO, IN BOOLEAN )
//
// Input Parameters:
// *****************
//
//      PTARGET_INFO *  PmTarget : Pointer to a target pipe
//      BOOLEAN         PmMayBePending : flag to know whether the notification
//                                 must be registered as pending or not
//
// Output Parameters:
// ******************
//
//  None
//
// Return value:
// *************
//
//  None
//
// *************************************************************************
//
// Handles the notification of a differed command for a pipe.
// If a request bloc is pending, it is given back to the application.
// The pending flags allows a notification request to be stored as pending
// if no wait request has been registered. Otherwise, the notification
// request is dropped away
//
// *************************************************************************
VOID APHNotifyPipe(
    IN  PTARGET_INFO    PmTarget,
    IN  BOOLEAN         PmMayBePending )
{
    LPWAIT_NOTIFY_REQ_INFO  LcLPtrReq       ;
    LPRESP_HEADER_INFO      LcLPtrRepHeader ;
    BOOLEAN                 LcFound     ;
    WORD                    k           ;
    WORD                    LcMaxPipe   ;
    PPIPE_INFO              LcPtPipe    ;


    // Select the appropriate structures
    // ----------------------------------
    if ( PmTarget->tgCaracPipeVoie == OPER_PLAY )
    {
        LcPtPipe    = &TbPipeOutInfo[0];
        LcMaxPipe   = MAX_DRV_OUTPIPE;
    }
    else
    {
        LcPtPipe    = &TbPipeInInfo[0];
        LcMaxPipe   = MAX_DRV_INPIPE;
    }

    // While the corresponding pipe has not been found
    // ***********************************************
    for ( k = 0, LcFound = FALSE ;
         ( k < LcMaxPipe ) && (!LcFound);
         k++ )
    {
        // If the current pipe is the right
        // ********************************
        if (  (LcPtPipe[k].piNbAudio != 0)
            && (LcPtPipe[k].piNumPipeForDsp == PmTarget->tgPipe)
            && (LcPtPipe[k].piNumBoard == PmTarget->tgCarte) )
        {
            LcFound = TRUE;

            LcPtPipe[k].piPendingNotify = TRUE ;

            if (LcPtPipe[k].piAdrNotifyReq != NULL)
            {
                LcLPtrReq =
                    (LPWAIT_NOTIFY_REQ_INFO)LcPtPipe[k].piAdrNotifyReq;
                LcLPtrRepHeader =
                    (LPRESP_HEADER_INFO)LcLPtrReq->wnrForDriver.deeAdrBlkResp;

                LcPtPipe[k].piAdrNotifyReq = NULL;

                // Fill Response bloc
                // ******************
                LcLPtrRepHeader->rhCptr = SUCCESS;

                SignalAsyncProcessed(
                    (LPDWORD) LcLPtrRepHeader                ,
                    (PDWORD)  LcLPtrReq->wnrForDriver.deeIrp ) ;

                // ## FS (16/04/1998) -- FA #152
                // A command has been notified but
                // no read has occured yet
                // --------------------------------
                LcPtPipe[k].piNotifiedNotReadYet = TRUE ;

                // ## FS (07/11/1997) -- bouncing notification
                //
                // Clear the pending notification flag once
                // the application is notified
                // ----------------------------------------
                LcPtPipe[k].piPendingNotify = FALSE ;

            }
            // No wait request and the notification
            // should not stay pending
            else if ( !PmMayBePending )
            {
                // This is a StopPipe
                // ------------------

                // ## FS (25/11/97) -- missing reinit of the pending flag
                // that cause missing further notifications after a stop
                // pipe when there is no wait for notification
                // bug fix for FA#78
                // ------------------------------------------------------
                LcPtPipe[k].piPendingNotify = FALSE ;
            }
            else
            {
                // ## FS (16/04/1998) -- FA #152
                // A command has been notified but
                // no read has occured yet
                // --------------------------------
                LcPtPipe[k].piNotifiedNotReadYet = TRUE ;
            }
        }
        // Endif (the current pipe is the right)
        // *************************************
    }
    // Endwhile
    // ********
}


// *************************************************************************
//
// VOID APHNotifyBoardPnpEvent( IN WORD, IN BYTE )
//
// Input Parameters:
// *****************
//
//      WORD    PmBoardNum  : Board index
//      BYTE    PmEvent     : Event to dispatch to applications
//
// *************************************************************************
//
// Handles the notification of a differed command for a pipe.
// If a request bloc is pending, it is given back to the application.
//
// *************************************************************************
VOID APHNotifyBoardPnpEvent(
    IN  WORD    PmBoardNum,
    IN  BYTE    PmEvent )
{
    LPWAIT_BOARD_PNP_REQ_INFO   LcLPtrReq   ;
    LPWAIT_BOARD_PNP_RESP_INFO  LcLPtrRep   ;
    LPRESP_HEADER_INFO      LcLPtrRepHeader ;
    PAPPLI_INFO             LcPtAppli       ;
    UINT                    i               ;

    // Seek for any application that has requested
    // pocket events
    //
    LcPtAppli = &(TbAppliInfo[0]) ;
    for ( i = 0 ; i < MAX_PCX_HANDLE ; i++ )
    {
        // Skip free slots of TbAppliInfo
        //
        // Skip any application that is not waiting for
        // pocket events or not
        //
        if (   ( LcPtAppli->Carac != 0 )
            && ( LcPtAppli->AdrBlkReqBoardPnp != NULL ) )
        {
            // Here we have found an application
            // waiting for any events about PCXPocket boards.
            // Hence, let's retrieve and fill the
            // reply block of the Wait command sent by the
            // application, and let's terminate the asynchronous wait
            //
            LcLPtrReq = (LPWAIT_BOARD_PNP_REQ_INFO) LcPtAppli->AdrBlkReqBoardPnp ;
            LcLPtrRep = (LPWAIT_BOARD_PNP_RESP_INFO) LcLPtrReq->wpqForDriver.deeAdrBlkResp ;
            LcLPtrRepHeader = (LPRESP_HEADER_INFO) LcLPtrRep ;

            // The Wait request is over now, so let's forget about
            // it
            //
            LcPtAppli->AdrBlkReqBoardPnp = NULL ;

            // Fill Response bloc
            // ******************
            LcLPtrRepHeader->rhCptr = SUCCESS ;
            LcLPtrRep->wprEvent = PmEvent ;
            LcLPtrRep->wprBoardMask = UTIMaskWord( PmBoardNum ) ;

            // Terminate the Wait request
            // **************************
            SignalAsyncProcessed(
                    (LPDWORD) LcLPtrRepHeader                ,
                    (PDWORD)  LcLPtrReq->wpqForDriver.deeIrp ) ;
        }

        // Next slot
        //
        LcPtAppli++;

    }
    // For all applications
}

// *************************************************************************
//
// VOID APHCancelBoardPnpEvent(...)
//
// Input Parameters:
// *****************
//
//      WORD    PmAppliNum
//
// *************************************************************************
//
// If a request bloc is pending for this applicaiton, it is given back to the
// application.
//
// *************************************************************************
VOID APHCancelBoardPnpEvent(
    IN  WORD    PmAppliNum )
{
    LPWAIT_BOARD_PNP_REQ_INFO   LcLPtrReq;
    LPWAIT_BOARD_PNP_RESP_INFO  LcLPtrRep;
    LPRESP_HEADER_INFO          LcLPtrRepHeader;
    PAPPLI_INFO                 LcPtAppli;

    LcPtAppli = &(TbAppliInfo[PmAppliNum]) ;

    if ( LcPtAppli->Carac != 0 )
    {
        if ( LcPtAppli->AdrBlkReqBoardPnp != NULL )
        {
            LcLPtrReq = (LPWAIT_BOARD_PNP_REQ_INFO) LcPtAppli->AdrBlkReqBoardPnp ;
            LcLPtrRep = (LPWAIT_BOARD_PNP_RESP_INFO) LcLPtrReq->wpqForDriver.deeAdrBlkResp ;
            LcLPtrRepHeader = (LPRESP_HEADER_INFO) LcLPtrRep ;

            LcPtAppli->AdrBlkReqBoardPnp = NULL ;

            // Fill Response bloc
            // ******************
            LcLPtrRepHeader->rhCptr = SUCCESS ;
            LcLPtrRep->wprEvent = BOARD_EVENT_NOTHING ;
            LcLPtrRep->wprBoardMask = 0 ;

            // Terminate the Wait request
            // **************************
            SignalAsyncProcessed(
                    (LPDWORD) LcLPtrRepHeader                ,
                    (PDWORD)  LcLPtrReq->wpqForDriver.deeIrp ) ;
        }
    }
}


// *************************************************************************
//
// VOID APHNotifyGpioEvent(...)
//
// Input Parameters:
// *****************
//
//      WORD    PmBoardNum  : Pocket board index
//                            
//
// *************************************************************************
//
// Handles the notification of a differed command for a board.
// If a request bloc is pending, it is given back to the application.
//
// *************************************************************************
VOID APHNotifyGpioEvent(
    IN  WORD    PmBoardNum )
{
    LPWAIT_GPIO_REQ_INFO    LcLPtrReq       ;
    LPWAIT_GPIO_RESP_INFO   LcLPtrRep       ;
    LPRESP_HEADER_INFO      LcLPtrRepHeader ;
    PAPPLI_INFO             LcPtAppli       ;
    WORD                    LcAppIndex      ;

    // An application opened the GPIOs.
    //
    LcAppIndex = APH_Board_Info_Array[PmBoardNum].biGpioAppliIndex;
    if ( LcAppIndex != MAX_PCX_HANDLE )
    {
        LcPtAppli = &(TbAppliInfo[LcAppIndex]) ;

        if ( LcPtAppli->Carac != 0 )
        {
            // The application gave us a reply block.
            //
            if ( LcPtAppli->AdrBlkReqGpio != NULL )
            {
                // Hence, let's retrieve and fill the
                // reply block of the Wait command sent by the
                // application, and let's terminate the asynchronous wait
                //
                LcLPtrReq = (LPWAIT_GPIO_REQ_INFO) LcPtAppli->AdrBlkReqGpio ;
                LcLPtrRep = (LPWAIT_GPIO_RESP_INFO) LcLPtrReq->wpqForDriver.deeAdrBlkResp ;
                LcLPtrRepHeader = (LPRESP_HEADER_INFO) LcLPtrRep ;

                // The Wait request is over now, so let's forget about it
                //
                LcPtAppli->AdrBlkReqGpio = NULL ;
                APH_Board_Info_Array[PmBoardNum].biGpioEvent = FALSE;

                // Fill Response bloc
                // ******************
                LcLPtrRepHeader->rhCptr = SUCCESS ;
                LcLPtrRep->wgrBoardMask = UTIMaskWord( PmBoardNum );

                DOUT(DBG_PRINT, ("GPIO: signal %d", PmBoardNum));

                // Terminate the Wait request
                // **************************
                SignalAsyncProcessed(
                        (LPDWORD) LcLPtrRepHeader                ,
                        (PDWORD)  LcLPtrReq->wpqForDriver.deeIrp ) ;
            }
            else

            // The application didn't give us a reply block. Store the
            // fact that this event occured.
            //
            {
                APH_Board_Info_Array[PmBoardNum].biGpioEvent = TRUE;

                DOUT(DBG_PRINT, ("GPIO: keep %d", PmBoardNum));
            }
        }
    }
}

// *************************************************************************
//
// VOID APHCancelGpioEvent(...)
//
// Input Parameters:
// *****************
//
//      WORD    PmAppliNum
//
// *************************************************************************
//
// If a request bloc is pending for this applicaiton, it is given back to the
// application.
//
// *************************************************************************
VOID APHCancelGpioEvent(
    IN  WORD    PmAppliNum )
{
    LPWAIT_GPIO_REQ_INFO    LcLPtrReq       ;
    LPWAIT_GPIO_RESP_INFO   LcLPtrRep       ;
    LPRESP_HEADER_INFO      LcLPtrRepHeader ;
    PAPPLI_INFO             LcPtAppli       ;

    LcPtAppli = &(TbAppliInfo[PmAppliNum]) ;

    if ( LcPtAppli->Carac != 0 )
    {
        // The application gave us a reply block.
        //
        if ( LcPtAppli->AdrBlkReqGpio != NULL )
        {
            // Hence, let's retrieve and fill the
            // reply block of the Wait command sent by the
            // application, and let's terminate the asynchronous wait
            //
            LcLPtrReq = (LPWAIT_GPIO_REQ_INFO) LcPtAppli->AdrBlkReqGpio ;
            LcLPtrRep = (LPWAIT_GPIO_RESP_INFO) LcLPtrReq->wpqForDriver.deeAdrBlkResp ;
            LcLPtrRepHeader = (LPRESP_HEADER_INFO) LcLPtrRep ;

            // The Wait request is over now, so let's forget about
            // it
            //
            LcPtAppli->AdrBlkReqGpio = NULL ;

            // Fill Response bloc
            // ******************
            LcLPtrRepHeader->rhCptr = SUCCESS ;
            LcLPtrRep->wgrBoardMask = UTIMaskWord( 0 ) ; // Arbitrary value.

            // Terminate the Wait request
            // **************************
            SignalAsyncProcessed(
                    (LPDWORD) LcLPtrRepHeader                ,
                    (PDWORD)  LcLPtrReq->wpqForDriver.deeIrp ) ;
        }
    }
}

// *************************************************************************
//
// VOID APHTreatGpioIt(...)
//
// Input Parameters:
// *****************
//
//      WORD    PmBoardNum
//
// *************************************************************************
//
// If a GPIO input changes, that is opened, save it and notify the event
//
// *************************************************************************
VOID APHTreatGpioIt(
    IN  WORD    LcCurrentBoard )
{
    PBOARD_INFO LcPtBoard = &(APH_Board_Info_Array[LcCurrentBoard]) ;

    // if there are GPIO's to trace, lets do so
    if(LcPtBoard->biGpioNotifyMask != 0)
    {
        WORD        LcErrCode;
        DWORD       LcGpioData;

        // read the bits that have to be traced!
        LcErrCode = CUR_COMMANDS_PTR->PIOReadGPIO( LcPtBoard->biGpioNotifyMask, &LcGpioData );
        if(LcErrCode == SUCCESS)
        {
            // if different from previous value, let's continue
            if(LcGpioData != LcPtBoard->biGpioNotifyLastRead)
            {
                DWORD       LcGpioData1;
                DWORD       LcGpioData2;
            
                // read 2 more times to be sure that is was no Peak or noise that made an interrupt
                CUR_COMMANDS_PTR->PIOReadGPIO( LcPtBoard->biGpioNotifyMask, &LcGpioData1 );
                CUR_COMMANDS_PTR->PIOReadGPIO( LcPtBoard->biGpioNotifyMask, &LcGpioData2 );

                // only if we read 3 times the same thing
                if((LcGpioData == LcGpioData1) && (LcGpioData == LcGpioData2))
                {
                    WORD LcNextWriteIndex = LcPtBoard->biGpioFifoWriteIndex + 1;
                    if( LcNextWriteIndex == GPIO_NP2_FIFO_SIZE )
                        LcNextWriteIndex = 0;

                    // if there is place in the Fifo, store the value
                    if( LcNextWriteIndex != LcPtBoard->biGpioFifoReadIndex)
                    {
                        LcPtBoard->biGpioFifo[LcPtBoard->biGpioFifoWriteIndex] = LcGpioData;
                        LcPtBoard->biGpioFifoWriteIndex = LcNextWriteIndex;
                    }

                    // store also here the last read value!
                    LcPtBoard->biGpioNotifyLastRead = LcGpioData;

                    APHNotifyGpioEvent(LcCurrentBoard);
                }
            }
        }
    }
}


// *************************************************************************
//
// WORD     APHGetPipeClock( ... );
//
// Input Parameters:
// *****************
//
// PTARGET_INFO PmPTarget:  Structure which design the target
//
// Output Parameters:
// **************************
//
// PBYTE       PmPSource
// PBYTE       PmPSyncPresent
// PDWORD      PmPFrequency
//
// *************************************************************************
//
//  Read the characteristics of the clock of the pipe.
//
// *************************************************************************
WORD     APHGetPipeClock(
    IN  BOOLEAN         PmForceActual,
    IN  PTARGET_INFO    PmPTarget,
    OUT PBYTE           PmPSource,
    OUT PBYTE           PmPSyncPresent,
    OUT PDWORD          PmPFrequency )
{
    PBOARD_INFO   LcPBoard;
    WORD          LcRet = SUCCESS;
	BOOLEAN       LcpDummy1;

	WORD LcCurrentBoard = PmPTarget->tgCarte;

    LcPBoard = CUR_BOARD_INFO_PTR;
	
	*PmPSource      = CLOCK_TYPE_ETHERSOUND;

	LcRet = CUR_PROTOCOL_PTR->IClock_BoardGetClockFrequency(	PmPFrequency,	&LcpDummy1);

	if	((*PmPFrequency == 0)  || (LcRet != SUCCESS))
		*PmPSyncPresent = DRV_SYNC_UNKNOWN;
	else	 
		*PmPSyncPresent = DRV_SYNC_PRESENT;

    return( LcRet );
} //APHGetPipeClock


// *************************************************************************
//
// DWORD APH_Get_Pipe_Audio_Mask ( WORD PmPipeIndex ) 
//
// *************************************************************************
DWORDLONG APH_Get_Pipe_Audio_Mask( WORD PmPipeIndex ) 
{ 
    ASSERT( TbPipeInInfo[PmPipeIndex].piPhysAudioMask);
    return TbPipeInInfo[PmPipeIndex].piPhysAudioMask;
} // APH_Get_Pipe_Audio_Mask



// *************************************************************************
//
// VOID APHPrepareFakedPipeEntry( );
//
// Input Parameters:
// *****************
//
//  None.
//
// Output Parameters:
// ******************
//
//  None.
//
// Return value:
// *************
//
//  None.
//
// *************************************************************************
//
// Create a pseudo VOIE_INFO / PIPE_INFO entry for DirectSound use
//
// *************************************************************************
//
VOID    APHPrepareFakedPipeEntry(
    IN  PTARGET_INFO    PmPTarget,
    IN  WORD            PmAppIndex,
    IN  WORD            PmAudioNumber,
    OUT PDWORDLONG      PmPipeMaskPtr )
{
    PPIPE_INFO  LcPtPipe;
    PVOIE_INFO  LcPtVoie;

	SHORT LcCurrentBoard = PmPTarget->tgCarte;

    PDSP_INFO   LcPDsp = &(APH_Board_Info_Array[LcCurrentBoard].biTbDspInfo[0]);
    DWORD       LcMaxPipe ;
    WORD        j;
    PDWORDLONG  LcPMaskVPInOut;
    DWORDLONG   LcPhysAudioMask;
    BYTE        LcPipeIndex;

    *PmPipeMaskPtr = 0 ;

	if( PmPTarget->tgCaracPipeVoie == OPER_PLAY )
	{
		LcPtPipe = TbPipeOutInfo;
		LcMaxPipe = MAX_DRV_OUTPIPE;
		LcPMaskVPInOut = &LcPDsp->dsMaskVPOut;
	}
	else	// OPER_REC
	{
		LcPtPipe = TbPipeInInfo;
		LcMaxPipe = MAX_DRV_INPIPE;
		LcPMaskVPInOut = &LcPDsp->dsMaskVPIn;
	}

    LcPhysAudioMask = (DWORDLONG)Channels2AudioMask(PmAudioNumber) << PmPTarget->tgAudio;

	// check LcPDsp->dsMaskVPIn or LcPDsp->dsMaskVPOut for audios already used
    if( (*LcPMaskVPInOut & LcPhysAudioMask) != LcPhysAudioMask )
    {
        return ;
    }

    for ( LcPipeIndex=0 ; LcPipeIndex < LcMaxPipe ; LcPipeIndex++ )
    {
		// on prend le premier dispo en se basant sur nbAudio
		// 
        if ( LcPtPipe[LcPipeIndex].piNbAudio == 0 )
            break ;
    }
    if( LcPipeIndex == LcMaxPipe)   return;

    DOUT(DBG_PRINT, ("APHPrepareFakedPipeEntry %c PhysAudio %I64x PipeIndex %d\n",
        PmPTarget->tgCaracPipeVoie?'C':'P', LcPhysAudioMask, LcPipeIndex ));

    // initialize the entry
    // ---------------------
    if( PmPTarget->tgCaracPipeVoie == OPER_PLAY ) {
        LcPtVoie = TbVoieOutInfo[LcCurrentBoard];
    } else {
        LcPtVoie = TbVoieInInfo[LcCurrentBoard];
    }
    LcPtVoie = &LcPtVoie[PmPTarget->tgAudio];
    LcPtPipe = &LcPtPipe[LcPipeIndex];

    // Fill the corresponding pipe structure
    // **************************************
    LcPtPipe->piNumPipeForDsp = (BYTE)PmPTarget->tgAudio;
    LcPtPipe->piNumBoard = (BYTE) LcCurrentBoard;
    LcPtPipe->piNbAudio = (BYTE) PmAudioNumber;
    LcPtPipe->piNbMaxFlux = (BYTE) 1;
    LcPtPipe->piStreamMask         = 1L;
    LcPtPipe->piPhysAudioMask = LcPhysAudioMask;
    LcPtPipe->piVioHandle          = 0 ;  // Initiliazed later on
    // LcPtPipe->piHandleBuffers      = 0 ;  // Initiliazed later on
    LcPtPipe->piAdrNotifyReq       = NULL;      // FS - 25/04/1997
    LcPtPipe->piPendingNotify      = FALSE ;    // for notified commands
    LcPtPipe->piNotifiedNotReadYet = FALSE ;    // for notified commands

	// reserve audios in LcPDsp->dsMaskVPIn or LcPDsp->dsMaskVPOut
    *LcPMaskVPInOut &= ~LcPhysAudioMask;

    *PmPipeMaskPtr = UTIMask64bit( LcPipeIndex );

    for( j=0; j<PmAudioNumber; j++ )
    {
        ASSERT( LcPtVoie->IndexAppli == 0 );
        LcPtVoie->Nat = 0; // physical
        LcPtVoie->AppAudioNum = 0; // unused since faked
        LcPtVoie->AudioNum = (BYTE) PmPTarget->tgAudio + j;
        LcPtVoie->IndexAppli = (BYTE) ( PmAppIndex + 1 );
        LcPtVoie->NumPipe = LcPipeIndex;
        LcPtVoie++;
    }
}

// *************************************************************************
//
// VOID APHFillInFakedPipeEntry( );
//
// Input Parameters:
// *****************
//
//  None.
//
// Output Parameters:
// ******************
//
//  None.
//
// Return value:
// *************
//
//  None.
//
// *************************************************************************
//
// Fills remining fields of PIPE_INFO entry for DirectSound use
//
// *************************************************************************
//
VOID    APHFillInFakedPipeEntry(
    IN  PTARGET_INFO    PmPTarget,
    IN  DWORDLONG       PmPipeMask,
	IN  PVOID           PmParentIchWave)
{
    PPIPE_INFO  LcPtPipe;
    WORD        LcPipeIndex ;

    LcPipeIndex = UTI64Mask2Word( PmPipeMask );

    LcPtPipe = ( PmPTarget->tgCaracPipeVoie == OPER_PLAY ) ? TbPipeOutInfo : TbPipeInInfo ;

    // initialize the entry
    // ---------------------
    LcPtPipe[LcPipeIndex].piVioHandle       = PmPTarget->tgVioHandle ;
    LcPtPipe[LcPipeIndex].piParentIchWave   = PmParentIchWave ;
}

// *************************************************************************
//
// VOID APHRemoveFakedPipeEntry( );
//
// Input Parameters:
// *****************
//
//  None.
//
// Output Parameters:
// ******************
//
//  None.
//
// Return value:
// *************
//
//  None.
//
// *************************************************************************
//
// Remove a pseudo VOIE_INFO / PIPE_INFO entry for DirectSound use
//
// *************************************************************************
//
VOID    APHRemoveFakedPipeEntry(
    IN  PTARGET_INFO    PmPTarget,
    IN  WORD            PmAppIndex )
{
    PPIPE_INFO  LcPtPipe;
    PVOIE_INFO  LcPtVoie;
    BOOLEAN     LcFound = FALSE ;
    DWORD       LcMaxPipe ;
    DWORD       LcFirstAudio ;
    DWORD       LcPipeIndex;

	SHORT LcCurrentBoard = PmPTarget->tgCarte;

    if( PmPTarget->tgCaracPipeVoie == OPER_PLAY ) {
        LcPtPipe = TbPipeOutInfo;
        LcPtVoie = TbVoieOutInfo[LcCurrentBoard];
        LcMaxPipe = MAX_DRV_OUTPIPE;
    } else {
        LcPtPipe = TbPipeInInfo;
        LcPtVoie = TbVoieInInfo[LcCurrentBoard];
        LcMaxPipe = MAX_DRV_INPIPE;
    }

    for ( LcPipeIndex = 0 ; LcPipeIndex < LcMaxPipe ; LcPipeIndex++ )
    {
		if (   ( LcPtPipe[LcPipeIndex].piNumPipeForDsp == PmPTarget->tgPipe )
            && ( LcPtPipe[LcPipeIndex].piNumBoard == LcCurrentBoard )
			
			// cas ou p(0) est en fait le pipe sur 2/3 qu'on a allou en premier et qu'on vient de liberer, 
			// on a alors p(0)->piNumPipeForDsp == 0, on on va donc pointer sur celui l pour libere le pipe sur 0/1 
			// ce qui verrouille les voie 0/1 qui ne seront plus liberees.
			// dans le prepare c'est piNbAudio qu'on regarde, c'est donc a qu'il faut tester
			// 

			&& ( LcPtPipe[LcPipeIndex].piNbAudio != 0 ))
        {
            LcFound = TRUE ;
            break ;
        }
    }
    ASSERT( LcFound );

    // initialize the entry
    // ---------------------
    if ( LcFound == TRUE )
    {
        LcFirstAudio = LcPtPipe[LcPipeIndex].piNumPipeForDsp;
        ASSERT( LcPtVoie[LcFirstAudio].IndexAppli == (PmAppIndex+1) );

        PDSP_INFO   LcPDsp = &(APH_Board_Info_Array[LcCurrentBoard].biTbDspInfo[0]);

        WORD  LcNbAudio = LcPtPipe[LcPipeIndex].piNbAudio;
        DWORDLONG LcPhysAudioMask = ((DWORDLONG)Channels2AudioMask(LcNbAudio)) << PmPTarget->tgAudio;

        DOUT(DBG_PRINT, ("APHRemoveFakedPipeEntry %c PhysAudioMask %I64x PipeIndex %d\n",
            PmPTarget->tgCaracPipeVoie?'C':'P', LcPhysAudioMask, LcPipeIndex ));

        if ( PmPTarget->tgCaracPipeVoie == OPER_PLAY )
        {
            LcPDsp->dsMaskVPOut |= LcPhysAudioMask;
        }
        else
        {
            LcPDsp->dsMaskVPIn |= LcPhysAudioMask;
        }
        BZERO2( &(LcPtVoie[LcFirstAudio]), VOIE_INFO, LcNbAudio );
        BZERO2( &(LcPtPipe[LcPipeIndex]), PIPE_INFO, 1 );
    }
}


VOID APHNotifyAllDSoundPipes( IN WORD PmBoardIndex )
{
	int i;
    // For all the pipes
    // -----------------
    for (i=0; i<2; i++)
    {
        BOOLEAN		LcIsCapture;
		WORD		LcCurrentPipe, LcNbPipe;
		PPIPE_INFO	LcPtPipe;

        switch(i)
        {
        case 0 :
            LcPtPipe = TbPipeOutInfo;
            LcNbPipe = MAX_DRV_OUTPIPE;
            LcIsCapture = FALSE;
            break;

        case 1 :
            LcPtPipe = TbPipeInInfo;
            LcNbPipe = MAX_DRV_INPIPE;
            LcIsCapture = TRUE;
            break;
        }

		for (LcCurrentPipe=0; LcCurrentPipe<LcNbPipe; LcCurrentPipe++)
		{
			// If this pipe belongs to the current board
			// -----------------------------------------
			if ( (LcPtPipe->piNumBoard == PmBoardIndex) )
			{
				// Direct Sound Pipe !
				//
				if( LcPtPipe->piParentIchWave )
				{
					DSNDNotifyStream(LcPtPipe->piParentIchWave, LcIsCapture, LcPtPipe->piNumPipeForDsp, FALSE);
				}
			}// Endif this pipe belongs to the current board
            // --------------------------------------------

            // Following pipe
            // --------------
            LcPtPipe += 1;
        }
   }// Endfor all the pipes
   // --------------------
}


// *************************************************************************
//
// VOID APHRemoveAllBoardPipeEntry( );
//
// Input Parameters:
// *****************
//
//  None.
//
// Output Parameters:
// ******************
//
//  None.
//
// Return value:
// *************
//
//  None.
//
// *************************************************************************
//
// Remove a pseudo VOIE_INFO / PIPE_INFO entry for DirectSound use
//
// *************************************************************************
//
VOID    APHRemoveAllBoardPipeEntry( IN WORD PmBoardIndex, BOOLEAN PmKeepDSound )
{
    for( int i=0; i<2; i++ )
    {
        PPIPE_INFO LcPtPipe  = ( i==0 ) ? TbPipeOutInfo : TbPipeInInfo ;
        PVOIE_INFO LcTbVoie  = ( i==0 ) ? TbVoieOutInfo[PmBoardIndex] : TbVoieInInfo[PmBoardIndex] ;
        int        LcMaxPipe = ( i==0 ) ? MAX_DRV_OUTPIPE : MAX_DRV_INPIPE ;

        for ( int j=0 ; j<LcMaxPipe ; j++ )
        {
            if( (LcPtPipe->piNbAudio != 0) &&
                (LcPtPipe->piNumBoard == PmBoardIndex) &&
                ((PmKeepDSound == FALSE) || (LcPtPipe->piParentIchWave == NULL)) )
            {
                // release all the pipes audios in dsMaskVPOut or dsMaskVPIn:
                //
                DOUT(DBG_PRINT, ("APHRemoveAllBoardPipeEntry pipe %d audio %d\n", j, LcPtPipe->piNumPipeForDsp));

                PVOIE_INFO LcVoie = &LcTbVoie[LcPtPipe->piNumPipeForDsp];
                TARGET_INFO LcTarget;

                LcTarget.tgCaracPipeVoie = (i==0) ? OPER_PLAY : OPER_REC;
                LcTarget.tgCarte = PmBoardIndex;
                LcTarget.tgPipe = LcPtPipe->piNumPipeForDsp;
                LcTarget.tgVioHandle = LcPtPipe->piVioHandle;
                APHNotifyPipe( &LcTarget, FALSE );

                // mark the pipe as paused to start it correctly after wakeup() !
                APH_Protocol_Array[PmBoardIndex]->IFlow_PipePause( &LcTarget, 1, START_PAUSE_IMMEDIATE );

                // re-arrange stream list (no call to DSP)
                APH_Protocol_Array[PmBoardIndex]->IFlow_PipeRelease( &LcTarget, FALSE );

                BUFFreeBuffers( &LcPtPipe->piHandleBuffers, NULL );

                AudioReleaseSubFct( LcVoie->IndexAppli-1, LcVoie->NumPipe, LcPtPipe->piNumBoard, i!=0 );

                // Remove the current output pipe from PipeUerOutMask of BOARD_INFO structure
                //
                if( i==0 )
                {
                    // Get the corresponding DSP structure
                    int LcDsp = 0;
                    PDSP_INFO LcDspInfoPtr = &(APH_Board_Info_Array[PmBoardIndex].biTbDspInfo[LcDsp]);

                    for ( int k = 0 ; k < MAX_CONTEXT ; k ++ )
                    {
                        LcDspInfoPtr->dsContextMaskOutPipes[k] = 0;
                        LcDspInfoPtr->dsContextID[k] = 0;
                    }
                }
                else
                {
                    // do not change audio input settings if DHS controlled
                    //
                    if( FALSE == APHChkIsAudioDHSControlled( PmBoardIndex, LcTarget.tgPipe, TRUE ) )
                    {
                        // release possible source reservation on matching audios
                        //
                        DWORDLONG LcAudioMask = APH_Get_Pipe_Audio_Mask( LcVoie->NumPipe );

                        WORD LcRet = APH_Protocol_Array[PmBoardIndex]->IResource_Source_Release_Audios(LcAudioMask);

                        DOUT(DBG_PRINT, ("APHRemoveAllBoardPipeEntry REC release audios(mask %x) : %x\n", LcAudioMask, LcRet));
                    }
                }

                for( int k=0; k<LcPtPipe->piNbAudio; k++ )
                {
                    ASSERT( LcVoie->IndexAppli == 0 ); // reset to 0 by AudioReleaseSubFct
                    ASSERT( LcVoie->NumPipe == j );

                    BZERO2( LcVoie, VOIE_INFO,  1 );
                    LcVoie++;
                }

                BZERO2( LcPtPipe, PIPE_INFO,  1 );
            }
            LcPtPipe++;
        }
    }

    // TODO DHSRemoveBoard( PmBoardIndex, PmKeepDSound );   // keep DSound -> keep DHS
}


//**************************************************************************
//
// WORD    VIOGetMACAddress( IN WORD, OUT PCHAR )
//
//**************************************************************************
WORD    VIOGetMACAddress ( IN  WORD          LcCurrentBoard,
                           OUT PBYTE         PmPMACAddress )
{
    return CUR_COMMANDS_PTR->PIOGetMACAddress( PmPMACAddress ); 
} // VIOGetMACAddress

