// *************************************************************************
//
//  COPYRIGHT 1996-2000 DIGIGRAM. ALL RIGHTS RESERVED.
//  Portions Copyright (c) 1998-1999 Intel Corporation
//  Portions Copyright (c) 1998-1999 Microsoft Corporation. 
//
// **************************************************************************

#ifndef _COMMON_H_
#define _COMMON_H_

#include "pcxini_e.h"
#include "ESIOCommands.h"
#include "lxprotocol.h"


/*****************************************************************************
 * Structs
 *****************************************************************************
 */

/*****************************************************************************
 * Constants
 *****************************************************************************
 */

/*****************************************************************************
 * Classes
 *****************************************************************************
 */

/*****************************************************************************
 * CAdapterCommon
 *****************************************************************************
 * This is the common adapter object shared by all miniports to access the
 * hardware.
 */
class CAdapterCommon : public IAdapterCommon,
                       public IAdapterPowerManagement,
                       public CUnknown
{
private:
    static LONG     m_Instance;         // object instance counter
    PDEVICE_OBJECT  m_pDeviceObject;    // Device object used for registry access.
    DEVICE_POWER_STATE m_PowerState;    // Current power state of the device.

    ULONG           m_ulWaveOutNumber;
    ULONG           m_ulWaveInNumber;
    ULONG           m_ulMaxWaveInOutNumber;

    PGENERAL_INFO   m_pGeneralInfo;

    WORD            m_BoardIndex;
    BOOLEAN         m_ResetBoardDone;

    KSPIN_LOCK      m_MsgLock;          // spin lock for cards SendMessages protection

    /*************************************************************************
     * CAdapterCommon methods
     *************************************************************************
     */

	VOID RegisterBoardAPINP();
    VOID InitEtherConfig();

public:

	CProtocol *m_pDSP;
	CPIOCommands *m_PIO;

    DECLARE_STD_UNKNOWN();
    DEFINE_STD_CONSTRUCTOR(CAdapterCommon);
    ~CAdapterCommon();

    /*************************************************************************
     * IAdapterPowerManagement methods
     *************************************************************************
     */
    IMP_IAdapterPowerManagement;

    /*************************************************************************
     * IAdapterCommon methods
     *************************************************************************
     */

    //
    // Initialize the adapter common object -> initialize and probe HW.
    //
    STDMETHODIMP_(NTSTATUS) Init
    (
        IN  PRESOURCELIST  ResourceList,
        IN  PDEVICE_OBJECT DeviceObject,
        IN  LPGENERAL_INFO GeneralInfo,
        IN  WORD           BoardIndex
    );

    STDMETHODIMP_(NTSTATUS) InitDSP
    (
        IN  PDEVICE_OBJECT DeviceObject,
        IN  LPGENERAL_INFO GeneralInfo,
        IN  WORD           BoardIndex
    );

    STDMETHODIMP_(ULONG) GetWaveOutNumber();

    STDMETHODIMP_(ULONG) GetWaveInNumber();

    STDMETHODIMP_(ULONG) GetMaxWaveInOutNumber();

    STDMETHODIMP_(WORD) GetBoardIndex();

    STDMETHODIMP_(NTSTATUS) GetBoardType
    (
        OUT PWORD           PmPFamilyType,
        OUT PWORD           PmPTypeNotAliased,
        OUT PWORD           PmPOptions
    );

    STDMETHODIMP_(WORD) ConvertDSound2Driver
    (
        IN LONG PmDSound,
        IN TopoNodes PmType
    );
    STDMETHODIMP_(LONG) ConvertDriver2DSound
    (
        IN WORD PmDriverLevel,
        IN TopoNodes PmType
    );

    STDMETHODIMP_(VOID) AcquireBoardLock
    (
        IN  PKIRQL  PmPOldIrql
    );
    STDMETHODIMP_(VOID) ReleaseBoardLock
    (
        IN  PKIRQL  PmPOldIrql
    );

    STDMETHODIMP_(VOID) AcquireBoardLockAtDpcLevel(VOID);
    STDMETHODIMP_(VOID) ReleaseBoardLockAtDpcLevel(VOID);

    STDMETHODIMP_(NTSTATUS) SetBoardClock
    (
        IN  DWORD   PmFrequency,
		IN  DWORDLONG PmInPipeMask,
		IN  DWORDLONG PmOutPipeMask
    );

	STDMETHODIMP_(NTSTATUS) SetUERType
    (
        IN      WORD    PmBoardAudio,
        IN      BYTE    PmUERType
    );

	STDMETHODIMP_(NTSTATUS) GetNextClockType
    (
        IN      LPBYTE  PmClockType,
        IN      LPWORD  PmSyncInNum
    );

    STDMETHODIMP_(BOOL)	GetCurrentClock
    (
		IN		DWORDLONG PmMaskPipeIN,
		IN		DWORDLONG PmMaskPipeOUT,
        OUT     LPDWORD PmPFrequency,   
        OUT     LPBOOL  PmPFrequencyLocked,
        OUT     LPBYTE  PmPClockType,
        OUT     LPWORD  PmPSyncInNum
    );

    STDMETHODIMP_(NTSTATUS) ReleaseClockSettings
    (
		IN		DWORDLONG PmInPipeMask,
		IN		DWORDLONG PmOutPipeMask
    );

	STDMETHODIMP_(VOID*) GetProtocolPtrAsVoid
    (
        VOID
    );

    STDMETHODIMP_(VOID*) GetIOCommandsPtrAsVoid
    (
        VOID
    );

    /*************************************************************************
     * Friends
     *************************************************************************
     */

    friend NTSTATUS NewAdapterCommon
    (
        OUT PADAPTERCOMMON *OutAdapterCommon,
        IN  PRESOURCELIST ResourceList
    );
};

#endif  //_COMMON_H_
