// *************************************************************************
//
//  COPYRIGHT 1996-2000 DIGIGRAM. ALL RIGHTS RESERVED.
//
//  DIGIGRAM
//
// **************************************************************************

#include "drvdef.h"
#include "pcxini_e.h"

#include "unicode.h"   // UNCAllocateUnicodeString

#include "log.h"
#include "pci_conf.h"



// Digigram official vendor ID
// (found in PCI subsystem vendor id for PCXNP, PCI vendor id for PCXNP/PLX,
//  and LCM boards subsystem vendor id)
//
#define DIGI_VENDOR_ID                      0x1369

// PLX official vendor ID and Device Id for the chipset used
// in LCM boards (PLX9050)
//
#define PLX_VENDOR_ID                       0x10b5
#define PLX9056_DEVICE_ID                   0x9056

// LXES Boards subsystem IDs (PLX9056)
// ***************************
#define LX6464ES_SERIAL_SUBSYSTEM_ID        0xC001
#define LX6464ES_CAE_SERIAL_SUBSYSTEM_ID    0xC002

// Define optional SubsystemID and SubsystemVendorID field
// in PCI_COMMON_HEADER according to PCI specs
//

typedef struct _BOARD_PCI_DETECTION_INFO {
    WORD pdiNbTest;
    WORD pdiVID;
    WORD pdiDID;
    WORD pdiSVID;
    WORD pdiSDID;
    WORD pdiBoardFam;
    WORD pdiBoard;
} BOARD_PCI_DETECTION_INFO, *PBOARD_PCI_DETECTION_INFO ;  


// *****************************************************
// * DESCRIPTION of PCI recognition for each PCI board *
// *****************************************************
static BOARD_PCI_DETECTION_INFO TbPCIDetectionInfo[] =
{ 
	{ 4, PLX_VENDOR_ID, PLX9056_DEVICE_ID, DIGI_VENDOR_ID,
      LX6464ES_SERIAL_SUBSYSTEM_ID, LXES_BOARD, LX6464ES_BOARD
    },
    { 4, PLX_VENDOR_ID, PLX9056_DEVICE_ID, DIGI_VENDOR_ID,
    LX6464ES_CAE_SERIAL_SUBSYSTEM_ID, LXES_BOARD, LX6464ES_BOARD
    },
    {
      0
    }
} ;


// ********************************************
// * DESCRIPTION of files used for each board *
// ********************************************
static BOARD_FILES_INFO TbFilesInfo[] =
{
   // EEPROM        ,  BOOT         ,  XILINX_1      ,  XILINX_2     ,  DEF_DSP
   //
   { "LX6464ES"     , LX6464ES_BOARD, LX6464ES_SERIAL_SUBSYSTEM_ID,
     NULL           , NULL,           NULL           , NULL          ,  NULL
   },
   { "LX6464ES-CAE" , LX6464ES_BOARD, LX6464ES_CAE_SERIAL_SUBSYSTEM_ID,
     NULL           , NULL,           NULL           , NULL          ,  NULL
   },
   { NULL }
} ;


// **********************************************************************
// VOID GetBoardInformation( PPCI_COMMON_CONFIG, PBOARD_INFO )
// **********************************************************************
//
// Input Parameters
// ****************
//
//  PPCI_COMMON_CONFIG      PmBusInfo    :  the PCI bus config for the board
//
// Output Parameters
// ****************
//
//  BOARD_INFO (BOARD_INFO) PmBoardInfoPtr : board identification
//
// Return Value
// ************
//
//  None
//
// **********************************************************************
STATIC BOOLEAN GetBoardInformation(
    IN  PMY_PCI_CONFIG      PmConfigPtr,
    OUT LPBOARD_INFO        PmBoardInfoPtr )
{
    PBOARD_FILES_INFO LcFilesInfoPtr = TbFilesInfo ;
    PBOARD_PCI_DETECTION_INFO LcPCIDetectionInfoPtr = TbPCIDetectionInfo ;

    WORD LcPotentialFlavor ;

/*   // if already initialized do no reset previous settings
    // ----------------------------------------------------
    if ( PmBoardInfoPtr->biXilinxTestDone ) return TRUE;*/

    // Initialize default reply
    // ------------------------
    PmBoardInfoPtr->biTypeNoAlias  = UNKNOWN_BOARD;
    PmBoardInfoPtr->biType         = UNKNOWN_BOARD;
 
    for( ; LcPCIDetectionInfoPtr->pdiNbTest != 0 ; LcPCIDetectionInfoPtr++ )
    {
        switch( LcPCIDetectionInfoPtr->pdiNbTest )
        {
        case 4 : if ( PmConfigPtr->SubSystemID != LcPCIDetectionInfoPtr->pdiSDID ) continue ;
        case 3 : if ( PmConfigPtr->SubVendorID != LcPCIDetectionInfoPtr->pdiSVID ) continue ; 
        case 2 : if ( PmConfigPtr->DeviceID != LcPCIDetectionInfoPtr->pdiDID ) continue ; 
        case 1 : if ( PmConfigPtr->VendorID != LcPCIDetectionInfoPtr->pdiVID ) continue ; 
        }
        break ;
    }

    // Board is not recognized
    if ( LcPCIDetectionInfoPtr->pdiNbTest == 0 ) return FALSE ;

    // Board is recognized so let's update its description 
    PmBoardInfoPtr->biType        = (BYTE) LcPCIDetectionInfoPtr->pdiBoardFam ;
    PmBoardInfoPtr->biTypeNoAlias = (BYTE) LcPCIDetectionInfoPtr->pdiBoard ;

    // The last PCI test performed can have different values for a same
    // kind of board. This is the flavor. 
    switch( LcPCIDetectionInfoPtr->pdiNbTest )
    {
        case 4 : LcPotentialFlavor = PmConfigPtr->SubSystemID ; break ;
        case 3 : LcPotentialFlavor = PmConfigPtr->SubVendorID ; break ; 
        case 2 : LcPotentialFlavor = PmConfigPtr->DeviceID ; break ; 
        case 1 : LcPotentialFlavor = PmConfigPtr->VendorID ; break ; 
    }

    PmBoardInfoPtr->biCSID = LcPotentialFlavor ;
    PmBoardInfoPtr->biFlavor = LcPotentialFlavor & 0x00ff;

    while (    ( LcFilesInfoPtr->bfiBoardName != NULL )
            && (    ( LcFilesInfoPtr->bfiBoard != LcPCIDetectionInfoPtr->pdiBoard ) 
		 || (    ( LcFilesInfoPtr->bfiCSID != 0 )
                      && ( LcFilesInfoPtr->bfiCSID != LcPotentialFlavor ) ) ) )
    {
        LcFilesInfoPtr++ ;
    }

    // Just in case
    if ( LcFilesInfoPtr->bfiBoardName == NULL ) return FALSE ; 

    PmBoardInfoPtr->bipFiles = LcFilesInfoPtr;     

    return TRUE ;
}


// ****************************************************************************
// VOID ExtractBoardInformation(
//      IN LPPCI_COMMON_CONFIG  PmPciCConfigPtr,
//      OUT LPBOARD_INFO        PmBoardInfoPtr,
//      OUT LPPORT_INFO         PmPortInfoPtr)
// ****************************************************************************
//
// Input parameters :
// ******************
//
//      IN LPPCI_COMMON_CONFIG   PmPciCConfigPtr
//
// Output parameters :
// *******************
//
//      OUT LPBOARD_INFO         PmBoardInfoPtr
//      OUT LPPORT_INFO          PmPortInfoPtr
//
// ****************************************************************************
// Fill a GENERAL_INFO struct. with information from a PCI_COMMON_CONFIG one
// ****************************************************************************
//
VOID PCIExtractBoardInformation(
    IN PMY_PCI_CONFIG       PmPciCConfigPtr,
    OUT LPBOARD_INFO        PmBoardInfoPtr)
{
    BOOLEAN                 LcDigigramBoardDetected;

    ASSERT(PmBoardInfoPtr->biCarac == CARAC_FREE);
    
    // Retrieve the board type if it is a known one
    //
    LcDigigramBoardDetected = GetBoardInformation( PmPciCConfigPtr, PmBoardInfoPtr ) ;

    PmBoardInfoPtr->biNumIrq        = PmPciCConfigPtr->InterruptLine ;

    if ( LcDigigramBoardDetected )
    {
        PmBoardInfoPtr->portMEM =     PmPciCConfigPtr->BaseAddresses[0];
        PmBoardInfoPtr->portMEMsize = PmPciCConfigPtr->WindowSize[0];
        PmBoardInfoPtr->portPLX =     PmPciCConfigPtr->BaseAddresses[1];
        PmBoardInfoPtr->portPLXsize = PmPciCConfigPtr->WindowSize[1];
        PmBoardInfoPtr->portDSP =     PmPciCConfigPtr->BaseAddresses[2];
        PmBoardInfoPtr->portDSPsize = PmPciCConfigPtr->WindowSize[2];
    }
    else
    {
        // Board is not recognized, skip it
        //
        return ;
    }

    // Fill in the entry for the board
    // -------------------------------
    PmBoardInfoPtr->biCarac = CARAC_GHOST;  // not ready yet
}


