// *************************************************************************
//
//  COPYRIGHT 1996-2000 DIGIGRAM. ALL RIGHTS RESERVED.
//
//  DIGIGRAM
//
// **************************************************************************

// Include Files
// **************


#include "unicode.h"
#include "drvdbg.h"



// ***************************************************************************
// BOOLEAN UNCAllocateUnicodeString( INOUT PUNICODE_STRING )
//
// Input Parameters:
// *****************
//
//  PUNICODE_STRING  PmUStr    : the unicode string to be allocated
//
// Return Value:
// *************
//
//  TRUE if allocation completes successfully
//
//****************************************************************************
//
//  Allocates string buffer of a Unicode string, and zeroes its buffer
//
//**************************************************************************
BOOLEAN UNCAllocateUnicodeString(
    INOUT PUNICODE_STRING     PmPUniString )
{
    PmPUniString->MaximumLength  = STRING_SIZE        ;
    PmPUniString->Length         = 0                  ;
    PmPUniString->Buffer         = (PWSTR)
        DDK_ALLOC( sizeof(WCHAR) * PmPUniString->MaximumLength ) ;

    if ( PmPUniString->Buffer )
    {
        BZERO2( PmPUniString->Buffer,
                WCHAR,
                PmPUniString->MaximumLength );

        return( TRUE ) ;
    }

    DOUT(DBG_ERROR, ("Cannot allocate unicode string"));

    return(FALSE) ;
}

// ***************************************************************************
// VOID UNCFreeUnicodeString( INOUT PUNICODE_STRING )
//
// Input Parameters:
// *****************
//
//  PUNICODE_STRING  PmUStr    : the unicode string to be released
//
//****************************************************************************
//
//  Release string buffer of a Unicode string, and resets its length
//
//**************************************************************************VOID UNCFreeUnicodeString(
VOID UNCFreeUnicodeString(
    INOUT PUNICODE_STRING PmPUniString )
{
    if ( PmPUniString->Buffer )
    {
        PmPUniString->MaximumLength  = 0 ;
        PmPUniString->Length         = 0 ;
        DDK_FREE( PmPUniString->Buffer )     ;
    }
}

// ***************************************************************************
// BOOLEAN UNCAppendPChar2UString( INOUT PUNICODE_STRING, IN PCHAR )
//
// Input Parameters:
// *****************
//
//  PUNICODE_STRING  PmUStr1    : The unicode string to append to
//  PCHAR         PmStr2        : The string to append
//
// Return Value:
// *************
//
//  TRUE if appending completes successfully
//
//**************************************************************************
//
//  Append a PCHAR string to a Unicode string
//
//**************************************************************************
BOOLEAN UNCAppendPChar2UString(
    INOUT PUNICODE_STRING   PmUStr1,
    IN PCHAR                PmStr2 )
{
    ANSI_STRING     LcAnsiStr   ;
    UNICODE_STRING  LcUStr2     ;

    if ( !UNCAllocateUnicodeString( &LcUStr2 ) )
    {
        DOUT(DBG_ERROR, ("Failed to append a PChar to Unicode string"));
        return FALSE ;
    }

    // First convert the string to an ANSI, then Unicode string
    // ---------------------------------------------------------
    RtlInitAnsiString( &LcAnsiStr, PmStr2 ) ;
    RtlAnsiStringToUnicodeString( &LcUStr2, &LcAnsiStr, FALSE ) ;

    // Actually append now
    // --------------------
    RtlAppendUnicodeStringToString( PmUStr1, &LcUStr2 ) ;

    // Release the temporary unicode string
    // -------------------------------------
    UNCFreeUnicodeString( &LcUStr2 );

    return TRUE ;
}

// ***************************************************************************
// BOOLEAN UNCAppendUstring2UString(IN PUNICODE_STRING, INOUT PUNICODE_STRING)
//
// Input Parameters:
// *****************
//
//  PUNICODE_STRING  PmUStr1    : The unicode string to append to
//  PUNICODE_STRING  PmUStr2    : The unicode string to append
//
//**************************************************************************
//
//  Append a Unicode string to another Unicode string
//
//**************************************************************************
BOOLEAN UNCAppendUString2UString(
    INOUT PUNICODE_STRING   PmUStr1,
    IN    PUNICODE_STRING   PmUStr2 )
{
    // Actually append now
    // --------------------
    RtlAppendUnicodeStringToString( PmUStr1, PmUStr2 ) ;

    return TRUE ;
}
