// *************************************************************************
//
//  COPYRIGHT 1996-2000 DIGIGRAM. ALL RIGHTS RESERVED.
//
//  DIGIGRAM
//
// **************************************************************************

#ifndef _VIRTIO_H
#define _VIRTIO_H

#ifndef NPHD_DIAGDLL
#include "drvdef.h"
#endif

#include "ifapidrv.h"
#include "LXES_registers.h"

// Global contants
// ****************

#define SIZE_MAX_CMD    REG_CRM_NUMBER
#define SIZE_MAX_STATUS REG_CRM_NUMBER

#define ERR_TIMEOUT_CHK         0xfffffffe
#define ERR_TIMEOUT             0xffffffff


// TAG_DEBUG_DRIVER : DEB

// Number of context handled by the driver and DSP
// -----------------------------------------------
#define MAX_CONTEXT     2

// Global typedef
//***************

typedef PDWORD   HANDLE_PIPE, * PHANDLE_PIPE;

// TAG_DEBUG_DRIVER : FIN

typedef struct _TARGET_INFO {
    WORD        tgCarte;
    WORD        tgPipe;
    BYTE        tgCaracPipeVoie;    // bit0= 0:PLAY,    1:RECORD
                                    // bit1= 0:ONLINE,  1:OFFLINE
    BYTE        tgDifferedType;     // 0: Immediate command, otherwise differed
                                    // bit 0: differed request flag
                                    // bit 1: notify request flag
                                    // bit 2: H-Buffer relative request flag
    PCX_TIME    tgHour;
    DWORD       tgMaskFlux;
    WORD        tgAudio;       // audio number for the board point of view
    HANDLE_PIPE tgVioHandle;
} TARGET_INFO, *PTARGET_INFO, FAR *LPTARGET_INFO ;




typedef struct _CMD_RMH_INFO
{
  BYTE          Index; /* debug */ 
  WORD          LgCmd;
  WORD          LgStat;
  DWORD         Cmd[SIZE_MAX_CMD];
  DWORD         Stat[SIZE_MAX_STATUS];
  WORD          DspStat;
} CMD_RMH_INFO, *PCMD_RMH_INFO, FAR *LPCMD_RMH_INFO;


#endif // _VIRTIO_H





