/*
 *  Error Routines
 *  Copyright (c) 1998 by Jaroslav Kysela <perex@jcu.cz>
 *
 *  snd_strerror routine needs to be recoded for locale support
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "soundlib.h"

static const char *snd_error_codes[] = {
  "Sound protocol isn't compatible"
};

const char *snd_strerror( int errnum )
{
  if ( errnum < 0 ) errnum = -errnum;
  if ( errnum < SND_ERROR_BEGIN ) 
    return (const char *)strerror( errnum );
  errnum -= SND_ERROR_BEGIN;
  if ( errnum >= sizeof( snd_error_codes ) / sizeof( const char * ) )
    return "Unknown error";
  return snd_error_codes[ errnum ];
}
