;*******************************************************************/
;* Copyright 1995 Crystal Semiconductor Corp., ALL RIGHTS RESERVED */
;*   Program name: WAVE.EXE                                        */
;*   Purpose:      Wave Play/Record with DMA or PIO.               */
;*                 Reads/Writes WAVE format files direct to disk   */
;*                 Unlimited length.                               */
;*   Written by:   Richard Vail for Crystal Semiconductor          */
;*******************************************************************/
.MODEL	LARGE,C
.386

.DATA

EXTERN	C bLeftMaxPeak:BYTE
EXTERN	C bRightMaxPeak:BYTE
EXTERN	C wLeftMaxPeak:WORD
EXTERN	C wRightMaxPeak:WORD

.CODE

OUT_SAMPLE	PROTO	FAR C, lpIOData:FAR PTR BYTE, wSampleSize:WORD, wIOPort:WORD
IN_SAMPLE		PROTO	FAR C, lpIOData:FAR PTR BYTE, wSampleSize:WORD, wIOPort:WORD
GET_US_CLK	PROTO	FAR C
NIBBLE_SWAP	PROTO	FAR C, bufferptr:FAR PTR BYTE, buffersize:WORD
PEAK8M		PROTO	FAR C, bufferptr:FAR PTR BYTE, buffersize:WORD
PEAK8S		PROTO	FAR C, bufferptr:FAR PTR BYTE, buffersize:WORD
PEAK8UM		PROTO	FAR C, bufferptr:FAR PTR BYTE, buffersize:WORD
PEAK8US   	PROTO	FAR C, bufferptr:FAR PTR BYTE, buffersize:WORD
PEAK8AM		PROTO	FAR C, bufferptr:FAR PTR BYTE, buffersize:WORD
PEAK8AS		PROTO	FAR C, bufferptr:FAR PTR BYTE, buffersize:WORD
PEAK16M		PROTO	FAR C, bufferptr:FAR PTR BYTE, buffersize:WORD
PEAK16S		PROTO	FAR C, bufferptr:FAR PTR BYTE, buffersize:WORD
PEAK4M		PROTO	FAR C, bufferptr:FAR PTR BYTE, buffersize:WORD
PEAK4S		PROTO	FAR C, bufferptr:FAR PTR BYTE, buffersize:WORD

;********************************************************************
;void OUT_SAMPLE(BYTE _far *samples, WORD samplesize, WORD ioport);
OUT_SAMPLE	PROC		FAR C PUBLIC USES CX DX DS SI,
					lpIOData:FAR PTR BYTE,
					wSampleSize:WORD,
					wIOPort:WORD
	lds	si, [lpIOData]
	mov	cx, [wSampleSize]
	mov	dx, [wIOPort]
	cld
	rep	outsb
	ret
OUT_SAMPLE	ENDP

;********************************************************************
;void IN_SAMPLE(BYTE _far *samples, WORD samplesize, WORD ioport);
IN_SAMPLE		PROC		FAR C PUBLIC USES CX DX DS SI,
					lpIOData:FAR PTR BYTE,
					wSampleSize:WORD,
					wIOPort:WORD
	les	di, [lpIOData]
	mov	cx, [wSampleSize]
	mov	dx, [wIOPort]
	cld
	rep	insb
	ret
IN_SAMPLE		ENDP

;********************************************************************
;WORD GET_US_CLK(void);
GET_US_CLK	PROC		FAR C PUBLIC USES BX CX
	cli				; freeze ticker while checking
readhw:
	mov	al, 0C2h		; timer 0 read stat and count
	out	43h, al
	in	al, 40h		; store stat in ch
	mov	ch, al
	in	al, 40h		; store count in bx
	mov	bl, al
	in	al, 40h
	mov	bh, al

	mov	al, 0Ah
	out	20h, al
	in	al, 20h

	test	al, 001h		; check if system time is stale
	jz	short no_int_pending
	mov	ax, 0ffffh	; force max in lower part
	jmp	short gotlo
no_int_pending:
	test	ch, 040h
	jnz	short readhw	; timer invalid, retry

	mov	ax, bx		; move count to more convenient reg
     cmp  ax, 002h       ; timer<=2 => incorrect output bit on
                         ; some platforms, be safe and lose it
     jbe  short readhw	; timer invalid, retry
	neg	ax			; convert to count up
     mov  cl, ch      	; copy status word for destructive test
     and  cl, 00Eh    	; filter out mode bits
     cmp  cl, 006h    	; check for mode 3 (square wave)
     jne  short gotlo 	; only mode 3 needs extra work

	shl	ch, 1		; bash ch to get high bit of status
					; (output state) into high bit of
					; count via carry
	cmc				; invert carry to match count negation
	rcr	ax, 1		; mode 3 counts down twice by twos,
					; first with output high, then low
gotlo:
	sti
	ret
GET_US_CLK	ENDP

;********************************************************************
;void NIBBLE_SWAP(BYTE _far *buffer, WORD length);//reverse nibbles in ADPCM byte
NIBBLE_SWAP	PROC		FAR C PUBLIC USES DS SI BX CX,
					bufferptr:FAR PTR BYTE,
					buffersize:WORD
	mov	cx, [buffersize]
	lds	si, [bufferptr]
	mov	ax, ds
	mov	bx, si
	and	si, 0Fh
	shr	bx, 4		     ;normalize seg:off for max loop size
	add	ax, bx
	mov	ds, ax
	xor	bx, bx			;zero result
	cld				     ;incrementing
ns_loop:
	ror	byte ptr ds:[si], 4
	inc	si
	loop	ns_loop
	ret
NIBBLE_SWAP	ENDP

;********************************************************************
;void Peak8m(BYTE _far *buffer, WORD buffersize);	linear 8bit pcm mono
PEAK8M		PROC		FAR C PUBLIC USES SI BX CX,
					bufferptr:FAR PTR BYTE,
					buffersize:WORD
	push	ds
	mov	cx, [buffersize]
	lds	si, [bufferptr]
	mov	ax, ds
	mov	bx, si
	and	si, 0Fh
	shr	bx, 4		     ;normalize seg:off for max loop size
	add	ax, bx
	mov	ds, ax
	xor	bx, bx			;zero result
	cld				     ;incrementing
Peak8m_loop:
	lodsb				;load al from ds:si, inc si
	xor	al, 80h
	cmp	al, bl			;max
	jl	@F
	mov	bl, al
@@:
	loop	Peak8m_loop
	pop	ds
	mov	[bLeftMaxPeak], bl
	ret
PEAK8M	ENDP

;********************************************************************
;void Peak8s(BYTE _far *buffer, WORD buffersize);	linear 8bit pcm stereo
PEAK8S		PROC		FAR C PUBLIC USES SI BX CX,
					bufferptr:FAR PTR BYTE,
					buffersize:WORD
	push	ds
	mov	cx, [buffersize]
	shr	cx, 1			;halve for stereo
	lds	si, [bufferptr]
	mov	ax, ds
	mov	bx, si
	and	si, 0Fh
	shr	bx, 4		     ;normalize seg:off for max loop size
	add	ax, bx
	mov	ds, ax
	xor	bx, bx			;zero result
	cld				     ;incrementing
Peak8s_loop:
	lodsb				;load al from ds:si, inc si
	xor	al, 80h
	cmp	al, bl			;max
	jl	@F
	mov	bl, al
@@:
	lodsb				;load al from ds:si, inc si
	xor	al, 80h
	cmp	al, bh			;max
	jl	@F
	mov	bh, al
@@:
	loop	Peak8s_loop
	pop	ds
	mov	[bLeftMaxPeak], bl
	mov	[bRightMaxPeak], bh
	ret
PEAK8S	ENDP

;********************************************************************
;void Peak8um(BYTE _far *buffer, WORD buffersize);	ulaw 8bit companded mono
PEAK8UM		PROC		FAR C PUBLIC USES SI BX CX,
					bufferptr:FAR PTR BYTE,
					buffersize:WORD
	push	ds
	mov	cx, [buffersize]
	lds	si, [bufferptr]
	mov	ax, ds
	mov	bx, si
	and	si, 0Fh
	shr	bx, 4		     ;normalize seg:off for max loop size
	add	ax, bx
	mov	ds, ax
	xor	bx, bx			;zero result
	cld				     ;incrementing
Peak8um_loop:
	lodsb				;load al from ds:si, inc si
	not	al
	and	al, 7Fh
	cmp	al, bl			;max
	jb	@F
	mov	bl, al
@@:
	loop	Peak8um_loop
	pop	ds
	mov	[bLeftMaxPeak], bl
	ret
PEAK8UM	ENDP

;********************************************************************
;void Peak8us(BYTE _far *buffer, WORD buffersize);	ulaw 8bit companded stereo
PEAK8US   	PROC		FAR C PUBLIC USES SI BX CX,
					bufferptr:FAR PTR BYTE,
					buffersize:WORD
	push	ds
	mov	cx, [buffersize]
	shr	cx, 1			;halve for stereo
	lds	si, [bufferptr]
	mov	ax, ds
	mov	bx, si
	and	si, 0Fh
	shr	bx, 4		     ;normalize seg:off for max loop size
	add	ax, bx
	mov	ds, ax
	xor	bx, bx			;zero result
	cld				     ;incrementing
Peak8us_loop:
	lodsb				;load al from ds:si, inc si
	not	al
	and	al, 7Fh
	cmp	al, bl			;max
	jb	@F
	mov	bl, al
@@:
	lodsb				;load al from ds:si, inc si
	not	al
	and	al, 7Fh
	cmp	al, bh			;max
	jb	@F
	mov	bh, al
@@:
	loop	Peak8us_loop
	pop	ds
	mov	[bLeftMaxPeak], bl
	mov	[bRightMaxPeak], bh
	ret
PEAK8US	ENDP

;********************************************************************
;void Peak8am(BYTE _far *buffer, WORD buffersize);	alaw 8bit companded mono
PEAK8AM		PROC		FAR C PUBLIC USES SI BX CX,
					bufferptr:FAR PTR BYTE,
					buffersize:WORD
	push	ds
	mov	cx, [buffersize]
	lds	si, [bufferptr]
	mov	ax, ds
	mov	bx, si
	and	si, 0Fh
	shr	bx, 4		     ;normalize seg:off for max loop size
	add	ax, bx
	mov	ds, ax
	xor	bx, bx			;zero result
	cld				     ;incrementing
Peak8am_loop:
	lodsb				;load al from ds:si, inc si
	xor	al, 55h
	and	al, 7Fh
	cmp	al, bl			;max
	jb	@F
	mov	bl, al
@@:
	loop	Peak8am_loop
	pop	ds
	mov	[bLeftMaxPeak], bl
	ret
PEAK8AM	ENDP

;********************************************************************
;void Peak8as(BYTE _far *buffer, WORD buffersize);	alaw 8bit companded stereo
PEAK8AS		PROC		FAR C PUBLIC USES SI BX CX,
					bufferptr:FAR PTR BYTE,
					buffersize:WORD
	push	ds
	mov	cx, [buffersize]
	shr	cx, 1			;halve for stereo
	lds	si, [bufferptr]
	mov	ax, ds
	mov	bx, si
	and	si, 0Fh
	shr	bx, 4		     ;normalize seg:off for max loop size
	add	ax, bx
	mov	ds, ax
	xor	bx, bx			;zero result
	cld				     ;incrementing
Peak8as_loop:
	lodsb				;load al from ds:si, inc si
	xor	al, 55h
	and	al, 7Fh
	cmp	al, bl			;max
	jb	@F
	mov	bl, al
@@:
	lodsb				;load al from ds:si, inc si
	xor	al, 55h
	and	al, 7Fh
	cmp	al, bh			;max
	jb	@F
	mov	bh, al
@@:
	loop	Peak8as_loop
	pop	ds
	mov	[bLeftMaxPeak], bl
	mov	[bRightMaxPeak], bh
	ret
PEAK8AS	ENDP

;********************************************************************
;void Peak16m(BYTE _far *buffer, WORD buffersize);	linear 16bit pcm little endian mono
;	linear 16bit pcm big endian mono
PEAK16M		PROC		FAR C PUBLIC USES SI BX CX,
					bufferptr:FAR PTR BYTE,
					buffersize:WORD
	push	ds
	mov	cx, [buffersize]
	shr	cx, 1			;halve for 16 bit data
	lds	si, [bufferptr]
	mov	ax, ds
	mov	bx, si
	and	si, 0Fh
	shr	bx, 4		     ;normalize seg:off for max loop size
	add	ax, bx
	mov	ds, ax
	xor	bx, bx			;zero result
	cld				     ;incrementing
Peak16m_loop:
	lodsw				;load al from ds:si, inc si
	cmp	ax, bx			;max
	jl	@F
	mov	bx, ax
@@:
	loop	Peak16m_loop
	pop	ds
	mov	[wLeftMaxPeak], bx
	ret
PEAK16M	ENDP

;********************************************************************
;void Peak16s(BYTE _far *buffer, WORD buffersize);	linear 16bit pcm little endian stereo
;	linear 16bit pcm big endian stereo
PEAK16S		PROC		FAR C PUBLIC USES SI BX CX DX,
					bufferptr:FAR PTR BYTE,
					buffersize:WORD
	push	ds
	mov	cx, [buffersize]
	shr	cx, 1			;halve for 16 bit data
	shr	cx, 1			;halve again for sterso
	lds	si, [bufferptr]
	mov	ax, ds
	mov	bx, si
	and	si, 0Fh
	shr	bx, 4		     ;normalize seg:off for max loop size
	add	ax, bx
	mov	ds, ax
	xor	bx, bx			;zero result
	xor	dx, dx			;zero result
	cld				     ;incrementing
Peak16s_loop:
	lodsw				;load al from ds:si, inc si
	cmp	ax, bx			;max
	jl	@F
	mov	bx, ax
@@:
	lodsw				;load al from ds:si, inc si
	cmp	ax, dx			;max
	jl	@F
	mov	dx, ax
@@:
	loop	Peak16s_loop
	pop	ds
	mov	[wLeftMaxPeak], bx
	mov	[wRightMaxPeak], dx
	ret
PEAK16S	ENDP

;********************************************************************
;void Peak4m(BYTE _far *buffer, WORD buffersize);	4bit adpcm mono
PEAK4M		PROC		FAR C PUBLIC USES SI BX CX DX,
					bufferptr:FAR PTR BYTE,
					buffersize:WORD
	push	ds
	mov	cx, [buffersize]
	lds	si, [bufferptr]
	mov	ax, ds
	mov	bx, si
	and	si, 0Fh
	shr	bx, 4		     ;normalize seg:off for max loop size
	add	ax, bx
	mov	ds, ax
	xor	ax, ax
	xor	bx, bx
	xor	dx, dx
	cld				     ;incrementing
Peak4m_loop:
	lodsb				;load al from ds:si, inc si
	shl	ax, 4			;1st sample to al
	shr	al, 4			;2nd sample to ah
	cmp	al, dl			;1st sample
	jbe	@F
	cmp	bl, 07Fh
	je	@F
	inc	bl
	inc	bl				;inc again and fall thru dec
@@:
	cmp	bl, 0
	je	@F
	dec	bl
@@:
	mov	dl, al
	cmp	ah, dl			;2nd sample
	jbe	@F
	cmp	bl, 07Fh
	je	@F
	inc	bl
	inc	bl				;inc again and fall thru dec
@@:
	cmp	bl, 0
	je	@F
	dec	bl
@@:
	mov	dl, ah
	cmp	bl, bh			;now max
	jl	@F
	mov	bh, bl
@@:
	loop	Peak4m_loop
	pop	ds
	mov	[bLeftMaxPeak], bh
	ret
PEAK4M	ENDP

;********************************************************************
;void Peak4s(BYTE _far *buffer, WORD buffersize);	4bit adpcm stereo
PEAK4S		PROC		FAR C PUBLIC USES SI DI BX CX DX,
					bufferptr:FAR PTR BYTE,
					buffersize:WORD
	push	ds
	mov	cx, [buffersize]
	lds	si, [bufferptr]
	mov	ax, ds
	mov	bx, si
	and	si, 0Fh
	shr	bx, 4		     ;normalize seg:off for max loop size
	add	ax, bx
	mov	ds, ax
	xor	ax, ax
	xor	bx, bx
	xor	dx, dx
	xor	di, di
	cld				     ;incrementing
Peak4s_loop:
	lodsb				;load al from ds:si, inc si
	xor	ah, ah
	shl	ax, 4			;right sample to ah
	shr	al, 4			;left sample to al
	cmp	al, dl			;left sample
	jbe	@F
	cmp	bl, 07Fh
	je	@F
	inc	bl
	inc	bl				;inc again and fall thru dec
@@:
	cmp	bl, 0
	je	@F
	dec	bl
@@:
	mov	dl, al
	cmp	ah, dh			;right sample
	jbe	@F
	cmp	bh, 07Fh
	je	@F
	inc	bh
	inc	bh				;inc again and fall thru dec
@@:
	cmp	bh, 0
	je	@F
	dec	bh
@@:
	mov	dh, ah

	mov	ax, di			;recover max's
	cmp	bl, al			;left max
	jl	@F
	mov	al, bl
@@:
	cmp	bh, ah			;now max
	jl	@F
	mov	ah, bh
@@:
	mov	di, ax			;save max's
	loop	Peak4s_loop
	pop	ds
	mov	bx, di
	mov	[bLeftMaxPeak], bl
	mov	[bRightMaxPeak], bh
	ret
PEAK4S	ENDP

end
