#include <conio.h>
#include <dos.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "iw.h"
#include "iwapi.h"

static void iw_unlink(void)
{
    iw_unload_kernel();
}

struct load_kernel_cfg public_cfg;

static int iw_link(void)
{
    int ret, i;

    iwu_get_kernel_cfg(&public_cfg, 0);
    ret = iw_load_kernel(&public_cfg);
    if (ret) {
	fprintf(stderr, "Error: %s", iw_error_str(ret));
	return(ret);
    }

    ret = InitMidi();
    if (ret != 0) return(ret);
    ret = InitWave();
    if (ret != 0) return(ret);
    ret = InitMod();
    if (ret != 0) return(ret);
    return(0);
}
void DeInitIW(void)
{
    StopWaveFile();
    DeInitWave();
    StopMidiFile();
    DeInitMidi();
    DeInitMod();
    iw_unlink();
}
int InitIW(void)
{
    return(iw_link());
}
#define IWAPIERR_STR_BUFLEN 4096
static char iwapierr_str[IWAPIERR_STR_BUFLEN];
char *iwapi_error_str(int err)
{
    int rval;

    rval = iw_mls_getstring("iwapi.mls", -err, iwapierr_str, IWAPIERR_STR_BUFLEN);
    if (rval == IW_OK) return(iwapierr_str);
    if (rval == IW_MESSAGE_NOT_FOUND) return("Unknown error.");
    return(iwapierr_str);
}
